/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool;

import com.cognos.developer.schemas.bibus._3.AddOptions;
import com.cognos.developer.schemas.bibus._3.AnyTypeMIMEProp;
import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.BaseROLAPDataSource;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_PortType;
import com.cognos.developer.schemas.bibus._3.ContentManagerService_ServiceLocator;
import com.cognos.developer.schemas.bibus._3.DeleteOptions;
import com.cognos.developer.schemas.bibus._3.Model;
import com.cognos.developer.schemas.bibus._3.ModelView;
import com.cognos.developer.schemas.bibus._3.MultilingualToken;
import com.cognos.developer.schemas.bibus._3.MultilingualTokenProp;
import com.cognos.developer.schemas.bibus._3.PropEnum;
import com.cognos.developer.schemas.bibus._3.QueryOptions;
import com.cognos.developer.schemas.bibus._3.SchemaInfo;
import com.cognos.developer.schemas.bibus._3.SearchPathMultipleObject;
import com.cognos.developer.schemas.bibus._3.SearchPathSingleObject;
import com.cognos.developer.schemas.bibus._3.Sort;
import com.cognos.developer.schemas.bibus._3.StringProp;
import com.cognos.developer.schemas.bibus._3.UpdateActionEnum;
import com.cognos.developer.schemas.bibus._3.UpdateOptions;
import com.cognos.developer.schemas.bibus._3.XmlEncodedXML;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMdSchema;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaObject;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaView;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool.SecuritySpec;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.SimpleXMLValidator;
import com.cognos.xqe.util.FileHandler;
import com.cognos.xqe.util.xml.XMLUtils;
import java.io.ByteArrayInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.lang3.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXParseException;

public class ROLAPSecurityTool {
    private static final String SCHEMA_FILENAME = "RolapSecuritySpecification.xsd";
    private static final String SCHEMA_CLASSPATH = "/com/cognos/xqe/runtree/olap/mdx/rolapprovider/security/tool/RolapSecuritySpecification.xsd";
    private static String gCMURL = "http://localhost:9300/p2pd/servlet/dispatch";
    private static ContentManagerService_PortType cmService = null;
    private ContentManagerService_ServiceLocator cmServiceLocator = new ContentManagerService_ServiceLocator();
    private static final String UTF_8 = "UTF-8";
    private static final String PROPERTY_STR = "property";
    private static final String NAME_ATTR = "name";
    private static final String ROLAPSOURCE_STR = "ROLAPSource";
    private static final Pattern PATTERN = Pattern.compile("NAME");
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String SPACE_COLON = " : ";
    private static final String LINE_STR = "Line ";
    private static final String TMP_EXT = ".tmp";
    private static final String DISPATCHER_OPTION = "-dp";
    private static final String DATASOURCE_OPTION = "-ds";
    private static final String RESTORE_OPTION = "-r";
    private static final String BACKUP_OPTION = "-b";
    private static final String EXPORT_OPTION = "-e";
    private static final String IMPORT_OPTION = "-i";
    private static final String USERID_OPTION = "-u";
    private static final String NAMESPACE_OPTION = "-n";
    private static final String PASSWORD_OPTION = "-p";
    private static final String PARAMS_OPTION = "-params";
    private static final int DELIMITER_REPET = 10;
    private static final int BACKUP_FILE_PARTS = 2;
    private static final List<String> OPTIONS = Arrays.asList("-dp", "-ds", "-r", "-b", "-e", "-i", "-u", "-p", "-n", "-params");

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        block18: {
            try {
                HashMap<String, String> m = ROLAPSecurityTool.parseArgs(args);
                if (m.containsKey(PARAMS_OPTION)) {
                    String paramFile = m.get(PARAMS_OPTION);
                    String line = FileHandler.fileToString(paramFile);
                    m.clear();
                    m = ROLAPSecurityTool.parseArgs(ROLAPSecurityTool.parseLine(line));
                }
                if (m.size() == 0) {
                    System.out.append(ROLAPSecurityTool.usage());
                    return;
                }
                String userid = m.get(USERID_OPTION);
                String password = m.get(PASSWORD_OPTION);
                String namespace = m.get(NAMESPACE_OPTION);
                String dispatcher = m.get(DISPATCHER_OPTION);
                if (ROLAPSecurityTool.notEmpty(dispatcher)) {
                    gCMURL = dispatcher;
                }
                ROLAPSecurityTool secTool = new ROLAPSecurityTool(userid, password, namespace);
                if (ROLAPSecurityTool.notEmpty(m.get(IMPORT_OPTION))) {
                    String input = m.get(IMPORT_OPTION);
                    String ds = m.get(DATASOURCE_OPTION);
                    if (!ROLAPSecurityTool.notEmpty(input) || !ROLAPSecurityTool.notEmpty(ds)) break block18;
                    String inputContent = FileHandler.fileToString(input);
                    secTool.validateSecurityFile(inputContent);
                    SecuritySpec security = SecuritySpec.createInstanceFromSecurityFile(ds, inputContent);
                    String cubeModel = secTool.retrieveROLAPCubeModel(ds);
                    String newCubeModel = security.serializeSecuritySpecToCubeModel(cubeModel);
                    if (m.containsKey(BACKUP_OPTION)) {
                        secTool.backupCube(ds);
                    }
                    try {
                        ROLAPMetaMdSchema metaSchema = secTool.parseCubeModel(newCubeModel);
                        if (metaSchema == null) throw new XQERuntimeException(XQEMessageKeys.ROL_FailedToParseCubeModel, ds);
                        Model md = secTool.retrieveCMROLAPModel(ds);
                        String rolapModel = secTool.extractROLAPModel(md);
                        ArrayList<String> secViewNames = secTool.extractMetaSecurityViewNames(metaSchema);
                        String finalROLAPModel = secTool.insertROLAPCubeModelToROLAPModel(rolapModel, newCubeModel);
                        secTool.saveROLAPModel(md.getSearchPath().getValue(), finalROLAPModel);
                        secTool.deleteAllROLAPModelViews(md.getSearchPath().getValue());
                        secTool.addROLAPModelViews(md.getSearchPath().getValue(), secViewNames);
                        BaseClass[] modelViews = secTool.retrieveROLAPModelViews(md.getSearchPath().getValue());
                        ModelView[] modelViewsToUpdate = security.fillMappingForModelViewList(modelViews);
                        if (modelViewsToUpdate != null) {
                            cmService.update((BaseClass[])modelViewsToUpdate, new UpdateOptions());
                        }
                    }
                    catch (Exception e) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolCubeModelValidation, e.getMessage());
                    }
                    System.out.append(NEWLINE + XQEMessages.getMessage(XQEMessageKeys.ROL_SecToolCommandSucceed, XQEMessages.getCurrProductLocale()) + NEWLINE);
                    return;
                }
                if (ROLAPSecurityTool.notEmpty(m.get(EXPORT_OPTION))) {
                    String ds = m.get(DATASOURCE_OPTION);
                    String output = m.get(EXPORT_OPTION);
                    if (ROLAPSecurityTool.notEmpty(ds)) {
                        String securitySpec = secTool.exportSecurity(ds);
                        if (ROLAPSecurityTool.notEmpty(output)) {
                            ROLAPSecurityTool.writeToFile(output, securitySpec);
                        } else {
                            System.out.append(securitySpec);
                        }
                        System.out.append(NEWLINE + XQEMessages.getMessage(XQEMessageKeys.ROL_SecToolCommandSucceed, XQEMessages.getCurrProductLocale()) + NEWLINE);
                        return;
                    }
                    break block18;
                }
                if (!ROLAPSecurityTool.notEmpty(m.get(RESTORE_OPTION))) break block18;
                String input = m.get(RESTORE_OPTION);
                String ds = m.get(DATASOURCE_OPTION);
                if (!ROLAPSecurityTool.notEmpty(input) || !ROLAPSecurityTool.notEmpty(ds)) break block18;
                String backupFile = FileHandler.fileToString(input);
                String[] parts = backupFile.split(ROLAPSecurityTool.createBackupFileDelimiter(ds));
                if (parts.length != 2) throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToRestoreCube, input, "");
                String cubeModel = parts[0];
                String securityFile = parts[1];
                try {
                    ROLAPMetaMdSchema metaSchema = secTool.parseCubeModel(cubeModel);
                    if (metaSchema != null) {
                        Model md = secTool.retrieveCMROLAPModel(ds);
                        String rolapModel = secTool.extractROLAPModel(md);
                        ArrayList<String> secViewNames = secTool.extractMetaSecurityViewNames(metaSchema);
                        String finalROLAPModel = secTool.insertROLAPCubeModelToROLAPModel(rolapModel, cubeModel);
                        secTool.saveROLAPModel(md.getSearchPath().getValue(), finalROLAPModel);
                        secTool.deleteAllROLAPModelViews(md.getSearchPath().getValue());
                        secTool.addROLAPModelViews(md.getSearchPath().getValue(), secViewNames);
                        BaseClass[] modelViews = secTool.retrieveROLAPModelViews(md.getSearchPath().getValue());
                        SecuritySpec security = SecuritySpec.createInstanceFromSecurityFile(ds, securityFile);
                        ModelView[] modelViewsToUpdate = security.fillMappingForModelViewList(modelViews);
                        if (modelViewsToUpdate != null) {
                            cmService.update((BaseClass[])modelViewsToUpdate, new UpdateOptions());
                        }
                    }
                }
                catch (Exception e) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolCubeModelValidation, XQEMessages.getMessage(XQEMessageKeys.SEC_DecryptionFailure, XQEMessages.getCurrProductLocale()));
                }
                System.out.append(NEWLINE + XQEMessages.getMessage(XQEMessageKeys.ROL_SecToolCommandSucceed, XQEMessages.getCurrProductLocale()) + NEWLINE);
                return;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return;
            }
        }
        System.out.append(ROLAPSecurityTool.usage());
    }

    private String exportSecurity(String ds) throws Exception {
        String cubeModel = this.retrieveROLAPCubeModel(ds);
        Model md = this.retrieveCMROLAPModel(ds);
        BaseClass[] modelViews = this.retrieveROLAPModelViews(md.getSearchPath().getValue());
        SecuritySpec security = SecuritySpec.createInstanceFromCubeModel(cubeModel, modelViews);
        return security.serializeAsSecurityFile();
    }

    private void backupCube(String ds) throws Exception {
        String cubeModel = this.retrieveROLAPCubeModel(ds);
        String securityFile = this.exportSecurity(ds);
        String backupFile = cubeModel + ROLAPSecurityTool.createBackupFileDelimiter(ds) + securityFile;
        ROLAPSecurityTool.writeToFile(ds + "_" + System.currentTimeMillis() + TMP_EXT, backupFile);
    }

    public static String[] parseLine(String line) throws Exception {
        ArrayList<String> argList = new ArrayList<String>();
        Scanner sc = new Scanner((InputStream)new ByteArrayInputStream(line.getBytes(UTF_8)), UTF_8);
        while (sc.hasNext()) {
            if (sc.hasNext("\\\".*")) {
                String quotedString = sc.findInLine("\\\".*?\\\"");
                if (quotedString == null) continue;
                argList.add(quotedString.substring(1, quotedString.length() - 1));
                continue;
            }
            argList.add(sc.next());
        }
        sc.close();
        String[] args = new String[argList.size()];
        return argList.toArray(args);
    }

    public static HashMap<String, String> parseArgs(String[] args) {
        HashMap<String, String> m = new HashMap<String, String>();
        for (int i = 0; i < args.length; ++i) {
            int next;
            if (!OPTIONS.contains(args[i]) || (next = i + 1) >= args.length) continue;
            if (OPTIONS.contains(args[next])) {
                m.put(args[i], "");
                continue;
            }
            m.put(args[i], args[next]);
        }
        return m;
    }

    public static String usage() {
        return XQEMessages.getMessage(XQEMessageKeys.ROL_SecToolUsage, XQEMessages.getCurrProductLocale(), NEWLINE);
    }

    public static void dumpOptions(HashMap<String, String> m) {
        Set<String> s = m.keySet();
        for (String key : s) {
            System.out.append("option: " + key + " value:" + m.get(key) + NEWLINE);
        }
    }

    private void logon(String userid, String password, String namespace) throws Exception {
        StringBuilder credentialXML = new StringBuilder();
        credentialXML.append("<credential>");
        credentialXML.append("<namespace>").append(namespace).append("</namespace>");
        credentialXML.append("<username>").append(userid).append("</username>");
        credentialXML.append("<password>").append(password).append("</password>");
        credentialXML.append("</credential>");
        String encodedCredentials = credentialXML.toString();
        XmlEncodedXML xmlCredentials = new XmlEncodedXML();
        xmlCredentials.set_value(encodedCredentials);
        try {
            cmService.logon(xmlCredentials, null);
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolLogonError, userid, namespace);
        }
    }

    public ROLAPSecurityTool(String userid, String password, String namespace) throws Exception {
        this.cmServiceLocator.setMaintainSession(true);
        try {
            URL serverURL = new URL(gCMURL);
            cmService = this.cmServiceLocator.getcontentManagerService(serverURL);
            if (userid != null) {
                this.logon(userid, password, namespace);
            }
            cmService.query(new SearchPathMultipleObject("/"), new PropEnum[0], new Sort[0], new QueryOptions());
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToConnectToCM, e.getMessage());
        }
    }

    public void saveROLAPModel(String dataSourceModelSearchPath, String model) throws Exception {
        try {
            Model m = new Model();
            AnyTypeMIMEProp smodel = new AnyTypeMIMEProp();
            smodel.setValue(model);
            m.setModel(smodel);
            SchemaInfo sinfo = new SchemaInfo();
            StringProp prop = new StringProp(sinfo, dataSourceModelSearchPath);
            m.setSearchPath(prop);
            cmService.update(new BaseClass[]{m}, new UpdateOptions());
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToSaveRolapModelToCM, e.getMessage());
        }
    }

    public BaseClass[] retrieveROLAPModelViews(String dataSourceModelSearchPath) throws Exception {
        try {
            QueryOptions queryOpt = new QueryOptions();
            queryOpt.setSchemaInfo(true);
            BaseClass[] modelViews = cmService.query(new SearchPathMultipleObject(dataSourceModelSearchPath + "/*[@objectClass='modelView']"), new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.policies}, new Sort[0], queryOpt);
            return modelViews;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToRetrieveRolapModelFromCM, e.getMessage());
        }
    }

    public ModelView retrieveSingleROLAPModelView(String dataSourceModelSearchPath, String modelViewName) throws Exception {
        try {
            BaseClass[] modelViews = cmService.query(new SearchPathMultipleObject(dataSourceModelSearchPath + "/modelView[@name=" + XMLUtils.xPathLiteral(modelViewName) + "]"), new PropEnum[]{PropEnum.defaultName, PropEnum.searchPath, PropEnum.policies}, new Sort[0], new QueryOptions());
            if (modelViews.length == 1) {
                return (ModelView)modelViews[0];
            }
            return null;
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToSingleRetrieveRolapModelFromCM, modelViewName, e.getMessage());
        }
    }

    public void deleteAllROLAPModelViews(String dataSourceModelSearchPath) throws Exception {
        BaseClass[] modelView = this.retrieveROLAPModelViews(dataSourceModelSearchPath);
        try {
            DeleteOptions deleteOpt = new DeleteOptions();
            deleteOpt.setRecursive(true);
            deleteOpt.setForce(true);
            cmService.delete(modelView, deleteOpt);
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToDeleteAllModelViewsFromCM, dataSourceModelSearchPath, e.getMessage());
        }
    }

    public void addROLAPModelViews(String dataSourceModelSearchPath, ArrayList<String> viewNames) throws Exception {
        if (viewNames.size() > 0) {
            ModelView[] modelViews = new ModelView[viewNames.size()];
            try {
                for (int i = 0; i < viewNames.size(); ++i) {
                    ModelView mv = new ModelView();
                    MultilingualTokenProp viewName = new MultilingualTokenProp();
                    MultilingualToken value = new MultilingualToken();
                    value.setValue(viewNames.get(i));
                    value.setLocale("en-us");
                    viewName.setValue(new MultilingualToken[]{value});
                    mv.setName(viewName);
                    modelViews[i] = mv;
                }
                SearchPathSingleObject s = new SearchPathSingleObject(dataSourceModelSearchPath);
                AddOptions addOpts = new AddOptions();
                addOpts.setUpdateAction(UpdateActionEnum.replace);
                cmService.add(s, (BaseClass[])modelViews, addOpts);
            }
            catch (Exception e) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToSaveModelViewsToCM, e.getMessage());
            }
        }
    }

    public Model retrieveCMROLAPModel(String dataSourceName) throws Exception {
        try {
            BaseClass[] modelList = cmService.query(new SearchPathMultipleObject(this.buildModelSearchPath(dataSourceName)), new PropEnum[]{PropEnum.model, PropEnum.searchPath}, new Sort[0], new QueryOptions());
            return (Model)modelList[0];
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToRetrieveRolapModelFromCM, e.getMessage());
        }
    }

    public String extractROLAPModel(Model m) throws Exception {
        AnyTypeMIMEProp smodel = m.getModel();
        return smodel.getValue();
    }

    public String retrieveROLAPCubeModel(String dataSourceName) throws Exception {
        try {
            Model m = this.retrieveCMROLAPModel(dataSourceName);
            String model = this.extractROLAPModel(m);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            ByteArrayInputStream bis = new ByteArrayInputStream(model.getBytes(UTF_8));
            Document doc = docBuilder.parse(bis);
            NodeList nl = doc.getElementsByTagName(PROPERTY_STR);
            int l = nl.getLength();
            for (int i = 0; i < l; ++i) {
                NamedNodeMap nnm = nl.item(i).getAttributes();
                int t = nnm.getLength();
                for (int j = 0; j < t; ++j) {
                    Node n = nnm.item(j);
                    if (!n.getNodeName().equals(NAME_ATTR) || !n.getNodeValue().equals(ROLAPSOURCE_STR)) continue;
                    return nl.item(i).getFirstChild().getNodeValue();
                }
            }
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToRetrieveRolapCubeModelToCM, e.getMessage());
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToRetrieveRolapCubeModelToCM, XQEMessages.getMessage(XQEMessageKeys.ROL_CannotFindCube, XQEMessages.getCurrProductLocale(), dataSourceName));
    }

    public String insertROLAPCubeModelToROLAPModel(String model, String cubeModel) {
        String startTag = "<property name=\"ROLAPSource\">";
        String endTag = "</property>";
        String[] first = model.split("<property name=\"ROLAPSource\">");
        if (first.length == 2) {
            String[] second = first[1].split("</property>");
            return first[0] + "<property name=\"ROLAPSource\">" + StringEscapeUtils.escapeXml((String)cubeModel) + "</property>" + second[1];
        }
        return "";
    }

    public ROLAPMetaMdSchema parseCubeModel(String cubeModel) throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            ByteArrayInputStream bis = new ByteArrayInputStream(cubeModel.getBytes(UTF_8));
            docBuilder.parse(bis);
            return ROLAPMetaObject.parse(cubeModel);
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolCubeModelValidation, e.getMessage());
        }
    }

    public ArrayList<String> extractMetaSecurityViewNames(ROLAPMetaMdSchema schema) {
        ArrayList<String> names = new ArrayList<String>();
        ROLAPMetaCube[] cubes = schema.getCubes();
        for (int i = 0; i < cubes.length; ++i) {
            Map<String, ROLAPMetaView> views = cubes[i].getSecurityViews();
            if (views == null) continue;
            Set<String> sv = views.keySet();
            for (String s : sv) {
                names.add(s);
            }
        }
        return names;
    }

    private static boolean notEmpty(String s) {
        return s != null && !s.equals("");
    }

    private String buildModelSearchPath(String dataSourceName) {
        String template = "CAMID(\":\")/rolapDataSource[@name='NAME']/model[last()] | CAMID(\":\")/rolapVirtualDataSource[@name='NAME']/model[last()]";
        return PATTERN.matcher("CAMID(\":\")/rolapDataSource[@name='NAME']/model[last()] | CAMID(\":\")/rolapVirtualDataSource[@name='NAME']/model[last()]").replaceAll(dataSourceName);
    }

    private String buildDataSourceSearchPath(String dataSourceName) {
        String template = "CAMID(\":\")/rolapDataSource[@name='NAME'] | CAMID(\":\")/rolapVirtualDataSource[@name='NAME']";
        return PATTERN.matcher("CAMID(\":\")/rolapDataSource[@name='NAME'] | CAMID(\":\")/rolapVirtualDataSource[@name='NAME']").replaceAll(dataSourceName);
    }

    public BaseROLAPDataSource retrieveCMROLAPDataSource(String dataSourceName) throws Exception {
        try {
            BaseClass[] dsList = cmService.query(new SearchPathMultipleObject(this.buildDataSourceSearchPath(dataSourceName)), new PropEnum[]{PropEnum.searchPath, PropEnum.defaultName}, new Sort[0], new QueryOptions());
            return (BaseROLAPDataSource)dsList[0];
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToRetrieveRolapDatasourceFromCM, e.getMessage());
        }
    }

    public String getROLAPModel(String dataSourceName) throws Exception {
        Model m = this.retrieveCMROLAPModel(dataSourceName);
        return m.getModel().getValue();
    }

    private void validateSecurityFile(String fileContent) throws Exception {
        SimpleXMLValidator validator = new SimpleXMLValidator();
        URL schemaURL = this.getClass().getResource(SCHEMA_CLASSPATH);
        validator.validateString(fileContent, schemaURL);
        StringBuilder sb = new StringBuilder();
        if (validator.encounteredErrors()) {
            String message;
            for (SAXParseException se : validator.getFatalErrors()) {
                message = LINE_STR + se.getLineNumber() + SPACE_COLON + se.getMessage();
                sb.append(message).append(NEWLINE);
            }
            for (SAXParseException se : validator.getErrors()) {
                message = LINE_STR + se.getLineNumber() + SPACE_COLON + se.getMessage();
                sb.append(message).append(NEWLINE);
            }
            for (SAXParseException se : validator.getWarnings()) {
                message = LINE_STR + se.getLineNumber() + SPACE_COLON + se.getMessage();
                sb.append(message).append(NEWLINE);
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolSecurityFileValidation, sb.toString());
        }
    }

    private static void writeToFile(String fileName, String text) {
        try {
            FileOutputStream fout = new FileOutputStream(fileName, false);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)fout, UTF_8);
            writer.write(text);
            writer.close();
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolGeneralError, e.getMessage());
        }
    }

    private static String createBackupFileDelimiter(String ds) {
        String delimiterString = "";
        for (int i = 0; i < 10; ++i) {
            delimiterString = delimiterString + ds;
        }
        return delimiterString;
    }
}

