/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaRule;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.SecManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool.LookupTableSpec;
import java.util.ArrayList;

public class SecurityRuleSpec {
    private String name = null;
    private String dimension = null;
    private String hierarchy = null;
    private String ruleType = null;
    private String securityType = null;
    private ArrayList<RuleSpecExpressionObj> expressions = new ArrayList();
    private RuleSpecExpressionObj grantDenySpec;

    public SecurityRuleSpec(String ruleName, String dimName, String hierName, String rType, String secType) {
        this.name = ruleName;
        this.dimension = dimName;
        this.hierarchy = hierName;
        if (rType != null && rType.length() > 0) {
            this.ruleType = rType;
        }
        if (secType != null && secType.length() > 0) {
            this.securityType = secType;
        }
    }

    public void addExpr(String expr, ExpressionType exprType, String exprAllAttr, String exprScopeAttr) {
        this.expressions.add(new RuleSpecExpressionObj(expr, exprType, exprAllAttr, exprScopeAttr));
    }

    public void setGrantDenySpec(LookupTableSpec lookupTableSpecification, ExpressionType exprType, String exprAllAttr, String exprScopeAttr) {
        this.grantDenySpec = new RuleSpecExpressionObj(lookupTableSpecification, exprType, exprAllAttr, exprScopeAttr);
    }

    public boolean isSecurityLookupRule() {
        return this.grantDenySpec != null;
    }

    public ArrayList<RuleSpecExpressionObj> getExprList() {
        return this.expressions;
    }

    public RuleSpecExpressionObj getGrantDenySpec() {
        return this.grantDenySpec;
    }

    public String getName() {
        return this.name;
    }

    public String getDimension() {
        return this.dimension;
    }

    public String getHierarchy() {
        return this.hierarchy;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public String getRuleType() {
        return this.ruleType;
    }

    private boolean hasGrantExpression() {
        for (RuleSpecExpressionObj expr : this.expressions) {
            if (ExpressionType.grant != expr.expressionType) continue;
            return true;
        }
        return false;
    }

    public void validate(ArrayList<String> issues) {
        if (this.hasGrantExpression()) {
            if (this.ruleType != null && this.ruleType.length() > 0 && ROLAPMetaRule.RuleType.valueOf(this.ruleType) == ROLAPMetaRule.RuleType.deny_self_and_descendants) {
                issues.add(XQEMessages.getMessage(XQEMessageKeys.ROL_AllowExpressionNotAllowedInDenyDescendantsRuleType, XQEMessages.getCurrProductLocale(), this.getName(), this.hierarchy, "", ROLAPMetaRule.RuleType.deny_self_and_descendants.toString()));
            }
        } else if (this.ruleType != null && this.ruleType.length() > 0 && ROLAPMetaRule.RuleType.valueOf(this.ruleType) == ROLAPMetaRule.RuleType.basic && this.securityType != null && this.securityType.length() > 0 && SecManager.SecurityType.valueOf(this.securityType) != SecManager.SecurityType.value) {
            issues.add(XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidSecurityRuleTypeCombination, XQEMessages.getCurrProductLocale(), this.getName(), this.getSecurityType().toString(), this.getRuleType().toString()));
        }
    }

    public static enum ExpressionType {
        grant,
        deny;


        public static ExpressionType getExpressionType(String type) throws Exception {
            if (type.equalsIgnoreCase("grant") || type.equalsIgnoreCase("olap:grant")) {
                return grant;
            }
            if (type.equalsIgnoreCase("deny") || type.equalsIgnoreCase("olap:deny")) {
                return deny;
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolInvalidExpressionType, type);
        }
    }

    public class RuleSpecExpressionObj {
        private final String expression;
        private final LookupTableSpec lookupTableSpec;
        private final ExpressionType expressionType;
        private final String expressionAllAttr;
        private final String expressionScopeAttr;

        public RuleSpecExpressionObj(String exprText, ExpressionType exprType, String exprAllAttr, String exprScopeAttr) {
            this.expression = exprText;
            this.lookupTableSpec = null;
            this.expressionType = exprType;
            this.expressionAllAttr = exprAllAttr;
            this.expressionScopeAttr = exprScopeAttr;
        }

        public String getExpression() {
            return this.expression;
        }

        public String getExpressionScopeAttr() {
            return this.expressionScopeAttr;
        }

        public String getExpressionAllAttr() {
            return this.expressionAllAttr;
        }

        public ExpressionType getExpressionType() {
            return this.expressionType;
        }

        public boolean isGantAll() {
            return this.expressionType.equals((Object)ExpressionType.grant) && Boolean.valueOf(this.expressionAllAttr) != false;
        }

        public RuleSpecExpressionObj(LookupTableSpec lookupTableSpecification, ExpressionType exprType, String exprAllAttr, String exprScopeAttr) {
            this.expression = null;
            this.lookupTableSpec = lookupTableSpecification;
            this.expressionType = exprType;
            this.expressionAllAttr = exprAllAttr;
            this.expressionScopeAttr = exprScopeAttr;
        }

        public LookupTableSpec getLookupTableSpec() {
            return this.lookupTableSpec;
        }
    }
}

