/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool;

import com.cognos.developer.schemas.bibus._3.BaseClass;
import com.cognos.developer.schemas.bibus._3.ModelView;
import com.cognos.developer.schemas.bibus._3.Permission;
import com.cognos.developer.schemas.bibus._3.Policy;
import com.cognos.developer.schemas.bibus._3.PolicyArrayProp;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool.LookupTableQueryItem;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool.LookupTableSpec;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool.SecurityPolicySpec;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool.SecurityRuleSpec;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.tool.SecurityViewSpec;
import com.cognos.xqe.trace.LogLevel;
import java.io.ByteArrayInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class SecuritySpec {
    private static final String UTF_8 = "UTF-8";
    private static final String NEWLINE = System.getProperty("line.separator");
    private static final String NAME_ATTR = "name";
    private static final String TYPE_ATTR = "type";
    private static final String SECURITYTYPE_ATTR = "securityType";
    private static final String SCOPE_ATTR = "scope";
    private static final String ALL_ATTR = "all";
    private static final String CUBENAME_ATTR = "cubeName";
    private static final String DIMENSION_ATTR = "dimension";
    private static final String HIERARCHY_ATTR = "hierarchy";
    private static final String SECURITY_ELM = "security";
    private static final String SECURITYRULES_ELM = "securityRules";
    private static final String SECURITYRULE_ELM = "rule";
    private static final String SECURITYVIEWS_ELM = "securityViews";
    private static final String SECURITYVIEW_ELM = "view";
    static final String GRANT_ELM = "grant";
    static final String DENY_ELM = "deny";
    private static final String RULEREF_ELM = "ruleRef";
    private static final String POLICY_ELM = "policy";
    private static final String PERMISSION_ELM = "permission";
    private static final String SECURITYOBJECT_ATTR = "securityObject";
    private static final String SECURITYOBJECTTYPE_ATTR = "securityObjectType";
    private static final String ACCESS_ATTR = "access";
    private static final String LOCALE_ATTR = "locale";
    private static final String DEFAULTLOCALE_ATTR = "defaultLocale";
    private static final String READ_VALUE = "read";
    private static final String LOOKUP_TABLE_QUERY_ITEM_ELEM = "lookupTableQueryItem";
    private static final String LEVEL_REF_ATTR = "levelRef";
    private static final String QUERY_ITEM_REF_ATTR = "queryItemRef";
    private static final String LOOKUP_TABLE_FILTER_ELEM = "lookupTableFilter";
    private static final String REF_OBJECT_ATTR = "refObject";
    private static final String OLAP_PREFIX = "olap:";
    private static final String OLAP_SECURITYRULES_ELM = "olap:securityRules";
    private static final String OLAP_VIEW_ELM = "olap:view";
    private static final String OLAP_VIEWS_ELM = "olap:views";
    private static final String OLAP_SECURITYDIMENSIONREF_ELM = "olap:securityDimensionRef";
    private static final String OLAP_SECURITYHIERARCHYREF_ELM = "olap:securityHierarchyRef";
    private static final String OLAP_RULEREF_ELM = "olap:ruleRef";
    private static final String OLAP_CUBE_ELM = "olap:cube";
    private static final String OLAP_SECURITY_ELM = "olap:security";
    private static final String OLAP_RULE_ELM = "olap:rule";
    static final String OLAP_GRANT_ELM = "olap:grant";
    static final String OLAP_DENY_ELM = "olap:deny";
    private static final String OLAP_DIMENSION_ELM = "olap:dimension";
    private static final String OLAP_HIERARCHY_ELM = "olap:hierarchy";
    private static final String OLAP_FACTS_ELM = "olap:facts";
    private static final String OLAP_NAME_ELM = "olap:name";
    private static final String OLAP_MDSCHEMA_ELM = "olap:mdSchema";
    private static final String MEASURE_DIM_NAME = "Measures";
    private static final String DIMENSION_CATEGORY_ATTR = "category";
    private static final String PUBLIC = "public";
    private SecurityRuleMap ruleMap = new SecurityRuleMap();
    private TreeMap<String, SecurityViewSpec> viewMap = new TreeMap();
    private String cube = null;
    private String cubeDefaultLocale = "en-us";

    private SecuritySpec(String cubeName) {
        this.cube = cubeName;
    }

    private static boolean isLogging() {
        return ROLAPLog.isOn("ROLAPCubes.Security", LogLevel.INFO);
    }

    public String getCubeName() {
        return this.cube;
    }

    public SecurityRuleMap getSecurityRules() {
        return this.ruleMap;
    }

    public Map<String, SecurityViewSpec> getSecurityViews() {
        return this.viewMap;
    }

    private void parseSecurityRuleFromSecurityFile(Node securityRules) throws Exception {
        if (securityRules != null) {
            ArrayList<Node> ruleNodeList = SecuritySpec.filterElementNodeList(SECURITYRULE_ELM, securityRules.getChildNodes());
            for (int i = 0; i < ruleNodeList.size(); ++i) {
                Node ruleNode = ruleNodeList.get(i);
                String ruleName = SecuritySpec.getAttributeValue(ruleNode, NAME_ATTR);
                String secTypeAttr = SecuritySpec.getAttributeValueNoException(ruleNode, SECURITYTYPE_ATTR);
                SecurityRuleSpec sRule = null;
                sRule = secTypeAttr != null && secTypeAttr.equalsIgnoreCase(DIMENSION_ATTR) ? new SecurityRuleSpec(ruleName, SecuritySpec.getAttributeValue(ruleNode, DIMENSION_ATTR), null, SecuritySpec.getAttributeValueNoException(ruleNode, TYPE_ATTR), secTypeAttr) : new SecurityRuleSpec(ruleName, SecuritySpec.getAttributeValue(ruleNode, DIMENSION_ATTR), SecuritySpec.getAttributeValue(ruleNode, HIERARCHY_ATTR), SecuritySpec.getAttributeValueNoException(ruleNode, TYPE_ATTR), secTypeAttr);
                ArrayList<Node> exprNodeList = SecuritySpec.filterElementNodeList(ruleNode.getChildNodes());
                for (int k = 0; k < exprNodeList.size(); ++k) {
                    Node grantDenyNode = exprNodeList.get(k);
                    String exprAllAttr = SecuritySpec.getAttributeValueNoException(grantDenyNode, ALL_ATTR);
                    String exprScopeAttr = SecuritySpec.getAttributeValueNoException(grantDenyNode, SCOPE_ATTR);
                    if (this.isSecurityLookupRule(grantDenyNode, false)) {
                        LookupTableSpec lookupTableSpec = this.getGrantDenyElementContent(grantDenyNode, false);
                        sRule.setGrantDenySpec(lookupTableSpec, SecurityRuleSpec.ExpressionType.getExpressionType(grantDenyNode.getNodeName()), exprAllAttr, exprScopeAttr);
                        continue;
                    }
                    sRule.addExpr(grantDenyNode.getTextContent(), SecurityRuleSpec.ExpressionType.getExpressionType(grantDenyNode.getNodeName()), exprAllAttr, exprScopeAttr);
                }
                this.ruleMap.put(sRule);
            }
        }
    }

    private void parseSecurityViewFromSecurityFile(Node views) throws Exception {
        if (views != null) {
            ArrayList<Node> viewNodeList = SecuritySpec.filterElementNodeList(SECURITYVIEW_ELM, views.getChildNodes());
            for (int i = 0; i < viewNodeList.size(); ++i) {
                Node view = viewNodeList.get(i);
                SecurityViewSpec securityView = new SecurityViewSpec(SecuritySpec.getAttributeValue(view, NAME_ATTR));
                ArrayList<Node> policyNodeList = SecuritySpec.filterElementNodeList(view.getChildNodes());
                for (int j = 0; j < policyNodeList.size(); ++j) {
                    Node child = policyNodeList.get(j);
                    if (child.getNodeName().equals(RULEREF_ELM)) {
                        String hierarchy;
                        String dimension;
                        String ruleRefName = SecuritySpec.getAttributeValue(child, NAME_ATTR);
                        SecurityRuleSpec ruleRef = this.ruleMap.get(ruleRefName, dimension = SecuritySpec.getAttributeValue(child, DIMENSION_ATTR), hierarchy = SecuritySpec.getAttributeValueNoException(child, HIERARCHY_ATTR));
                        if (ruleRef != null) {
                            securityView.addRule(ruleRef);
                            continue;
                        }
                        throw new XQERuntimeException(XQEMessageKeys.ROL_SecurityReferenceNotFoundInCube, (Object)ruleRefName, (Object)securityView.getName(), (Object)this.cube);
                    }
                    if (!child.getNodeName().equals(POLICY_ELM)) continue;
                    Node policyNode = child;
                    ArrayList<Node> permissionNodeList = SecuritySpec.filterElementNodeList(child.getChildNodes());
                    if (permissionNodeList.size() == 1) {
                        SecurityPolicySpec policy = new SecurityPolicySpec(SecuritySpec.getAttributeValue(policyNode, SECURITYOBJECT_ATTR), SecurityPolicySpec.SecurityObjectType.getObjectType(SecuritySpec.getAttributeValue(policyNode, SECURITYOBJECTTYPE_ATTR)), SecurityPolicySpec.AccessType.getAccessType(SecuritySpec.getAttributeValue(permissionNodeList.get(0), ACCESS_ATTR)));
                        securityView.addPolicy(policy);
                        continue;
                    }
                    throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolTooManyPermission, SecuritySpec.getAttributeValue(policyNode, SECURITYOBJECT_ATTR), securityView.getName());
                }
                this.viewMap.put(securityView.getName(), securityView);
            }
        }
    }

    public static SecuritySpec createInstanceFromSecurityFile(String cubeName, String securityFile) throws Exception {
        ByteArrayInputStream bis;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document model = docBuilder.parse(bis = new ByteArrayInputStream(securityFile.getBytes(UTF_8)));
        NodeList securityListNode = model.getElementsByTagName(SECURITY_ELM);
        if (securityListNode != null && securityListNode.getLength() == 1) {
            Node securityNode = securityListNode.item(0);
            String securityCubeName = SecuritySpec.getAttributeValue(securityNode, CUBENAME_ATTR);
            if (securityCubeName.equals(cubeName)) {
                SecuritySpec security = new SecuritySpec(cubeName);
                ArrayList<Node> list = SecuritySpec.filterElementNodeList(securityNode.getChildNodes());
                for (int i = 0; i < list.size(); ++i) {
                    if (list.get(i).getNodeName().equals(SECURITYRULES_ELM)) {
                        security.parseSecurityRuleFromSecurityFile(list.get(i));
                        continue;
                    }
                    if (!list.get(i).getNodeName().equals(SECURITYVIEWS_ELM)) continue;
                    security.parseSecurityViewFromSecurityFile(list.get(i));
                }
                ArrayList<String> issues = new ArrayList<String>();
                security.validate(issues);
                if (issues.size() > 0) {
                    StringBuilder reasons = new StringBuilder();
                    reasons.append(NEWLINE);
                    for (int i = 0; i < issues.size(); ++i) {
                        reasons.append("[" + i + ": " + issues.get(i) + "]" + NEWLINE);
                    }
                    throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolSecurityFileValidation, reasons.toString());
                }
                return security;
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolIncorrectImportFileForCube, securityCubeName, cubeName);
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolIncorrectHandlingTooManyCubes);
    }

    private void parseSecurityRuleFromCubeModel(Document model) throws Exception {
        Node mdSchema;
        String cmDefaultLocale;
        NodeList mdSchemaList = model.getElementsByTagName(OLAP_MDSCHEMA_ELM);
        if (mdSchemaList.getLength() > 0 && (cmDefaultLocale = SecuritySpec.getAttributeValueNoException(mdSchema = mdSchemaList.item(0), DEFAULTLOCALE_ATTR)) != null && cmDefaultLocale.length() > 0) {
            this.cubeDefaultLocale = cmDefaultLocale;
        }
        NodeList securityRulesElementList = model.getElementsByTagName(OLAP_SECURITYRULES_ELM);
        for (int i = 0; i < securityRulesElementList.getLength(); ++i) {
            Node hierarchyOrfactsElement = securityRulesElementList.item(i).getParentNode();
            String dimension = null;
            String hierarchy = null;
            if (hierarchyOrfactsElement.getNodeName().equals(OLAP_HIERARCHY_ELM)) {
                Node dimensionElement = hierarchyOrfactsElement.getParentNode();
                dimension = SecuritySpec.getLocalizedName(dimensionElement, this.cubeDefaultLocale);
                hierarchy = SecuritySpec.getLocalizedName(hierarchyOrfactsElement, this.cubeDefaultLocale);
            } else if (hierarchyOrfactsElement.getNodeName().equals(OLAP_DIMENSION_ELM)) {
                dimension = SecuritySpec.getLocalizedName(hierarchyOrfactsElement, this.cubeDefaultLocale);
                hierarchy = null;
            } else {
                dimension = MEASURE_DIM_NAME;
                hierarchy = MEASURE_DIM_NAME;
            }
            Node securityRulesElement = securityRulesElementList.item(i);
            ArrayList<Node> ruleElementList = SecuritySpec.filterElementNodeList(OLAP_RULE_ELM, securityRulesElement.getChildNodes());
            for (Node ruleElement : ruleElementList) {
                SecurityRuleSpec securityRule = new SecurityRuleSpec(SecuritySpec.getAttributeValue(ruleElement, NAME_ATTR), dimension, hierarchy, SecuritySpec.getAttributeValueNoException(ruleElement, TYPE_ATTR), SecuritySpec.getAttributeValueNoException(ruleElement, SECURITYTYPE_ATTR));
                ArrayList<Node> exprElementList = SecuritySpec.filterElementNodeList(ruleElement.getChildNodes());
                for (Node grantDenyNode : exprElementList) {
                    String exprAllAttr = SecuritySpec.getAttributeValueNoException(grantDenyNode, ALL_ATTR);
                    String exprScopeAttr = SecuritySpec.getAttributeValueNoException(grantDenyNode, SCOPE_ATTR);
                    if (this.isSecurityLookupRule(grantDenyNode, true)) {
                        LookupTableSpec lookupTableSpec = this.getGrantDenyElementContent(grantDenyNode, true);
                        securityRule.setGrantDenySpec(lookupTableSpec, SecurityRuleSpec.ExpressionType.getExpressionType(grantDenyNode.getNodeName()), exprAllAttr, exprScopeAttr);
                        continue;
                    }
                    if (grantDenyNode == null) continue;
                    securityRule.addExpr(grantDenyNode.getTextContent(), SecurityRuleSpec.ExpressionType.getExpressionType(grantDenyNode.getNodeName()), exprAllAttr, exprScopeAttr);
                }
                this.ruleMap.put(securityRule);
            }
        }
    }

    private void parseSecurityViewFromCubeModel(Document model, BaseClass[] modelViews) throws Exception {
        NodeList viewElementList = model.getElementsByTagName(OLAP_VIEW_ELM);
        if (viewElementList != null) {
            for (int i = 0; i < viewElementList.getLength(); ++i) {
                Node viewElement = viewElementList.item(i);
                String viewName = SecuritySpec.getAttributeValue(viewElement, NAME_ATTR);
                SecurityViewSpec view = new SecurityViewSpec(viewName);
                ArrayList<Node> dimRefElementList = SecuritySpec.filterElementNodeList(OLAP_SECURITYDIMENSIONREF_ELM, viewElement.getChildNodes());
                for (Node dimRefElement : dimRefElementList) {
                    ArrayList<Node> hierRefElementList = SecuritySpec.filterElementNodeList(OLAP_SECURITYHIERARCHYREF_ELM, dimRefElement.getChildNodes());
                    for (Node hierRefElement : hierRefElementList) {
                        ArrayList<Node> ruleRefElementList = SecuritySpec.filterElementNodeList(OLAP_RULEREF_ELM, hierRefElement.getChildNodes());
                        for (Node ruleRefElement : ruleRefElementList) {
                            String ruleName = SecuritySpec.getAttributeValue(ruleRefElement, NAME_ATTR);
                            String ruleDimension = SecuritySpec.getAttributeValue(dimRefElement, NAME_ATTR);
                            String ruleHierarchy = SecuritySpec.getAttributeValue(hierRefElement, NAME_ATTR);
                            SecurityRuleSpec ruleSpec = this.ruleMap.get(ruleName, ruleDimension, ruleHierarchy);
                            view.addRule(ruleSpec);
                        }
                    }
                    ArrayList<Node> ruleRefElementList = SecuritySpec.filterElementNodeList(OLAP_RULEREF_ELM, dimRefElement.getChildNodes());
                    for (Node ruleRefElement : ruleRefElementList) {
                        String ruleName = SecuritySpec.getAttributeValue(ruleRefElement, NAME_ATTR);
                        String ruleDimension = SecuritySpec.getAttributeValue(dimRefElement, NAME_ATTR);
                        String ruleHierarchy = null;
                        SecurityRuleSpec ruleSpec = this.ruleMap.get(ruleName, ruleDimension, ruleHierarchy);
                        view.addRule(ruleSpec);
                    }
                }
                this.viewMap.put(view.getName(), view);
            }
            for (int j = 0; j < modelViews.length; ++j) {
                ModelView modelView = (ModelView)modelViews[j];
                PolicyArrayProp policyProp = modelView.getPolicies();
                if (policyProp.getSchemaInfo().isAcquired()) continue;
                Policy[] policies = policyProp.getValue();
                for (int k = 0; k < policies.length; ++k) {
                    Policy p = policies[k];
                    Permission[] permissions = p.getPermissions();
                    for (int m = 0; m < permissions.length; ++m) {
                        if (!permissions[m].getName().equals(READ_VALUE)) continue;
                        String className = p.getSecurityObject().getClass().getName();
                        SecurityPolicySpec policySpec = new SecurityPolicySpec(p.getSecurityObject().getSearchPath().getValue(), SecurityPolicySpec.SecurityObjectType.getObjectType(className), SecurityPolicySpec.AccessType.getAccessType(permissions[m].getAccess().getValue()));
                        SecurityViewSpec viewSpec = this.viewMap.get(modelView.getDefaultName().getValue());
                        if (viewSpec == null) continue;
                        viewSpec.addPolicy(policySpec);
                    }
                }
            }
        }
    }

    public static SecuritySpec createInstanceFromCubeModel(String cubeModel, BaseClass[] modelViews) throws Exception {
        ByteArrayInputStream bis;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document model = docBuilder.parse(bis = new ByteArrayInputStream(cubeModel.getBytes(UTF_8)));
        NodeList cubeElementList = model.getElementsByTagName(OLAP_CUBE_ELM);
        if (cubeElementList != null && cubeElementList.getLength() == 1) {
            SecuritySpec security = new SecuritySpec(SecuritySpec.getAttributeValue(cubeElementList.item(0), NAME_ATTR));
            security.parseSecurityRuleFromCubeModel(model);
            security.parseSecurityViewFromCubeModel(model, modelViews);
            return security;
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolGeneralError, "olap:cube:null");
    }

    private void cleanSecurityInCubeModel(Document model) {
        ArrayList<Node> securityRulesElementList = SecuritySpec.filterElementNodeList(model.getElementsByTagName(OLAP_SECURITYRULES_ELM));
        for (int i = 0; i < securityRulesElementList.size(); ++i) {
            Node securityRuleElement = securityRulesElementList.get(i);
            Node parent = securityRuleElement.getParentNode();
            parent.removeChild(securityRuleElement);
        }
        NodeList securityElementList = model.getElementsByTagName(OLAP_SECURITY_ELM);
        for (int i = 0; i < securityElementList.getLength(); ++i) {
            Node securityElement = securityElementList.item(i);
            Node parent = securityElement.getParentNode();
            parent.removeChild(securityElement);
        }
    }

    private Node findDimensionNodeInCubeModel(Document model, String dimension) {
        if (model == null || dimension == null) {
            return null;
        }
        NodeList dimensionNodeList = model.getElementsByTagName(OLAP_DIMENSION_ELM);
        for (int i = 0; i < dimensionNodeList.getLength(); ++i) {
            Node dimensionNode = dimensionNodeList.item(i);
            String localizedName = SecuritySpec.getLocalizedNameNoException(dimensionNode, this.cubeDefaultLocale);
            if (!localizedName.equals(dimension)) continue;
            return dimensionNode;
        }
        return null;
    }

    private Node findHierarcyNodeInDimension(Node dimensionNode, String hierarchy) {
        if (dimensionNode == null || hierarchy == null) {
            return null;
        }
        ArrayList<Node> hierarchyNodeList = SecuritySpec.filterElementNodeList(OLAP_HIERARCHY_ELM, dimensionNode.getChildNodes());
        for (int ii = 0; ii < hierarchyNodeList.size(); ++ii) {
            Node hierarchyNode = hierarchyNodeList.get(ii);
            String localizedName = SecuritySpec.getLocalizedNameNoException(hierarchyNode, this.cubeDefaultLocale);
            if (!localizedName.equals(hierarchy)) continue;
            return hierarchyNode;
        }
        return null;
    }

    public String serializeSecuritySpecToCubeModel(String cubeModel) throws Exception {
        Node mdSchema;
        String cmDefaultLocale;
        ByteArrayInputStream bis;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document model = docBuilder.parse(bis = new ByteArrayInputStream(cubeModel.getBytes(UTF_8)));
        NodeList mdSchemaList = model.getElementsByTagName(OLAP_MDSCHEMA_ELM);
        if (mdSchemaList.getLength() > 0 && (cmDefaultLocale = SecuritySpec.getAttributeValueNoException(mdSchema = mdSchemaList.item(0), DEFAULTLOCALE_ATTR)) != null && cmDefaultLocale.length() > 0) {
            this.cubeDefaultLocale = cmDefaultLocale;
        }
        this.cleanSecurityInCubeModel(model);
        for (SecurityRuleSpec ruleSpec : this.ruleMap.values()) {
            Node dimensionNode;
            Node hierarchyOrfactsNode = null;
            if (ruleSpec.getDimension().equals(MEASURE_DIM_NAME) && ruleSpec.getHierarchy().equals(MEASURE_DIM_NAME)) {
                NodeList factsNodeList = model.getElementsByTagName(OLAP_FACTS_ELM);
                if (factsNodeList.getLength() == 1) {
                    hierarchyOrfactsNode = factsNodeList.item(0);
                }
            } else {
                dimensionNode = this.findDimensionNodeInCubeModel(model, ruleSpec.getDimension());
                if (dimensionNode != null) {
                    hierarchyOrfactsNode = this.findHierarcyNodeInDimension(dimensionNode, ruleSpec.getHierarchy());
                }
            }
            if (hierarchyOrfactsNode != null) {
                Node securityRulesElement;
                ArrayList<Node> securityRulesNodeList = SecuritySpec.filterElementNodeList(OLAP_SECURITYRULES_ELM, hierarchyOrfactsNode.getChildNodes());
                if (securityRulesNodeList.size() > 0) {
                    securityRulesElement = securityRulesNodeList.get(0);
                } else {
                    securityRulesElement = model.createElement(OLAP_SECURITYRULES_ELM);
                    hierarchyOrfactsNode.appendChild(securityRulesElement);
                }
                Element ruleElement = model.createElement(OLAP_RULE_ELM);
                ruleElement.setAttribute(NAME_ATTR, ruleSpec.getName());
                if (ruleSpec.getRuleType() != null) {
                    ruleElement.setAttribute(TYPE_ATTR, ruleSpec.getRuleType());
                }
                if (ruleSpec.getSecurityType() != null) {
                    ruleElement.setAttribute(SECURITYTYPE_ATTR, ruleSpec.getSecurityType());
                }
                if (ruleSpec.isSecurityLookupRule()) {
                    SecurityRuleSpec.RuleSpecExpressionObj grantDenySpec = ruleSpec.getGrantDenySpec();
                    Element grantDenyElement = this.createGrantDenyElement(model, ruleSpec, grantDenySpec, true);
                    this.addGrantDenyElementContent(ruleSpec, model, grantDenySpec, grantDenyElement, true);
                    ruleElement.appendChild(grantDenyElement);
                } else {
                    ArrayList<SecurityRuleSpec.RuleSpecExpressionObj> expressions = ruleSpec.getExprList();
                    for (SecurityRuleSpec.RuleSpecExpressionObj expr : expressions) {
                        Element grantDenyElement = this.createGrantDenyElement(model, ruleSpec, expr, true);
                        this.addGrantDenyElementContent(ruleSpec, model, expr, grantDenyElement, true);
                        ruleElement.appendChild(grantDenyElement);
                    }
                }
                securityRulesElement.appendChild(ruleElement);
                continue;
            }
            dimensionNode = this.findDimensionNodeInCubeModel(model, ruleSpec.getDimension());
            String secType = ruleSpec.getSecurityType();
            if (dimensionNode != null && secType != null && secType.equalsIgnoreCase(DIMENSION_ATTR)) {
                Node securityRulesElement;
                ArrayList<Node> securityRulesNodeList = SecuritySpec.filterElementNodeList(OLAP_SECURITYRULES_ELM, dimensionNode.getChildNodes());
                if (securityRulesNodeList.size() > 0) {
                    securityRulesElement = securityRulesNodeList.get(0);
                } else {
                    securityRulesElement = model.createElement(OLAP_SECURITYRULES_ELM);
                    dimensionNode.appendChild(securityRulesElement);
                }
                Element ruleElement = model.createElement(OLAP_RULE_ELM);
                ruleElement.setAttribute(NAME_ATTR, ruleSpec.getName());
                if (ruleSpec.getRuleType() != null) {
                    ruleElement.setAttribute(TYPE_ATTR, ruleSpec.getRuleType());
                }
                if (ruleSpec.getSecurityType() != null) {
                    ruleElement.setAttribute(SECURITYTYPE_ATTR, ruleSpec.getSecurityType());
                }
                ArrayList<SecurityRuleSpec.RuleSpecExpressionObj> expressions = ruleSpec.getExprList();
                for (SecurityRuleSpec.RuleSpecExpressionObj expr : expressions) {
                    Element grantDenyElement = this.createGrantDenyElement(model, ruleSpec, expr, true);
                    this.addGrantDenyElementContent(ruleSpec, model, expr, grantDenyElement, true);
                    ruleElement.appendChild(grantDenyElement);
                }
                securityRulesElement.appendChild(ruleElement);
                continue;
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolIncorrectNoSuchRuleInHierarchy, ruleSpec.getHierarchy(), ruleSpec.getName());
        }
        Element securityElement = model.createElement(OLAP_SECURITY_ELM);
        Element viewsElement = model.createElement(OLAP_VIEWS_ELM);
        securityElement.appendChild(viewsElement);
        Iterator<SecurityViewSpec> secViewIt = this.viewMap.values().iterator();
        while (secViewIt.hasNext()) {
            Element viewElement = model.createElement(OLAP_VIEW_ELM);
            SecurityViewSpec view = secViewIt.next();
            viewElement.setAttribute(NAME_ATTR, view.getName());
            for (SecurityRuleSpec ruleSpec : view.getRuleSpecs()) {
                Element securityDimensionRefElement = model.createElement(OLAP_SECURITYDIMENSIONREF_ELM);
                securityDimensionRefElement.setAttribute(NAME_ATTR, ruleSpec.getDimension());
                String secType = ruleSpec.getSecurityType();
                if (!ruleSpec.getDimension().equals(MEASURE_DIM_NAME) && secType != null && secType.equalsIgnoreCase(DIMENSION_ATTR)) {
                    securityDimensionRefElement.setAttribute(DIMENSION_CATEGORY_ATTR, PUBLIC);
                    Element ruleRefElement = model.createElement(OLAP_RULEREF_ELM);
                    ruleRefElement.setAttribute(NAME_ATTR, ruleSpec.getName());
                    securityDimensionRefElement.appendChild(ruleRefElement);
                } else {
                    String publicOrPrivate = PUBLIC;
                    if (ruleSpec.getDimension().equals(MEASURE_DIM_NAME) && ruleSpec.getHierarchy().equals(MEASURE_DIM_NAME)) {
                        publicOrPrivate = "private";
                    }
                    securityDimensionRefElement.setAttribute(DIMENSION_CATEGORY_ATTR, publicOrPrivate);
                    Element securityHierRefElement = model.createElement(OLAP_SECURITYHIERARCHYREF_ELM);
                    securityDimensionRefElement.appendChild(securityHierRefElement);
                    securityHierRefElement.setAttribute(NAME_ATTR, ruleSpec.getHierarchy());
                    Element ruleRefElement = model.createElement(OLAP_RULEREF_ELM);
                    ruleRefElement.setAttribute(NAME_ATTR, ruleSpec.getName());
                    securityHierRefElement.appendChild(ruleRefElement);
                }
                viewElement.appendChild(securityDimensionRefElement);
            }
            viewsElement.appendChild(viewElement);
        }
        NodeList cubeElementList = model.getElementsByTagName(OLAP_CUBE_ELM);
        if (cubeElementList != null && cubeElementList.getLength() == 1 && this.viewMap.size() > 0) {
            cubeElementList.item(0).appendChild(securityElement);
        }
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(model);
        StreamResult result = new StreamResult(new StringWriter());
        transformer.transform(source, result);
        return result.getWriter().toString();
    }

    private Element createGrantDenyElement(Document model, SecurityRuleSpec ruleSpec, SecurityRuleSpec.RuleSpecExpressionObj grantDenySpec, boolean elementForCubeModel) {
        Element exprTypeElement;
        String olapPrefix = "";
        if (elementForCubeModel) {
            olapPrefix = OLAP_PREFIX;
        }
        if (grantDenySpec.getExpressionType().equals((Object)SecurityRuleSpec.ExpressionType.grant)) {
            exprTypeElement = model.createElement(olapPrefix + GRANT_ELM);
            if (Boolean.valueOf(grantDenySpec.getExpressionAllAttr()).booleanValue()) {
                exprTypeElement.setAttribute(ALL_ATTR, grantDenySpec.getExpressionAllAttr());
                if (SecuritySpec.isLogging() && (grantDenySpec.getExpressionScopeAttr() != null || grantDenySpec.getExpression() != null)) {
                    ROLAPLog.log("ROLAPCubes.Security", "The 'grant' rule \"" + ruleSpec.getName() + "\" has the 'all' attribute set to 'true'. The attribute 'scope' and the expression will be ignored.");
                }
            }
        } else {
            exprTypeElement = model.createElement(olapPrefix + DENY_ELM);
        }
        return exprTypeElement;
    }

    private void addGrantDenyElementContent(SecurityRuleSpec ruleSpec, Document securityDoc, SecurityRuleSpec.RuleSpecExpressionObj grantDenySpec, Element grantDenyElement, boolean elementForCubeModel) {
        if (grantDenySpec.isGantAll()) {
            return;
        }
        String olapPrefix = "";
        if (elementForCubeModel) {
            olapPrefix = OLAP_PREFIX;
        }
        if (ruleSpec.isSecurityLookupRule()) {
            LookupTableQueryItem[] ltQueryItems;
            LookupTableSpec lookupTableSpec = grantDenySpec.getLookupTableSpec();
            for (LookupTableQueryItem ltQueryItem : ltQueryItems = lookupTableSpec.getQueryItems()) {
                Element ltQueryItemElement = securityDoc.createElement(olapPrefix + LOOKUP_TABLE_QUERY_ITEM_ELEM);
                ltQueryItemElement.setAttribute(LEVEL_REF_ATTR, ltQueryItem.getLevelRef());
                ltQueryItemElement.setAttribute(QUERY_ITEM_REF_ATTR, ltQueryItem.getQueryItem());
                grantDenyElement.appendChild(ltQueryItemElement);
            }
            Element ltFilterElement = securityDoc.createElement(olapPrefix + LOOKUP_TABLE_FILTER_ELEM);
            ltFilterElement.setTextContent(lookupTableSpec.getFilterExpression());
            grantDenyElement.appendChild(ltFilterElement);
        } else {
            grantDenyElement.setTextContent(grantDenySpec.getExpression());
        }
        if (grantDenySpec.getExpressionScopeAttr() != null && grantDenySpec.getExpressionScopeAttr().length() > 0) {
            grantDenyElement.setAttribute(SCOPE_ATTR, grantDenySpec.getExpressionScopeAttr());
        }
    }

    private LookupTableSpec getGrantDenyElementContent(Node grantDenyNode, boolean elementFromCubeModel) throws Exception {
        ArrayList<LookupTableQueryItem> lookupTableQueryItems = new ArrayList<LookupTableQueryItem>();
        String filterExpr = null;
        String olapPrefix = "";
        if (elementFromCubeModel) {
            olapPrefix = OLAP_PREFIX;
        }
        ArrayList<Node> grantDenyNodeList = SecuritySpec.filterElementNodeList(grantDenyNode.getChildNodes());
        for (Node grantDenyChildNode : grantDenyNodeList) {
            if (grantDenyChildNode.getNodeName().equals(olapPrefix + LOOKUP_TABLE_QUERY_ITEM_ELEM)) {
                String levelRef = SecuritySpec.getAttributeValueNoException(grantDenyChildNode, LEVEL_REF_ATTR);
                String queryItem = SecuritySpec.getAttributeValue(grantDenyChildNode, QUERY_ITEM_REF_ATTR);
                lookupTableQueryItems.add(new LookupTableQueryItem(levelRef, queryItem));
                continue;
            }
            if (!grantDenyChildNode.getNodeName().equals(olapPrefix + LOOKUP_TABLE_FILTER_ELEM)) continue;
            filterExpr = grantDenyChildNode.getTextContent();
        }
        LookupTableSpec lookupTableSpec = new LookupTableSpec(lookupTableQueryItems.toArray(new LookupTableQueryItem[lookupTableQueryItems.size()]), filterExpr);
        return lookupTableSpec;
    }

    public String serializeAsSecurityFile() throws Exception {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = factory.newDocumentBuilder();
            Document securityDoc = docBuilder.newDocument();
            Element securityElement = securityDoc.createElement(SECURITY_ELM);
            securityElement.setAttribute(CUBENAME_ATTR, this.cube);
            Element securityRulesElement = securityDoc.createElement(SECURITYRULES_ELM);
            for (SecurityRuleSpec ruleSpec : this.ruleMap.values()) {
                Element securityRuleElement = securityDoc.createElement(SECURITYRULE_ELM);
                if (ruleSpec.getHierarchy() != null) {
                    securityRuleElement.setAttribute(HIERARCHY_ATTR, ruleSpec.getHierarchy());
                }
                securityRuleElement.setAttribute(DIMENSION_ATTR, ruleSpec.getDimension());
                securityRuleElement.setAttribute(NAME_ATTR, ruleSpec.getName());
                if (ruleSpec.getRuleType() != null) {
                    securityRuleElement.setAttribute(TYPE_ATTR, ruleSpec.getRuleType());
                }
                if (ruleSpec.getSecurityType() != null) {
                    securityRuleElement.setAttribute(SECURITYTYPE_ATTR, ruleSpec.getSecurityType());
                }
                if (ruleSpec.isSecurityLookupRule()) {
                    SecurityRuleSpec.RuleSpecExpressionObj grantDenySpec = ruleSpec.getGrantDenySpec();
                    Element grantDenyElement = this.createGrantDenyElement(securityDoc, ruleSpec, grantDenySpec, false);
                    this.addGrantDenyElementContent(ruleSpec, securityDoc, grantDenySpec, grantDenyElement, false);
                    securityRuleElement.appendChild(grantDenyElement);
                } else {
                    ArrayList<SecurityRuleSpec.RuleSpecExpressionObj> expressions = ruleSpec.getExprList();
                    for (SecurityRuleSpec.RuleSpecExpressionObj expr : expressions) {
                        Element grantDenyElement = this.createGrantDenyElement(securityDoc, ruleSpec, expr, false);
                        this.addGrantDenyElementContent(ruleSpec, securityDoc, expr, grantDenyElement, false);
                        securityRuleElement.appendChild(grantDenyElement);
                    }
                }
                securityRulesElement.appendChild(securityRuleElement);
            }
            securityElement.appendChild(securityRulesElement);
            Element securityViewsElement = securityDoc.createElement(SECURITYVIEWS_ELM);
            for (SecurityViewSpec view : this.viewMap.values()) {
                Element securityViewElement = securityDoc.createElement(SECURITYVIEW_ELM);
                securityViewElement.setAttribute(NAME_ATTR, view.getName());
                for (SecurityRuleSpec ref : view.getRuleSpecs()) {
                    Element ruleRefElement = securityDoc.createElement(RULEREF_ELM);
                    if (ref.getHierarchy() != null) {
                        ruleRefElement.setAttribute(HIERARCHY_ATTR, ref.getHierarchy());
                    }
                    ruleRefElement.setAttribute(DIMENSION_ATTR, ref.getDimension());
                    ruleRefElement.setAttribute(NAME_ATTR, ref.getName());
                    securityViewElement.appendChild(ruleRefElement);
                }
                for (SecurityPolicySpec policy : view.getPolicySpecs()) {
                    Element policyElement = securityDoc.createElement(POLICY_ELM);
                    policyElement.setAttribute(SECURITYOBJECT_ATTR, policy.getSecurityObject());
                    policyElement.setAttribute(SECURITYOBJECTTYPE_ATTR, policy.getSecurityObjectType().toString());
                    Element permissionElement = securityDoc.createElement(PERMISSION_ELM);
                    permissionElement.setAttribute(NAME_ATTR, READ_VALUE);
                    permissionElement.setAttribute(ACCESS_ATTR, policy.getAccess().toString());
                    policyElement.appendChild(permissionElement);
                    securityViewElement.appendChild(policyElement);
                }
                securityViewsElement.appendChild(securityViewElement);
            }
            securityElement.appendChild(securityViewsElement);
            securityDoc.appendChild(securityElement);
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(securityDoc);
            StreamResult result = new StreamResult(new StringWriter());
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            transformer.transform(source, result);
            return result.getWriter().toString();
        }
        catch (Exception e) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolUnableToExportSecurityFile, e.getMessage());
        }
    }

    public ModelView[] fillMappingForModelViewList(BaseClass[] modelViews) {
        Map<String, SecurityViewSpec> views = this.getSecurityViews();
        ArrayList<ModelView> modelViewsToUpdate = new ArrayList<ModelView>();
        if (modelViews != null) {
            for (int i = 0; i < modelViews.length; ++i) {
                int numPolicies;
                ModelView mView = (ModelView)modelViews[i];
                PolicyArrayProp policyArrayProp = new PolicyArrayProp();
                String viewName = mView.getDefaultName().getValue();
                SecurityViewSpec viewSpec = views.get(viewName);
                if (viewSpec == null || (numPolicies = viewSpec.getPolicySpecs().size()) <= 0) continue;
                Policy[] policies = new Policy[numPolicies];
                for (int j = 0; j < numPolicies; ++j) {
                    Policy policy = new Policy();
                    SecurityPolicySpec policySpec = viewSpec.getPolicySpecs().get(j);
                    BaseClass securityObj = policySpec.createCMSecurityObject();
                    policy.setSecurityObject(securityObj);
                    policy.setPermissions(new Permission[]{policySpec.createCMPermissionObject()});
                    policies[j] = policy;
                }
                policyArrayProp.setValue(policies);
                mView.setPolicies(policyArrayProp);
                modelViewsToUpdate.add(mView);
            }
        }
        ModelView[] modelViewArr = null;
        if (modelViewsToUpdate.size() > 0) {
            modelViewArr = new ModelView[modelViewsToUpdate.size()];
            modelViewsToUpdate.toArray(modelViewArr);
        }
        return modelViewArr;
    }

    private static ArrayList<Node> filterElementNodeList(NodeList nl) {
        return SecuritySpec.filterElementNodeList(null, nl);
    }

    private static ArrayList<Node> filterElementNodeList(String elementTagName, NodeList nl) {
        ArrayList<Node> newNL = new ArrayList<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1 || elementTagName != null && !nl.item(i).getNodeName().equals(elementTagName)) continue;
            newNL.add(nl.item(i));
        }
        return newNL;
    }

    private static String getAttributeValue(Node node, String attrName) throws Exception {
        NamedNodeMap nnm = node.getAttributes();
        if (nnm != null) {
            int t = nnm.getLength();
            for (int j = 0; j < t; ++j) {
                Node n = nnm.item(j);
                if (!n.getNodeName().equals(attrName)) continue;
                return n.getNodeValue();
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolMissingAttributeValue, attrName);
        }
        throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolMissingAttribute, attrName, node.getNodeName());
    }

    private static String getAttributeValueNoException(Node node, String attrName) {
        try {
            return SecuritySpec.getAttributeValue(node, attrName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String getLocalizedName(Node node, String locale) throws Exception {
        ArrayList<Node> nameNodeList = SecuritySpec.filterElementNodeList(OLAP_NAME_ELM, node.getChildNodes());
        if (nameNodeList.size() > 0) {
            for (int ii = 0; ii < nameNodeList.size(); ++ii) {
                Node nameNode = nameNodeList.get(ii);
                if (nameNode == null || !SecuritySpec.getAttributeValue(nameNode, LOCALE_ATTR).equalsIgnoreCase(locale)) continue;
                return nameNode.getTextContent();
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_SecToolMissingAttributeValue, OLAP_NAME_ELM);
        }
        return SecuritySpec.getAttributeValue(node, NAME_ATTR);
    }

    private static String getLocalizedNameNoException(Node node, String locale) {
        try {
            return SecuritySpec.getLocalizedName(node, locale);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private boolean isSecurityLookupRule(Node grantDenyElement, boolean elemFromCubeModel) {
        NodeList childNodeList = grantDenyElement.getChildNodes();
        if (childNodeList.getLength() <= 1) {
            return false;
        }
        String olapPrefix = "";
        if (elemFromCubeModel) {
            olapPrefix = OLAP_PREFIX;
        }
        for (int i = 0; i < childNodeList.getLength(); ++i) {
            if (childNodeList.item(i).getNodeType() != 1 || !childNodeList.item(i).getNodeName().equals(olapPrefix + LOOKUP_TABLE_QUERY_ITEM_ELEM)) continue;
            return true;
        }
        return false;
    }

    public void validate(ArrayList<String> issues) {
        Iterator<SecurityRuleSpec> rulesIt = this.ruleMap.values().iterator();
        while (rulesIt.hasNext()) {
            rulesIt.next().validate(issues);
        }
    }

    private final class SecurityRuleMap {
        private TreeMap<String, SecurityRuleSpec> ruleMap = new TreeMap();

        private SecurityRuleMap() {
        }

        public SecurityRuleSpec get(String ruleName, String ruleDimension, String ruleHierarchy) {
            return this.ruleMap.get(this.keyGen(ruleName, ruleDimension, ruleHierarchy));
        }

        public void put(SecurityRuleSpec rule) {
            this.ruleMap.put(this.keyGen(rule.getName(), rule.getDimension(), rule.getHierarchy()), rule);
        }

        public Collection<SecurityRuleSpec> values() {
            return this.ruleMap.values();
        }

        private String keyGen(String ruleName, String ruleDimension, String ruleHierarchy) {
            String key = ruleName + ruleDimension + ruleHierarchy;
            return key.toLowerCase();
        }
    }
}

