/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentRefCountingMap<K, V> {
    private ReentrantReadWriteLock mLock = new ReentrantReadWriteLock();
    private HashMap<K, AtomicLong> mCounts = new HashMap();
    private HashMap<K, Set<V>> mValues = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(K key, V value) {
        this.mLock.writeLock().lock();
        try {
            Set<Object> set;
            AtomicLong count = this.mCounts.get(key);
            if (count == null) {
                this.mCounts.put(key, new AtomicLong(1L));
                set = Collections.newSetFromMap(new ConcurrentHashMap());
                this.mValues.put(key, set);
            } else {
                count.incrementAndGet();
                set = this.mValues.get(key);
            }
            set.add(value);
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public Set<V> get(K key) {
        this.mLock.readLock().lock();
        try {
            Set<V> set = this.mValues.get(key);
            return set;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public void clear() {
        this.mLock.writeLock().lock();
        try {
            this.mCounts.clear();
            this.mValues.clear();
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    public void removeAll(K key) {
        this.mLock.writeLock().lock();
        try {
            this.mCounts.remove(key);
            this.mValues.remove(key);
        }
        finally {
            this.mLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(K key) {
        this.mLock.writeLock().lock();
        try {
            AtomicLong count = this.mCounts.get(key);
            if (count == null) {
                boolean bl = true;
                return bl;
            }
            if (count.decrementAndGet() <= 0L) {
                this.removeAll(key);
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.mLock.writeLock().unlock();
        }
        return false;
    }

    public Set<K> keySet() {
        this.mLock.readLock().lock();
        try {
            HashSet<K> hashSet = new HashSet<K>(this.mCounts.keySet());
            return hashSet;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }

    public int size() {
        this.mLock.readLock().lock();
        try {
            int n = this.mCounts.size();
            return n;
        }
        finally {
            this.mLock.readLock().unlock();
        }
    }
}

