/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.util;

import com.cognos.pogo.pdk.BIBusEnvelope;
import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.ast.macro.MacroExpander;
import com.cognos.xqe.ast.v5Exp.V5ExpressionProcessor;
import com.cognos.xqe.ast.v5Exp.V5MemberUniqueName;
import com.cognos.xqe.ast.v5Exp.V5MultiPartIdentifier;
import com.cognos.xqe.bibushandler.RequestEnvironment;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.IMetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.metadata.provider.MetadataService;
import com.cognos.xqe.query.engine.ExecutionEnvironment;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.query.engine.PlanningEnvironment;
import com.cognos.xqe.query.engine.QueryEngine;
import com.cognos.xqe.query.planner.QueryPlanner;
import com.cognos.xqe.resultset.interfaces.IHybridResultSet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.PlannedV5QuerySet;
import com.cognos.xqe.runtree.XDataContext;
import com.cognos.xqe.runtree.XIterator;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.TraceContext;
import com.cognos.xqe.transformation.v5.util.V5SubQueryBuilder;
import com.cognos.xqe.util.IReleasable;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.zipi.ZipiBridge;
import com.cognos.xqe.zipi.ZipiContext;
import com.ibm.cognos.pogo.zipi.ZipiTimer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class V5ExpressionUtils {
    private static final String REQUEST_ID_FOR_VALIDATION = "requestIDForValidation";
    private static final String CUBE_NAME = "$CUBE_NAME$";
    private static final String CM_DATASOURCE_NAME = "$CM_DS_NAME$";
    private static final String CONNECTION_TEMPLATE = "dimensionalSource[sourceType=RO; cmDataSource=$CM_DS_NAME$; catalog=ROLAP Catalog; cube=$CUBE_NAME$]";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashSet<IMember> executeAndFetchMembers(IHierarchy hierarchy, ROLAPCube cube, String v5Expression) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCFetchingMembersFromCube", cube.getName());
        try {
            HashSet<IMember> hashSet = V5ExpressionUtils.tryToExecuteAndFetchMembers(hierarchy, cube, v5Expression);
            return hashSet;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<IMember> tryToExecuteAndFetchMembers(IHierarchy hierarchy, ROLAPCube cube, String v5Expression) {
        HashSet<IMember> members = null;
        TraceContext traceCtx = TraceContext.enter();
        IReleasable c = null;
        try {
            RequestEnvironment reqEnv = V5ExpressionUtils.createRequestEnvironment(REQUEST_ID_FOR_VALIDATION, hierarchy, cube.getName());
            reqEnv.setCMRequestExecutor(cube.getAccountManager());
            PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
            ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
            c = V5ExpressionUtils.buildMetadataConnection(execEnv, cube);
            planEnv.setMetdataConnection((IMetadataConnection)c);
            MultiRequestContext multiRequestContext = execEnv.getMultiRequestContext();
            ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(execEnv);
            multiRequestContext.incrementRefCount();
            ROLAPLog.logOpStart(LogLevel.TRACE, "ROLAPCubes.Security", "Started fetching members from cube [" + cube.getName() + "] for expression: \"" + v5Expression + "\"");
            try {
                PlannedV5QuerySet plannedQuerySet = V5SubQueryBuilder.planSingleExpressionQuery(v5Expression, planEnv, false, true);
                XDataContext dataContext = execEnv.pushDataContext();
                try {
                    IHybridResultSet rs = null;
                    try {
                        rs = V5SubQueryBuilder.executeSubQuery(dataContext, plannedQuerySet);
                        members = V5ExpressionUtils.fetchMembers(rs, cube);
                        ROLAPLog.log("ROLAPCubes.Security", "Expression returned " + members.size() + " members.");
                    }
                    finally {
                        if (rs != null) {
                            rs.release();
                        }
                    }
                }
                finally {
                    execEnv.popDataContext(dataContext);
                }
            }
            catch (XQERuntimeException e) {
                ROLAPLog.logError("ROLAPCubes.Security", "Expression evaluation had an error", e);
                throw e;
            }
            finally {
                try {
                    ROLAPLog.logOpEnd(LogLevel.TRACE, "ROLAPCubes.Security", "Finished fetching members.");
                    multiRequestContext.decrementRefCount();
                }
                finally {
                    executionEnvironmentContext.exit();
                }
            }
        }
        finally {
            traceCtx.exit();
            if (c != null) {
                c.release();
            }
        }
        return members;
    }

    private static MetadataConnection buildMetadataConnection(ExecutionEnvironment execEnv, IROLAPCube cube) {
        String cmDatasourceName = System.getProperty(V5ExpressionUtils.buildDatasourceKey(cube.getName()));
        if (cmDatasourceName == null) {
            cmDatasourceName = cube.getName();
        }
        String defaultLocale = null;
        if (cube instanceof ROLAPVirtualCube) {
            defaultLocale = ((ROLAPVirtualCube)cube).getMetaCube().getDefaultLocale();
        } else if (cube instanceof ROLAPCube) {
            defaultLocale = ((ROLAPCube)cube).getModelCube().getDefaultLocale();
        }
        ((RequestEnvironment)execEnv.getRequestEnvironment()).setRunLocale(defaultLocale);
        ((RequestEnvironment)execEnv.getRequestEnvironment()).setExpressionLocale(defaultLocale);
        return V5ExpressionUtils.buildMetadataConnection(execEnv, cube.getName(), cmDatasourceName);
    }

    private static MetadataConnection buildMetadataConnection(ExecutionEnvironment execEnv, String cubeName, String cmDatasourceName) {
        String packageConnectionString = CONNECTION_TEMPLATE.replace(CUBE_NAME, cubeName);
        packageConnectionString = packageConnectionString.replace(CM_DATASOURCE_NAME, cmDatasourceName);
        MetadataConnection c = MetadataService.getInstance().getConnection("MFW4J", packageConnectionString, execEnv, false);
        return c;
    }

    private static RequestEnvironment createRequestEnvironment(String requestID, IHierarchy hierarchy, String cubeName) {
        ExecutionEnvironment execEnv = (ExecutionEnvironment)ExecutionEnvironmentContext.getExecutionEnvironment();
        RequestEnvironment reqEnv = ((RequestEnvironment)execEnv.getRequestEnvironment()).duplicate();
        reqEnv.setRequestID(requestID);
        reqEnv.setSubRequestID(null);
        if (hierarchy != null) {
            String reportName = hierarchy.getDimension().getName() + "_" + hierarchy.getName();
            reqEnv.setReportName(reportName);
        }
        reqEnv.setCubeName(cubeName);
        return reqEnv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashSet<IMember> fetchMembers(IHybridResultSet hybridResultSet, ROLAPCube cube) {
        HashSet<IMember> members = new HashSet<IMember>();
        XIterator xIt = null;
        try {
            if (hybridResultSet.getNumAxes() > 0) {
                xIt = hybridResultSet.getAxisIterator(0);
                ITuple tuple = (ITuple)xIt.next();
                while (tuple != null) {
                    IMember[] memberArray = tuple.getMembers();
                    if (memberArray != null) {
                        for (IMember m : memberArray) {
                            IMember includeMember = m;
                            if (includeMember.isCalculatedMember()) {
                                String originalV5Name = ((CalculatedMember)m).getOriginalV5Name();
                                includeMember = m.isMeasure() ? cube.getMeasure(originalV5Name) : cube.getCalculatedMember(UniqueNameGenerator.createProviderMemberUniqueName("RO", UniqueNameGenerator.extractPhysicalPartFromCognosMUN(originalV5Name)));
                            }
                            if (includeMember == null) continue;
                            members.add(includeMember);
                        }
                    }
                    tuple = (ITuple)xIt.next();
                }
            }
        }
        finally {
            if (null != xIt) {
                xIt.release();
            }
        }
        return members;
    }

    public static String buildDatasourceKey(String cubeName) {
        return cubeName + CM_DATASOURCE_NAME;
    }

    /*
     * Exception decompiling
     */
    public static final boolean validateSimpleExpression(ROLAPCube cube, String v5Expression, StringBuilder planningException, Map<String, Object> queryProperties, boolean isModelSecurityCheckRequired) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean validateCalculatedMemberDefinition(IHierarchy hierarchy, IROLAPCube cube, IROLAPMember rolapMember, String calcName) {
        ZipiTimer zipiTimer = ZipiBridge.startTimer("DCValidateExpression", ZipiContext.getQRDName());
        try {
            boolean bl = V5ExpressionUtils.tryToValidateCalculatedMemberDefinition(hierarchy, cube, rolapMember, calcName);
            return bl;
        }
        finally {
            if (zipiTimer != null) {
                zipiTimer.stop();
            }
        }
    }

    /*
     * Exception decompiling
     */
    private static boolean tryToValidateCalculatedMemberDefinition(IHierarchy hierarchy, IROLAPCube cube, IROLAPMember rolapMember, String calcName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void validateMUNs(ArrayList<V5MemberUniqueName> munList, IROLAPCube cube, String self) {
        ArrayList<V5MemberUniqueName> invalidMUNs = new ArrayList<V5MemberUniqueName>();
        for (V5MemberUniqueName mun : munList) {
            String string;
            if (mun.getNativeName().equals(self) || cube.findMember(string = UniqueNameGenerator.createProviderMemberUniqueName("RO", UniqueNameGenerator.extractPhysicalPartFromCognosMUN(mun.getNativeName()))) != null || !(cube instanceof IROLAPCube) || cube.getCalculatedMember(string) != null) continue;
            invalidMUNs.add(mun);
        }
        if (invalidMUNs.size() > 0) {
            StringBuilder listOfMember = new StringBuilder();
            for (IXQEQueryNode iXQEQueryNode : invalidMUNs) {
                listOfMember.append(((V5MemberUniqueName)iXQEQueryNode).getNativeName());
                listOfMember.append(",");
            }
            throw new XQERuntimeException(XQEMessageKeys.ROL_CalculatedMemberDefinitionHasInvalidMUNs, listOfMember.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final IXQEQueryNode checkV5ExpressionSyntax(String expression) throws XQERuntimeException {
        if (expression == null || expression.length() == 0) {
            return null;
        }
        BIBusEnvelope envelope = new BIBusEnvelope();
        Element bibusHeader = envelope.getBIBusHeader();
        bibusHeader.detach();
        RequestEnvironment reqEnv = V5ExpressionUtils.setupEnvironment(bibusHeader);
        reqEnv.setRequestID(REQUEST_ID_FOR_VALIDATION);
        PlanningEnvironment planEnv = QueryPlanner.setupEnvironment(reqEnv);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        MultiRequestContext multiRequestContext = execEnv.getMultiRequestContext();
        ExecutionEnvironmentContext executionEnvironmentContext = ExecutionEnvironmentContext.enter(execEnv);
        multiRequestContext.incrementRefCount();
        try {
            IXQEQueryNode node;
            if (expression.contains("#")) {
                MacroExpander expander = new MacroExpander();
                expression = expander.expand(null, planEnv, expression);
            }
            IXQEQueryNode iXQEQueryNode = node = V5ExpressionProcessor.parse(expression, planEnv, reqEnv.getExpressionLocale());
            return iXQEQueryNode;
        }
        finally {
            multiRequestContext.decrementRefCount();
            executionEnvironmentContext.exit();
        }
    }

    public static RequestEnvironment setupEnvironment(Element biBusHeader) {
        RequestEnvironment reqEnv = new RequestEnvironment((Element)biBusHeader.clone());
        QueryEngine.getInstance().configureRequestEnvironment(reqEnv);
        ExecutionEnvironment execEnv = (ExecutionEnvironment)reqEnv.getExecutionEnvironment();
        execEnv.setConnectionElement(DocumentHelper.createElement((String)"connection"));
        reqEnv.setSessionContextID(UUID.randomUUID().toString());
        QueryEngine.getInstance().configureMultiRequestContext(reqEnv, null);
        return reqEnv;
    }

    public static List<String> getExpressionIdentifiers(IXQEQueryNode queryNode) {
        IXQEQueryNode[] v5MultiPartIdentifierNodes = queryNode.getChildrenOfType(201030);
        ArrayList<String> identifiersList = new ArrayList<String>();
        if (v5MultiPartIdentifierNodes != null) {
            for (int index = 0; index < v5MultiPartIdentifierNodes.length; ++index) {
                String identifier = ((V5MultiPartIdentifier)v5MultiPartIdentifierNodes[index]).getIdentifier();
                if (identifier == null) continue;
                identifiersList.add(identifier);
            }
        }
        return identifiersList;
    }
}

