/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.validate;

import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.validate.ValidationTaskResult;
import com.cognos.xqe.trace.LogLevel;
import java.util.concurrent.Callable;

public abstract class AbstractValidationTask
implements Callable<ValidationTaskResult> {
    private static final String CUBE_VALIDATION_TASK_LOG_MSG = "Cube validation task ";
    protected ValidationTaskResult result = new ValidationTaskResult();
    protected final ROLAPCube cube;

    protected AbstractValidationTask(ROLAPCube theCube) {
        this.cube = theCube;
    }

    @Override
    public ValidationTaskResult call() throws Exception {
        ROLAPLog.logOpStart(LogLevel.INFO, "ROLAPCubes.Validation", CUBE_VALIDATION_TASK_LOG_MSG + this.getName() + " starting.");
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        try {
            envHelper.setCMRequestExecutor(this.cube.getAccountManager());
            envHelper.setInternalUse(true);
            envHelper.setUpEnvironment(true);
            ROLAPContext.setRelQueryExecuting();
            this.callImpl();
        }
        finally {
            envHelper.tearDownEnvironment();
            ROLAPLog.logOpEnd(LogLevel.INFO, "ROLAPCubes.Validation", CUBE_VALIDATION_TASK_LOG_MSG + this.getName() + " finished with success = " + this.result.isSuccess());
        }
        return this.result;
    }

    public abstract String getName();

    public abstract void callImpl() throws Exception;
}

