/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.validate;

import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.metadata.IQuerySubject;
import com.cognos.xqe.metadata.IRelationship;
import com.cognos.xqe.metadata.MetadataType;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.util.Governors;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

public class RelationalMetadata {
    private final ROLAPCube cube;
    private List<IQuerySubject> querySubjects = null;
    private List<IRelationship> relationships = null;

    public RelationalMetadata(ROLAPCube aCube) {
        this.cube = aCube;
    }

    public List<IQuerySubject> getQuerySubjects() {
        if (this.querySubjects == null) {
            this.querySubjects = this.fetchQuerySubjects();
        }
        return Collections.unmodifiableList(this.querySubjects);
    }

    public List<IRelationship> getRelationships() {
        if (this.relationships == null) {
            this.relationships = this.fetchAllRelationships();
        }
        return Collections.unmodifiableList(this.relationships);
    }

    public IMetadata getPrimaryKeySide(IRelationship relationship) {
        return this.findSide(relationship, EnumSet.of(IRelationship.Cardinality.ONE_ONE, IRelationship.Cardinality.ZERO_ONE));
    }

    public IMetadata getForeignKeySide(IRelationship relationship) {
        return this.findSide(relationship, EnumSet.of(IRelationship.Cardinality.ONE_MANY, IRelationship.Cardinality.ZERO_MANY));
    }

    private IMetadata findSide(IRelationship relationship, Set<IRelationship.Cardinality> searchFor) {
        Enum<IRelationship.Cardinality> lhsCard = relationship.getLeftCardinality();
        Enum<IRelationship.Cardinality> rhsCard = relationship.getRightCardinality();
        if (searchFor.contains(lhsCard)) {
            return relationship.getLeftRefObject();
        }
        if (searchFor.contains(rhsCard)) {
            return relationship.getRightRefObject();
        }
        return null;
    }

    private List<IQuerySubject> fetchQuerySubjects() {
        MetadataConnection mfwConnection = this.cube.getConnection();
        List<IMetadata> entities = mfwConnection.getEntities();
        ArrayList<IQuerySubject> physicalModelSubjects = new ArrayList<IQuerySubject>();
        for (IMetadata entity : entities) {
            IQuerySubject mfwSubject;
            IMetadata parentObj;
            if (!(entity instanceof IQuerySubject) || (parentObj = (mfwSubject = (IQuerySubject)entity).getParentObject()) == null || !parentObj.getObjectType().equals((Object)MetadataType.NAMESPACE) || "Business View".equalsIgnoreCase(parentObj.getName())) continue;
            physicalModelSubjects.add(mfwSubject);
        }
        return physicalModelSubjects;
    }

    private List<IRelationship> fetchAllRelationships() {
        MetadataConnection mfwConnection = this.cube.getConnection();
        ArrayList<IRelationship> allRelationships = new ArrayList<IRelationship>();
        Governors governors = new Governors();
        List<IMetadata> joins = mfwConnection.getJoins(governors);
        for (IMetadata possibleJoin : joins) {
            if (possibleJoin.getObjectType().equals((Object)MetadataType.RELATIONSHIP)) {
                IRelationship relationship = (IRelationship)possibleJoin;
                allRelationships.add(relationship);
                continue;
            }
            throw new IllegalStateException("Unexpected join type " + (Object)((Object)possibleJoin.getObjectType()) + " for " + possibleJoin);
        }
        return allRelationships;
    }

    public static enum QuerySubjectRelationshipUse {
        PrimaryKey,
        ForeignKey,
        All;

    }
}

