/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.format.FormatService;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMemberDef;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.List;

public class ROLAPVirtualCalculatedMeasure
extends ROLAPVirtualCalculatedMember
implements IROLAPMeasure {
    public ROLAPVirtualCalculatedMeasure(String name, ILevel level, Object calculationNode, String[] identifiers, ROLAPVirtualCalculatedMemberDef def) throws MetadataException {
        super(name, level, calculationNode, identifiers, def);
        this.formatId = def.getFormatId();
    }

    @Override
    public String getAggregateRule() {
        return this.getROLAPVirtualCalculatedMemberDef().getAggregateRule();
    }

    @Override
    public AggregateTypeEnum getRegularAggregate() {
        return AggregateTypeEnum.CALCULATED;
    }

    @Override
    public boolean isVisible() {
        return this.getROLAPVirtualCalculatedMemberDef().isVisible();
    }

    @Override
    public String getV5UniqueName() {
        if (this.v5UniqueName == null) {
            String part1 = UniqueNameGenerator.createMemberV5ModelPart(this.getHierarchy());
            String part2 = UniqueNameGenerator.createUniqueName(this.getName());
            this.v5UniqueName = UniqueNameGenerator.join(part1, part2);
        }
        return this.v5UniqueName;
    }

    @Override
    public String getV5UniqueCaption() {
        String part1 = UniqueNameGenerator.createMemberV5ModelPart(this.getHierarchy());
        String part2 = UniqueNameGenerator.createUniqueName(this.getDefaultCaption());
        return UniqueNameGenerator.join(part1, part2);
    }

    public String getDefaultCaption() {
        return this.getLocalizedCaption().toString(this.getLocalizedCaption().getDefaultLocale());
    }

    public String getUniqueDefaultCaption() {
        String result = this.uniqueName;
        if (result == null) {
            result = "";
            IMember parent = this.getParent();
            result = parent == null ? this.getHierarchy().getUniqueName() : parent.getUniqueName();
            if (!this.isFillerMember()) {
                result = result + ".[" + this.getDefaultCaption() + "]";
            }
            this.uniqueName = result;
        }
        return result;
    }

    public String getUniqueRuntimeCaption() {
        String result = null;
        IMember parent = this.getParent();
        result = parent == null ? this.getHierarchy().getUniqueName() : parent.getUniqueName();
        if (!this.isFillerMember()) {
            result = result + ".[" + this.getCaption() + "]";
        }
        return result;
    }

    public void setInheritedFormatId(List<IMember> measuresList, List<String> identifersInCalcExpressionList) {
        if (this.formatId == null) {
            ArrayList<FormatId> inheritedFormatIdList = new ArrayList<FormatId>();
            for (IMember measure : measuresList) {
                FormatId id;
                if (!(measure instanceof IROLAPMeasure) || !ROLAPMeasure.matchesMeasure((IROLAPMeasure)measure, identifersInCalcExpressionList) || (id = ((IROLAPMeasure)measure).getFormatId()) == null) continue;
                inheritedFormatIdList.add(id);
            }
            if (inheritedFormatIdList.size() == 1) {
                this.setFormatId((FormatId)inheritedFormatIdList.get(0));
            } else if (inheritedFormatIdList.size() > 0) {
                FormatId inheirtFormatId = FormatService.getInstance().formatResult("Add", inheritedFormatIdList);
                this.setFormatId(inheirtFormatId);
            }
        }
    }

    @Override
    public void setFormatId(FormatId fId) {
        this.formatId = fId;
    }

    @Override
    public boolean isSemiAggregate() {
        return false;
    }
}

