/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.ICacheableObject;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.query.engine.QueryEnvironmentHelper;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryStrategy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPAbstractHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPProvider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPVirtualNamedSet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPAccessAccountManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeAction;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeNameWrapper;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeStateEnum;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCubeSoftReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPMemberCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPSharedDimensionCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPVirtualMemberCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualCubeDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCubeDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimensionModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualNamedSetDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualQueryStrategy;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocaleUtility;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.management.openmbean.CompositeDataSupport;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularDataSupport;
import org.dom4j.Element;

public class ROLAPVirtualCube
extends ROLAPCube
implements IROLAPVirtualCube {
    private static final String LEVERAGESHAREDMEMBERCACHE_ATTR = "leverageSharedMemberCache";
    private ROLAPCube[] mSourceCubes;
    private ArrayList<String> mSourceCubeNames = new ArrayList();
    private List<String> mSourceCubeNamesMetricValue;
    private List<String> mAllSourceCubeNamesMetricValue;
    private ROLAPMetaVirtualCube metaCube;
    private boolean locked = false;
    private Date dateCreated;
    private ArrayList<String> mMemberKeyNames = new ArrayList();
    private IROLAPVirtualCubeDef rolapVirtualCubeDef;
    private static final String VIRTUAL_DIMENSION = "Virtual Dimension ";
    private static final String BECAUSE_THE_SRC_DIM_FROM_CUBE = "because the source dimension from cube ";
    private static final String COULD_NOT_LEVERAGE_SHARED_MEM_CACHE = " could not leverage the shared member cache ";
    private static final String COULD_NOT_LEVERAGE_ERORR_FORMATED_MESSAGE = "Virtual Dimension %s could not leverage the shared member cache because the source dimension from cube '%s' %s";
    private static final boolean USEVIRTUALMEMBERPROXY = false;

    @Override
    public void lock() {
        if (!this.locked) {
            for (ROLAPCube cube : this.mSourceCubes) {
                if (cube == null) continue;
                cube.lock();
            }
            this.locked = true;
        }
    }

    protected static String getFullyQualifiedLevelName(ICube cube, ILevel level) {
        return ROLAPVirtualCube.getFullyQualifiedUniqueName(cube, (IMetadata)level);
    }

    protected static String getFullyQualifiedHierarchyName(ICube cube, IHierarchy hierarchy) {
        return ROLAPVirtualCube.getFullyQualifiedUniqueName(cube, (IMetadata)hierarchy);
    }

    @Override
    public void unlock() {
        for (ROLAPCube cube : this.mSourceCubes) {
            if (cube == null) continue;
            cube.unlock();
        }
        this.locked = false;
    }

    public void loadCalculatedMembers(List<IDimension> list) {
        if (this.isRunning()) {
            this.validateCalculatedMembers(list);
        }
    }

    public ROLAPVirtualCube(String n, ROLAPCube.ROLAPCubeInfo cubeInfo) {
        super(n, cubeInfo);
        this.dateCreated = new Date();
        this.initSourceCubes();
        this.buildJMXCacheDiagnosticInfo();
    }

    private ROLAPMetaVirtualCube getMetaVirtualCube(String cubeName) {
        ROLAPMetaVirtualCube[] cubes;
        if (this.schema != null && (cubes = this.schema.getVirtualCubes()) != null) {
            for (int i = 0; i < cubes.length; ++i) {
                ROLAPMetaVirtualCube cube = cubes[i];
                if (!cube.getName().equalsIgnoreCase(cubeName)) continue;
                return cube;
            }
        }
        return null;
    }

    private void initSourceCubes() {
        ROLAPMetaVirtualCube metaVirtualCube = this.getMetaVirtualCube(this.getName());
        List sourceCubeRefs = metaVirtualCube.getXmlElement().elements("sourceCubeRef");
        this.mSourceCubeNames.clear();
        for (Element sourceCubeRef : sourceCubeRefs) {
            String name = sourceCubeRef.attributeValue("name");
            if (this.mSourceCubeNames.contains(name)) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_DuplicateSourceObjectRef, new ROLAPCubeNameWrapper(name));
            }
            this.mSourceCubeNames.add(name);
        }
        this.mSourceCubeNamesMetricValue = Collections.unmodifiableList((ArrayList)this.mSourceCubeNames.clone());
        this.mSourceCubes = new ROLAPCube[this.mSourceCubeNames.size()];
        int i = 0;
        for (String name : this.mSourceCubeNames) {
            ROLAPCube cube = ROLAPCubeManager.getInstance().getCube(name);
            this.setSourceCube(i, cube);
            ++i;
        }
        this.updateAllSourceCubeMetric();
        this.mMemberKeyNames.clear();
        for (i = 0; i < this.mSourceCubes.length; ++i) {
            this.mMemberKeyNames.add("MEMBER_" + (char)(65 + i) + "_KEY");
        }
    }

    public void updateAllSourceCubeMetric() {
        ArrayList<String> allSources = new ArrayList<String>();
        this.getAllSources(this, allSources);
        this.mAllSourceCubeNamesMetricValue = Collections.unmodifiableList(allSources);
    }

    public void addSourceCube(ROLAPCube sourceCube) {
        int i = 0;
        for (String name : this.mSourceCubeNames) {
            if (name.equalsIgnoreCase(sourceCube.getName())) {
                this.setSourceCube(i, sourceCube);
            }
            ++i;
        }
    }

    private void setSourceCube(int index, ROLAPCube sourceCube) {
        this.mSourceCubes[index] = sourceCube;
        if (sourceCube != null) {
            sourceCube.addDependentCube(this);
        }
    }

    @Override
    public void init(ROLAPProvider provider) {
        ILocalizedString name;
        this.setMetaCube(this.getMetaVirtualCube(this.getName()));
        this.setProvider(provider);
        this.initializeVirtualCubeConfiguration();
        if (this.getROLAPVirtualCubeDef() != null && (name = this.getROLAPVirtualCubeDef().getName()) != null) {
            this.namespace.setLocalizedName(this.getROLAPVirtualCubeDef().getName());
        }
        this.setDescription(this.metaCube.getComments());
        this.createMemberResolver(provider);
    }

    private void initializeVirtualCubeConfiguration() {
        this.rolapVirtualCubeDef = new ROLAPVirtualCubeDef(this.getMetaCube().getXmlElement(), this.getProvider(), this.mSourceCubes, this.getSchema().getDefaultLocale());
        super.initialise();
    }

    protected static String getFullyQualifiedUniqueName(ICube cube, IMetadata meta) {
        if (meta == null) {
            return null;
        }
        return UniqueNameGenerator.join(cube.getUniqueName(), meta.getUniqueName());
    }

    protected static String getFullyQualifiedUniqueName(String cubeName, IMetadata meta) {
        if (meta == null) {
            return null;
        }
        String cubeUniqueName = UniqueNameGenerator.createUniqueName(cubeName);
        return UniqueNameGenerator.join(cubeUniqueName, meta.getUniqueName());
    }

    private void initializeConfig() {
        this.getROLAPVirtualCubeDef().initializeConfig();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseDimensions() {
        ROLAPCubeReservation[] res = ROLAPVirtualCube.reserveSourceCubes(this.mSourceCubes);
        try {
            HashMap<String, IDimension[]> newDimensions = new HashMap<String, IDimension[]>();
            ArrayList<String> orderedDimNameList = new ArrayList<String>();
            for (int cubeIndex = 0; cubeIndex < this.mSourceCubes.length; ++cubeIndex) {
                ROLAPCube cube = this.mSourceCubes[cubeIndex];
                IDimension[] dims = null;
                if (cube == null) continue;
                for (IDimension dim : dims = (IDimension[])cube.getDimensions().toArray(new Dimension[0])) {
                    IDimension[] dimArray;
                    String fqName = ROLAPVirtualCube.getFullyQualifiedUniqueName(cube, (IMetadata)dim);
                    if (this.getROLAPVirtualCubeDef().getHiddenDimensions().contains(fqName)) continue;
                    String outputDimName = dim.getName();
                    if (this.getROLAPVirtualCubeDef().getFqToOutputDimensionName().containsKey(fqName)) {
                        outputDimName = this.getROLAPVirtualCubeDef().getFqToOutputDimensionName().get(fqName);
                    }
                    if ((dimArray = (IDimension[])newDimensions.get(outputDimName)) == null) {
                        dimArray = new IDimension[this.mSourceCubes.length];
                        newDimensions.put(outputDimName, dimArray);
                        orderedDimNameList.add(outputDimName);
                    }
                    dimArray[cubeIndex] = dim;
                }
            }
            String virtualCubeName = this.getName();
            IROLAPVirtualCubeDef virtualCubeDef = this.getROLAPVirtualCubeDef();
            if (virtualCubeDef.getMergeStyle() == ROLAPVirtualCubeDef.MergeStyleEnum.EXPLICIT) {
                orderedDimNameList = new ArrayList();
                List<String> virtualDimensionNames = virtualCubeDef.getVirtualDimensionNames();
                for (String virtualDimensionName : virtualDimensionNames) {
                    IDimension[] sourceDimensions;
                    if (ROLAPVirtualCube.isMeasuresDimension(virtualDimensionName, sourceDimensions = (IDimension[])newDimensions.get(virtualDimensionName))) {
                        orderedDimNameList.add(0, virtualDimensionName);
                        continue;
                    }
                    orderedDimNameList.add(virtualDimensionName);
                }
                for (String internalDimensionName : ROLAPMemberCache.INTERNAL_DIMENSION_NAMES) {
                    orderedDimNameList.add(internalDimensionName);
                }
            }
            for (String string : orderedDimNameList) {
                IDimension[] dimArray;
                String inheritedSharedUUID = this.getInheritedSharedUUID(string, dimArray = (IDimension[])newDimensions.get(string));
                if (inheritedSharedUUID != null && !ROLAPSharedDimensionCache.DISABLESHAREDDIMENSIONCACHE) {
                    ShareableROLAPDimension shareableDim = ROLAPSharedDimensionCache.getInstance().getAndRegisterShareableDimension(this, inheritedSharedUUID);
                    this.addDimension(shareableDim);
                    int[] sourceDimensionCubeIndexes = ROLAPVirtualCube.getSourceDimCubeIndexArray(dimArray);
                    shareableDim.addVirtualCubeSourceCubeIndexes(virtualCubeName, sourceDimensionCubeIndexes);
                    boolean needToRemoveCubeName = ROLAPContext.setCurrentCubeName(virtualCubeName);
                    try {
                        for (IHierarchy hierarchy : shareableDim.getHierarchies()) {
                            ((ROLAPAbstractHierarchy)hierarchy).initializeCalculatedMembers(this.getROLAPVirtualCubeDef().getHierarchyNameToVirtualCalcMemberDefs().get(hierarchy.getName()));
                            ((ROLAPAbstractHierarchy)hierarchy).createRelativeTimeMembers(this);
                        }
                        continue;
                    }
                    finally {
                        ROLAPContext.removeCurrentCubeName(needToRemoveCubeName);
                        continue;
                    }
                }
                new ROLAPVirtualDimension(dimArray, string, this);
            }
        }
        finally {
            ROLAPVirtualCube.unreserveSourceCubes(res);
        }
    }

    private static boolean isMeasuresDimension(String virtualDimensionName, IDimension[] sourceDimensions) {
        for (IDimension sourceDimension : sourceDimensions) {
            if (sourceDimension == null || sourceDimension.isMeasuresDimension()) continue;
            return false;
        }
        return true;
    }

    @Override
    public QueryStrategy getQueryStrategy() {
        return new ROLAPVirtualQueryStrategy();
    }

    public Date getCreateDate() {
        return this.dateCreated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void startCubeImpl(boolean forceStart) {
        try {
            super.startCubeImpl(forceStart);
            this.initSourceCubes();
            this.validateSourceCubeReferences();
            ROLAPCubeManager.getInstance().initCube(this);
            if (forceStart) {
                for (ROLAPCube cube : this.mSourceCubes) {
                    try {
                        cube.forceStart();
                    }
                    catch (Exception e) {
                        if (cube.isRunning()) continue;
                        throw new XQERuntimeException(XQEMessageKeys.ROL_StartDependentCubes, (Throwable)e, (Object)new ROLAPCubeNameWrapper(this.getName()), (Object)new ROLAPCubeNameWrapper(cube.getName()));
                    }
                }
            } else {
                this.checkSourceCubesRunning();
            }
            for (ROLAPCube cube : this.mSourceCubes) {
                try {
                    cube.waitForStart(true);
                }
                catch (Exception e) {
                    throw new XQERuntimeException(XQEMessageKeys.ROL_StartDependentCubes, (Throwable)e, (Object)new ROLAPCubeNameWrapper(this.getName()), (Object)new ROLAPCubeNameWrapper(cube.getName()));
                }
            }
            this.mAccountManager = new ROLAPAccessAccountManager(this.mSourceCubes[0].getAccountManager());
            this.mAccountManager.setUpBiBusEnvelope(true);
            ArrayList<ROLAPCubeReservation> reservations = new ArrayList<ROLAPCubeReservation>();
            QueryEnvironmentHelper envHelper = this.setUpExecutionEnvironment(true, true);
            try {
                try {
                    for (ROLAPCube cube : this.mSourceCubes) {
                        ROLAPCubeReservation reservation = cube.reserve();
                        reservations.add(reservation);
                    }
                    this.validateSourceCubeCSCompatibilityConfigs();
                    this.initializeConfig();
                    this.initializeCache(ROLAPCubeAction.START);
                    this.validateNRTSourceCubes();
                }
                finally {
                    for (ROLAPCubeReservation res : reservations) {
                        res.getCube().unreserve(res);
                    }
                }
            }
            finally {
                envHelper.tearDownEnvironment();
            }
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    private void checkSourceCubesRunning() {
        ROLAPCubeNameWrapper cubes = null;
        for (ROLAPCube cube : this.mSourceCubes) {
            if (cube.getState() == ROLAPCubeStateEnum.RUNNING) continue;
            if (cubes == null) {
                cubes = new ROLAPCubeNameWrapper();
            }
            cubes.add(cube.getName());
        }
        if (cubes != null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_StartDependentCubes, new ROLAPCubeNameWrapper(this.getName()), cubes);
        }
    }

    @Override
    protected void unpauseImpl() {
        this.checkSourceCubesRunning();
    }

    private void validateNRTSourceCubes() {
        XQEConfiguration xqeConfig;
        boolean allowVCCachingWithNRT;
        List<ROLAPCube> nrtSourceCubes = this.getNRTSourceCubes();
        if (nrtSourceCubes.size() > 0 && !(allowVCCachingWithNRT = (xqeConfig = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE)).getBooleanProperty("general.allowVirtualCubeCachingWithNRT", false))) {
            if (this.getConfigMaxDataCacheSize() > 0) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_VirtualCubeDataCacheWithNRTSourceCube, (Object)this.getName(), (Object)nrtSourceCubes.get(0).getName(), (Object)this.getConfigMaxDataCacheSize());
            }
            if (!this.getConfigIsDisableResultSetCache()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_VirtualCubeResultSetCacheWithNRTSourceCube, this.getName(), nrtSourceCubes.get(0).getName());
            }
        }
    }

    private List<ROLAPCube> getNRTSourceCubes() {
        ArrayList<ROLAPCube> nrtSourceCubes = new ArrayList<ROLAPCube>();
        for (ROLAPCube sourceCube : this.mSourceCubes) {
            if (sourceCube.isVirtual()) {
                nrtSourceCubes.addAll(((ROLAPVirtualCube)sourceCube).getNRTSourceCubes());
                continue;
            }
            if (!((ROLAPBaseCube)sourceCube).isNearRealTime()) continue;
            nrtSourceCubes.add(sourceCube);
        }
        return nrtSourceCubes;
    }

    private void validateSourceCubeReferences() {
        ROLAPCubeNameWrapper cubes = null;
        for (int i = 0; i < this.mSourceCubes.length; ++i) {
            if (this.mSourceCubes[i] != null) continue;
            if (cubes == null) {
                cubes = new ROLAPCubeNameWrapper();
            }
            cubes.add(this.mSourceCubeNames.get(i));
        }
        if (cubes != null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_DependentCubesMissing, new ROLAPCubeNameWrapper(this.getName()), (Object)cubes);
        }
    }

    private void validateSourceCubeCSCompatibilityConfigs() {
        int numCsCompatible = 0;
        for (ROLAPCube cube : this.mSourceCubes) {
            if (!cube.isCubingServicesCompatible()) continue;
            ++numCsCompatible;
        }
        if (numCsCompatible != 0 && numCsCompatible != this.mSourceCubes.length) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_MismatchedSourceCubeCompatibilityModes, new ROLAPCubeNameWrapper(this.getName()));
        }
    }

    public ROLAPCube[] getSourceCubes() {
        return this.mSourceCubes;
    }

    public void initializeCache(ROLAPCubeAction cubeAction) throws Exception {
        this.mMemberCacheManager = new ROLAPCacheManager<ROLAPMemberCache>(new ROLAPCube.MemberCacheFactory(this, this));
        ROLAPMemberCache.deleteCacheFolder(this.getName());
        this.buildMemberCache();
    }

    @Override
    public boolean isVirtual() {
        return true;
    }

    public static boolean useVirtualMemberProxy() {
        return USEVIRTUALMEMBERPROXY;
    }

    @Override
    public MetadataCacheKey cacheVirtualMemberData(IMember[] members, String name, ILevel level, ICacheKey cachedParentMemberKey, String caption) {
        Map<String, Object> virtualMemberProperties = this.prepareVirtualMemberProperties(name, members, caption);
        MetadataCacheKey cachedMemberKey = this.createKey(level);
        ICacheableObject cachedMemberContent = this.createCacheObject(cachedMemberKey, virtualMemberProperties, cachedParentMemberKey);
        Dimension dimension = (Dimension)level.getDimension();
        ROLAPVirtualCube virtualCube = (ROLAPVirtualCube)dimension.getCube();
        try {
            this.getMemberCacheInContext().getMetadataStorage().cacheMember(cachedMemberContent);
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCachePutException(e, virtualCube.getName(), dimension.getName());
        }
        return cachedMemberKey;
    }

    private Map<String, Object> prepareVirtualMemberProperties(String name, IMember[] members, String caption) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (name != null && caption != null && name != caption && caption.equals(name)) {
            name = caption;
        }
        if (name != null) {
            properties.put("NAME", name);
        }
        if (caption != null) {
            properties.put("CAPTION", caption);
        }
        for (int i = 0; i < members.length; ++i) {
            IMember member = members[i];
            if (member == null || !(member instanceof MemberProxy)) continue;
            properties.put(this.mMemberKeyNames.get(i), ((MemberProxy)member).getCacheKey());
        }
        properties.put("MEMBER_UNIQUE_NAME", null);
        return properties;
    }

    private MetadataCacheKey createKey(ILevel level) {
        Dimension dimension = (Dimension)level.getDimension();
        int dimensionIndexInCube = ((ROLAPVirtualCube)dimension.getCube()).getDimensionIndex(dimension);
        return new MetadataCacheKey(dimensionIndexInCube, dimension.getmaxMemberId());
    }

    private ICacheableObject createCacheObject(MetadataCacheKey cachedMemberKey, Map<String, Object> virtualMemberProperties, ICacheKey cachedParentMemberKey) {
        if (cachedParentMemberKey != null) {
            virtualMemberProperties.put("PARENT_MEMBER_CACHE_KEY", cachedParentMemberKey);
        }
        return ROLAPCacheEngine.createCacheableObject(cachedMemberKey, virtualMemberProperties);
    }

    @Override
    protected void stopCubeImpl() {
        try {
            this.setProvider(null);
            this.setDescription(null);
            this.clearMemberResolver();
            if (this.mMemberCacheManager != null) {
                this.mMemberCacheManager.release();
                this.mMemberCacheManager = null;
            }
            super.stopCubeImpl();
        }
        catch (Exception e) {
            throw XQERuntimeException.wrap(e);
        }
    }

    public ROLAPMetaVirtualCube getMetaCube() {
        return this.metaCube;
    }

    public void setMetaCube(ROLAPMetaVirtualCube mCube) {
        this.metaCube = mCube;
    }

    @Override
    protected ROLAPCubeReservation reserveImpl(ROLAPCubeSoftReservation softRes, ROLAPCubeReservation[] sourceReservations) {
        ROLAPCubeReservation[] reservations = ROLAPVirtualCube.reserveSourceCubes(this.mSourceCubes);
        ROLAPCubeReservation res = null;
        try {
            res = super.reserveImpl(softRes, reservations);
        }
        catch (Throwable e) {
            ROLAPVirtualCube.unreserveSourceCubes(reservations);
            throw XQERuntimeException.wrap(e);
        }
        return res;
    }

    @Override
    protected void unreserveImpl(ROLAPCubeReservation reservation, ROLAPContext ctx) {
        try {
            super.unreserveImpl(reservation, ctx);
        }
        finally {
            ROLAPVirtualCube.unreserveSourceCubes(reservation.getSourceReservations(), ctx);
        }
    }

    public String getMergeOperator() {
        return this.getROLAPVirtualCubeDef().getMergeOperator();
    }

    @Override
    public ROLAPMetaCube getModelCube() {
        return null;
    }

    @Override
    public int getMemberIndex(IMember member) {
        return ((IMemberCubics)member).getIndex();
    }

    public static ROLAPCubeReservation[] reserveSourceCubes(ROLAPCube[] sourceCubes) {
        return ROLAPVirtualCube.reserveSourceCubes(null, sourceCubes);
    }

    private static ROLAPCubeReservation[] reserveSourceCubes(ROLAPContext ctx, ROLAPCube[] sourceCubes) {
        ROLAPCubeReservation[] res = new ROLAPCubeReservation[sourceCubes.length];
        try {
            for (int i = 0; i < res.length; ++i) {
                if (sourceCubes[i] == null) continue;
                res[i] = sourceCubes[i].reserve();
                if (res[i] != null) continue;
                throw new XQERuntimeException(XQEMessageKeys.ROL_UnableToReserveCube, new ROLAPCubeNameWrapper(sourceCubes[i].getName()));
            }
        }
        catch (Throwable e) {
            ROLAPVirtualCube.unreserveSourceCubes(res, ctx);
            throw XQERuntimeException.wrap(e);
        }
        return res;
    }

    public static void unreserveSourceCubes(ROLAPCubeReservation[] res) {
        ROLAPVirtualCube.unreserveSourceCubes(res, null);
    }

    private static void unreserveSourceCubes(ROLAPCubeReservation[] res, ROLAPContext ctx) {
        if (res == null) {
            return;
        }
        Throwable savedException = null;
        for (int i = 0; i < res.length; ++i) {
            if (res[i] == null) continue;
            try {
                res[i].getCube().unreserve(res[i], ctx);
                continue;
            }
            catch (Throwable e) {
                if (savedException == null) {
                    savedException = e;
                }
                ROLAPLog.logError("ROLAPCubes.Management", String.format("Error unreserving source cube %s.", res[i].getCube().getName()), e);
            }
        }
        if (savedException != null) {
            throw XQERuntimeException.wrap(savedException);
        }
    }

    @Override
    public boolean isCubingServicesCompatible() {
        return this.getROLAPVirtualCubeDef().isCubingServicesCompatible();
    }

    @Override
    public boolean isRemoveNonExistentTuplesEnabled() {
        boolean compatible = true;
        for (ROLAPCube cube : this.mSourceCubes) {
            if (cube.isRemoveNonExistentTuplesEnabled()) continue;
            return false;
        }
        return compatible;
    }

    @Override
    public ROLAPMemberCache createMemberCache() {
        return new ROLAPVirtualMemberCache(this);
    }

    @Override
    public ROLAPDataCache createDataCache(ROLAPCacheBase parent) {
        return new ROLAPDataCache(this, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void validateCalculatedMembers() {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setCMRequestExecutor(this.getAccountManager());
        envHelper.setInternalUse(true);
        envHelper.setUpEnvironment(true);
        try {
            ROLAPCubeReservation reservation = this.reserve();
            try {
                this.validateCalculatedMembers(this.getDimensions());
            }
            finally {
                this.unreserve(reservation);
            }
        }
        finally {
            envHelper.tearDownEnvironment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateCalculatedMembers(List<IDimension> dimensions) {
        QueryEnvironmentHelper envHelper = new QueryEnvironmentHelper();
        envHelper.setCMRequestExecutor(this.getAccountManager());
        envHelper.setInternalUse(true);
        envHelper.setUpEnvironment(true);
        try {
            ROLAPCubeReservation reservation = this.reserve();
            boolean needToRemoveCurrentCubeName = ROLAPContext.setCurrentCubeName(this.getName());
            try {
                for (IDimension dim : dimensions) {
                    if (dim.isMeasuresDimension()) {
                        ROLAPVirtualLevel level = (ROLAPVirtualLevel)dim.getLevel(0);
                        level.validateCalculatedMeasures(this);
                        this.addMessageInvalidCalculatedMembersWereRemoved(level.getHierarchy());
                        continue;
                    }
                    List<IHierarchy> hierarchies = dim.getHierarchies();
                    for (IHierarchy hier : hierarchies) {
                        ROLAPAbstractHierarchy rolapHier = (ROLAPAbstractHierarchy)hier;
                        rolapHier.validateCalculatedMembers(this);
                        this.addMessageInvalidCalculatedMembersWereRemoved(rolapHier);
                    }
                }
                this.validateCalculatedDefaultMember();
            }
            finally {
                this.unreserve(reservation);
                ROLAPContext.removeCurrentCubeName(needToRemoveCurrentCubeName);
            }
        }
        finally {
            envHelper.tearDownEnvironment();
        }
    }

    public void loadNamedSets() {
        List<ROLAPVirtualNamedSetDef> namedSetDefs = this.rolapVirtualCubeDef.getNamedSets();
        for (ROLAPVirtualNamedSetDef namedSetDef : namedSetDefs) {
            ROLAPVirtualNamedSet virtualNamedSet = new ROLAPVirtualNamedSet(this, namedSetDef);
            if (this.getMemberCacheInContext().containsNamedSet(virtualNamedSet)) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_DuplicateNamedSetName, XQEMessages.getCurrProductLocale(), virtualNamedSet.getUniqueName());
                ROLAPLog.getLogger("ROLAPCubes.Loader").log(LogLevel.ERROR, errorMessage);
                continue;
            }
            this.getMemberCacheInContext().addNamedSet(virtualNamedSet);
        }
    }

    @Override
    public String getCaption() {
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        String locale = LocaleConverter.localeToStr(runLocale);
        ILocalizedString lcName = null;
        String lzCaption = null;
        if (this.getROLAPVirtualCubeDef() != null && (lcName = this.getROLAPVirtualCubeDef().getName()) != null && (lzCaption = lcName.toString(locale = LocaleUtility.getSupportedLocale(locale, lcName, this.getDefaultLocale()))) == null) {
            lzCaption = lcName.toString(this.getDefaultLocale());
        }
        if (lzCaption == null) {
            lzCaption = super.getName();
        }
        return lzCaption;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return this.getLocalizedName();
    }

    public ILocalizedString getLocalizedName() {
        ILocalizedString lcName = null;
        if (this.getROLAPVirtualCubeDef() != null) {
            lcName = this.getROLAPVirtualCubeDef().getName();
        }
        if (lcName == null) {
            lcName = AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.getName());
        }
        return lcName;
    }

    public ILocalizedString getLocalizedDescription() {
        return LocalizedString.emptyString();
    }

    @Override
    public TabularData getSourceCubesMetricValues() {
        TabularDataSupport tds = new TabularDataSupport(CUBE_LIST_TYPE);
        int i = 0;
        for (String cube : this.mSourceCubeNamesMetricValue) {
            CompositeDataSupport cds;
            if (cube == null) continue;
            try {
                cds = new CompositeDataSupport(CUBE_NAME_TYPE, CUBE_NAME_FIELDS, new Object[]{new Integer(i), cube});
            }
            catch (OpenDataException oe) {
                throw new XQERuntimeException(oe);
            }
            tds.put(cds);
            ++i;
        }
        return tds;
    }

    @Override
    public TabularData getStoppedSourceCubesMetricValues() {
        TabularDataSupport tds = new TabularDataSupport(CUBE_LIST_TYPE);
        ROLAPCubeManager cubeManager = ROLAPCubeManager.getInstance();
        HashSet<String> usedNames = new HashSet<String>();
        int i = 0;
        for (String cubeName : this.mAllSourceCubeNamesMetricValue) {
            CompositeDataSupport cds;
            ROLAPCube cube = cubeManager.getCube(cubeName);
            if (cube != null && cube.isRunning() || usedNames.contains(cubeName)) continue;
            usedNames.add(cubeName);
            try {
                cds = new CompositeDataSupport(CUBE_NAME_TYPE, CUBE_NAME_FIELDS, new Object[]{new Integer(i), cubeName});
            }
            catch (OpenDataException oe) {
                throw new XQERuntimeException(oe);
            }
            tds.put(cds);
            ++i;
        }
        return tds;
    }

    private void getAllSources(ROLAPCube cube, ArrayList<String> sources) {
        if (!cube.isVirtual()) {
            return;
        }
        for (ROLAPCube source : ((ROLAPVirtualCube)cube).getSourceCubes()) {
            if (source == null) continue;
            this.getAllSources(source, sources);
            sources.add(source.getName());
        }
    }

    @Override
    public String getName(String locale) {
        String runLocaleName = null;
        if (this.getROLAPVirtualCubeDef() != null) {
            runLocaleName = this.getROLAPVirtualCubeDef().getCubeName(locale);
        }
        if (runLocaleName == null) {
            runLocaleName = this.getName();
        }
        return runLocaleName;
    }

    @Override
    public IROLAPVirtualCubeDef getROLAPVirtualCubeDef() {
        return this.rolapVirtualCubeDef;
    }

    @Override
    public void addCalculatedMemberToMemberCacheInContent(ROLAPCalculatedMember calcMem) {
        this.getMemberCacheInContext().addCalculatedMember(calcMem);
    }

    @Override
    public void updateDependentMetric() {
        super.updateDependentMetric();
        for (ROLAPCube source : this.mSourceCubes) {
            if (source == null) continue;
            source.updateDependentMetric();
        }
    }

    private static int[] getSourceDimCubeIndexArray(IDimension[] dimArray) {
        int[] finalArray;
        int counter = 0;
        int[] tmpArray = new int[dimArray.length];
        for (int index = 0; index < dimArray.length; ++index) {
            if (dimArray[index] == null) continue;
            tmpArray[counter] = index;
            ++counter;
        }
        if (counter != dimArray.length) {
            finalArray = new int[counter];
            System.arraycopy(tmpArray, 0, finalArray, 0, counter);
        } else {
            finalArray = tmpArray;
        }
        return finalArray;
    }

    private String getInheritedSharedUUID(String name, IDimension[] dimArray) {
        String currUUID = null;
        String prevUUID = null;
        for (int srcIdx = 0; srcIdx < dimArray.length; ++srcIdx) {
            IDimension dim = dimArray[srcIdx];
            if (dim == null) continue;
            if (!dim.isShareable()) {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAP.MemberCache", LogLevel.TRACE).log(String.format(COULD_NOT_LEVERAGE_ERORR_FORMATED_MESSAGE, name, this.getSourceCubes()[srcIdx], "was not a shared dimension."));
                return null;
            }
            if (prevUUID == null) {
                prevUUID = ((ShareableROLAPDimension)dim).getUUID();
            }
            if ((currUUID = ((ShareableROLAPDimension)dim).getUUID()) == null) {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAP.MemberCache", LogLevel.TRACE).log(String.format(COULD_NOT_LEVERAGE_ERORR_FORMATED_MESSAGE, name, this.getSourceCubes()[srcIdx], "did not have UUID."));
                return null;
            }
            if (!currUUID.equals(prevUUID)) {
                XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAP.MemberCache", LogLevel.TRACE).log(VIRTUAL_DIMENSION + name + COULD_NOT_LEVERAGE_SHARED_MEM_CACHE + "because the UUIDs of the source dimensions did not match:  " + prevUUID + " vs " + currUUID + ".");
                return null;
            }
            prevUUID = currUUID;
        }
        String dimUniqueName = UniqueNameGenerator.createUniqueName(name);
        ROLAPVirtualDimensionModelRef dimensionModelRef = this.getROLAPVirtualCubeDef().getVirtualDimensionModel(dimUniqueName);
        if (dimensionModelRef == null) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAP.MemberCache", LogLevel.TRACE).log(VIRTUAL_DIMENSION + name + COULD_NOT_LEVERAGE_SHARED_MEM_CACHE + "because could not find expected virtual dimension '" + dimUniqueName + "' in the virtual cube model.");
            return null;
        }
        String attrValueStr = dimensionModelRef.getDimensionModelRef().attributeValue(LEVERAGESHAREDMEMBERCACHE_ATTR);
        if (attrValueStr != null && !Boolean.valueOf(attrValueStr).booleanValue()) {
            XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAP.MemberCache", LogLevel.TRACE).log(VIRTUAL_DIMENSION + name + COULD_NOT_LEVERAGE_SHARED_MEM_CACHE + "because the value of the attribute " + LEVERAGESHAREDMEMBERCACHE_ATTR + " is false.");
            return null;
        }
        XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "ROLAP.MemberCache", LogLevel.TRACE).log(VIRTUAL_DIMENSION + name + " is leveraging the shared member cache with UUID:  " + prevUUID);
        return currUUID;
    }

    @Override
    public boolean isValidateCube() {
        return false;
    }

    @Override
    public String getCubeCurrentPeriod() {
        return null;
    }
}

