/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MetadataResolver;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Provider;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualCubeDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMemberDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimensionModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchyModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevelModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMeasureFolderModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMemberModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualNamedSetDef;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleUtility;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.UniqueNameParserException;
import com.cognos.xqe.util.primitive.HashMapObjectBoolean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.dom4j.Element;
import org.dom4j.Node;

public class ROLAPVirtualCubeDef
implements IROLAPVirtualCubeDef {
    private static final String EXPLICIT = "explicit";
    public static final String SOURCE_DIMENSION_REF = "sourceDimensionRef";
    public static final String VIRTUAL_MEMBER = "virtualMember";
    public static final String SOURCE_CUBE_REF = "sourceCubeRef";
    public static final String DEFAULT_MERGE_OPERATOR = "+";
    public static final String PRECEDENCE = "precedence";
    public static final String VISIBLE = "visible";
    public static final String MERGE_OPERATOR = "mergeOperator";
    public static final String VIRTUAL_CALCULATED_MEMBER = "virtualCalculatedMember";
    public static final String VIRTUAL_NAMEDSETS = "virtualNamedSets";
    public static final String VIRTUAL_NAMEDSET = "virtualNamedSet";
    public static final String DISPLAY_PATH = "displayPath";
    public static final String PARENT_UNIQUE_NAME = "parent";
    public static final String TEMPLATE = "template";
    public static final String SOLVEORDER = "solveOrder";
    public static final String CAPTION = "caption";
    public static final String DESCRIPTION = "description";
    public static final String V5EXPRESSION = "V5Expression";
    public static final String NAME = "name";
    public static final String PATH = "path";
    public static final String HIDDEN = "hidden";
    public static final String VIRTUAL_DIMENSION = "virtualDimension";
    public static final String DEFAULT_HIERARCHY_REF = "defaultHierarchyRef";
    public static final String TRUE_STRING = "true";
    public static final String VIRTUAL_HIERARCHY = "virtualHierarchy";
    public static final String VIRTUAL_HIERARCHY_FOLDER = "virtualHierarchyFolder";
    public static final String SOURCE_HIERARCHY_REF = "sourceHierarchyRef";
    public static final String DEFAULT_MEMBER_REF = "defaultMemberRef";
    public static final String SOURCE_MEMBER_REF = "sourceMemberRef";
    public static final String VIRTUAL_LEVEL = "virtualLevel";
    public static final String SOURCE_LEVEL_REF = "sourceLevelRef";
    public static final String LOCALE = "locale";
    public static final String FORMAT = "format";
    public static final String COMMA = ", ";
    private List<String> virtualDimensionNames;
    private final HashMap<String, String> fqToOutputDimensionNames;
    private final HashMap<String, String> fqToOutputHierarchyNames;
    private final HashMap<String, String> fqToOutputLevelNames;
    private final HashMap<String, String> vHierarchyUniqueNameToDefaultMember;
    private final HashMap<String, String> vDimensionNameToDefaultHierarchy;
    private final HashMap<String, String> fqMemberNameToMergeOperator;
    private final HashMap<String, String> outputNameToFormat;
    private final HashMap<String, String> fqMemberNameToPrecedence;
    private final HashMap<String, String> fqMemberNameToOutputName;
    private final HashSet<String> hiddenDimensions = new HashSet();
    private final HashSet<String> hiddenHierarchies = new HashSet();
    private final HashSet<String> hiddenLevels = new HashSet();
    private final HashSet<String> hiddenMembers = new HashSet();
    private final HashMapObjectBoolean<String> outputNameToIsVisible;
    private HashMap<String, List<ROLAPVirtualCalculatedMemberDef>> hierarchyNameToVirtualCalcMemberDefs;
    private List<ROLAPVirtualNamedSetDef> namedSetModelRefs;
    private HashMap<String, ROLAPVirtualDimensionModelRef> dimensionModelRefs;
    private HashMap<String, ROLAPVirtualHierarchyModelRef> hierarchyModelRefs;
    private HashMap<String, ROLAPVirtualLevelModelRef> levelModelRefs;
    private HashMap<String, ROLAPVirtualMemberModelRef> sourceMemberModelRefs;
    private HashMap<String, ROLAPVirtualMemberModelRef> measuresModelRefs;
    private HashMap<String, ROLAPVirtualCalculatedMemberDef> calcMeasuresModelRefs;
    private ROLAPVirtualMeasureFolderModelRef rootMeasureFolder;
    private final String mergeOperator;
    private final Element virtualXMLElement;
    private final String defaultLocale;
    private final ROLAPCube[] mSourceCubes;
    private final HashMap<String, MetadataResolver> cubeToMetadataResolver;
    private MergeStyleEnum mergeStyleEnum;
    private static final String AGGREGATION = "aggregation";
    private static final String FUNCTION = "function";
    private static final String MERGE_STYLE = "mergeStyle";

    public ROLAPVirtualCubeDef(Element xmlElement, Provider provider, ROLAPCube[] sourceCubes, String dLocale) {
        this.virtualDimensionNames = new ArrayList<String>();
        this.fqToOutputDimensionNames = new HashMap();
        this.fqToOutputHierarchyNames = new HashMap();
        this.fqToOutputLevelNames = new HashMap();
        this.vDimensionNameToDefaultHierarchy = new HashMap();
        this.vHierarchyUniqueNameToDefaultMember = new HashMap();
        this.fqMemberNameToMergeOperator = new HashMap();
        this.fqMemberNameToPrecedence = new HashMap();
        this.fqMemberNameToOutputName = new HashMap();
        this.outputNameToFormat = new HashMap();
        this.outputNameToIsVisible = new HashMapObjectBoolean(true);
        this.dimensionModelRefs = new HashMap();
        this.hierarchyModelRefs = new HashMap();
        this.levelModelRefs = new HashMap();
        this.sourceMemberModelRefs = new HashMap();
        this.measuresModelRefs = new HashMap();
        this.calcMeasuresModelRefs = new HashMap();
        this.rootMeasureFolder = new ROLAPVirtualMeasureFolderModelRef();
        this.namedSetModelRefs = new ArrayList<ROLAPVirtualNamedSetDef>();
        this.virtualXMLElement = xmlElement;
        this.mergeOperator = this.virtualXMLElement.attributeValue(MERGE_OPERATOR);
        this.defaultLocale = dLocale;
        this.mSourceCubes = sourceCubes;
        String mergeStyle = this.virtualXMLElement.attributeValue(MERGE_STYLE);
        this.mergeStyleEnum = mergeStyle != null && mergeStyle.equalsIgnoreCase(EXPLICIT) ? MergeStyleEnum.EXPLICIT : MergeStyleEnum.CLASSIC;
        this.cubeToMetadataResolver = new HashMap(this.mSourceCubes.length);
        for (ROLAPCube sourceCube : this.mSourceCubes) {
            this.cubeToMetadataResolver.put(sourceCube.getName(), sourceCube.getMemberResolver());
        }
    }

    @Override
    public IDimension[] getSourceDimensions(String dimName) {
        HashMap<String, IDimension[]> newDimensions = new HashMap<String, IDimension[]>();
        ArrayList<String> orderedNameList = new ArrayList<String>();
        for (int cubeIndex = 0; cubeIndex < this.mSourceCubes.length; ++cubeIndex) {
            ROLAPCube cube = this.mSourceCubes[cubeIndex];
            IDimension[] dims = null;
            if (cube == null) continue;
            for (IDimension dim : dims = (IDimension[])cube.getDimensions().toArray(new Dimension[0])) {
                IDimension[] dimArray;
                String fqName = ROLAPVirtualCube.getFullyQualifiedUniqueName(cube, (IMetadata)dim);
                if (this.getHiddenDimensions().contains(fqName)) continue;
                String outputName = dim.getName();
                if (this.getFqToOutputDimensionName().containsKey(fqName)) {
                    outputName = this.getFqToOutputDimensionName().get(fqName);
                }
                if ((dimArray = (IDimension[])newDimensions.get(outputName)) == null) {
                    dimArray = new IDimension[this.mSourceCubes.length];
                    newDimensions.put(outputName, dimArray);
                    orderedNameList.add(outputName);
                }
                dimArray[cubeIndex] = dim;
            }
        }
        IDimension[] dimArray = (IDimension[])newDimensions.get(dimName);
        if (dimArray == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_MissingSourceDim, dimName);
        }
        return dimArray;
    }

    @Override
    public String getMergeOperator() {
        return this.mergeOperator;
    }

    @Override
    public boolean isCubingServicesCompatible() {
        boolean compatible = true;
        for (ROLAPCube cube : this.mSourceCubes) {
            if (cube.isCubingServicesCompatible()) continue;
            return false;
        }
        return compatible;
    }

    private boolean isMeasuresDimension(List<String> fqSrcDimUniqueNames) {
        for (String fqSrcDimUniqueName : fqSrcDimUniqueNames) {
            IDimension srcDimension = null;
            for (ROLAPCube cube : this.mSourceCubes) {
                for (IDimension dim : cube.getDimensions()) {
                    String dimKey = ROLAPVirtualCube.getFullyQualifiedUniqueName(cube, (IMetadata)dim);
                    if (!fqSrcDimUniqueName.equalsIgnoreCase(dimKey)) continue;
                    srcDimension = dim;
                    break;
                }
                if (srcDimension != null) break;
            }
            if (srcDimension != null && srcDimension.isMeasuresDimension()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSourceLevelHidden(ICube sourceCube, ILevel sourceLevel) {
        boolean hidden = false;
        while (sourceLevel != null) {
            String fqName = ROLAPVirtualCube.getFullyQualifiedLevelName(sourceCube, sourceLevel);
            if (this.getHiddenLevels().contains(fqName)) {
                hidden = true;
            }
            sourceLevel = sourceLevel.getPreviousLevel();
        }
        return hidden;
    }

    public boolean isSourceHierarchyHidden(ROLAPCube sourceCube, IHierarchy sourceHierarchy) {
        String fqName = ROLAPVirtualCube.getFullyQualifiedHierarchyName(sourceCube, sourceHierarchy);
        return this.getHiddenHierarchies().contains(fqName);
    }

    @Override
    public HashSet<String> getHiddenMembers() {
        return this.hiddenMembers;
    }

    @Override
    public HashSet<String> getHiddenLevels() {
        return this.hiddenLevels;
    }

    @Override
    public HashSet<String> getHiddenHierarchies() {
        return this.hiddenHierarchies;
    }

    @Override
    public HashSet<String> getHiddenDimensions() {
        return this.hiddenDimensions;
    }

    @Override
    public MergeStyleEnum getMergeStyle() {
        return this.mergeStyleEnum;
    }

    @Override
    public List<String> getVirtualDimensionNames() {
        return this.virtualDimensionNames;
    }

    @Override
    public HashMapObjectBoolean<String> getOutputNameToIsVisible() {
        return this.outputNameToIsVisible;
    }

    @Override
    public HashMap<String, String> getFqMemberNameToOutputName() {
        return this.fqMemberNameToOutputName;
    }

    @Override
    public HashMap<String, String> getFqMemberNameToPrecedence() {
        return this.fqMemberNameToPrecedence;
    }

    @Override
    public HashMap<String, String> getFqMemberNameToMergeOperator() {
        return this.fqMemberNameToMergeOperator;
    }

    @Override
    public HashMap<String, String> getOutputNameToFormat() {
        return this.outputNameToFormat;
    }

    @Override
    public HashMap<String, List<ROLAPVirtualCalculatedMemberDef>> getHierarchyNameToVirtualCalcMemberDefs() {
        if (this.hierarchyNameToVirtualCalcMemberDefs != null) {
            return this.hierarchyNameToVirtualCalcMemberDefs;
        }
        return new HashMap<String, List<ROLAPVirtualCalculatedMemberDef>>();
    }

    @Override
    public List<ROLAPVirtualNamedSetDef> getNamedSets() {
        return this.namedSetModelRefs;
    }

    @Override
    public HashMap<String, String> getFqToOutputLevelName() {
        return this.fqToOutputLevelNames;
    }

    @Override
    public HashMap<String, String> getFqToOutputHierarchyName() {
        return this.fqToOutputHierarchyNames;
    }

    @Override
    public HashMap<String, String> getFqToOutputDimensionName() {
        return this.fqToOutputDimensionNames;
    }

    @Override
    public HashMap<String, String> getVDimensionNameToDefaultHierarchy() {
        return this.vDimensionNameToDefaultHierarchy;
    }

    @Override
    public HashMap<String, String> getVHierarchyUniqueNameToDefaultMember() {
        return this.vHierarchyUniqueNameToDefaultMember;
    }

    private void initializeVirtualMemberConfiguration(Element virtualHierarchy, boolean isMeasuresHierarchy) {
        ArrayList<Element> virtualMembers = new ArrayList<Element>();
        this.getAllVirtualMemberElements(virtualHierarchy, virtualMembers);
        for (Element virtualMember : virtualMembers) {
            String outputName = this.getDefaultName(virtualMember);
            String memberMergeOperator = virtualMember.attributeValue(MERGE_OPERATOR);
            String precedence = virtualMember.attributeValue(PRECEDENCE);
            String isVisible = virtualMember.attributeValue(VISIBLE);
            String format = virtualMember.attributeValue(FORMAT);
            ROLAPLog.log("ROLAPCubes.Virtual", "Virtual Member Name " + outputName);
            if (outputName != null && outputName.length() > 0) {
                ROLAPVirtualMemberModelRef memberDef = new ROLAPVirtualMemberModelRef(this, virtualMember);
                if (isMeasuresHierarchy) {
                    this.measuresModelRefs.put(outputName, memberDef);
                }
                List<Element> sourceMemberRefs = CollectionCast.uncheckedCast(virtualMember.elements(SOURCE_MEMBER_REF));
                for (Element sourceMemberRef : sourceMemberRefs) {
                    String hidden;
                    String uniqueName = sourceMemberRef.attributeValue(NAME);
                    ROLAPLog.log("ROLAPCubes.Virtual", "    Virtual Member Source " + uniqueName);
                    if ((uniqueName = this.validateSourceMemberReference(uniqueName)) == null) continue;
                    String oldName = this.fqMemberNameToOutputName.put(uniqueName, outputName);
                    this.sourceMemberModelRefs.put(uniqueName, memberDef);
                    if (oldName != null) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_DuplicateSourceObjectRef, uniqueName);
                    }
                    if (memberMergeOperator != null && memberMergeOperator.length() > 0) {
                        ROLAPLog.log("ROLAPCubes.Virtual", "        MergeOperator " + memberMergeOperator);
                        this.fqMemberNameToMergeOperator.put(uniqueName, memberMergeOperator);
                    }
                    if (precedence != null && precedence.length() > 0) {
                        ROLAPLog.log("ROLAPCubes.Virtual", "        Precedence " + precedence);
                        this.fqMemberNameToPrecedence.put(uniqueName, precedence);
                    }
                    if ((hidden = sourceMemberRef.attributeValue(HIDDEN)) == null || hidden.length() <= 0 || !hidden.equalsIgnoreCase(TRUE_STRING)) continue;
                    this.logHiddenMember(uniqueName);
                    this.hiddenMembers.add(uniqueName);
                }
                if (isVisible != null && !isVisible.equalsIgnoreCase(TRUE_STRING)) {
                    ROLAPLog.log("ROLAPCubes.Virtual", "Is Not Visible ");
                    this.outputNameToIsVisible.put(outputName, false);
                } else {
                    this.outputNameToIsVisible.put(outputName, true);
                }
                if (format == null || format.length() <= 0) continue;
                ROLAPLog.log("ROLAPCubes.Virtual", "Format " + format);
                this.outputNameToFormat.put(outputName, format);
                continue;
            }
            ROLAPLog.logWarn("ROLAPCubes.Virtual", "Virtual member has an empty name. The model configuration for this member will be ignored");
        }
    }

    private void initializeVirtualMeasureFolderConfiguration(Element containerElement, ROLAPVirtualMeasureFolderModelRef parentFolderDef) {
        ArrayList<Element> virtualMembersOrFlders = new ArrayList<Element>();
        this.getChildMembersAndFolders(containerElement, virtualMembersOrFlders);
        for (Element virtualMemberOrFolder : virtualMembersOrFlders) {
            String objName = this.getDefaultName(virtualMemberOrFolder);
            if (virtualMemberOrFolder.getName().equals(VIRTUAL_MEMBER)) {
                ROLAPVirtualMemberModelRef memberDef = this.measuresModelRefs.get(objName);
                if (memberDef == null) continue;
                parentFolderDef.addChildMember(memberDef);
                continue;
            }
            if (virtualMemberOrFolder.getName().equals(VIRTUAL_CALCULATED_MEMBER)) {
                ROLAPVirtualCalculatedMemberDef calcMemberDef = this.calcMeasuresModelRefs.get(objName);
                if (calcMemberDef == null) continue;
                parentFolderDef.addChildCalcMember(calcMemberDef);
                continue;
            }
            if (!virtualMemberOrFolder.getName().equals(VIRTUAL_HIERARCHY_FOLDER)) continue;
            ROLAPVirtualMeasureFolderModelRef folderDef = new ROLAPVirtualMeasureFolderModelRef(virtualMemberOrFolder, this);
            this.initializeVirtualMeasureFolderConfiguration(virtualMemberOrFolder, folderDef);
            parentFolderDef.addChildFolder(folderDef);
        }
    }

    private void getAllVirtualMemberElements(Element container, List<Element> childMembers) {
        int size = container.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node child = container.node(i);
            if (!(child instanceof Element)) continue;
            if (child.getName().equals(VIRTUAL_HIERARCHY_FOLDER)) {
                this.getAllVirtualMemberElements((Element)child, childMembers);
                continue;
            }
            if (!child.getName().equals(VIRTUAL_MEMBER)) continue;
            childMembers.add((Element)child);
        }
    }

    private void getAllVirtualCalculatedMemberElements(Element container, List<Element> childMembers) {
        int size = container.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node child = container.node(i);
            if (!(child instanceof Element)) continue;
            if (child.getName().equals(VIRTUAL_HIERARCHY_FOLDER)) {
                this.getAllVirtualCalculatedMemberElements((Element)child, childMembers);
                continue;
            }
            if (!child.getName().equals(VIRTUAL_CALCULATED_MEMBER)) continue;
            childMembers.add((Element)child);
        }
    }

    private void getChildMembersAndFolders(Element container, List<Element> children) {
        int size = container.nodeCount();
        for (int i = 0; i < size; ++i) {
            Node child = container.node(i);
            if (!(child instanceof Element) || !child.getName().equals(VIRTUAL_HIERARCHY_FOLDER) && !child.getName().equals(VIRTUAL_MEMBER) && !child.getName().equals(VIRTUAL_CALCULATED_MEMBER)) continue;
            children.add((Element)child);
        }
    }

    private String validateSourceMemberReference(String uniqueName) {
        String cubeName = ROLAPVirtualCubeDef.getCubeNameFromFqUniqueName(uniqueName);
        MetadataResolver resolver = this.cubeToMetadataResolver.get(cubeName);
        String returnName = uniqueName;
        try {
            if (resolver != null) {
                IMember mem;
                String unQualUniqueName = uniqueName;
                String cubeUNameDot = UniqueNameGenerator.createUniqueName(cubeName) + ".";
                if (unQualUniqueName.startsWith(cubeUNameDot)) {
                    unQualUniqueName = unQualUniqueName.substring(cubeUNameDot.length());
                }
                returnName = (mem = resolver.resolveMember(unQualUniqueName)) != null ? cubeUNameDot + mem.getUniqueName() : null;
            }
        }
        catch (InterpreterException e) {
            returnName = null;
        }
        if (returnName == null) {
            ROLAPLog.logWarn("ROLAPCubes.Virtual", "Unable to resolve source member: " + uniqueName);
        }
        return returnName;
    }

    private String validateSourceLevelReference(String uniqueName) {
        String cubeName = ROLAPVirtualCubeDef.getCubeNameFromFqUniqueName(uniqueName);
        MetadataResolver resolver = this.cubeToMetadataResolver.get(cubeName);
        String returnName = uniqueName;
        try {
            if (resolver != null) {
                ILevel lev;
                String unQualUniqueName = uniqueName;
                String cubeUNameDot = UniqueNameGenerator.createUniqueName(cubeName) + ".";
                if (unQualUniqueName.startsWith(cubeUNameDot)) {
                    unQualUniqueName = unQualUniqueName.substring(cubeUNameDot.length());
                }
                returnName = (lev = resolver.resolveLevel(unQualUniqueName)) != null ? cubeUNameDot + lev.getUniqueName() : null;
            }
        }
        catch (InterpreterException e) {
            returnName = null;
        }
        if (returnName == null) {
            ROLAPLog.logWarn("ROLAPCubes.Virtual", "Unable to resolve source level: " + uniqueName);
        }
        return returnName;
    }

    private String validateSourceHierarchyReference(String uniqueName) {
        String cubeName = ROLAPVirtualCubeDef.getCubeNameFromFqUniqueName(uniqueName);
        MetadataResolver resolver = this.cubeToMetadataResolver.get(cubeName);
        String returnName = uniqueName;
        try {
            if (resolver != null) {
                IHierarchy hier;
                String unQualUniqueName = uniqueName;
                String cubeUNameDot = UniqueNameGenerator.createUniqueName(cubeName) + ".";
                if (unQualUniqueName.startsWith(cubeUNameDot)) {
                    unQualUniqueName = unQualUniqueName.substring(cubeUNameDot.length());
                }
                returnName = (hier = resolver.resolveHierarchy(unQualUniqueName)) != null ? cubeUNameDot + hier.getUniqueName() : null;
            }
        }
        catch (InterpreterException e) {
            returnName = null;
        }
        if (returnName == null) {
            ROLAPLog.logWarn("ROLAPCubes.Virtual", "Unable to resolve source hierarchy: " + uniqueName);
        }
        return returnName;
    }

    private String getDefaultName(Element metadata) {
        if (metadata == null) {
            return null;
        }
        String locale = this.getDefaultLocale();
        String defaultName = null;
        if (locale != null) {
            List<Object> names = null;
            names = metadata.getName().matches(VIRTUAL_MEMBER) || metadata.getName().matches(VIRTUAL_CALCULATED_MEMBER) ? CollectionCast.uncheckedCast(metadata.elements(CAPTION)) : CollectionCast.uncheckedCast(metadata.elements(NAME));
            if (names != null) {
                for (Element name : names) {
                    if (!locale.equalsIgnoreCase(name.attributeValue(LOCALE))) continue;
                    defaultName = name.getText();
                    break;
                }
            }
        }
        if (defaultName == null) {
            defaultName = metadata.attributeValue(NAME);
        }
        return defaultName;
    }

    private String validateSourceDimensionReference(String uniqueName) {
        String cubeName = ROLAPVirtualCubeDef.getCubeNameFromFqUniqueName(uniqueName);
        MetadataResolver resolver = this.cubeToMetadataResolver.get(cubeName);
        String returnName = uniqueName;
        try {
            if (resolver != null) {
                IDimension dim;
                String unQualUniqueName = uniqueName;
                String cubeUNameDot = UniqueNameGenerator.createUniqueName(cubeName) + ".";
                if (unQualUniqueName.startsWith(cubeUNameDot)) {
                    unQualUniqueName = unQualUniqueName.substring(cubeUNameDot.length());
                }
                returnName = (dim = resolver.resolveDimension(unQualUniqueName)) != null ? cubeUNameDot + dim.getUniqueName() : null;
            }
        }
        catch (InterpreterException e) {
            returnName = null;
        }
        if (returnName == null) {
            ROLAPLog.logWarn("ROLAPCubes.Virtual", "Unable to resolve source dimension: " + uniqueName);
        }
        return returnName;
    }

    public static String getCubeNameFromFqUniqueName(String uniqueName) {
        String cubeName = null;
        try {
            String[] elements = UniqueNameParser.parse(uniqueName);
            cubeName = elements[0];
        }
        catch (UniqueNameParserException e) {
            throw XQERuntimeException.wrap(e);
        }
        return cubeName;
    }

    private void initializeVirtualDimensionConfig() {
        List<Element> virtualDimensions = CollectionCast.uncheckedCast(this.virtualXMLElement.elements(VIRTUAL_DIMENSION));
        for (Element virtualDimension : virtualDimensions) {
            String vdName = this.getDefaultName(virtualDimension);
            ROLAPLog.logTrace("ROLAPCubes.Virtual", "Virtual Dimension Name " + vdName);
            ArrayList<String> srcDimensions = new ArrayList<String>();
            if (vdName != null && vdName.length() > 0) {
                String defaultHierarchyName;
                Element defaultHierarchyRef;
                String dimUniqueName = ROLAPVirtualCubeDef.createDimensionUniqueName(vdName);
                this.dimensionModelRefs.put(dimUniqueName, new ROLAPVirtualDimensionModelRef(this, virtualDimension));
                boolean isVirtualDimensionHidden = true;
                List<Element> sourceDimensionRefs = CollectionCast.uncheckedCast(virtualDimension.elements(SOURCE_DIMENSION_REF));
                for (Element sourceDimensionRef : sourceDimensionRefs) {
                    String sourceName = sourceDimensionRef.attributeValue(NAME);
                    ROLAPLog.logTrace("ROLAPCubes.Virtual", "    Virtual Dimension Source " + sourceName);
                    if ((sourceName = this.validateSourceDimensionReference(sourceName)) == null) continue;
                    String oldName = this.fqToOutputDimensionNames.put(sourceName, vdName);
                    if (oldName != null) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_DuplicateSourceObjectRef, sourceName);
                    }
                    String hidden = sourceDimensionRef.attributeValue(HIDDEN);
                    if (hidden != null && hidden.equalsIgnoreCase(TRUE_STRING)) {
                        this.hiddenDimensions.add(sourceName);
                        this.logHiddenDimension(sourceName);
                    } else {
                        isVirtualDimensionHidden = false;
                    }
                    srcDimensions.add(sourceName);
                }
                if (!isVirtualDimensionHidden) {
                    this.virtualDimensionNames.add(vdName);
                }
                if ((defaultHierarchyRef = virtualDimension.element(DEFAULT_HIERARCHY_REF)) != null && (defaultHierarchyName = defaultHierarchyRef.attributeValue(NAME)) != null && defaultHierarchyName.length() > 0) {
                    this.vDimensionNameToDefaultHierarchy.put(vdName, defaultHierarchyName);
                    ROLAPLog.logTrace("ROLAPCubes.Virtual", "        Default Hierarchy " + defaultHierarchyName);
                }
                boolean isMeasures = this.isMeasuresDimension(srcDimensions);
                this.initializeVirtualHierarchyConfig(virtualDimension, isMeasures);
                continue;
            }
            ROLAPLog.logWarn("ROLAPCubes.Virtual", "Virtual dimension has an empty name. The model configuration for this dimension will be ignored");
        }
        if (this.mergeStyleEnum.equals((Object)MergeStyleEnum.EXPLICIT)) {
            this.resolveHiddenMetaData();
        }
    }

    private void initializeVirtualNamedSetsConfig() {
        List virtualNamedSetsElement = CollectionCast.uncheckedCast(this.virtualXMLElement.elements(VIRTUAL_NAMEDSETS));
        if (virtualNamedSetsElement == null || virtualNamedSetsElement.size() == 0) {
            return;
        }
        List<Element> virtualNamedSets = CollectionCast.uncheckedCast(((Element)virtualNamedSetsElement.get(0)).elements(VIRTUAL_NAMEDSET));
        HashSet<String> addedNamedSets = new HashSet<String>();
        for (Element virtualNamedSet : virtualNamedSets) {
            List<Element> displayPaths;
            List<Element> descriptions;
            String name = virtualNamedSet.attributeValue(NAME);
            if (addedNamedSets.contains(name)) {
                ROLAPLog.logWarn("ROLAPCubes.Virtual", "Duplicated named set found in cube model: " + name + ". Second definition will be ignored");
                continue;
            }
            addedNamedSets.add(name);
            ROLAPVirtualNamedSetDef virtualNamedSetDef = new ROLAPVirtualNamedSetDef();
            virtualNamedSetDef.setName(name);
            String v5Expression = virtualNamedSet.element(V5EXPRESSION).attributeValue(TEMPLATE);
            virtualNamedSetDef.setExpression(v5Expression);
            List<Element> captions = CollectionCast.uncheckedCast(virtualNamedSet.elements(CAPTION));
            if (captions != null) {
                ILocalizedString localizedCaption = this.generateLocalizedString(this.defaultLocale, name, captions);
                virtualNamedSetDef.setLocalizedCaption(localizedCaption);
            }
            if ((descriptions = CollectionCast.uncheckedCast(virtualNamedSet.elements(DESCRIPTION))) != null) {
                ILocalizedString localizedDescription = this.generateLocalizedString(this.defaultLocale, name, descriptions);
                virtualNamedSetDef.setLocalizedDescription(localizedDescription);
            }
            if ((displayPaths = CollectionCast.uncheckedCast(virtualNamedSet.elements(DISPLAY_PATH))) != null) {
                ILocalizedString localizedDisplayPath = this.generateLocalizedString(this.defaultLocale, "", displayPaths);
                virtualNamedSetDef.setLocalizedDisplayPath(localizedDisplayPath);
            }
            this.namedSetModelRefs.add(virtualNamedSetDef);
        }
    }

    private void resolveHiddenMetaData() {
        for (ROLAPCube sourceCube : this.mSourceCubes) {
            List<IDimension> dimList = sourceCube.getDimensions();
            for (IDimension dim : dimList) {
                this.resolveHiddenDimension(sourceCube, dim);
            }
        }
    }

    private void resolveHiddenDimension(ICube sourceCube, IDimension dim) {
        String dimKey = ROLAPVirtualCube.getFullyQualifiedUniqueName(sourceCube, (IMetadata)dim);
        if (!this.fqToOutputDimensionNames.containsKey(dimKey) && dim.getType() != DimensionTypeEnum.INTERNAL) {
            this.hiddenDimensions.add(dimKey);
            this.logHiddenDimension(dimKey);
        }
        List<IHierarchy> hierList = dim.getHierarchies();
        for (IHierarchy hier : hierList) {
            this.resolveHiddenHierarchy(sourceCube, hier);
        }
    }

    private void resolveHiddenHierarchy(ICube sourceCube, IHierarchy hier) {
        String hierKey = ROLAPVirtualCube.getFullyQualifiedHierarchyName(sourceCube, hier);
        if (!this.fqToOutputHierarchyNames.containsKey(hierKey) && hier.getDimension().getType() != DimensionTypeEnum.INTERNAL) {
            this.hiddenHierarchies.add(hierKey);
            this.logHiddenHierarchy(hierKey);
        }
        List<ILevel> levelList = hier.getLevels();
        for (ILevel level : levelList) {
            this.resolveHiddenLevel(sourceCube, level);
        }
    }

    private void resolveHiddenLevel(ICube sourceCube, ILevel level) {
        String levelKey = ROLAPVirtualCube.getFullyQualifiedLevelName(sourceCube, level);
        if (!(level.getDimension().isMeasuresDimension() || level.getHierarchy().isParentChild() || this.fqToOutputLevelNames.containsKey(levelKey) || level.getDimension().getType() == DimensionTypeEnum.INTERNAL)) {
            this.hiddenLevels.add(levelKey);
            this.logHiddenLevel(levelKey);
        }
        if (level.getDimension().isMeasuresDimension()) {
            List<IMember> members = level.getMembers();
            for (IMember measure : members) {
                this.resolveHiddenMeasures(measure);
            }
        }
    }

    private void resolveHiddenMeasures(IMember measure) {
        String measureKey = ROLAPVirtualCube.getFullyQualifiedUniqueName(measure.getDimension().getCube(), (IMetadata)measure);
        if (!this.fqMemberNameToOutputName.containsKey(measureKey)) {
            this.hiddenMembers.add(measureKey);
            this.logHiddenMember(measureKey);
        }
    }

    private void logHiddenMember(String mun) {
        ROLAPLog.log("ROLAPCubes.Virtual", "        " + mun + "  Is Hidden ");
    }

    private void logHiddenLevel(String lun) {
        ROLAPLog.log("ROLAPCubes.Virtual", "        Level Hidden: " + lun);
    }

    private void logHiddenHierarchy(String hun) {
        ROLAPLog.log("ROLAPCubes.Virtual", "        Hierarchy Hidden: " + hun);
    }

    private void logHiddenDimension(String dun) {
        ROLAPLog.log("ROLAPCubes.Virtual", "        Dimension Hidden: " + dun);
    }

    private void initializeVirtualHierarchyConfig(Element virtualDimension, boolean isMeasures) {
        String dimName = this.getDefaultName(virtualDimension);
        List<Element> virtualHierarchies = CollectionCast.uncheckedCast(virtualDimension.elements(VIRTUAL_HIERARCHY));
        for (Element virtualHierarchy : virtualHierarchies) {
            String vhName = this.getDefaultName(virtualHierarchy);
            ROLAPLog.logTrace("ROLAPCubes.Virtual", "Virtual Hierarchy Name " + vhName);
            if (vhName != null && vhName.length() > 0) {
                String defaultMemberName;
                String hierUniqueName = ROLAPVirtualCubeDef.createHierarchyUniqueName(dimName, vhName);
                this.hierarchyModelRefs.put(hierUniqueName, new ROLAPVirtualHierarchyModelRef(this, virtualHierarchy));
                List<Element> sourceHierarchyRefs = CollectionCast.uncheckedCast(virtualHierarchy.elements(SOURCE_HIERARCHY_REF));
                for (Element sourceHierarchyRef : sourceHierarchyRefs) {
                    String sourceName = sourceHierarchyRef.attributeValue(NAME);
                    ROLAPLog.logTrace("ROLAPCubes.Virtual", "    Virtual Hierarchy Source " + sourceName);
                    if ((sourceName = this.validateSourceHierarchyReference(sourceName)) == null) continue;
                    String oldName = this.fqToOutputHierarchyNames.put(sourceName, vhName);
                    if (oldName != null) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_DuplicateSourceObjectRef, sourceName);
                    }
                    String hidden = sourceHierarchyRef.attributeValue(HIDDEN);
                    if (hidden == null || !hidden.equalsIgnoreCase(TRUE_STRING)) continue;
                    this.hiddenHierarchies.add(sourceName);
                    this.logHiddenHierarchy(sourceName);
                }
                Element defaultMemberRef = virtualHierarchy.element(DEFAULT_MEMBER_REF);
                if (defaultMemberRef != null && (defaultMemberName = defaultMemberRef.attributeValue(NAME)) != null && defaultMemberName.length() > 0) {
                    this.vHierarchyUniqueNameToDefaultMember.put(UniqueNameGenerator.createUniqueName(dimName, vhName), defaultMemberName);
                    ROLAPLog.logTrace("ROLAPCubes.Virtual", "        Default Member " + defaultMemberName);
                }
                this.initializeVirtualLevelConfig(virtualHierarchy);
                ArrayList<Element> virtualCalculatedMemberDefs = new ArrayList<Element>();
                this.getAllVirtualCalculatedMemberElements(virtualHierarchy, virtualCalculatedMemberDefs);
                if (virtualCalculatedMemberDefs != null) {
                    this.initializeVirtualCalculatedMembers(vhName, virtualCalculatedMemberDefs, isMeasures);
                }
                this.initializeVirtualMemberConfiguration(virtualHierarchy, isMeasures);
                if (!isMeasures) continue;
                this.initializeVirtualMeasureFolderConfiguration(virtualHierarchy, this.rootMeasureFolder);
                continue;
            }
            ROLAPLog.logWarn("ROLAPCubes.Virtual", "Virtual hierarchy has an empty name. The model configuration for this hierarchy will be ignored");
        }
    }

    private void initializeVirtualCalculatedMembers(String vhName, List<Element> virtualCalculatedMemberDefs, boolean isMeasures) {
        if (this.hierarchyNameToVirtualCalcMemberDefs == null) {
            this.hierarchyNameToVirtualCalcMemberDefs = new HashMap();
        }
        ArrayList<ROLAPVirtualCalculatedMemberDef> virtualCalculatedMemberDefList = new ArrayList<ROLAPVirtualCalculatedMemberDef>();
        for (Element virtualCalculatedMemberDef : virtualCalculatedMemberDefs) {
            Element aggRuleElement;
            String calcName = this.getDefaultName(virtualCalculatedMemberDef);
            Element parentElement = virtualCalculatedMemberDef.element(PARENT_UNIQUE_NAME);
            String parentUniqueName = null;
            String aggRule = null;
            if (parentElement != null) {
                parentUniqueName = parentElement.attributeValue(NAME);
            }
            if ((aggRuleElement = virtualCalculatedMemberDef.element(AGGREGATION)) != null) {
                aggRule = aggRuleElement.attributeValue(FUNCTION);
            }
            String v5Expression = virtualCalculatedMemberDef.element(V5EXPRESSION).attributeValue(TEMPLATE);
            String solveOrder = virtualCalculatedMemberDef.attributeValue(SOLVEORDER);
            List<Element> captions = CollectionCast.uncheckedCast(virtualCalculatedMemberDef.elements(CAPTION));
            List<Element> names = CollectionCast.uncheckedCast(virtualCalculatedMemberDef.elements(NAME));
            List<Element> descriptions = CollectionCast.uncheckedCast(virtualCalculatedMemberDef.elements(DESCRIPTION));
            ROLAPVirtualCalculatedMemberDef def = new ROLAPVirtualCalculatedMemberDef();
            def.setName(calcName);
            def.setParentUniqueName(parentUniqueName);
            def.setV5Expression(v5Expression);
            def.setAggregateRule(aggRule);
            if (solveOrder != null) {
                int sOrder = Integer.parseInt(solveOrder);
                def.setSolveOrder(sOrder);
            }
            if (captions != null) {
                ILocalizedString localizedCaption = this.generateLocalizedString(this.defaultLocale, calcName, captions);
                def.setLocalizedCaption(localizedCaption);
            }
            if (names != null) {
                ILocalizedString localizedName = this.generateLocalizedString(this.defaultLocale, calcName, names);
                def.setLocalizedName(localizedName);
            }
            if (descriptions != null) {
                ILocalizedString localizedDescription = this.generateLocalizedString(this.defaultLocale, calcName, descriptions);
                def.setLocalizedDescription(localizedDescription);
            }
            FormatId formatId = ROLAPMetaMeasure.generateFormatId(virtualCalculatedMemberDef.attributeValue(FORMAT));
            def.setFormatId(formatId);
            String visibleAttribute = virtualCalculatedMemberDef.attributeValue(VISIBLE);
            boolean isVisible = visibleAttribute == null ? true : TRUE_STRING.equalsIgnoreCase(visibleAttribute);
            def.setIsVisible(isVisible);
            virtualCalculatedMemberDefList.add(def);
            if (!isMeasures) continue;
            this.calcMeasuresModelRefs.put(def.getName(), def);
        }
        this.hierarchyNameToVirtualCalcMemberDefs.put(vhName, virtualCalculatedMemberDefList);
    }

    private ILocalizedString generateLocalizedString(String dLocale, String calcName, List<Element> elements) {
        HashMap<String, String> elementsMap = new HashMap<String, String>();
        for (Element caption : elements) {
            String text = caption.getText();
            String locale = caption.attributeValue(LOCALE);
            elementsMap.put(locale, text);
        }
        String defaultString = (String)elementsMap.get(dLocale);
        if (defaultString == null) {
            defaultString = calcName;
        }
        LocalizedString localizedString = new LocalizedString(dLocale, defaultString);
        Set localeSet = elementsMap.keySet();
        for (String locale : localeSet) {
            String text = (String)elementsMap.get(locale);
            localizedString.put(locale, text);
        }
        return localizedString;
    }

    private void initializeVirtualLevelConfig(Element virtualHierarchy) {
        String dimensionName = this.getDefaultName(virtualHierarchy.getParent());
        String hierarchyName = this.getDefaultName(virtualHierarchy);
        List<Element> virtualLevels = CollectionCast.uncheckedCast(virtualHierarchy.elements(VIRTUAL_LEVEL));
        for (Element virtualLevel : virtualLevels) {
            String vlName = this.getDefaultName(virtualLevel);
            ROLAPLog.logTrace("ROLAPCubes.Virtual", "Virtual Level Name " + vlName);
            if (vlName != null && vlName.length() > 0) {
                String levelUniqueName = ROLAPVirtualCubeDef.createLevelUniqueName(dimensionName, hierarchyName, vlName);
                this.levelModelRefs.put(levelUniqueName, new ROLAPVirtualLevelModelRef(this, virtualLevel));
                List<Element> sourceLevelRefs = CollectionCast.uncheckedCast(virtualLevel.elements(SOURCE_LEVEL_REF));
                for (Element sourceLevelRef : sourceLevelRefs) {
                    String sourceName = sourceLevelRef.attributeValue(NAME);
                    ROLAPLog.logTrace("ROLAPCubes.Virtual", "    Virtual Level Source" + sourceName);
                    if ((sourceName = this.validateSourceLevelReference(sourceName)) == null) continue;
                    String oldName = this.fqToOutputLevelNames.put(sourceName, vlName);
                    if (oldName != null) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_DuplicateSourceObjectRef, sourceName);
                    }
                    String hidden = sourceLevelRef.attributeValue(HIDDEN);
                    if (hidden == null || !hidden.equalsIgnoreCase(TRUE_STRING)) continue;
                    this.hiddenLevels.add(sourceName);
                    this.logHiddenLevel(sourceName);
                }
                continue;
            }
            ROLAPLog.logWarn("ROLAPCubes.Virtual", "Virtual level has an empty name. The model configuration for this level will be ignored");
        }
    }

    @Override
    public void initializeConfig() {
        this.hiddenDimensions.clear();
        this.hiddenHierarchies.clear();
        this.hiddenLevels.clear();
        this.hiddenMembers.clear();
        this.virtualDimensionNames.clear();
        this.fqToOutputDimensionNames.clear();
        this.fqToOutputHierarchyNames.clear();
        this.fqToOutputLevelNames.clear();
        this.vDimensionNameToDefaultHierarchy.clear();
        this.vHierarchyUniqueNameToDefaultMember.clear();
        this.fqMemberNameToMergeOperator.clear();
        this.outputNameToFormat.clear();
        this.fqMemberNameToPrecedence.clear();
        this.fqMemberNameToOutputName.clear();
        this.outputNameToIsVisible.clear();
        this.initializeVirtualDimensionConfig();
        this.initializeVirtualNamedSetsConfig();
    }

    @Override
    public List<Object> getMeasureItems() {
        return this.rootMeasureFolder.getChildren();
    }

    @Override
    public String getDefaultLocale() {
        return this.defaultLocale;
    }

    @Override
    public IROLAPCube[] getSourceCubes() {
        return this.mSourceCubes;
    }

    @Override
    public String getCubeName(String locale) {
        locale = LocaleUtility.getSupportedLocale(locale, this.getName(), this.getDefaultLocale());
        List<Element> virtualCubeNames = CollectionCast.uncheckedCast(this.virtualXMLElement.elements(NAME));
        String value = null;
        for (Element name : virtualCubeNames) {
            if (!locale.equalsIgnoreCase(name.attributeValue(LOCALE))) continue;
            value = name.getText();
            break;
        }
        return value;
    }

    @Override
    public Element getVirtualCubeModel() {
        return this.virtualXMLElement;
    }

    @Override
    public ROLAPVirtualDimensionModelRef getVirtualDimensionModel(String dimUniqueName) {
        return this.dimensionModelRefs.get(dimUniqueName);
    }

    @Override
    public ROLAPVirtualHierarchyModelRef getVirtualHierarchyModel(String hierarchyUniqueName) {
        return this.hierarchyModelRefs.get(hierarchyUniqueName);
    }

    @Override
    public ROLAPVirtualLevelModelRef getVirtualLevelModel(String levelUniqueName) {
        return this.levelModelRefs.get(levelUniqueName);
    }

    @Override
    public HashMap<String, ROLAPVirtualMemberModelRef> getVirtualMemberModel() {
        return this.sourceMemberModelRefs;
    }

    @Override
    public ILocalizedString getName() {
        String localeValue;
        String locale;
        LocalizedString value = null;
        List<Element> names = CollectionCast.uncheckedCast(this.getVirtualCubeModel().elements(NAME));
        for (Element name : names) {
            locale = name.attributeValue(LOCALE);
            localeValue = name.getText();
            if (!locale.equalsIgnoreCase(this.getDefaultLocale())) continue;
            value = new LocalizedString(locale, localeValue);
            break;
        }
        for (Element name : names) {
            locale = name.attributeValue(LOCALE);
            localeValue = name.getText();
            if (value == null || value.isLocaleExist(locale)) continue;
            value.put(locale, localeValue);
        }
        return value;
    }

    static String createDimensionUniqueName(String dimension) {
        String dimUniqueName = UniqueNameGenerator.createSingleNamePart(dimension);
        return dimUniqueName;
    }

    static String createHierarchyUniqueName(String dimension, String hierarchy) {
        String dimUniqueName = UniqueNameGenerator.createSingleNamePart(dimension);
        String hierUniqueName = UniqueNameGenerator.appendUniqueName(dimUniqueName, hierarchy);
        return hierUniqueName;
    }

    static String createLevelUniqueName(String dimension, String hierarchy, String level) {
        String dimUniqueName = UniqueNameGenerator.createSingleNamePart(dimension);
        String hierUniqueName = UniqueNameGenerator.appendUniqueName(dimUniqueName, hierarchy);
        String levelUniqueName = UniqueNameGenerator.appendUniqueName(hierUniqueName, level);
        return levelUniqueName;
    }

    static String createMemberUniqueName(String dimension, String hierarchy, String member, boolean isMeasure) {
        String hierUniqueName = null;
        if (isMeasure) {
            hierUniqueName = UniqueNameGenerator.createSingleNamePart(hierarchy);
        } else {
            String dimUniqueName = UniqueNameGenerator.createSingleNamePart(dimension);
            hierUniqueName = UniqueNameGenerator.appendUniqueName(dimUniqueName, hierarchy);
        }
        String memberUniqueName = UniqueNameGenerator.appendUniqueName(hierUniqueName, member);
        return memberUniqueName;
    }

    public static enum MergeStyleEnum {
        CLASSIC,
        EXPLICIT;

    }
}

