/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.DimensionTypeEnum;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPModelValidationException;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualCubeDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimensionModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.OrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ROLAPVirtualDimension
extends Dimension
implements IROLAPDimension {
    Boolean canRollUp = null;
    private final IDimension[] mSourceDimensions;
    private OrderedMap<ROLAPVirtualCalculatedMeasure> calculatedMeasuresMap = null;

    @Override
    public boolean isShareable() {
        return false;
    }

    @Override
    public ROLAPCacheEngine getMetadataStorage() {
        return (ROLAPCacheEngine)((Cube)((Object)this.getROLAPCube())).getMetadataStorage();
    }

    @Override
    public ROLAPMetaDimension getMetaDimension() {
        return null;
    }

    @Override
    public MetadataConnection getConnection() {
        return this.getCube().getConnection();
    }

    @Override
    public String getName(String locale) {
        ROLAPVirtualDimensionModelRef dimModelRef;
        String localizedName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && (dimModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualDimensionModel(this.getUniqueName())) != null) {
            localizedName = dimModelRef.getName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    public ROLAPVirtualDimension(IDimension[] dimensions, String name, Cube cube) {
        super(name, cube);
        this.mSourceDimensions = dimensions;
        this.description = this.getName();
        boolean isTimeDim = true;
        boolean isMeasureDim = true;
        boolean isInternalDim = true;
        for (IDimension dimension : this.mSourceDimensions) {
            if (dimension == null) continue;
            if (!dimension.isTimeDimension()) {
                isTimeDim = false;
            }
            if (!dimension.isMeasuresDimension()) {
                isMeasureDim = false;
            }
            if (dimension.getType() == DimensionTypeEnum.INTERNAL) continue;
            isInternalDim = false;
        }
        if (isInternalDim) {
            this.setType(DimensionTypeEnum.INTERNAL);
        } else if (isTimeDim) {
            this.setType(DimensionTypeEnum.TIME);
        } else if (isMeasureDim) {
            this.setType(DimensionTypeEnum.MEASURE);
        }
        this.initializeVirtualHierarchies();
    }

    private void initializeVirtualHierarchies() {
        int hierarchyCount = 0;
        LinkedHashMap<String, IROLAPHierarchy[]> vHierNameToSourceHiers = this.getVirtualHierarchyArgs();
        String defHierarchyName = this.determineDefaultHierarchyName(vHierNameToSourceHiers.keySet());
        IROLAPVirtualCubeDef virtualCubeDef = this.getROLAPVirtualCubeDef();
        for (Map.Entry<String, IROLAPHierarchy[]> entry : vHierNameToSourceHiers.entrySet()) {
            String vHierName = entry.getKey();
            boolean isDefaultHierarchy = vHierName.equals(defHierarchyName);
            boolean useTwoPartUniqueName = true;
            if (isDefaultHierarchy && (virtualCubeDef.isCubingServicesCompatible() || this.isMeasuresDimension())) {
                useTwoPartUniqueName = false;
                if (!vHierName.equals(this.getName())) {
                    if (vHierNameToSourceHiers.containsKey(this.getName())) {
                        throw new XQERuntimeException(XQEMessageKeys.ROL_DuplicateHierarchyNameFromDimRename, this.getUniqueName(), this.getCube().getUniqueName());
                    }
                    vHierName = this.getName();
                }
            }
            ROLAPVirtualHierarchy hier = new ROLAPVirtualHierarchy(entry.getValue(), vHierName, this, useTwoPartUniqueName, virtualCubeDef.getHierarchyNameToVirtualCalcMemberDefs().get(vHierName));
            if (isDefaultHierarchy) {
                this.setDefaultHierarchy(hier);
            }
            ++hierarchyCount;
        }
        if (hierarchyCount == 0) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidModelEmptyDimension, this.getCube().getUniqueName(), this.getUniqueName());
        }
    }

    protected IROLAPVirtualCubeDef getROLAPVirtualCubeDef() {
        IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getCube());
        return cube.getROLAPVirtualCubeDef();
    }

    private LinkedHashMap<String, IROLAPHierarchy[]> getVirtualHierarchyArgs() {
        IROLAPVirtualCubeDef cubeDef = this.getROLAPVirtualCubeDef();
        HashMap<String, String> fqNameToOutputHierName = cubeDef.getFqToOutputHierarchyName();
        HashSet<String> hiddenHierarchies = cubeDef.getHiddenHierarchies();
        LinkedHashMap<String, IROLAPHierarchy[]> vHierNameToSourceHiers = new LinkedHashMap<String, IROLAPHierarchy[]>();
        for (int srcIdx = 0; srcIdx < this.mSourceDimensions.length; ++srcIdx) {
            IDimension sourceDimension = this.mSourceDimensions[srcIdx];
            if (sourceDimension == null) continue;
            ICube sourceCube = (ICube)((Object)((IROLAPVirtualCube)((Object)this.getCube())).getSourceCubes()[srcIdx]);
            List<IHierarchy> sourceDimHierarchies = sourceDimension.getHierarchies();
            for (IHierarchy sourceDimHierarchy : sourceDimHierarchies) {
                IROLAPHierarchy[] hierArray;
                String fqName = ROLAPVirtualCube.getFullyQualifiedHierarchyName(sourceCube, sourceDimHierarchy);
                if (hiddenHierarchies.contains(fqName)) continue;
                String outputName = fqNameToOutputHierName.get(fqName);
                if (outputName == null) {
                    outputName = sourceDimHierarchy.getName();
                }
                if ((hierArray = vHierNameToSourceHiers.get(outputName)) == null) {
                    hierArray = new IROLAPHierarchy[this.mSourceDimensions.length];
                    vHierNameToSourceHiers.put(outputName, hierArray);
                }
                hierArray[srcIdx] = (IROLAPHierarchy)sourceDimHierarchy;
            }
        }
        return vHierNameToSourceHiers;
    }

    private String determineDefaultHierarchyName(Set<String> vHierNames) {
        IROLAPVirtualCubeDef def = this.getROLAPVirtualCubeDef();
        HashMap<String, String> fqNameToOutputHierName = def.getFqToOutputHierarchyName();
        HashSet<String> hiddenHierarchies = def.getHiddenHierarchies();
        String defHierarchyName = def.getVDimensionNameToDefaultHierarchy().get(this.getName());
        if (defHierarchyName != null) {
            if (!vHierNames.contains(defHierarchyName)) {
                throw new ROLAPModelValidationException(XQEMessageKeys.ROL_DefaultHierarchyNotInCube, (Object)this.getUniqueName(), (Object)this.getCube().getUniqueName(), (Object)defHierarchyName);
            }
            return defHierarchyName;
        }
        for (int srcIdx = 0; srcIdx < this.mSourceDimensions.length; ++srcIdx) {
            IDimension sourceDimension = this.mSourceDimensions[srcIdx];
            if (sourceDimension == null) continue;
            ICube sourceCube = (ICube)((Object)((IROLAPVirtualCube)((Object)this.getCube())).getSourceCubes()[srcIdx]);
            String fqHierarchyName = ROLAPVirtualCube.getFullyQualifiedHierarchyName(sourceCube, sourceDimension.getDefaultHierarchy());
            if (!hiddenHierarchies.contains(fqHierarchyName)) {
                defHierarchyName = sourceDimension.getDefaultHierarchy().getName();
                if (fqNameToOutputHierName.containsKey(fqHierarchyName)) {
                    defHierarchyName = fqNameToOutputHierName.get(fqHierarchyName);
                }
            }
            if (defHierarchyName != null) break;
        }
        if (defHierarchyName == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_NoDefaultHierarchyInCube, this.getUniqueName(), this.getCube().getUniqueName());
        }
        return defHierarchyName;
    }

    @Override
    public boolean isShell() {
        return false;
    }

    @Override
    public long getROLAPCardinality() {
        long card = 0L;
        int numHiers = this.getHierarchyCount();
        for (int hierx = 0; hierx < numHiers; ++hierx) {
            card += ((ROLAPVirtualHierarchy)this.getHierarchy(hierx)).getROLAPCardinality();
        }
        return card;
    }

    @Override
    public IROLAPCube getROLAPCube() {
        return (IROLAPCube)((Object)this.getCube());
    }

    @Override
    public IROLAPHierarchy[] getROLAPHierarchies() {
        return this.getHierarchies().toArray(new IROLAPHierarchy[0]);
    }

    @Override
    public IROLAPLevel[] getROLAPLevels() {
        return this.getDefaultHierarchy().getLevels().toArray(new IROLAPLevel[0]);
    }

    @Override
    public IROLAPMember[] getROLAPMembers() throws Exception {
        IMember[] members = this.getMembers();
        IROLAPMember[] membersOut = new IROLAPMember[members.length];
        for (int i = 0; i < members.length; ++i) {
            membersOut[i] = (IROLAPMember)members[i];
        }
        return membersOut;
    }

    @Override
    public int getROLAPType() {
        if (this.isTimeDimension()) {
            return 1;
        }
        if (this.isMeasuresDimension()) {
            return 2;
        }
        return 0;
    }

    @Override
    public IROLAPHierarchy getDefaultROLAPHierarchy() {
        return (IROLAPHierarchy)this.getDefaultHierarchy();
    }

    @Override
    public IROLAPMember getDefaultROLAPMember() throws Exception {
        return (IROLAPMember)this.getDefaultMember();
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeSessionScoped) {
        return CollectionCast.uncheckedCast(((IROLAPVirtualCube)((Object)this.getCube())).getCalculations(this));
    }

    @Override
    public boolean isDMR() {
        return false;
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return UniqueNameGenerator.createROLAPV5UniqueName(this.getCube(), ROLAPUtilities.getExpressionLocale(this), this);
    }

    public IDimension[] getSourceDimensions() {
        return this.mSourceDimensions;
    }

    @Override
    public String getCaption() {
        ROLAPVirtualDimensionModelRef dimensionModelRef;
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        String locale = LocaleConverter.localeToStr(runLocale);
        String localizedName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && (dimensionModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualDimensionModel(this.getUniqueName())) != null && (localizedName = dimensionModelRef.getName(locale)) == null) {
            localizedName = dimensionModelRef.getName(virtualCube.getDefaultLocale());
        }
        if (localizedName == null) {
            localizedName = super.getName();
        }
        return localizedName;
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return this.getLocalizedName();
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ROLAPVirtualDimensionModelRef dimModelRef;
        ILocalizedString lcName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && (dimModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualDimensionModel(this.getUniqueName())) != null) {
            lcName = dimModelRef.getName();
        }
        if (lcName == null) {
            lcName = AbstractSingleLocaleString.getSingleLocaleString(virtualCube.getDefaultLocale(), this.getName());
        }
        return lcName;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        return LocalizedString.emptyString();
    }

    public OrderedMap<ROLAPVirtualCalculatedMeasure> fetchCalculatedMembers(ROLAPVirtualLevel rolapVirtualLevel) {
        if (this.isMeasuresDimension()) {
            if (this.calculatedMeasuresMap != null) {
                return this.calculatedMeasuresMap;
            }
            this.calculatedMeasuresMap = new OrderedMap();
            ROLAPVirtualHierarchy virtualMeasureHier = (ROLAPVirtualHierarchy)this.getDefaultHierarchy();
            List<ROLAPCalculatedMember> calcMeasureList = virtualMeasureHier.getROLAPCalculatedMembers(this.getCube().getName());
            for (ROLAPCalculatedMember measure : calcMeasureList) {
                String defaultCaption;
                ROLAPVirtualCalculatedMeasure meas = (ROLAPVirtualCalculatedMeasure)measure;
                if (this.calculatedMeasuresMap.get(measure.getName()) == null) {
                    this.calculatedMeasuresMap.put(meas);
                }
                if ((defaultCaption = meas.getDefaultCaption()) != null && this.calculatedMeasuresMap.get(defaultCaption) == null) {
                    ROLAPVirtualCalculatedMeasure calcMember = new ROLAPVirtualCalculatedMeasure(defaultCaption, (ILevel)rolapVirtualLevel, null, null, meas.getROLAPVirtualCalculatedMemberDef());
                    calcMember.setParentMember(meas.getParent());
                    calcMember.setFormatId(meas.getFormatId());
                    this.calculatedMeasuresMap.put(calcMember);
                }
                ILocalizedString measureHierName = virtualMeasureHier.getLocalizedName();
                this.generateLocalizedCalculatedMeasures(rolapVirtualLevel, meas, measureHierName, meas.getLocalizedCaption());
                this.generateLocalizedCalculatedMeasures(rolapVirtualLevel, meas, measureHierName, meas.getLocalizedName());
            }
            return this.calculatedMeasuresMap;
        }
        return null;
    }

    private void generateLocalizedCalculatedMeasures(ROLAPVirtualLevel rolapVirtualLevel, ROLAPVirtualCalculatedMeasure measure, ILocalizedString measureParentName, ILocalizedString localizedMemNameString) {
        if (localizedMemNameString != null) {
            String[] supportedLocales;
            for (String locale : supportedLocales = localizedMemNameString.getSupportedLocales()) {
                String localizedParentName;
                String localizedMemName = localizedMemNameString.toString(locale);
                ROLAPVirtualCalculatedMeasure meas = new ROLAPVirtualCalculatedMeasure(localizedMemName, (ILevel)rolapVirtualLevel, null, null, measure.getROLAPVirtualCalculatedMemberDef());
                meas.setParentMember(measure.getParent());
                meas.setFormatId(measure.getFormatId());
                if (measureParentName != null && (localizedParentName = measureParentName.toString(locale)) != null) {
                    String uniqueName = UniqueNameGenerator.createUniqueName(localizedParentName, localizedMemName);
                    meas.setUniqueName(uniqueName);
                }
                if (this.calculatedMeasuresMap.get(meas.getName()) != null) continue;
                this.calculatedMeasuresMap.put(meas);
            }
        }
    }

    @Override
    public boolean getMembersRollup() {
        return this.getMembersRollup(false);
    }

    @Override
    public boolean getMembersRollup(ICube cube) {
        return this.getMembersRollup(false);
    }

    @Override
    public boolean getMembersRollup(ICube cube, boolean allowSecurityOverride) {
        return this.getMembersRollup(allowSecurityOverride);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getMembersRollup(boolean allowSecurityOverride) {
        if (this.canRollUp != null) {
            return this.canRollUp;
        }
        for (int srcIdx = 0; srcIdx < this.mSourceDimensions.length; ++srcIdx) {
            IROLAPDimension sourceDimension = (IROLAPDimension)this.mSourceDimensions[srcIdx];
            ICube sourceCube = (ICube)((Object)((IROLAPVirtualCube)((Object)this.getCube())).getSourceCubes()[srcIdx]);
            if (sourceDimension == null) continue;
            String previousCurrentCubeName = ROLAPContext.getCurrentCubeName();
            ROLAPContext.removeCurrentCubeName(previousCurrentCubeName != null);
            try {
                ROLAPContext.setCurrentCubeName(sourceCube.getName());
                if (sourceDimension.getMembersRollup(sourceCube, allowSecurityOverride)) continue;
                boolean bl = false;
                return bl;
            }
            finally {
                ROLAPContext.removeCurrentCubeName(true);
                if (previousCurrentCubeName != null) {
                    ROLAPContext.setCurrentCubeName(previousCurrentCubeName);
                }
            }
        }
        if (this.hasHiddenMembers()) {
            this.canRollUp = Boolean.FALSE;
            return this.canRollUp;
        }
        return true;
    }

    private boolean hasHiddenMembers() {
        ArrayList<String> cubeAndDimNames = new ArrayList<String>();
        for (int srcIdx = 0; srcIdx < this.mSourceDimensions.length; ++srcIdx) {
            IDimension sourceDimension = this.mSourceDimensions[srcIdx];
            if (sourceDimension == null) continue;
            ICube sourceCube = (ICube)((Object)((IROLAPVirtualCube)((Object)this.getCube())).getSourceCubes()[srcIdx]);
            cubeAndDimNames.add(UniqueNameGenerator.createUniqueName(sourceCube.getName(), sourceDimension.getName()));
        }
        HashSet<String> hiddenMembers = this.getROLAPVirtualCubeDef().getHiddenMembers();
        for (String hiddenMember : hiddenMembers) {
            if (!this.matchesDimension(cubeAndDimNames, hiddenMember)) continue;
            return true;
        }
        return false;
    }

    private boolean matchesDimension(ArrayList<String> cubeAndDimNames, String hiddenMember) {
        if (!this.isMeasuresDimension()) {
            for (String cubeAndDimName : cubeAndDimNames) {
                if (!hiddenMember.startsWith(cubeAndDimName)) continue;
                return true;
            }
        }
        return false;
    }
}

