/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.ast.IXQEQueryNode;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQEMessages;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.provider.MetadataConnection;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.Property;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.V5ExpressionUtils;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMeasure;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevelModelRef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualProperty;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.transformation.rolap.ROLAPUtilities;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.LightweightOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.UniqueNameParser;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;

public class ROLAPVirtualLevel
extends Level
implements IROLAPLevel {
    private static final int ONE_THOUSAND = 1000;
    private static final int EIGHT = 8;
    private static final int FIVE = 5;
    private final ILevel[] mSourceLevels;
    private final String[] mSourceCubeNames;

    public ROLAPVirtualLevel(IROLAPCube[] sourceCubes, ILevel[] levels, String name, ROLAPVirtualHierarchy hierarchy) {
        super(name, hierarchy);
        this.mSourceLevels = levels;
        int size = 0;
        if (sourceCubes != null) {
            size = sourceCubes.length;
        }
        this.mSourceCubeNames = new String[size];
        for (int idx = 0; idx < this.mSourceLevels.length; ++idx) {
            ILevel level = this.mSourceLevels[idx];
            if (level == null) continue;
            ROLAPVirtualLevel.addMemberProperties(this, level, sourceCubes[idx]);
            this.mSourceCubeNames[idx] = sourceCubes[idx].getName();
        }
    }

    @Override
    public String getCaption() {
        ROLAPVirtualLevelModelRef levelModelRef;
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        String locale = LocaleConverter.localeToStr(runLocale);
        String localizedName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && (levelModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualLevelModel(this.getUniqueName())) != null && (localizedName = levelModelRef.getName(locale)) == null) {
            localizedName = levelModelRef.getName(virtualCube.getDefaultLocale());
        }
        if (localizedName == null) {
            localizedName = super.getName();
        }
        return localizedName;
    }

    @Override
    public String getName(String locale) {
        ROLAPVirtualLevelModelRef levelModelRef;
        String localizedName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && (levelModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualLevelModel(this.getUniqueName())) != null) {
            localizedName = levelModelRef.getName(locale);
        }
        if (localizedName == null) {
            localizedName = this.getName();
        }
        return localizedName;
    }

    @Override
    public int getROLAPCardinality() {
        return this.getROLAPCardinality(true);
    }

    @Override
    public int getROLAPCardinality(boolean onlyEstimateCount) {
        int cardinality = 0;
        List<ROLAPCalculatedMember> calcMembers = this.getROLAPCalculatedMembers(true);
        if (onlyEstimateCount) {
            int memberCount = 1000;
            if (this.getIndex() < 5) {
                memberCount = (int)Math.pow(8.0, this.getIndex() + 1);
            }
            cardinality = calcMembers.size() + memberCount;
        } else {
            List<IMember> memberList = this.getMembers();
            SecurityManagerInterface securityManager = this.getSecurityManager();
            if (securityManager == null) {
                cardinality = memberList.size() + calcMembers.size();
            } else {
                ROLAPHierarchy hier = (ROLAPHierarchy)this.getHierarchy();
                IMember[] calculatedMembers = calcMembers.toArray(new IMember[calcMembers.size()]);
                calculatedMembers = securityManager.applySecurity(calculatedMembers, hier);
                IMember[] members = memberList.toArray(new IMember[memberList.size()]);
                members = securityManager.applySecurity(members, hier);
                int memberCount = members.length;
                cardinality = calculatedMembers.length + memberCount;
            }
        }
        return cardinality;
    }

    private SecurityManagerInterface getSecurityManager() {
        IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        return cube.getSecurityManager(cube.getProvider());
    }

    @Override
    public IROLAPDimension getROLAPDimension() {
        return (IROLAPDimension)this.getDimension();
    }

    @Override
    public int getROLAPGeneration() {
        return this.getIndex();
    }

    @Override
    public IROLAPHierarchy getROLAPHierarchy() {
        return (IROLAPHierarchy)this.getHierarchy();
    }

    @Override
    public int getROLAPLevelNumber() {
        return this.getIndex();
    }

    @Override
    public IROLAPMember[] getROLAPMembers(boolean includeCalcMembers) {
        IMember[] members = null;
        if (includeCalcMembers) {
            ArrayList<IMember> allMembers = new ArrayList<IMember>();
            List<IMember> nonCalcMembers = this.getMembers();
            List<ROLAPCalculatedMember> calcMembers = this.getROLAPCalculatedMembers(true);
            if (this.getIndex() == 0) {
                allMembers.addAll(nonCalcMembers);
                allMembers.addAll(calcMembers);
                members = allMembers.toArray(new IMember[allMembers.size()]);
            } else {
                List<IMember> parents = null;
                ILevel parentLevel = this.getHierarchy().getLevel(this.getIndex() - 1);
                parents = (this.getHierarchy().isRagged() || this.getHierarchy().isUnbalanced()) && parentLevel instanceof Level ? ((Level)parentLevel).getMembers(true, false) : new ArrayList<IROLAPMember>(Arrays.asList(((ROLAPVirtualLevel)parentLevel).getROLAPMembers(true)));
                HashMap<IMember, ArrayList<IMember>> mapping = new HashMap<IMember, ArrayList<IMember>>();
                Iterator<IMember> it = nonCalcMembers.iterator();
                IMember parent = null;
                IMember oldParent = null;
                ArrayList<IMember> childList = new ArrayList<IMember>();
                if (it.hasNext()) {
                    IMember mem = it.next();
                    oldParent = parent = mem.getParent();
                    childList.add(mem);
                    while (it.hasNext()) {
                        mem = it.next();
                        parent = mem.getParent();
                        if (parent != oldParent) {
                            mapping.put(oldParent, childList);
                            childList = new ArrayList<IMember>();
                        }
                        childList.add(mem);
                        oldParent = parent;
                    }
                    mapping.put(oldParent, childList);
                }
                for (IMember iMember : calcMembers) {
                    parent = iMember.getParent();
                    childList = (ArrayList<IMember>)mapping.get(parent);
                    if (childList == null) {
                        childList = new ArrayList<IMember>();
                    }
                    childList.add(iMember);
                    mapping.put(parent, childList);
                }
                it = parents.iterator();
                while (it.hasNext()) {
                    if ((this.getHierarchy().isRagged() || this.getHierarchy().isUnbalanced()) && parent instanceof Member) {
                        for (parent = it.next(); parent != null && ((Member)parent).isFillerMember(); parent = parent.getParent()) {
                        }
                    }
                    if ((childList = (ArrayList<IMember>)mapping.get(parent)) == null) continue;
                    allMembers.addAll(childList);
                }
                members = allMembers.toArray(new IMember[allMembers.size()]);
            }
        } else {
            members = this.getMembers().toArray(new IMember[0]);
        }
        SecurityManagerInterface securityManager = this.getSecurityManager();
        if (securityManager != null) {
            members = securityManager.applySecurity(members, this.getHierarchy());
        }
        IROLAPMember[] serverMembers = new IROLAPMember[members.length];
        for (int i = 0; i < members.length; ++i) {
            serverMembers[i] = (IROLAPMember)members[i];
        }
        return serverMembers;
    }

    @Override
    public String getMemberKeyPropertyName() {
        return null;
    }

    @Override
    public IROLAPProperty[] getProperties() {
        List<IProperty> props = this.getMemberProperties();
        IROLAPProperty[] output = new IROLAPProperty[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            output[i] = (IROLAPProperty)props.get(i);
        }
        return output;
    }

    public int[] getPropertyTypes() {
        List<IProperty> props = this.getMemberProperties();
        int[] output = new int[props.size()];
        for (int i = 0; i < props.size(); ++i) {
            Property prop = (Property)props.get(i);
            output[i] = prop.getDataType() != null ? (int)prop.getDataType().getCCLTypeCode() : 12;
        }
        return output;
    }

    @Override
    public int getType() {
        boolean initialized = false;
        int type = 0;
        boolean isTimeLevel = false;
        for (ILevel level : this.mSourceLevels) {
            if (level == null) continue;
            if (level instanceof IROLAPLevel) {
                if (!initialized) {
                    initialized = true;
                    type = ((IROLAPLevel)level).getType();
                    isTimeLevel = level.getDimension().isTimeDimension();
                    continue;
                }
                if (type == ((IROLAPLevel)level).getType()) continue;
                if (isTimeLevel && level.getDimension().isTimeDimension()) {
                    type = 13;
                    continue;
                }
                return 0;
            }
            return 0;
        }
        return type;
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeSessionScoped) {
        IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getHierarchy().getDimension().getCube());
        return CollectionCast.uncheckedCast(cube.getCalculations(this));
    }

    private boolean isSourceLevelsAllLevel() {
        boolean isAllLevel = true;
        for (ILevel level : this.mSourceLevels) {
            if (level == null) continue;
            isAllLevel &= ((Level)level).isAllLevel();
        }
        return isAllLevel;
    }

    @Override
    public boolean isAllLevel() {
        return this.isSourceLevelsAllLevel();
    }

    @Override
    public boolean isValidPropertyName(String name) {
        if (super.isValidPropertyName(name)) {
            return true;
        }
        return name.equalsIgnoreCase("CAPTION") || name.equalsIgnoreCase("DESCRIPTION") || name.equalsIgnoreCase("MEMBER_KEY");
    }

    public ILevel[] getSourceLevels() {
        return this.mSourceLevels;
    }

    public ILevel getSourceLevel(ICube sourceCube) {
        ILevel[] sourceLevels;
        for (ILevel level : sourceLevels = this.getSourceLevels()) {
            if (level == null || !level.getDimension().getCube().equals(sourceCube)) continue;
            return level;
        }
        return null;
    }

    @Override
    public ROLAPMetaLevel getMetaLevel() {
        return null;
    }

    public List<ROLAPMetaLevel> getSourceMetaLevels() {
        ArrayList<ROLAPMetaLevel> metaLevels = new ArrayList<ROLAPMetaLevel>();
        int index = 0;
        for (ILevel sourceLevel : this.mSourceLevels) {
            if (sourceLevel != null) {
                if (sourceLevel instanceof ROLAPVirtualLevel) {
                    metaLevels.addAll(((ROLAPVirtualLevel)sourceLevel).getSourceMetaLevels());
                } else {
                    ROLAPLevel sourceROLAPLevel = (ROLAPLevel)sourceLevel;
                    if (!sourceROLAPLevel.getDimension().isShareable()) {
                        ROLAPMetaLevel metaLevel = sourceROLAPLevel.getMetaLevel();
                        if (metaLevel != null) {
                            metaLevels.add(metaLevel);
                        }
                    } else {
                        this.addSourceMetaLevelsFromSharedDim(metaLevels, sourceROLAPLevel, this.mSourceCubeNames[index]);
                    }
                }
            }
            ++index;
        }
        return metaLevels;
    }

    private void addSourceMetaLevelsFromSharedDim(List<ROLAPMetaLevel> metaLevels, ROLAPLevel sourceROLAPLevel, String sourceCubeName) {
        ShareableROLAPDimension sharedDim = (ShareableROLAPDimension)sourceROLAPLevel.getDimension();
        ROLAPCube sourceCube = sharedDim.getCube(sourceCubeName);
        if (sourceCube instanceof IROLAPVirtualCube) {
            IROLAPCube[] sourceCubes = ((IROLAPVirtualCube)((Object)sourceCube)).getSourceCubes();
            int[] sourceCubesIndices = sharedDim.getVirtualCubeSourceCubeIndexes(sourceCube.getName());
            for (int index = 0; index < sourceCubesIndices.length; ++index) {
                IROLAPCube cube = sourceCubes[sourceCubesIndices[index]];
                this.addSourceMetaLevelsFromSharedDim(metaLevels, sourceROLAPLevel, cube.getName());
            }
        } else {
            ROLAPMetaLevel metaLevel = this.getMetaLevel(sourceROLAPLevel, sourceCubeName);
            if (metaLevel != null) {
                metaLevels.add(metaLevel);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ROLAPMetaLevel getMetaLevel(ROLAPLevel sourceROLAPLevel, String sourceCubeName) {
        String previousCurrentCubeName = ROLAPContext.getCurrentCubeName();
        ROLAPContext.removeCurrentCubeName(previousCurrentCubeName != null);
        ROLAPContext.setCurrentCubeName(sourceCubeName);
        try {
            ROLAPMetaLevel rOLAPMetaLevel = sourceROLAPLevel.getMetaLevel();
            return rOLAPMetaLevel;
        }
        finally {
            ROLAPContext.removeCurrentCubeName(true);
            if (previousCurrentCubeName != null) {
                ROLAPContext.setCurrentCubeName(previousCurrentCubeName);
            }
        }
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        return UniqueNameGenerator.createROLAPV5UniqueName(cubeName, ROLAPUtilities.getExpressionLocale(this), this);
    }

    private static void addMemberProperties(ROLAPVirtualLevel outputLevel, ILevel level, IROLAPCube sourceCube) {
        List<IProperty> properties = sourceCube != null ? ((IROLAPLevel)level).getMemberProperties(sourceCube.getName()) : level.getMemberProperties();
        for (IProperty prop : properties) {
            ROLAPVirtualProperty virtualProp = new ROLAPVirtualProperty(prop.getName(), (ILevel)outputLevel);
            virtualProp.setCaption(prop.getName());
            virtualProp.setDataType(prop.getDataType());
            virtualProp.setInitialised();
            virtualProp.addSourceProperty(prop, sourceCube);
            outputLevel.addMemberProperty(virtualProp, sourceCube);
        }
    }

    @Override
    public MetadataConnection getConnection() {
        return this.getHierarchy().getConnection();
    }

    public void validateCalculatedMeasures(IROLAPVirtualCube rolapCube) {
        if (!this.getDimension().isMeasuresDimension()) {
            return;
        }
        List<IMember> measures = this.getMembers(false, true);
        ArrayList<ROLAPCalculatedMember> calcMeasuresToRemove = new ArrayList<ROLAPCalculatedMember>(measures.size());
        ListIterator<IMember> iterator = measures.listIterator();
        while (iterator.hasNext()) {
            IMember measure = iterator.next();
            if (!measure.isCalculatedMember()) continue;
            ROLAPVirtualCalculatedMeasure calcMeasure = (ROLAPVirtualCalculatedMeasure)measure;
            String v5Expression = calcMeasure.getROLAPVirtualCalculatedMemberDef().getV5Expression();
            boolean isV5ExpressionSyntaxValid = false;
            IXQEQueryNode queryNode = null;
            try {
                queryNode = V5ExpressionUtils.checkV5ExpressionSyntax(v5Expression);
                isV5ExpressionSyntaxValid = queryNode != null;
            }
            catch (XQERuntimeException e) {
                String errorMessage = XQEMessages.getMessage(XQEMessageKeys.ROL_InvalidCalculatedMemberDefinition, XQEMessages.getCurrProductLocale(), measure.getName(), this.getHierarchy().getUniqueName());
                ROLAPLog.logError("ROLAPCubes.Loader", errorMessage, e);
                rolapCube.addInvalidCalculatedMember(this.getHierarchy(), measure.getName());
            }
            if (!isV5ExpressionSyntaxValid || !V5ExpressionUtils.validateCalculatedMemberDefinition(this.getHierarchy(), rolapCube, calcMeasure, calcMeasure.getName())) {
                calcMeasuresToRemove.add(calcMeasure);
                continue;
            }
            if (calcMeasure.getFormatId() != null) continue;
            List<String> expressionIndentifers = V5ExpressionUtils.getExpressionIdentifiers(queryNode);
            calcMeasure.setInheritedFormatId(((ROLAPVirtualLevel)measure.getHierarchy().getLevel(0)).getMembers(false, true), expressionIndentifers);
        }
        if (calcMeasuresToRemove.size() > 0) {
            for (ROLAPCalculatedMember m : calcMeasuresToRemove) {
                ((ROLAPVirtualHierarchy)this.getHierarchy()).getROLAPCalculatedMembers(rolapCube.getName()).remove(m);
                ((ROLAPCube)((Object)rolapCube)).getRootMeasureFolder().removeChild(m.getUniqueName());
            }
            ((ROLAPVirtualCube)this.getDimension().getCube()).getMemberCacheInContext().removeCalculatedMembers(calcMeasuresToRemove);
        }
    }

    private HashSet<String> getRegularMeasuresSet(List<IMember> measures) {
        HashSet<String> regularMeasuresSet = new HashSet<String>();
        ListIterator<IMember> iterator = measures.listIterator();
        while (iterator.hasNext()) {
            IMember measure = iterator.next();
            if (measure.isCalculatedMember()) continue;
            regularMeasuresSet.add(measure.getUniqueName());
        }
        return regularMeasuresSet;
    }

    @Override
    public List<IMember> getMembers(boolean includeFillerMembers, boolean includeHiddenMembers) throws MetadataException {
        if (this.getDimension().isMeasuresDimension() && this.getIndex() == 0) {
            return this.getMembersWithCalcs(this.getDimension().getCube().getName(), includeFillerMembers, includeHiddenMembers);
        }
        return super.getMembers(includeFillerMembers, includeHiddenMembers);
    }

    private List<IMember> getMembersWithCalcs(String cubeName, boolean includeFillerMembers, boolean includeHiddenMembers) {
        List<ROLAPCalculatedMember> calculatedMeasuresList = ((ROLAPVirtualHierarchy)this.getHierarchy()).getROLAPCalculatedMembers(cubeName);
        ArrayList<IMember> measuresList = new ArrayList<IMember>();
        if (calculatedMeasuresList != null && calculatedMeasuresList.size() > 0) {
            IMember[] measArray;
            IOrderedMap<IMember> measures = this.getMembersOrderedMap();
            for (IMember iMember : measArray = (IMember[])measures.toArray(new IMember[0])) {
                measuresList.add(iMember);
            }
            HashSet<String> regularMeasuresSet = this.getRegularMeasuresSet(measuresList);
            ArrayList<ROLAPVirtualCalculatedMeasure> calcMeasuresToRemove = new ArrayList<ROLAPVirtualCalculatedMeasure>(measures.size());
            for (ROLAPCalculatedMember rOLAPCalculatedMember : calculatedMeasuresList) {
                ROLAPVirtualCalculatedMeasure calcMeasure = (ROLAPVirtualCalculatedMeasure)rOLAPCalculatedMember;
                if (regularMeasuresSet.contains(calcMeasure.getUniqueName())) {
                    calcMeasuresToRemove.add(calcMeasure);
                    continue;
                }
                measuresList.add(calcMeasure);
            }
            if (calcMeasuresToRemove.size() > 0) {
                for (IMember iMember : calcMeasuresToRemove) {
                    ((ROLAPVirtualHierarchy)this.getHierarchy()).getROLAPCalculatedMembers(cubeName).remove(iMember);
                }
            }
            return this.getMembersFromList(measuresList, includeFillerMembers, includeHiddenMembers);
        }
        return super.getMembers(includeFillerMembers, includeHiddenMembers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<IMember> getMembersFromList(List<IMember> measuresList, boolean includeFillerMembers, boolean includeHiddenMembers) {
        boolean mayContainFillers = this.getHierarchy().isRagged() || this.getHierarchy().isUnbalanced();
        this.readLock().lock();
        try {
            if (!mayContainFillers || includeFillerMembers) {
                ArrayList<IMember> result = new ArrayList<IMember>();
                for (IMemberCubics iMemberCubics : measuresList) {
                    if (!includeHiddenMembers && iMemberCubics.isHidden()) continue;
                    result.add(iMemberCubics);
                }
                ArrayList<IMember> arrayList = result;
                return arrayList;
            }
            ArrayList<IMember> result = new ArrayList<IMember>();
            for (IMemberCubics iMemberCubics : measuresList) {
                if (iMemberCubics.isFillerMember() || !includeHiddenMembers && iMemberCubics.isHidden()) continue;
                result.add(iMemberCubics);
            }
            ArrayList<IMember> arrayList = result;
            return arrayList;
        }
        finally {
            this.readLock().unlock();
        }
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return this.getLocalizedName();
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ROLAPVirtualLevelModelRef levelModelRef;
        ILocalizedString lcName = null;
        IROLAPVirtualCube virtualCube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        if (virtualCube.getROLAPVirtualCubeDef() != null && (levelModelRef = virtualCube.getROLAPVirtualCubeDef().getVirtualLevelModel(this.getUniqueName())) != null) {
            lcName = levelModelRef.getName();
        }
        if (lcName == null) {
            lcName = AbstractSingleLocaleString.getSingleLocaleString(virtualCube.getDefaultLocale(), this.getName());
        }
        return lcName;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        return LocalizedString.emptyString();
    }

    @Override
    public FormatId getCalculatedMeasureFormatId(String calcName) {
        ROLAPVirtualDimension rolapVirtualDimension = (ROLAPVirtualDimension)this.getDimension();
        return this.getVirtualCalculatedMemberFormatIds(calcName, rolapVirtualDimension.fetchCalculatedMembers(this));
    }

    private FormatId getVirtualCalculatedMemberFormatIds(String calcName, IOrderedMap<ROLAPVirtualCalculatedMeasure> calculatedMeasures) {
        if (calculatedMeasures != null) {
            String[] identifiers = UniqueNameParser.parseNoThrow(calcName);
            if (identifiers != null && identifiers.length > 0) {
                for (int index = 0; index < calculatedMeasures.size(); ++index) {
                    ROLAPVirtualCalculatedMeasure measure = calculatedMeasures.get(index);
                    String v5UniqueDefaultCaption = UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(identifiers[0]), measure.getUniqueDefaultCaption());
                    if (v5UniqueDefaultCaption.equals(calcName)) {
                        return measure.getFormatId();
                    }
                    String v5UniqueRuntimeCaption = UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(identifiers[0]), measure.getUniqueRuntimeCaption());
                    if (v5UniqueRuntimeCaption.equals(calcName)) {
                        return measure.getFormatId();
                    }
                    String v5UniqueName = UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(identifiers[0]), measure.getUniqueName());
                    if (!v5UniqueName.equals(calcName)) continue;
                    return measure.getFormatId();
                }
            } else {
                return null;
            }
        }
        return null;
    }

    @Override
    public synchronized IMember getMember(String memberName) throws MetadataException {
        String[] parts;
        IMember member = super.getMember(memberName);
        if (member != null && (parts = UniqueNameParser.parseNoThrow(memberName)) != null && parts.length > 0 && !member.getUniqueName().equals(memberName)) {
            List<IMember> members = this.getMembers();
            for (IMember mem : members) {
                if (!mem.getUniqueName().equals(memberName)) continue;
                member = mem;
                break;
            }
        }
        return member;
    }

    public void addMemberProperty(ROLAPVirtualProperty prop, IROLAPCube sourceCube) {
        if (!this.memberProperties.contains(prop.getName())) {
            this.memberProperties.put(prop);
        } else {
            ROLAPVirtualProperty virtProp = (ROLAPVirtualProperty)this.getMemberProperty(prop.getName());
            virtProp.addSourceProperty(prop.getInitialSourceProperty(), sourceCube);
        }
    }

    @Override
    public List<IProperty> getMemberProperties(String cubeName) {
        IDimension dimension = this.getDimension();
        Cube cb = dimension.isShareable() ? ((ShareableROLAPDimension)dimension).getCube(cubeName) : (Cube)dimension.getCube();
        SecurityManagerInterface securityManager = cb.getSecurityManager();
        if (securityManager != null) {
            return this.getMemberPropertiesWithSecurity(securityManager);
        }
        return this.memberProperties.toArrayList();
    }

    @Override
    protected IOrderedMap<IMember> createOrderedMap() {
        return new LightweightOrderedMap<IMember>();
    }
}

