/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.Member;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberOperations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.SecurityPaddingOrderedMap;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualCubeDef;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMemberModelRef;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.ImmutableOrderedMap;
import com.cognos.xqe.util.LocaleConverter;
import com.cognos.xqe.util.LocaleUtility;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public class ROLAPVirtualMember
extends Member
implements IROLAPVirtualMember {
    private int unrestrictedChildrenCount = -1;
    private IROLAPMember mParent = null;
    private final IMember[] mSourceMembers;
    private boolean isPaddingMember = false;
    private boolean isSecPaddingMember = false;
    private final ICacheKey memberKey;

    public ROLAPVirtualMember(ICacheKey inMemberKey, IMember[] members, String name, ILevel level, String caption) {
        super(name, level);
        this.mSourceMembers = members;
        this.setMemberId(((Dimension)this.getDimension()).getmaxMemberId());
        this.memberKey = inMemberKey;
        this.setCaption(caption);
    }

    public ICacheKey getMemberKey() {
        return this.memberKey;
    }

    @Override
    public Pair[] getSourceMembers() {
        ArrayList<Pair> members = new ArrayList<Pair>();
        for (int index = 0; index < this.mSourceMembers.length; ++index) {
            IMember member = this.mSourceMembers[index];
            if (member == null) continue;
            members.add(new Pair(member, XQEIntegerPool.getInteger(index)));
        }
        return members.toArray(new Pair[members.size()]);
    }

    @Override
    public IMember[] getOrderedSourceMembers() {
        return this.mSourceMembers;
    }

    @Override
    public Object getProperty(String propName) {
        if ("PARENT_UNIQUE_NAME".equalsIgnoreCase(propName)) {
            IROLAPMember memberParent = this.getROLAPParent();
            if (memberParent != null) {
                return memberParent.getUniqueName();
            }
            return null;
        }
        if ("PARENT_LEVEL".equalsIgnoreCase(propName)) {
            IROLAPMember memberParent = this.getROLAPParent();
            if (memberParent != null) {
                return memberParent.getROLAPLevel().getROLAPLevelNumber();
            }
            return null;
        }
        if ("PARENT_COUNT".equalsIgnoreCase(propName)) {
            return this.getROLAPParentCount();
        }
        if ("CHILDREN_CARDINALITY".equalsIgnoreCase(propName)) {
            return this.getROLAPChildrenCount();
        }
        if ("AGGREGATION_FUNCTION_NULL".equalsIgnoreCase(propName)) {
            for (IMember member : this.mSourceMembers) {
                Boolean b;
                if (member == null || (b = (Boolean)member.getProperty(propName)) == null || !b.booleanValue()) continue;
                return b;
            }
            return null;
        }
        if ("MEMBER_CAPTION".equalsIgnoreCase(propName)) {
            return this.getCaption();
        }
        return this.getSourceMemberProperty(propName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IOrderedMap<IMember> fetchChildMembers() throws MetadataException, ProviderException {
        ILevel nextLevel = this.getLevel().getNextLevel();
        IOrderedMap<IMember> result = null;
        if (nextLevel == null) {
            result = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
            return result;
        }
        result = this.createOrderedMap();
        if (this.hasGotAllChildren() && this.fetchCachedChildren(result)) {
            return result;
        }
        IROLAPVirtualCubeDef cubeDef = ((ROLAPVirtualDimension)this.getDimension()).getROLAPVirtualCubeDef();
        HashSet<String> hiddenMembers = cubeDef.getHiddenMembers();
        HashMap<String, String> fnNameToOutputName = cubeDef.getFqMemberNameToOutputName();
        HashMap<String, ROLAPVirtualMemberModelRef> membersDef = cubeDef.getVirtualMemberModel();
        ROLAPVirtualMemberModelRef memberDef = null;
        HashMap<String, IMember[]> memberMap = new HashMap<String, IMember[]>();
        ArrayList<String> orderedNameList = new ArrayList<String>();
        HashMap<String, String> captions = new HashMap<String, String>();
        HashMap<String, StringBuilder> identifiers = new HashMap<String, StringBuilder>();
        boolean isCubingServicesCompatible = cubeDef.isCubingServicesCompatible();
        for (int i = 0; i < this.mSourceMembers.length; ++i) {
            IMember member = this.mSourceMembers[i];
            if (member == null) continue;
            IMember[] children = member.getChildMembers();
            ICube sourceCube = (ICube)((Object)cubeDef.getSourceCubes()[i]);
            String currentThreadLocalCubeName = null;
            if (member.getDimension().isShareable()) {
                currentThreadLocalCubeName = this.setThreadLocalCubeName(i);
            }
            try {
                Object level;
                if (children.length > 0 && cubeDef.isSourceLevelHidden((level = children[0].getLevel()).getDimension().getCube(), (ILevel)level)) continue;
                level = children;
                int n = ((IMember[])level).length;
                for (int j = 0; j < n; ++j) {
                    String outputName;
                    Object child = level[j];
                    String fqName = ROLAPVirtualCube.getFullyQualifiedUniqueName(sourceCube, (IMetadata)child);
                    if (hiddenMembers.contains(fqName)) continue;
                    String caption = outputName = fnNameToOutputName.get(fqName);
                    if (outputName == null) {
                        outputName = child.getName();
                        caption = child.getCaption();
                    } else if (!isCubingServicesCompatible) {
                        String childIdentifier = child.getName();
                        StringBuilder identifier = (StringBuilder)identifiers.get(outputName);
                        if (identifier == null) {
                            identifier = new StringBuilder(childIdentifier);
                        } else if (!identifier.toString().equals(childIdentifier)) {
                            identifier.append("?").append(childIdentifier);
                        }
                        identifiers.put(outputName, identifier);
                        memberDef = membersDef.get(fqName);
                        if (memberDef != null) {
                            ((ROLAPVirtualHierarchy)this.getHierarchy()).addMemberDef(identifier.toString(), memberDef);
                        }
                    }
                    captions.put(outputName, caption);
                    IMember[] childSourceMembers = (IMember[])memberMap.get(outputName);
                    if (childSourceMembers == null) {
                        childSourceMembers = new IMember[cubeDef.getSourceCubes().length];
                        memberMap.put(outputName, childSourceMembers);
                        orderedNameList.add(outputName);
                    }
                    childSourceMembers[i] = child;
                }
                continue;
            }
            finally {
                if (currentThreadLocalCubeName != null) {
                    ROLAPContext.removeCurrentCubeName(true);
                    ROLAPContext.setCurrentCubeName(currentThreadLocalCubeName);
                }
            }
        }
        ArrayList<ROLAPVirtualMember> members = new ArrayList<ROLAPVirtualMember>();
        if (orderedNameList.isEmpty() && !this.getHierarchy().isParentChild()) {
            String caption;
            if (((IROLAPHierarchy)this.getHierarchy()).getFillerCaptionType() == IROLAPHierarchy.FillerCaptionType.BLANK_CAPTION) {
                caption = " ";
            } else {
                caption = this.getCaption();
                if (caption == null) {
                    caption = this.getName();
                }
            }
            ROLAPVirtualMember cm = this.createVirtualChildMember(nextLevel, new IMember[0], caption, "");
            cm.setPaddingMember(true);
            members.add(cm);
        } else {
            for (String outputName : orderedNameList) {
                StringBuilder sbIdentifier;
                IMember[] childSourceMembers = (IMember[])memberMap.get(outputName);
                String caption = (String)captions.get(outputName);
                String identifier = outputName;
                if (!isCubingServicesCompatible && (sbIdentifier = (StringBuilder)identifiers.get(outputName)) != null) {
                    identifier = sbIdentifier.toString();
                }
                ROLAPVirtualMember cm = this.createVirtualChildMember(nextLevel, childSourceMembers, caption, identifier);
                members.add(cm);
            }
        }
        result.retainAll(members);
        return result;
    }

    public ROLAPVirtualMember createVirtualChildMember(ILevel nextLevel, IMember[] sourceMembers, String caption, String identifier) {
        IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        MetadataCacheKey cacheKey = cube.cacheVirtualMemberData(sourceMembers, identifier, nextLevel, this.getMemberKey(), null);
        ROLAPVirtualMember cm = new ROLAPVirtualMember(cacheKey, sourceMembers, identifier, nextLevel, caption);
        cm.setParentMember(this);
        return cm;
    }

    boolean fetchCachedChildren(IOrderedMap<IMember> childMembers) {
        boolean bFound = false;
        try {
            ROLAPCacheEngine storage = this.getROLAPDimension().getMetadataStorage();
            List<ICacheKey> childKeys = storage.getMemberChildrenFromCache(this.getMemberKey());
            if (childKeys != null) {
                for (ICacheKey childKey : childKeys) {
                    IMember member = null;
                    String childName = storage.getMemberNameFromCache(childKey);
                    Level childLevel = (Level)this.getLevel().getNextLevel();
                    if (!childLevel.hasGotAllMembers()) continue;
                    member = childLevel.getMember(childName, ((MetadataCacheKey)childKey).getMetadataChildId());
                    if (member == null) {
                        throw new ProviderException("ROLAPVirtualMember object " + childName + " expected to be present, but not found within level members list.");
                    }
                    childMembers.put(member);
                }
            }
        }
        catch (ProviderException e) {
            throw new MetadataException("la1003", e);
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCacheGetException(e, this.getDimension().getCube().getName(), this.getDimension().getName());
        }
        if (childMembers.size() == 0) {
            childMembers = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
        } else {
            bFound = true;
        }
        return bFound;
    }

    @Override
    public int getROLAPChildrenCount() {
        return this.getROLAPChildrenCount(true);
    }

    private SecurityManagerInterface getSecurityManager() {
        IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
        return securityManager;
    }

    public int getROLAPChildrenCount(boolean onlyEstimateCountWhenSecurityIsEnabled) {
        int childrenCount = 0;
        SecurityManagerInterface securityManager = this.getSecurityManager();
        if (securityManager != null) {
            if (onlyEstimateCountWhenSecurityIsEnabled) {
                childrenCount = this.getUnrestrictedChildrenCount(true) + this.getROLAPCalculatedMembers(true).size() == 0 ? 0 : 1;
            } else {
                ArrayList<IMember> relationList = new ArrayList<IMember>();
                try {
                    this.getRelationsOf(1, true, relationList);
                }
                catch (Exception ex) {
                    relationList.clear();
                }
                childrenCount = relationList.size();
            }
        } else {
            childrenCount = this.getUnrestrictedChildrenCount(false) + this.getROLAPCalculatedMembers(true).size();
        }
        return childrenCount;
    }

    private synchronized void initUnrestrictedChildrenCount(boolean securityEnabled) {
        if (this.unrestrictedChildrenCount == -1) {
            if (securityEnabled) {
                this.unrestrictedChildrenCount = ((IROLAPMember)this.mSourceMembers[0]).getROLAPChildrenCount();
            } else {
                ArrayList<IMember> relationList = new ArrayList<IMember>();
                try {
                    this.getRelationsOf(1, false, relationList);
                }
                catch (Exception ex) {
                    relationList.clear();
                }
                this.unrestrictedChildrenCount = relationList.size();
            }
        }
    }

    private int getUnrestrictedChildrenCount(boolean securityEnabled) {
        if (this.unrestrictedChildrenCount == -1) {
            this.initUnrestrictedChildrenCount(securityEnabled);
        }
        return this.unrestrictedChildrenCount;
    }

    public IROLAPCube getROLAPCube() {
        return (IROLAPCube)((Object)this.getLevel().getDimension().getCube());
    }

    @Override
    public IROLAPDimension getROLAPDimension() {
        return (IROLAPDimension)this.getLevel().getDimension();
    }

    @Override
    public IROLAPHierarchy getROLAPHierarchy() {
        return (IROLAPHierarchy)this.getHierarchy();
    }

    @Override
    public IROLAPLevel getROLAPLevel() {
        return (IROLAPLevel)this.getLevel();
    }

    @Override
    public int getROLAPOrdinal() {
        return this.getIndex();
    }

    @Override
    public IROLAPMember getROLAPParent() {
        if (this.mParent != null) {
            return this.mParent;
        }
        ArrayList<IMember> relationList = new ArrayList<IMember>();
        try {
            this.getRelationsOf(4, true, relationList);
        }
        catch (Exception ex) {
            relationList.clear();
        }
        if (relationList.isEmpty()) {
            return null;
        }
        this.mParent = (IROLAPMember)relationList.get(0);
        return this.mParent;
    }

    @Override
    public int getROLAPParentCount() {
        if (this.getROLAPParent() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getROLAPType() {
        int result = 1;
        boolean initialized = false;
        for (IMember member : this.mSourceMembers) {
            if (member == null || !(member instanceof IROLAPMember)) continue;
            if (!initialized) {
                initialized = true;
                result = ((IROLAPMember)member).getROLAPType();
                continue;
            }
            if (result == ((IROLAPMember)member).getROLAPType()) continue;
            return 1;
        }
        return result;
    }

    public Object[] getProperties() {
        ArrayList<String> names = new ArrayList<String>();
        for (IMember member : this.mSourceMembers) {
            this.fetchMemberPropertyNames(names, member);
        }
        Object[] props = new Object[names.size()];
        for (int index = 0; index < names.size(); ++index) {
            props[index] = this.getProperty(names.get(index));
        }
        return props;
    }

    private void fetchMemberPropertyNames(ArrayList<String> names, IMember member) {
        block4: {
            if (member == null) break block4;
            if (member instanceof IROLAPMember) {
                IROLAPProperty[] properties = ((IROLAPMember)member).getROLAPLevel().getProperties();
                for (int index = 0; index < properties.length; ++index) {
                    String propName = properties[index].getName();
                    if (names.contains(propName)) continue;
                    names.add(propName);
                }
            } else {
                Set<String> propertiesNames = member.getLevel().getAvailableProperties();
                for (String propName : propertiesNames) {
                    if (names.contains(propName)) continue;
                    names.add(propName);
                }
            }
        }
    }

    @Override
    public void getRelationsOf(int treeOp, boolean includeCalcMembers, ArrayList<IMember> relationList) throws Exception {
        ROLAPMemberOperations.getRelationsOf(this, treeOp, includeCalcMembers, relationList);
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeSessionScoped) {
        return CollectionCast.uncheckedCast(((IROLAPVirtualCube)((Object)this.getLevel().getDimension().getCube())).getCalculations(this));
    }

    public void flushChildren() {
        this.gotAllChildren = false;
        this.children.clear();
    }

    @Override
    public boolean isPaddingMember() {
        return this.isPaddingMember;
    }

    public void setPaddingMember(boolean paddingMember) {
        this.isPaddingMember = paddingMember;
    }

    @Override
    public boolean isSecurityPaddingMember() {
        return this.isSecPaddingMember;
    }

    @Override
    public void setSecurityPaddingMember(boolean paddingMember) {
        this.isSecPaddingMember = paddingMember;
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        String uniqueName = this.getUniqueName();
        return UniqueNameGenerator.createMemberV5UniqueName(cubeName, this.getLevel(), uniqueName);
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return this.getLocalizedName();
    }

    @Override
    public String getCaption() {
        if (this.isMeasure()) {
            return super.getCaption();
        }
        Locale runLocale = ExecutionEnvironmentContext.getExecutionEnvironment().getRequestEnvironment().getRunLocale();
        String locale = LocaleConverter.localeToStr(runLocale);
        ILocalizedString lcCaption = null;
        String caption = null;
        ROLAPVirtualMemberModelRef memberModelRef = ((ROLAPVirtualHierarchy)this.getHierarchy()).getMemberDefinition(this.getName());
        if (memberModelRef != null && this.matchSourceMembers(memberModelRef) && (lcCaption = memberModelRef.getCaption()) != null) {
            caption = lcCaption.toString(locale = LocaleUtility.getSupportedLocale(locale, lcCaption, this.getDefaultLocale()));
            if (caption == null) {
                caption = lcCaption.toString(lcCaption.getDefaultLocale());
            }
            return caption;
        }
        lcCaption = this.getSourceLocalizedCaption();
        if (lcCaption != null && (caption = lcCaption.toString(locale = LocaleUtility.getSupportedLocale(locale, lcCaption, this.getDefaultLocale()))) == null) {
            try {
                caption = lcCaption.toString(this.getROLAPCube().getDefaultLocale());
            }
            catch (Exception e) {
                throw new ProviderException("Internal error - Invalid cube for member:" + this.getName());
            }
        }
        if (caption == null) {
            caption = super.getCaption();
        }
        return caption;
    }

    private boolean matchSourceMembers(ROLAPVirtualMemberModelRef memberModelRef) {
        String[] modelSourceMemberRefs = memberModelRef.getSourceMemberRefs();
        Pair[] sourceMembers = this.getSourceMembers();
        int matchCount = 0;
        if (sourceMembers.length == modelSourceMemberRefs.length) {
            for (Pair srcMemberPair : sourceMembers) {
                IMember srcMember = (IMember)srcMemberPair.getFirst();
                if (srcMember == null) continue;
                String uniqueName = UniqueNameGenerator.join(UniqueNameGenerator.createUniqueName(srcMember.getHierarchy().getDimension().getCube().getName()), srcMember.getUniqueName());
                for (String memberSourceMemberRef : modelSourceMemberRefs) {
                    if (!uniqueName.equals(memberSourceMemberRef)) continue;
                    ++matchCount;
                }
            }
            return matchCount == sourceMembers.length;
        }
        return false;
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ILocalizedString lcName = null;
        ROLAPVirtualMemberModelRef memberModelRef = ((ROLAPVirtualHierarchy)this.getHierarchy()).getMemberDefinition(this.getName());
        if (memberModelRef != null && (lcName = memberModelRef.getCaption()) != null) {
            return lcName;
        }
        lcName = this.getSourceLocalizedCaption();
        if (lcName == null) {
            lcName = AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), super.getCaption());
        }
        return lcName;
    }

    @Override
    public ILocalizedString getLocalizedDescription() {
        return LocalizedString.emptyString();
    }

    @Override
    public void setParentMember(IMember parent) {
        super.setParentMember(parent);
        if (parent != null) {
            super.setParentLevelNumber(parent.getLevel().getIndex());
        }
    }

    @Override
    public int getParentLevelNumber() {
        ILevel level = this.getLevel();
        if (level.getIndex() == 0) {
            return -1;
        }
        return super.getParentLevelNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ILocalizedString getSourceLocalizedCaption() {
        Pair[] sourceMembers;
        LocalizedString lcName = null;
        for (Pair memberPair : sourceMembers = this.getSourceMembers()) {
            IMember member = (IMember)memberPair.getFirst();
            String currentThreadLocalCubeName = null;
            if (member.getDimension().isShareable()) {
                currentThreadLocalCubeName = this.setThreadLocalCubeName((Integer)memberPair.getSecond());
            }
            try {
                ILocalizedString sourceCaption = ((IROLAPMember)member).getLocalizedCaption();
                if (lcName == null) {
                    lcName = new LocalizedString(sourceCaption);
                    continue;
                }
                if (sourceCaption.getDefaultLocale() != null && !lcName.isLocaleExist(sourceCaption.getDefaultLocale())) {
                    lcName.put(sourceCaption.getDefaultLocale(), sourceCaption.toString());
                }
                for (String sourceLocale : sourceCaption.getSupportedLocales()) {
                    if (lcName.isLocaleExist(sourceLocale)) continue;
                    lcName.put(sourceLocale, sourceCaption.toString(sourceLocale));
                }
            }
            finally {
                if (member.getDimension().isShareable()) {
                    ROLAPContext.removeCurrentCubeName(true);
                    if (currentThreadLocalCubeName != null) {
                        ROLAPContext.removeCurrentCubeName(true);
                        ROLAPContext.setCurrentCubeName(currentThreadLocalCubeName);
                    }
                }
            }
        }
        return lcName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getSourceMemberProperty(String propName) {
        Pair[] sourceMembers;
        Object result = null;
        for (Pair memberPair : sourceMembers = this.getSourceMembers()) {
            IMember member = (IMember)memberPair.getFirst();
            String currentThreadLocalCubeName = null;
            if (member.getDimension().isShareable()) {
                currentThreadLocalCubeName = this.setThreadLocalCubeName((Integer)memberPair.getSecond());
            }
            try {
                result = ((IROLAPMember)member).getProperty(propName);
            }
            finally {
                if (member.getDimension().isShareable()) {
                    ROLAPContext.removeCurrentCubeName(true);
                    if (currentThreadLocalCubeName != null) {
                        ROLAPContext.removeCurrentCubeName(true);
                        ROLAPContext.setCurrentCubeName(currentThreadLocalCubeName);
                    }
                }
                if (result != null) {
                    return result;
                }
            }
        }
        return null;
    }

    private String setThreadLocalCubeName(int sourceCubeIndex) {
        String currentThreadLocalCubeName = ROLAPContext.getCurrentCubeName();
        ROLAPContext.removeCurrentCubeName(currentThreadLocalCubeName != null);
        IROLAPVirtualCubeDef cubeDef = ((ROLAPVirtualDimension)this.getDimension()).getROLAPVirtualCubeDef();
        ICube sourceCube = (ICube)((Object)cubeDef.getSourceCubes()[sourceCubeIndex]);
        ROLAPContext.setCurrentCubeName(sourceCube.getName());
        return currentThreadLocalCubeName;
    }

    @Override
    public List<IMember> getAllChildren(String cubeName) throws MetadataException, ProviderException {
        throw new UnsupportedOperationException("ROLAPmember.getAllChildren not supported");
    }

    @Override
    public String getDescription() {
        Pair[] sourceMembers;
        for (Pair memberPair : sourceMembers = this.getSourceMembers()) {
            IMember member = (IMember)memberPair.getFirst();
            String description = member.getDescription();
            if (description == null) continue;
            return description;
        }
        return super.getDescription();
    }

    public IMember getSourceMember() {
        Pair[] sourceMembers;
        for (Pair memberPair : sourceMembers = this.getSourceMembers()) {
            IMember member = (IMember)memberPair.getFirst();
            if (member == null) continue;
            return member;
        }
        return null;
    }

    public IMember getSourceMember(ICube sourceCube) {
        Pair[] sourceMembers;
        for (Pair memberPair : sourceMembers = this.getSourceMembers()) {
            IMember member = (IMember)memberPair.getFirst();
            if (!member.getDimension().getCube().equals(sourceCube)) continue;
            return member;
        }
        return null;
    }

    public boolean findSourceMember(IMember otherMember) {
        Pair[] sourceMembers;
        for (Pair memberPair : sourceMembers = this.getSourceMembers()) {
            IMember member = (IMember)memberPair.getFirst();
            if (member == null || !member.equals(otherMember)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDefaultLocale() {
        return this.getROLAPCube().getDefaultLocale();
    }

    @Override
    protected IOrderedMap<IMember> createOrderedMap() {
        return new SecurityPaddingOrderedMap<IMember>();
    }

    public void setSecurityPaddingMember(IMember securityPaddingMember) {
        if (this.children == null) {
            this.children = this.createOrderedMap();
        }
        ((SecurityPaddingOrderedMap)this.children).setSecurityPaddingMember(securityPaddingMember);
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof IMember)) {
            return false;
        }
        return this.findSourceMember((IMember)other);
    }

    @Override
    public int hashCode() {
        if (this.hashCode == -1) {
            this.hashCode = this.getUniqueName().hashCode();
        }
        return this.hashCode;
    }
}

