/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.bibushandler.CancelManager;
import com.cognos.xqe.bibushandler.OperationCanceledException;
import com.cognos.xqe.cache.CacheException;
import com.cognos.xqe.cache.ICacheEngine;
import com.cognos.xqe.cache.ICacheKey;
import com.cognos.xqe.cache.util.ICacheableNameValueBasedContent;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IMetadata;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.ProviderException;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MemberProxy;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberOperations;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheBase;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPCacheEngine;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.util.SecurityPaddingOrderedMap;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMemberModelRef;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.util.AbstractSingleLocaleString;
import com.cognos.xqe.util.CollectionCast;
import com.cognos.xqe.util.ILocalizedString;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.ImmutableOrderedMap;
import com.cognos.xqe.util.LocalizedString;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ROLAPVirtualMemberProxy
extends MemberProxy
implements IROLAPVirtualMember {
    private static final String ONE = "1";
    private Map<String, Object> cachedMemberProps = null;
    private int unrestrictedChildrenCount = -1;
    private final IMember[] mSourceMembers;
    private String mun = null;

    public ROLAPVirtualMemberProxy(ICacheKey memKey, String memName, ILevel memLevel, IMember parent, IMember[] sourceMembers) {
        super(memKey, memName, memLevel);
        this.setParentMember(parent);
        this.setPropValueInCache("MEMBER_UNIQUE_NAME", this.prepareUniqueName());
        this.mSourceMembers = sourceMembers;
    }

    public void setPropValueInCache(String propName, Object propValue) {
        ROLAPCacheEngine metadataCache = ((IROLAPDimension)this.getLevel().getDimension()).getMetadataStorage();
        ROLAPVirtualMemberProxy.setPropValueInCache(metadataCache, (ROLAPVirtualDimension)this.getLevel().getDimension(), this.getCacheKey(), propName, propValue);
    }

    public static void setPropValueInCache(ICacheEngine metadataCache, ROLAPVirtualDimension dim, ICacheKey memberCacheKey, String propName, Object propValue) {
        try {
            if (propValue != null) {
                ICacheableNameValueBasedContent cachedMemberContent = (ICacheableNameValueBasedContent)metadataCache.get(memberCacheKey);
                if (cachedMemberContent == null) {
                    cachedMemberContent = ROLAPCacheEngine.createCacheableObject((MetadataCacheKey)memberCacheKey, null);
                }
                cachedMemberContent.put(propName, propValue);
                metadataCache.cacheObject(cachedMemberContent);
            }
        }
        catch (CacheException e) {
            ROLAPCacheBase.throwCacheGetException(e, dim.getCube().getName(), dim.getName());
        }
    }

    private String prepareUniqueName() {
        if (this.mun != null) {
            return this.mun;
        }
        StringBuilder result = new StringBuilder();
        IMember parent = this.getParent();
        if (parent == null) {
            result.append(this.getDimension().getUniqueName());
        } else {
            result.append(parent.getUniqueName());
        }
        if (!this.isFillerMember()) {
            result.append(".[");
            result.append(this.getName());
            result.append("]");
        }
        this.mun = result.toString();
        return this.mun;
    }

    @Override
    public String getUniqueName() {
        return this.prepareUniqueName();
    }

    @Override
    public synchronized Object retrievePropValueFromCache(String propName) {
        Object result = null;
        if (this.cachedMemberProps == null) {
            ICacheableNameValueBasedContent cachedMemberContent;
            IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getLevel().getDimension().getCube());
            ICacheEngine metadataCache = cube.getMetadataStorage();
            try {
                cachedMemberContent = (ICacheableNameValueBasedContent)metadataCache.get(this.getCacheKey());
            }
            catch (CacheException e) {
                ROLAPCacheBase.throwCacheGetException(e, this.getDimension().getCube().getName(), this.getDimension().getName());
                return null;
            }
            if (cachedMemberContent != null) {
                this.cachedMemberProps = cachedMemberContent.getContent();
            }
        }
        if (this.cachedMemberProps != null) {
            result = this.cachedMemberProps.get(propName);
        }
        return result;
    }

    @Override
    public Pair[] getSourceMembers() {
        ArrayList<Pair> members = new ArrayList<Pair>();
        for (int index = 0; index < this.mSourceMembers.length; ++index) {
            IMember member = this.mSourceMembers[index];
            if (member == null) continue;
            members.add(new Pair(member, XQEIntegerPool.getInteger(index)));
        }
        return members.toArray(new Pair[members.size()]);
    }

    protected IMember getSourceMember(int memberIndex) {
        return this.mSourceMembers[memberIndex];
    }

    @Override
    public IMember[] getOrderedSourceMembers() {
        return this.mSourceMembers;
    }

    private boolean hasSingleMemberB(IMember mA, IMember mB) {
        ROLAPCube cubeB = null;
        ROLAPCube[] sourceCubes = ((ROLAPVirtualCube)this.getDimension().getCube()).getSourceCubes();
        if (sourceCubes.length > 1) {
            cubeB = sourceCubes[1];
        }
        return mB == null && mA != null && mA.getDimension().getCube() == cubeB;
    }

    @Override
    public Object getProperty(String propName) {
        Object result = null;
        if ("PARENT_UNIQUE_NAME".equalsIgnoreCase(propName)) {
            IROLAPMember parent = this.getROLAPParent();
            if (parent != null) {
                return parent.getUniqueName();
            }
            return null;
        }
        if ("PARENT_LEVEL".equalsIgnoreCase(propName)) {
            IROLAPMember parent = this.getROLAPParent();
            if (parent != null) {
                return parent.getROLAPLevel().getROLAPLevelNumber();
            }
            return null;
        }
        if ("PARENT_COUNT".equalsIgnoreCase(propName)) {
            return this.getROLAPParentCount();
        }
        if ("CHILDREN_CARDINALITY".equalsIgnoreCase(propName)) {
            return this.getROLAPChildrenCount();
        }
        if ("AGGREGATION_FUNCTION_NULL".equalsIgnoreCase(propName)) {
            for (IMember member : this.mSourceMembers) {
                Boolean b;
                if (member == null || (b = (Boolean)member.getProperty(propName)) == null || !b.booleanValue()) continue;
                return b;
            }
            return null;
        }
        if ("MEMBER_CAPTION".equalsIgnoreCase(propName) || "memberCaption".equalsIgnoreCase(propName)) {
            return this.getCaption();
        }
        for (IMember member : this.mSourceMembers) {
            if (member == null || (result = member.getProperty(propName)) == null) continue;
            return result;
        }
        return result;
    }

    @Override
    public IOrderedMap<IMember> fetchChildren() {
        ILevel nextLevel = this.getLevel().getNextLevel();
        IOrderedMap<IMember> result = null;
        if (nextLevel == null) {
            result = ImmutableOrderedMap.EMPTY_ORDERED_MEMBER_MAP;
            return result;
        }
        result = this.createOrderedMap();
        ROLAPVirtualCube cube = (ROLAPVirtualCube)this.getDimension().getCube();
        HashSet<String> hiddenMembers = cube.getROLAPVirtualCubeDef().getHiddenMembers();
        HashMap<String, String> fnNameToOutputName = cube.getROLAPVirtualCubeDef().getFqMemberNameToOutputName();
        HashMap<String, ArrayList<Object>> memberMap = new HashMap<String, ArrayList<Object>>();
        ArrayList<String> orderedNameList = new ArrayList<String>();
        HashMap<String, String> captions = new HashMap<String, String>();
        HashMap<String, StringBuilder> identifiers = new HashMap<String, StringBuilder>();
        boolean isCubingServicesCompatible = cube.isCubingServicesCompatible();
        CancelManager cancelManager = ExecutionEnvironmentContext.getExecutionEnvironment().getCancelManager();
        for (IMember member : this.mSourceMembers) {
            if (member == null) continue;
            IMember[] children = member.getChildMembers();
            if (children.length > 0) {
                ILevel level = children[0].getLevel();
                if (cube.getROLAPVirtualCubeDef().isSourceLevelHidden(level.getDimension().getCube(), level)) continue;
            }
            for (IMember child : children) {
                String outputName;
                if (cancelManager != null && cancelManager.isRequestCancelled()) {
                    throw new OperationCanceledException();
                }
                String fqName = ROLAPVirtualCube.getFullyQualifiedUniqueName(child.getDimension().getCube(), (IMetadata)child);
                if (hiddenMembers.contains(fqName)) continue;
                String caption = outputName = fnNameToOutputName.get(fqName);
                if (outputName == null) {
                    outputName = child.getName();
                    caption = child.getCaption();
                } else if (!isCubingServicesCompatible) {
                    String childIdentifier = child.getName();
                    StringBuilder identifier = (StringBuilder)identifiers.get(outputName);
                    if (identifier == null) {
                        identifier = new StringBuilder(childIdentifier);
                    } else {
                        identifier.append("?").append(childIdentifier);
                    }
                    identifiers.put(outputName, identifier);
                }
                captions.put(outputName, caption);
                ArrayList<Object> list = (ArrayList<Object>)memberMap.get(outputName);
                if (list == null) {
                    list = new ArrayList<Object>();
                    memberMap.put(outputName, list);
                    orderedNameList.add(outputName);
                }
                list.add(child);
            }
        }
        if (orderedNameList.isEmpty() && !this.getHierarchy().isParentChild()) {
            String caption;
            if (((IROLAPHierarchy)this.getHierarchy()).getFillerCaptionType() == IROLAPHierarchy.FillerCaptionType.BLANK_CAPTION) {
                caption = " ";
            } else {
                caption = this.getCaption();
                if (caption == null) {
                    caption = this.getName();
                }
            }
            ROLAPVirtualMemberProxy cm = this.createVirtualMember(nextLevel, new IMember[0], caption, "");
            cm.setPaddingMember(true);
            result.put(cm);
        } else {
            for (String outputName : orderedNameList) {
                StringBuilder sbIdentifier;
                ArrayList list = (ArrayList)memberMap.get(outputName);
                String identifier = outputName;
                if (!isCubingServicesCompatible && (sbIdentifier = (StringBuilder)identifiers.get(outputName)) != null) {
                    identifier = sbIdentifier.toString();
                }
                MetadataCacheKey cacheKey = cube.cacheVirtualMemberData(list.toArray(new IMember[list.size()]), outputName, nextLevel, this.getCacheKey(), outputName);
                ROLAPVirtualMemberProxy cm = new ROLAPVirtualMemberProxy(cacheKey, outputName, nextLevel, this, list.toArray(new IMember[list.size()]));
                result.put(cm);
            }
        }
        return result;
    }

    private ROLAPVirtualMemberProxy createVirtualMember(ILevel nextLevel, IMember[] sourceMembers, String caption, String identifier) {
        IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        MetadataCacheKey cacheKey = cube.cacheVirtualMemberData(sourceMembers, identifier, nextLevel, this.getCacheKey(), caption);
        ROLAPVirtualMemberProxy cm = new ROLAPVirtualMemberProxy(cacheKey, identifier, nextLevel, this, sourceMembers);
        cm.setParentMember(this);
        return cm;
    }

    @Override
    public List<ROLAPCalculatedMember> getROLAPCalculatedMembers(boolean includeSessionScoped) {
        return CollectionCast.uncheckedCast(((IROLAPVirtualCube)((Object)this.getLevel().getDimension().getCube())).getCalculations(this));
    }

    @Override
    public int getROLAPChildrenCount() {
        return this.getROLAPChildrenCount(true);
    }

    private SecurityManagerInterface getSecurityManager() {
        IROLAPVirtualCube cube = (IROLAPVirtualCube)((Object)this.getDimension().getCube());
        SecurityManagerInterface securityManager = cube.getSecurityManager(cube.getProvider());
        return securityManager;
    }

    public int getROLAPChildrenCount(boolean onlyEstimateCountWhenSecurityIsEnabled) {
        int childrenCount = 0;
        SecurityManagerInterface securityManager = this.getSecurityManager();
        if (securityManager != null) {
            if (onlyEstimateCountWhenSecurityIsEnabled) {
                childrenCount = this.getUnrestrictedChildrenCount(true) + this.getROLAPCalculatedMembers(true).size() == 0 ? 0 : 1;
            } else {
                ArrayList<IMember> relationList = new ArrayList<IMember>();
                try {
                    this.getRelationsOf(1, true, relationList);
                }
                catch (Exception ex) {
                    relationList.clear();
                }
                childrenCount = relationList.size();
            }
        } else {
            childrenCount = this.getUnrestrictedChildrenCount(false) + this.getROLAPCalculatedMembers(true).size();
        }
        return childrenCount;
    }

    private synchronized void initUnrestrictedChildrenCount(boolean securityEnabled) {
        if (this.unrestrictedChildrenCount == -1) {
            if (securityEnabled) {
                for (IMember member : this.mSourceMembers) {
                    if (member == null) continue;
                    this.unrestrictedChildrenCount = ((IROLAPMember)member).getROLAPChildrenCount();
                    break;
                }
            } else {
                ArrayList<IMember> relationList = new ArrayList<IMember>();
                try {
                    this.getRelationsOf(1, false, relationList);
                }
                catch (Exception ex) {
                    relationList.clear();
                }
                this.unrestrictedChildrenCount = relationList.size();
            }
        }
    }

    private int getUnrestrictedChildrenCount(boolean securityEnabled) {
        if (this.unrestrictedChildrenCount == -1) {
            this.initUnrestrictedChildrenCount(securityEnabled);
        }
        return this.unrestrictedChildrenCount;
    }

    @Override
    public String getDefaultLocale() {
        return this.getROLAPDimension().getROLAPCube().getDefaultLocale();
    }

    @Override
    public IROLAPDimension getROLAPDimension() {
        return (IROLAPDimension)this.getLevel().getDimension();
    }

    @Override
    public IROLAPHierarchy getROLAPHierarchy() {
        return (IROLAPHierarchy)this.getHierarchy();
    }

    @Override
    public IROLAPLevel getROLAPLevel() {
        return (IROLAPLevel)this.getLevel();
    }

    @Override
    public int getROLAPOrdinal() {
        return this.getIndex();
    }

    @Override
    public IROLAPMember getROLAPParent() {
        ArrayList<IMember> relationList = new ArrayList<IMember>();
        try {
            this.getRelationsOf(4, true, relationList);
        }
        catch (Exception ex) {
            relationList.clear();
        }
        if (relationList.isEmpty()) {
            return null;
        }
        return (IROLAPMember)relationList.get(0);
    }

    @Override
    public int getROLAPParentCount() {
        if (this.getROLAPParent() != null) {
            return 1;
        }
        return 0;
    }

    @Override
    public int getROLAPType() {
        int result = 1;
        boolean initialized = false;
        for (IMember member : this.mSourceMembers) {
            if (member == null || !(member instanceof IROLAPMember)) continue;
            if (!initialized) {
                initialized = true;
                result = ((IROLAPMember)member).getROLAPType();
                continue;
            }
            if (result == ((IROLAPMember)member).getROLAPType()) continue;
            return 1;
        }
        return result;
    }

    public Object[] getProperties() {
        ArrayList<String> names = new ArrayList<String>();
        for (IMember member : this.mSourceMembers) {
            this.fetchMemberPropertyNames(names, member);
        }
        Object[] props = new Object[names.size()];
        for (int index = 0; index < names.size(); ++index) {
            props[index] = this.getProperty(names.get(index));
        }
        return props;
    }

    private void fetchMemberPropertyNames(ArrayList<String> names, IMember member) {
        block4: {
            if (member == null) break block4;
            if (member instanceof IROLAPMember) {
                IROLAPProperty[] properties = ((IROLAPMember)member).getROLAPLevel().getProperties();
                for (int index = 0; index < properties.length; ++index) {
                    String propName = properties[index].getName();
                    if (names.contains(propName)) continue;
                    names.add(propName);
                }
            } else {
                Set<String> propertiesNames = member.getLevel().getAvailableProperties();
                for (String propName : propertiesNames) {
                    if (names.contains(propName)) continue;
                    names.add(propName);
                }
            }
        }
    }

    @Override
    public void getRelationsOf(int treeOp, boolean includeCalcMembers, ArrayList<IMember> relationList) throws Exception {
        ROLAPMemberOperations.getRelationsOf(this, treeOp, includeCalcMembers, relationList);
    }

    @Override
    public int hierarchyCompare(IMember b, boolean postOrder) throws MetadataException {
        return this.hierarchyCompare(this, b, postOrder);
    }

    private int hierarchyCompare(IMember a, IMember b, boolean postOrder) throws MetadataException {
        IMember ac = a;
        IMember bc = b;
        IMember ap = a;
        IMember bp = b;
        if (a == b) {
            return 0;
        }
        int levelA = ((Level)ac.getLevel()).getIndex();
        int levelB = ((Level)bc.getLevel()).getIndex();
        while (levelA > levelB && ((IMemberCubics)ac).getParent(true) != null) {
            ap = ac;
            levelA = ((Level)(ac = ((IMemberCubics)ac).getParent(true)).getLevel()).getIndex();
            if (levelA >= levelB) continue;
            while (levelB > levelA && ((IMemberCubics)bc).getParent(true) != null) {
                bp = bc;
                bc = ((IMemberCubics)bc).getParent(true);
                levelB = ((Level)bc.getLevel()).getIndex();
            }
        }
        while (levelB > levelA && ((IMemberCubics)bc).getParent(true) != null) {
            bp = bc;
            levelB = ((Level)(bc = ((IMemberCubics)bc).getParent(true)).getLevel()).getIndex();
            if (levelA <= levelB) continue;
            while (levelA > levelB && ((IMemberCubics)ac).getParent(true) != null) {
                ap = ac;
                ac = ((IMemberCubics)ac).getParent(true);
                levelA = ((Level)ac.getLevel()).getIndex();
            }
        }
        if (ac == bc) {
            if (ac == b) {
                if (postOrder) {
                    return 1;
                }
                return -1;
            }
            if (bc == a) {
                if (postOrder) {
                    return -1;
                }
                return 1;
            }
        }
        while (ac != null && bc != null && ac != bc) {
            bp = bc;
            bc = ((IMemberCubics)bc).getParent(true);
            ap = ac;
            ac = ((IMemberCubics)ac).getParent(true);
        }
        if (ap != null && bp != null) {
            if (ap instanceof CalculatedMember) {
                if (bp instanceof CalculatedMember) {
                    if (((IMemberCubics)ap).getMemberId() < ((IMemberCubics)bp).getMemberId()) {
                        return -1;
                    }
                    return 1;
                }
                return -1;
            }
            if (bp instanceof CalculatedMember) {
                return 1;
            }
            if (((IMemberCubics)ap).isFillerMember() && ((IMemberCubics)bp).isFillerMember()) {
                if (((IMemberCubics)a).getIndexInParentsChildren() < ((IMemberCubics)b).getIndexInParentsChildren()) {
                    return 1;
                }
                return -1;
            }
            if (((IMemberCubics)ap).getIndexInParentsChildren() < ((IMemberCubics)bp).getIndexInParentsChildren()) {
                return 1;
            }
            return -1;
        }
        String msg = "Could not work out which member was higher in hierarchyCompare function. Members may not be in the same dimension";
        throw new MetadataException(msg);
    }

    @Override
    public boolean isPaddingMember() {
        return this.retrievePropValueFromCache("PADDING_MEMBER") != null;
    }

    @Override
    public boolean isSecurityPaddingMember() {
        return this.retrievePropValueFromCache("SECURITY_PADDING_MEMBER") != null;
    }

    @Override
    public void setSecurityPaddingMember(boolean paddingMember) {
        if (paddingMember) {
            this.cachedMemberProps.put("SECURITY_PADDING_MEMBER", ONE);
        } else {
            this.cachedMemberProps.remove("SECURITY_PADDING_MEMBER");
        }
    }

    @Override
    public ILocalizedString getLocalizedCaption() {
        return this.getLocalizedName();
    }

    @Override
    public ILocalizedString getLocalizedName() {
        ILocalizedString lcName = null;
        ROLAPVirtualMemberModelRef memberModelRef = ((ROLAPVirtualHierarchy)this.getHierarchy()).getMemberDefinition(this.getName());
        if (memberModelRef != null) {
            lcName = memberModelRef.getCaption();
        }
        if (lcName == null) {
            lcName = AbstractSingleLocaleString.getSingleLocaleString(this.getDefaultLocale(), this.getCaption());
        }
        return lcName;
    }

    @Override
    public LocalizedString getLocalizedDescription() {
        return LocalizedString.emptyString();
    }

    @Override
    public int getParentLevelNumber() {
        ILevel level = this.getLevel();
        if (level.getIndex() == 0) {
            return -1;
        }
        return super.getParentLevelNumber();
    }

    public void setPaddingMember(boolean paddingMember) {
        this.setPropValueInCache("PADDING_MEMBER", ONE);
    }

    @Override
    public String getV5UniqueName() {
        return this.getV5UniqueName(null);
    }

    @Override
    public String getV5UniqueName(String cubeName) {
        String uniqueName = this.getUniqueName();
        return UniqueNameGenerator.createMemberV5UniqueName(cubeName, this.getLevel(), uniqueName);
    }

    @Override
    public List<IMember> getAllChildren(String cubeName) throws MetadataException, ProviderException {
        throw new UnsupportedOperationException("ROLAPmember.getAllChildren not supported");
    }

    @Override
    protected IOrderedMap<IMember> createOrderedMap() {
        return new SecurityPaddingOrderedMap<IMember>();
    }
}

