/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.IMemberCubics;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.metadatacache.MetadataCacheKey;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualSecurityManager;
import com.cognos.xqe.util.IOrderedMap;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ROLAPVirtualSecurityCombinationHierInfo {
    private static final String IN_CUBE = " in cube ";
    private static final String FOR_AUTH_KEY = " for AuthorizationKey";
    private static final String QUOTE = "\"";
    private static final String SPACE = " ";
    private IHierarchy mHierarchy = null;
    private IMember mDefaultMember = null;
    private HashMap<IMember, IMember[]> unbalancedNodeMap = new HashMap();
    private HashSet<ILevel> levelsWithPaddingMembers = new HashSet();

    public ROLAPVirtualSecurityCombinationHierInfo(IHierarchy hierarchy, String authKey, IROLAPSecurityManager secManager) {
        this.mHierarchy = hierarchy;
        Hierarchy[] hiers = secManager.applySecurity(new Hierarchy[]{(Hierarchy)hierarchy});
        if (hiers == null || hiers.length == 0) {
            return;
        }
        this.initializeDefaultMember(authKey, secManager);
        this.collectUnbalancedNodes(authKey, secManager);
    }

    public IMember getDefaultMember() {
        return this.mDefaultMember;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void initializeDefaultMember(String authKey, IROLAPSecurityManager secManager) {
        if (secManager.hasNoRestrictions() || !secManager.hasRestrictions(this.mHierarchy)) {
            this.mDefaultMember = this.mHierarchy.getDefaultMember();
            return;
        }
        IMember originalDefaultMember = this.mHierarchy.getDefaultMember();
        this.mDefaultMember = null;
        IROLAPSecurityManager.MemberStatus memberStatus = secManager.getMemberStatus(originalDefaultMember);
        if (memberStatus == IROLAPSecurityManager.MemberStatus.GRANTED) {
            this.mDefaultMember = originalDefaultMember;
            return;
        }
        List<ILevel> levels = this.mHierarchy.getLevels();
        IMember commonVisibleAncestor = null;
        int levelIndex = 0;
        for (ILevel level : levels) {
            int numGrantedMembers = 0;
            int numVisibleAncestors = 0;
            IMember firstVisibleAncestor = null;
            IMember firstGrantedMember = null;
            List<IMember> members = ((Level)level).getMembers(false, false);
            for (IMember member : members) {
                memberStatus = secManager.getMemberStatus(member);
                if (memberStatus == IROLAPSecurityManager.MemberStatus.GRANTED) {
                    if (numGrantedMembers == 0) {
                        firstGrantedMember = member;
                    }
                    ++numGrantedMembers;
                    continue;
                }
                if (memberStatus != IROLAPSecurityManager.MemberStatus.VISIBLE_ANCESTOR) continue;
                if (numVisibleAncestors == 0) {
                    firstVisibleAncestor = member;
                }
                ++numVisibleAncestors;
            }
            if (levelIndex == 0) {
                if (numGrantedMembers > 0) {
                    this.mDefaultMember = firstGrantedMember;
                    break;
                }
                if (numVisibleAncestors > 1) {
                    this.mDefaultMember = firstVisibleAncestor;
                    break;
                }
                if (numVisibleAncestors != 1) {
                    this.mDefaultMember = null;
                    return;
                }
                commonVisibleAncestor = firstVisibleAncestor;
            } else {
                if (numGrantedMembers == 1) {
                    if (numVisibleAncestors == 0) {
                        this.mDefaultMember = firstGrantedMember;
                        break;
                    }
                    this.mDefaultMember = commonVisibleAncestor;
                    break;
                }
                if (numGrantedMembers > 1) {
                    this.mDefaultMember = commonVisibleAncestor;
                    break;
                }
                if (numGrantedMembers == 0) {
                    if (numVisibleAncestors > 1) {
                        this.mDefaultMember = commonVisibleAncestor;
                        break;
                    }
                    if (numVisibleAncestors == 1) {
                        commonVisibleAncestor = firstVisibleAncestor;
                    }
                }
            }
            ++levelIndex;
        }
        if (this.mDefaultMember == originalDefaultMember) return;
        String defaultMemberName = "";
        if (this.mDefaultMember != null) {
            defaultMemberName = this.mDefaultMember.getUniqueName();
            ROLAPLog.log("ROLAPCubes.Security", "Hierachy " + this.mHierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(secManager.getCube().getName()) + " has its default member changed to " + defaultMemberName + " from " + originalDefaultMember.getUniqueName() + " for AuthorizationKey: \"" + authKey + "\".");
            return;
        }
        ROLAPLog.log("ROLAPCubes.Security", "Marking Hierarchy " + this.mHierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(secManager.getCube().getName()) + " as all denied for AuthorizationKey: \"" + authKey + "\" because there is no valid default member.");
    }

    public Map<IMember, IMember[]> getUnbalancedNodes() {
        return this.unbalancedNodeMap;
    }

    public boolean belongsToThisCombination(IMember securityPaddingMember) {
        boolean isPaddingMember = false;
        Collection<IMember[]> values = this.unbalancedNodeMap.values();
        for (IMember[] pad : values) {
            for (int i = 0; i < pad.length; ++i) {
                if (securityPaddingMember != pad[i]) continue;
                isPaddingMember = true;
                return isPaddingMember;
            }
        }
        return isPaddingMember;
    }

    public IMember[] getSecurityPaddingMembers(IMember member) {
        return this.unbalancedNodeMap.get(member);
    }

    public boolean hasSecurityPaddingMembers() {
        return this.unbalancedNodeMap.size() > 0;
    }

    public boolean hasSecurityPaddingMembers(ILevel level) {
        return this.levelsWithPaddingMembers.contains(level);
    }

    private void collectUnbalancedNodes(String authKey, IROLAPSecurityManager secManager) {
        if (this.mHierarchy.isParentChild() || this.mHierarchy.getLevelCount() == 1) {
            return;
        }
        ILevel rootLevel = this.mHierarchy.getLevel(0);
        List<IMember> levelMembers = rootLevel.getMembers();
        for (IMember member : levelMembers) {
            this.checkMemberForPadding(member, secManager);
        }
        if (this.unbalancedNodeMap.size() > 0 && ROLAPLog.isOn("ROLAPCubes.Security")) {
            StringBuilder sb = new StringBuilder();
            for (IMember unbalancedNode : this.unbalancedNodeMap.keySet()) {
                sb.append(unbalancedNode.getName());
                sb.append(",");
            }
            ROLAPLog.log("ROLAPCubes.Security", "Unbalanced nodes for hierarchy " + this.mHierarchy.getUniqueName() + IN_CUBE + UniqueNameGenerator.createUniqueName(secManager.getCube().getName()) + FOR_AUTH_KEY + SPACE + QUOTE + authKey + QUOTE + " {" + sb.toString() + "}");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkMemberForPadding(IMember member, IROLAPSecurityManager secManager) {
        int levelCount = member.getHierarchy().getLevelCount();
        List<IMember> visibleChildren = this.getVisibleChildren(member, secManager);
        if (visibleChildren.size() > 0) {
            if (member.getLevel().getIndex() == levelCount - 2) {
                return;
            }
            for (IMember child : visibleChildren) {
                this.checkMemberForPadding(child, secManager);
            }
        } else {
            IMember iMember = member;
            synchronized (iMember) {
                IMember[] paddingMembers = this.getDescendantPaddingMembers(member);
                if (paddingMembers == null) {
                    paddingMembers = this.createPaddingMembersUnbalancedNodes(member, secManager);
                } else {
                    for (IMember paddMember : paddingMembers) {
                        IROLAPMember cachedPadd = (IROLAPMember)paddMember;
                        cachedPadd.setSecurityPaddingMember(true);
                    }
                }
                this.unbalancedNodeMap.put(member, paddingMembers);
            }
        }
    }

    private List<IMember> getVisibleChildren(IMember member, IROLAPSecurityManager secManager) {
        ArrayList<IMember> visibleChildren = new ArrayList<IMember>();
        List<IMember> children = member.getChildren();
        for (IMember child : children) {
            if (!((ROLAPVirtualSecurityManager)secManager).isAllowed(child)) continue;
            visibleChildren.add(child);
        }
        return visibleChildren;
    }

    private IMember[] createPaddingMembersUnbalancedNodes(IMember member, IROLAPSecurityManager secManager) {
        String caption;
        int numPaddingMembers = member.getHierarchy().getLevelCount() - member.getLevel().getIndex() - 1;
        int paddingIndex = 0;
        IMember[] paddingMembers = new IMember[numPaddingMembers];
        ILevel level = member.getLevel().getNextLevel();
        IMember parent = member;
        if (((IROLAPHierarchy)parent.getHierarchy()).getFillerCaptionType() == IROLAPHierarchy.FillerCaptionType.BLANK_CAPTION) {
            caption = SPACE;
        } else {
            caption = parent.getCaption();
            if (caption == null) {
                caption = parent.getName();
            }
        }
        while (level != null) {
            IROLAPMember childMember;
            this.levelsWithPaddingMembers.add(level);
            if (member.getDimension().isShareable()) {
                childMember = new ROLAPSecurityPaddingMemberProxy(this.createSecurityPaddingMemberCacheKey((ROLAPCube)secManager.getCube(), parent), "_SECURED_", level, parent);
                if (parent instanceof ROLAPMemberProxy) {
                    ((ROLAPMemberProxy)parent).setSecurityPaddingMember((ROLAPSecurityPaddingMemberProxy)childMember);
                }
                paddingMembers[paddingIndex] = childMember;
            } else {
                childMember = ((ROLAPVirtualMember)parent).createVirtualChildMember(level, new IMember[0], caption, "_SECURED_");
                childMember.setSecurityPaddingMember(true);
                ((ROLAPVirtualMember)parent).setSecurityPaddingMember(childMember);
                ((ROLAPVirtualMember)parent).setGotAllChildren();
                paddingMembers[paddingIndex] = childMember;
            }
            parent = paddingMembers[paddingIndex];
            level = level.getNextLevel();
            ++paddingIndex;
        }
        return paddingMembers;
    }

    private MetadataCacheKey createSecurityPaddingMemberCacheKey(ROLAPCube cube, IMember member) {
        IROLAPDimension d = ((IROLAPMember)member).getROLAPDimension();
        int maxMemberId = ((Dimension)member.getDimension()).getmaxMemberId();
        return new MetadataCacheKey(cube.getDimensionIndex(d), maxMemberId);
    }

    private IMember[] getDescendantPaddingMembers(IMember member) {
        IOrderedMap<IMember> childrenList = ((IMemberCubics)member).getChildrenOrderedMap();
        if (childrenList == null) {
            return null;
        }
        IMember paddingMember = childrenList.get("_SECURED_");
        if (paddingMember == null) {
            return null;
        }
        IMember[] paddingMembers = new IMember[member.getHierarchy().getLevelCount() - member.getLevel().getIndex() - 1];
        ILevel level = paddingMember.getLevel();
        while (level != null) {
            this.levelsWithPaddingMembers.add(level);
            paddingMembers[level.getIndex() - member.getLevel().getIndex() - 1] = paddingMember;
            level = null;
            childrenList = ((IMemberCubics)paddingMember).getChildrenOrderedMap();
            if (childrenList == null || (paddingMember = childrenList.get("_SECURED_")) == null) continue;
            level = paddingMember.getLevel();
        }
        return paddingMembers;
    }
}

