/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualSecurityCombinationHierInfo;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;

public class ROLAPVirtualSecurityCombinationInfo {
    private ConcurrentHashMap<IHierarchy, ROLAPVirtualSecurityCombinationHierInfo> dimensionHierarchyRestrictionMap;
    private IROLAPSecurityManager mSecManager = null;
    private String mAuthKey = null;
    private HashSet<IHierarchy> securityPaddingMemberHierarchies;

    public ROLAPVirtualSecurityCombinationInfo(String authKey, IROLAPSecurityManager secManager) {
        this.mSecManager = secManager;
        this.mAuthKey = authKey;
        this.dimensionHierarchyRestrictionMap = new ConcurrentHashMap();
        this.securityPaddingMemberHierarchies = new HashSet();
    }

    public HashSet<IHierarchy> getSecurityPaddingMemberHierarchies() {
        return this.securityPaddingMemberHierarchies;
    }

    public boolean belongsToThisSecurityInfo(IHierarchy hierarchy, IMember securityPaddingMember) {
        ROLAPVirtualSecurityCombinationHierInfo hierarchyRestriction = this.dimensionHierarchyRestrictionMap.get(hierarchy);
        if (hierarchyRestriction == null) {
            return false;
        }
        return hierarchyRestriction.belongsToThisCombination(securityPaddingMember);
    }

    private ROLAPVirtualSecurityCombinationHierInfo getOrCreateHierarchyInfo(IHierarchy hierarchy) {
        ROLAPVirtualSecurityCombinationHierInfo hierarchyRestriction = this.dimensionHierarchyRestrictionMap.get(hierarchy);
        if (hierarchyRestriction == null) {
            hierarchyRestriction = new ROLAPVirtualSecurityCombinationHierInfo(hierarchy, this.mAuthKey, this.mSecManager);
            if (hierarchyRestriction.hasSecurityPaddingMembers()) {
                this.securityPaddingMemberHierarchies.add(hierarchy);
            }
            this.dimensionHierarchyRestrictionMap.putIfAbsent(hierarchy, hierarchyRestriction);
            hierarchyRestriction = this.dimensionHierarchyRestrictionMap.get(hierarchy);
        }
        return hierarchyRestriction;
    }

    public IMember getDefaultMember(IHierarchy hierarchy) {
        ROLAPVirtualSecurityCombinationHierInfo hierarchyRestriction = this.getOrCreateHierarchyInfo(hierarchy);
        return hierarchyRestriction.getDefaultMember();
    }

    public IMember[] getSecurityPaddingMembers(IHierarchy hierarchy, IMember member) {
        if (!this.securityPaddingMemberHierarchies.contains(hierarchy)) {
            return null;
        }
        ROLAPVirtualSecurityCombinationHierInfo hierarchyRestriction = this.getOrCreateHierarchyInfo(hierarchy);
        return hierarchyRestriction.getSecurityPaddingMembers(member);
    }

    public boolean hasSecurityPaddingMembers(ILevel level) {
        if (!this.securityPaddingMemberHierarchies.contains(level.getHierarchy())) {
            return false;
        }
        ROLAPVirtualSecurityCombinationHierInfo hierarchyRestriction = this.getOrCreateHierarchyInfo(level.getHierarchy());
        return hierarchyRestriction.hasSecurityPaddingMembers(level);
    }

    public boolean hasSecurityPaddingMembers(IHierarchy hierarchy) {
        if (!this.securityPaddingMemberHierarchies.contains(hierarchy)) {
            return false;
        }
        ROLAPVirtualSecurityCombinationHierInfo hierarchyRestriction = this.getOrCreateHierarchyInfo(hierarchy);
        return hierarchyRestriction.hasSecurityPaddingMembers();
    }
}

