/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.metadata.IProperty;
import com.cognos.xqe.metadata.MemberTypeEnum;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.FilteredTupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.ITupleList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.tuplelist.TupleListFilter;
import com.cognos.xqe.runtree.olap.mdx.metadata.CalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Hierarchy;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.IROLAPMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ShareableROLAPDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.IROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.IROLAPSecurityManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPSecurityPaddingMemberProxy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.security.ROLAPUserSecurityContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.CompositionBuilder;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.IROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCalculatedMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualDimension;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualHierarchy;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualLevel;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualMember;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualProperty;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.virtual.ROLAPVirtualSecurityCombinationInfo;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.composite.ICompositionCalculator;
import com.cognos.xqe.util.Pair;
import com.cognos.xqe.util.monitor.ResourceMonitor;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import com.cognos.xqe.util.primitive.HashMapObjectLong;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class ROLAPVirtualSecurityManager
implements IROLAPSecurityManager,
ICompositionCalculator {
    public static final long DEFAULT_COMPOSITION = -1L;
    private final ROLAPCube[] mSourceCubes;
    private final IROLAPSecurityManager[] mSecurityManagers;
    private final boolean hasNoDimensionalSecurityBool;
    private ConcurrentHashMap<String, ROLAPVirtualSecurityCombinationInfo> authKeyToSecurityInfo;
    private final boolean isAllDenied;
    private final ROLAPCube virtualCube;

    @Override
    public ROLAPCube getCube() {
        return this.virtualCube;
    }

    public ROLAPVirtualSecurityManager(ROLAPVirtualCube theVirtualCube, ROLAPCube[] sourceCubes) {
        this.virtualCube = theVirtualCube;
        this.mSourceCubes = sourceCubes;
        this.mSecurityManagers = new IROLAPSecurityManager[this.mSourceCubes.length];
        this.authKeyToSecurityInfo = new ConcurrentHashMap();
        boolean tmpAllAccess = true;
        for (int i = 0; i < this.mSourceCubes.length; ++i) {
            this.mSecurityManagers[i] = (IROLAPSecurityManager)this.mSourceCubes[i].getSecurityManager();
            if (this.mSecurityManagers[i] == null || this.mSecurityManagers[i].hasNoRestrictions()) continue;
            tmpAllAccess = false;
        }
        this.hasNoDimensionalSecurityBool = tmpAllAccess;
        this.isAllDenied = this.calculateIsAllDenied();
    }

    public IMember[] except(IMember[] members, IMember[] allowed) {
        HashSet<IMember> allowedMembers = new HashSet<IMember>();
        for (int i = 0; i < allowed.length; ++i) {
            allowedMembers.add(allowed[i]);
        }
        ArrayList<IMember> result = new ArrayList<IMember>();
        for (int i = 0; i < members.length; ++i) {
            if (allowedMembers.contains(members[i])) continue;
            result.add(members[i]);
        }
        return result.toArray(new IMember[result.size()]);
    }

    private boolean isAllowed(SecurityManagerInterface security, IMember baseMember) {
        IMember[] membersOut = security.applySecurity(new IMember[]{baseMember}, baseMember.getHierarchy());
        return membersOut != null && membersOut.length > 0;
    }

    private boolean isAllowed(SecurityManagerInterface security, IProperty baseProperty) {
        ArrayList<IProperty> propertyIn = new ArrayList<IProperty>();
        propertyIn.add(baseProperty);
        List<IProperty> propertyOut = security.applySecurity(propertyIn);
        return propertyOut != null && propertyOut.size() > 0;
    }

    private boolean isAllowed(SecurityManagerInterface security, IDimension baseDimension) {
        Dimension[] dimensionsOut = security.applySecurity(new Dimension[]{(Dimension)baseDimension});
        return dimensionsOut != null && dimensionsOut.length > 0;
    }

    private boolean isAllowed(SecurityManagerInterface security, IHierarchy baseHierarchy) {
        Hierarchy[] hierarchiesOut = security.applySecurity(new Hierarchy[]{(Hierarchy)baseHierarchy});
        return hierarchiesOut != null && hierarchiesOut.length > 0;
    }

    private boolean isAllowed(SecurityManagerInterface security, ILevel baseLevel) {
        Level[] levelsOut = security.applySecurity(new Level[]{(Level)baseLevel});
        return levelsOut != null && levelsOut.length > 0;
    }

    public boolean isAllowed(IMember virtualMember) {
        if (virtualMember instanceof NullMember) {
            return true;
        }
        if (virtualMember == null) {
            return false;
        }
        if (virtualMember.isCalculatedMember() && (virtualMember = this.getRolapCalculatedMember(virtualMember)) == null) {
            return true;
        }
        if (virtualMember.getType() == MemberTypeEnum.QUERY_CALCULATION || virtualMember.getType() == MemberTypeEnum.SESSION_CALCULATION || virtualMember.getType() == MemberTypeEnum.GLOBAL_CALCULATION) {
            IMember virtualParentMember = virtualMember.getParent();
            if (virtualParentMember == null) {
                return true;
            }
            virtualMember = virtualParentMember;
        }
        Pair[] baseMembers = null;
        if (virtualMember instanceof IROLAPMember) {
            if (((IROLAPMember)virtualMember).isPaddingMember()) {
                return true;
            }
            if (((IROLAPMember)virtualMember).isSecurityPaddingMember()) {
                return this.getOrCreateSecInfo().belongsToThisSecurityInfo(virtualMember.getHierarchy(), virtualMember);
            }
            if (virtualMember instanceof IROLAPVirtualMember) {
                baseMembers = ((IROLAPVirtualMember)virtualMember).getSourceMembers();
            } else if (virtualMember.getDimension().isShareable()) {
                baseMembers = new Pair[this.mSourceCubes.length];
                for (int index = 0; index < this.mSourceCubes.length; ++index) {
                    Pair pair;
                    baseMembers[index] = pair = new Pair(virtualMember, XQEIntegerPool.getInteger(index));
                }
            }
        }
        boolean result = false;
        for (Pair baseMemberPair : baseMembers) {
            IMember baseMember = (IMember)baseMemberPair.getFirst();
            if (baseMember == null) continue;
            if (baseMember instanceof ROLAPSecurityPaddingMemberProxy) {
                return false;
            }
            ROLAPCube baseMemberCube = this.mSourceCubes[(Integer)baseMemberPair.getSecond()];
            boolean matchedBaseMemberCube = false;
            for (int i = 0; i < this.mSourceCubes.length && !matchedBaseMemberCube; ++i) {
                if (baseMemberCube != this.mSourceCubes[i]) continue;
                if (this.mSecurityManagers[i] != null) {
                    if (this.isAllowed((SecurityManagerInterface)this.mSecurityManagers[i], baseMember)) {
                        return true;
                    }
                } else {
                    return true;
                }
                matchedBaseMemberCube = true;
            }
        }
        return result;
    }

    @Override
    public IROLAPSecurityManager.MemberStatus getMemberStatus(IMember virtualMember) {
        if (this.isAllAccess()) {
            return IROLAPSecurityManager.MemberStatus.GRANTED;
        }
        if (virtualMember instanceof NullMember) {
            return IROLAPSecurityManager.MemberStatus.GRANTED;
        }
        if (virtualMember == null) {
            return IROLAPSecurityManager.MemberStatus.DENIED;
        }
        if (virtualMember.isCalculatedMember() && (virtualMember = this.getRolapCalculatedMember(virtualMember)) == null) {
            return IROLAPSecurityManager.MemberStatus.GRANTED;
        }
        boolean isCalculatedMember = false;
        while (virtualMember.getType() == MemberTypeEnum.QUERY_CALCULATION || virtualMember.getType() == MemberTypeEnum.SESSION_CALCULATION || virtualMember.getType() == MemberTypeEnum.GLOBAL_CALCULATION) {
            isCalculatedMember = true;
            IMember virtualMemberParent = virtualMember.getParent();
            if (virtualMemberParent == null) {
                return IROLAPSecurityManager.MemberStatus.GRANTED;
            }
            virtualMember = virtualMemberParent;
        }
        Pair[] baseMembers = null;
        if (virtualMember instanceof IROLAPMember) {
            if (((IROLAPMember)virtualMember).isPaddingMember()) {
                return IROLAPSecurityManager.MemberStatus.GRANTED;
            }
            if (((IROLAPMember)virtualMember).isSecurityPaddingMember()) {
                if (this.getOrCreateSecInfo().belongsToThisSecurityInfo(virtualMember.getHierarchy(), virtualMember)) {
                    return IROLAPSecurityManager.MemberStatus.GRANTED;
                }
                return IROLAPSecurityManager.MemberStatus.DENIED;
            }
            if (virtualMember instanceof ROLAPVirtualMember) {
                baseMembers = ((ROLAPVirtualMember)virtualMember).getSourceMembers();
            } else if (virtualMember.getDimension().isShareable()) {
                baseMembers = new Pair[this.mSourceCubes.length];
                for (int index = 0; index < this.mSourceCubes.length; ++index) {
                    Pair pair;
                    baseMembers[index] = pair = new Pair(virtualMember, XQEIntegerPool.getInteger(index));
                }
            }
        }
        IROLAPSecurityManager.MemberStatus memberStatus = IROLAPSecurityManager.MemberStatus.NONE;
        for (Pair baseMemberPair : baseMembers) {
            IMember baseMember = (IMember)baseMemberPair.getFirst();
            if (baseMember == null) continue;
            ROLAPCube baseMemberCube = this.mSourceCubes[(Integer)baseMemberPair.getSecond()];
            boolean matchedBaseMemberCube = false;
            for (int i = 0; i < this.mSourceCubes.length && !matchedBaseMemberCube; ++i) {
                if (baseMemberCube != this.mSourceCubes[i]) continue;
                matchedBaseMemberCube = true;
                IROLAPSecurityManager.MemberStatus tempMemberStatus = this.mSecurityManagers[i] != null ? this.mSecurityManagers[i].getMemberStatus(baseMember) : IROLAPSecurityManager.MemberStatus.GRANTED;
                if (tempMemberStatus == IROLAPSecurityManager.MemberStatus.VISIBLE_ANCESTOR) {
                    if (isCalculatedMember) {
                        return IROLAPSecurityManager.MemberStatus.GRANTED;
                    }
                    return IROLAPSecurityManager.MemberStatus.VISIBLE_ANCESTOR;
                }
                if (tempMemberStatus == IROLAPSecurityManager.MemberStatus.GRANTED) {
                    memberStatus = IROLAPSecurityManager.MemberStatus.GRANTED;
                    continue;
                }
                if (memberStatus == IROLAPSecurityManager.MemberStatus.GRANTED) continue;
                if (tempMemberStatus == IROLAPSecurityManager.MemberStatus.SECURED_PADDING_MEMBER) {
                    memberStatus = IROLAPSecurityManager.MemberStatus.SECURED_PADDING_MEMBER;
                    continue;
                }
                if (memberStatus == IROLAPSecurityManager.MemberStatus.SECURED_PADDING_MEMBER || tempMemberStatus != IROLAPSecurityManager.MemberStatus.DENIED) continue;
                memberStatus = IROLAPSecurityManager.MemberStatus.DENIED;
            }
        }
        return memberStatus;
    }

    private boolean isAllowed(ITuple t, HashSet<IMember> disallowedMembers) {
        boolean allowed = true;
        for (int i = 0; allowed && i < t.size(); ++i) {
            IMember m = t.getMember(i);
            allowed = !disallowedMembers.contains(m);
        }
        return allowed;
    }

    private Set applySecurity(ISet set, InterpreterContext interpreterContext) {
        IHierarchy[] hiers = set.getHierarchies();
        HashSet<IMember> disallowedMembers = new HashSet<IMember>();
        IMember[][] members = ((Set)set).getMembers(hiers);
        for (int i = 0; i < hiers.length; ++i) {
            IMember[] allowed = this.applySecurity(members[i], null);
            if (allowed.length >= members[i].length) continue;
            IMember[] notAllowed = this.except(members[i], allowed);
            for (int k = 0; k < notAllowed.length; ++k) {
                disallowedMembers.add(notAllowed[k]);
            }
        }
        if (disallowedMembers.isEmpty()) {
            return (Set)set;
        }
        ResourceMonitor.checkMaxSetSize(set.size(), interpreterContext.getQueryContext(), XQEMessageKeys.MDX_MaxCrossjoinSize);
        TupleListFilter filter = new TupleListFilter(set.size());
        int i = 0;
        while ((long)i < set.size()) {
            Tuple tuple = (Tuple)set.getTuple(i);
            if (this.isAllowed(tuple, disallowedMembers)) {
                filter.enable(i);
            }
            ++i;
        }
        ITupleList tl = FilteredTupleList.construct(((Set)set).getTupleList(), filter);
        return new Set(tl);
    }

    public boolean calculateIsAllDenied() {
        boolean tempIsAllDenied = true;
        for (int i = 0; i < this.mSecurityManagers.length; ++i) {
            if (this.mSecurityManagers[i] == null || this.mSecurityManagers[i].isAllDenied()) continue;
            tempIsAllDenied = false;
            break;
        }
        return tempIsAllDenied;
    }

    @Override
    public boolean isAllDenied() {
        return this.isAllDenied;
    }

    @Override
    public boolean isAllAccess() {
        return this.hasNoRestrictions() || this.isUserSysAdmin();
    }

    private ROLAPVirtualSecurityCombinationInfo getOrCreateSecInfo() {
        String authKey = this.getAuthorizationKeyForCurrentUser();
        ROLAPVirtualSecurityCombinationInfo secInfo = this.authKeyToSecurityInfo.get(authKey);
        if (secInfo == null) {
            secInfo = new ROLAPVirtualSecurityCombinationInfo(authKey, this);
            this.authKeyToSecurityInfo.putIfAbsent(authKey, secInfo);
            secInfo = this.authKeyToSecurityInfo.get(authKey);
        }
        return secInfo;
    }

    @Override
    public boolean isUserSysAdmin() {
        for (int i = 0; i < this.mSecurityManagers.length; ++i) {
            if (this.mSecurityManagers[i] == null) continue;
            return this.mSecurityManagers[i].isUserSysAdmin();
        }
        return false;
    }

    @Override
    public boolean hasNoRestrictions() {
        return this.hasNoDimensionalSecurityBool;
    }

    @Override
    public ISet[] applySecurity(ISet[] axes, InterpreterContext interpreterContext) {
        if (axes == null) {
            return null;
        }
        ISet[] result = new Set[axes.length];
        for (int i = 0; i < axes.length; ++i) {
            ISet set = axes[i];
            if (!this.isAllAccess()) {
                set = this.applySecurity(set, interpreterContext);
            }
            ((Set)set).addCurrentMemberDimensions(((Set)axes[i]).getCurrentMemberDimensions());
            ((Set)set).addCurrentMemberHierarchies(((Set)axes[i]).getCurrentMemberHierarchies());
            result[i] = (Set)set;
        }
        return result;
    }

    @Override
    public IMember[] applySecurity(IMember[] virtualMembers, IHierarchy virtualHierarchy) {
        if (virtualMembers == null || virtualMembers.length == 0 || this.isAllAccess()) {
            IMember[] visibleMembers = this.filterSecurityPaddingMembersFromOriginalArray(virtualMembers);
            return visibleMembers;
        }
        if (virtualHierarchy != null && !this.hasRestrictions(virtualHierarchy)) {
            IMember[] visibleMembers = this.filterSecurityPaddingMembersFromOriginalArray(virtualMembers);
            return visibleMembers;
        }
        ArrayList<IMember> output = new ArrayList<IMember>();
        for (IMember member : virtualMembers) {
            if (!this.isAllowed(member)) continue;
            output.add(member);
        }
        if (virtualMembers.length == output.size()) {
            return virtualMembers;
        }
        return output.toArray(new IMember[output.size()]);
    }

    public IMember[] filterSecurityPaddingMembersFromOriginalArray(IMember[] originalMembers) {
        ArrayList<IMember> visibleMembers = new ArrayList<IMember>(originalMembers.length);
        boolean wasModified = false;
        for (int i = 0; i < originalMembers.length; ++i) {
            IMember member = originalMembers[i];
            if (member instanceof IROLAPMember && ((IROLAPMember)member).isSecurityPaddingMember()) {
                wasModified = true;
                continue;
            }
            visibleMembers.add(member);
        }
        if (wasModified) {
            return visibleMembers.toArray(new IMember[visibleMembers.size()]);
        }
        return originalMembers;
    }

    @Override
    public ISet filterSecureValueMembers(ISet set) {
        if (set == null || set.size() == 0L || this.isAllAccess()) {
            return set;
        }
        boolean selectionWasModified = false;
        HashSet<IHierarchy> securityPaddingMemberHierarchies = this.getOrCreateSecInfo().getSecurityPaddingMemberHierarchies();
        if (securityPaddingMemberHierarchies == null || securityPaddingMemberHierarchies.size() == 0) {
            return set;
        }
        IHierarchy[] setHierarchies = set.getHierarchies();
        HashSet<IMember>[] selections = ((Set)set).selectionsInHierarchies(setHierarchies);
        for (int i = 0; i < setHierarchies.length; ++i) {
            if (!securityPaddingMemberHierarchies.contains(setHierarchies[i])) continue;
            HashSet<IMember> hierarchyMembers = selections[i];
            Iterator hierarchyMemberIter = hierarchyMembers.iterator();
            while (hierarchyMemberIter.hasNext()) {
                IMember nextMember = (IMember)hierarchyMemberIter.next();
                if (!(nextMember instanceof IROLAPMember) || !((IROLAPMember)nextMember).isSecurityPaddingMember()) continue;
                hierarchyMemberIter.remove();
                selectionWasModified = true;
            }
            if (!hierarchyMembers.isEmpty()) continue;
            return null;
        }
        if (selectionWasModified) {
            return BlockTupleStorageUtil.createCjsFromMemberSelections(selections);
        }
        return set;
    }

    @Override
    public IMember[] filterSecureValueMembers(IMember[] members) {
        if (members == null || members.length == 0 || this.isAllAccess()) {
            return members;
        }
        ROLAPVirtualSecurityCombinationInfo securityInfo = this.getOrCreateSecInfo();
        if (securityInfo.getSecurityPaddingMemberHierarchies().size() == 0) {
            return members;
        }
        ArrayList<IROLAPMember> outputMembers = new ArrayList<IROLAPMember>(members.length);
        for (int i = 0; i < members.length; ++i) {
            IROLAPMember member = (IROLAPMember)members[i];
            if (member.isSecurityPaddingMember()) continue;
            outputMembers.add(member);
        }
        if (members.length == outputMembers.size()) {
            return members;
        }
        return outputMembers.toArray(new IMember[outputMembers.size()]);
    }

    @Override
    public HashMapObjectLong<IMember> calculateMemberCompositions(List<IMember> members) {
        int i;
        HashMapObjectLong<IMember> compositions = new HashMapObjectLong<IMember>();
        CompositionBuilder[] tmpCompositions = new CompositionBuilder[members.size()];
        for (i = 0; i < members.size(); ++i) {
            tmpCompositions[i] = new CompositionBuilder();
        }
        this.getLeafMemberCompositions(members, tmpCompositions);
        for (i = 0; i < members.size(); ++i) {
            compositions.put(members.get(i), tmpCompositions[i].getComposition());
        }
        return compositions;
    }

    @Override
    public void getLeafMemberCompositions(List<IMember> members, CompositionBuilder[] compositions) {
        if (members.isEmpty()) {
            return;
        }
        List<IROLAPSecurityManager> sourceSecManagers = this.getSourceSecurityManagers();
        List<List<IMember>> sourceMembersBySecurityManager = this.getSourceMembersByCube(members);
        for (int i = 0; i < sourceSecManagers.size(); ++i) {
            IROLAPSecurityManager sourceSecManager = sourceSecManagers.get(i);
            if (sourceSecManager == null) {
                for (int j = 0; j < members.size(); ++j) {
                    compositions[j].setNext(true);
                }
                continue;
            }
            List<IMember> sourceMembers = sourceMembersBySecurityManager.get(i);
            sourceSecManager.getLeafMemberCompositions(sourceMembers, compositions);
        }
    }

    private List<IROLAPSecurityManager> getSourceSecurityManagers() {
        return Arrays.asList(this.mSecurityManagers);
    }

    private List<IMember> getOrderedSourceMembers(IMember member) {
        ArrayList<IMember> sourceMembers;
        block3: {
            block4: {
                block2: {
                    sourceMembers = new ArrayList<IMember>();
                    if (member != null && (!(member instanceof IROLAPMember) || !((IROLAPMember)member).isPaddingMember())) break block2;
                    for (int i = 0; i < this.mSecurityManagers.length; ++i) {
                        sourceMembers.add(null);
                    }
                    break block3;
                }
                if (!(member instanceof IROLAPVirtualMember)) break block4;
                IROLAPVirtualMember vm = (IROLAPVirtualMember)member;
                IMember[] orderedSourceMembers = vm.getOrderedSourceMembers();
                sourceMembers.addAll(Arrays.asList(orderedSourceMembers));
                break block3;
            }
            if (!member.getDimension().isShareable()) break block3;
            for (int index = 0; index < this.mSourceCubes.length; ++index) {
                sourceMembers.add(member);
            }
        }
        return sourceMembers;
    }

    private List<List<IMember>> getSourceMembersByCube(List<IMember> members) {
        ArrayList<List<IMember>> allSourceMembers = new ArrayList<List<IMember>>();
        for (int i = 0; i < this.mSourceCubes.length; ++i) {
            allSourceMembers.add(new ArrayList());
        }
        for (IMember member : members) {
            int i;
            List<IMember> sourceMembers = this.getOrderedSourceMembers(member);
            if (sourceMembers.size() == 0 && member.getDimension().isShareable()) {
                for (i = 0; i < this.mSourceCubes.length; ++i) {
                    ((List)allSourceMembers.get(i)).add(member);
                }
                continue;
            }
            for (i = 0; i < this.mSourceCubes.length; ++i) {
                ((List)allSourceMembers.get(i)).add(sourceMembers.get(i));
            }
        }
        return allSourceMembers;
    }

    @Override
    public long calculateTupleComposition(Tuple tuple, HashMapObjectLong<IMember> memberCompositions) {
        long memberComposition;
        if (tuple.size() == 0) {
            return -1L;
        }
        IMember[] members = tuple.getMembers();
        long tupleComposition = memberCompositions.get(members[0]);
        for (int i = 1; i < members.length && tupleComposition != 0L; tupleComposition &= memberComposition, ++i) {
            memberComposition = memberCompositions.get(members[i]);
        }
        return tupleComposition;
    }

    private boolean isAllowed(Dimension dimension) {
        block11: {
            block10: {
                if (!dimension.isShareable()) break block10;
                int[] sourceCubeIndices = ((ShareableROLAPDimension)dimension).getVirtualCubeSourceCubeIndexes(this.virtualCube.getName());
                boolean matchedBaseDimensionCube = false;
                for (int i = 0; i < this.mSourceCubes.length && !matchedBaseDimensionCube; ++i) {
                    if (this.mSecurityManagers[sourceCubeIndices[i]] != null) {
                        if (this.isAllowed((SecurityManagerInterface)this.mSecurityManagers[sourceCubeIndices[i]], dimension)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                    matchedBaseDimensionCube = true;
                }
                break block11;
            }
            if (!(dimension instanceof ROLAPVirtualDimension)) break block11;
            IDimension[] baseDimensions = ((ROLAPVirtualDimension)dimension).getSourceDimensions();
            int sourceCubeIndex = 0;
            for (IDimension baseDimension : baseDimensions) {
                if (baseDimension != null) {
                    ROLAPCube baseDimensionCube = this.mSourceCubes[sourceCubeIndex];
                    boolean matchedBaseDimensionCube = false;
                    for (int i = 0; i < this.mSourceCubes.length && !matchedBaseDimensionCube; ++i) {
                        if (baseDimensionCube != this.mSourceCubes[i]) continue;
                        if (this.mSecurityManagers[i] != null) {
                            if (this.isAllowed((SecurityManagerInterface)this.mSecurityManagers[i], baseDimension)) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                        matchedBaseDimensionCube = true;
                    }
                }
                ++sourceCubeIndex;
            }
        }
        return false;
    }

    private boolean isAllowed(Hierarchy hierarchy) {
        block7: {
            block6: {
                if (!hierarchy.getDimension().isShareable()) break block6;
                int[] sourceCubeIndices = ((ShareableROLAPDimension)hierarchy.getDimension()).getVirtualCubeSourceCubeIndexes(this.virtualCube.getName());
                boolean matchedBaseHierarchyCube = false;
                for (int i = 0; i < sourceCubeIndices.length && !matchedBaseHierarchyCube; ++i) {
                    if (this.mSecurityManagers[sourceCubeIndices[i]] != null && !this.isAllowed((SecurityManagerInterface)this.mSecurityManagers[i], hierarchy)) {
                        return false;
                    }
                    matchedBaseHierarchyCube = true;
                }
                break block7;
            }
            if (!(hierarchy instanceof ROLAPVirtualHierarchy)) break block7;
            IHierarchy[] baseHierarchies = ((ROLAPVirtualHierarchy)hierarchy).getSourceHierarchies();
            int sourceCubeIndex = 0;
            for (IHierarchy baseHierarchy : baseHierarchies) {
                if (baseHierarchy != null) {
                    ROLAPCube baseHierarchyCube = this.mSourceCubes[sourceCubeIndex];
                    boolean matchedBaseHierarchyCube = false;
                    for (int i = 0; i < this.mSourceCubes.length && !matchedBaseHierarchyCube; ++i) {
                        if (baseHierarchyCube != this.mSourceCubes[i]) continue;
                        if (this.mSecurityManagers[i] != null && !this.isAllowed((SecurityManagerInterface)this.mSecurityManagers[i], baseHierarchy)) {
                            return false;
                        }
                        matchedBaseHierarchyCube = true;
                    }
                }
                ++sourceCubeIndex;
            }
        }
        return true;
    }

    private boolean isAllowed(Level level) {
        block9: {
            block8: {
                if (!level.getHierarchy().getDimension().isShareable()) break block8;
                int[] sourceCubeIndices = ((ShareableROLAPDimension)level.getHierarchy().getDimension()).getVirtualCubeSourceCubeIndexes(this.virtualCube.getName());
                for (int i = 0; i < sourceCubeIndices.length; ++i) {
                    if (this.mSecurityManagers[sourceCubeIndices[i]] != null) {
                        if (!this.isAllowed((SecurityManagerInterface)this.mSecurityManagers[sourceCubeIndices[i]], level)) continue;
                        return true;
                    }
                    return true;
                }
                break block9;
            }
            if (!(level instanceof ROLAPVirtualLevel)) break block9;
            ILevel[] baseLevels = ((ROLAPVirtualLevel)level).getSourceLevels();
            int sourceCubeIndex = 0;
            for (ILevel baseLevel : baseLevels) {
                if (baseLevel != null) {
                    ROLAPCube baseLevelCube = this.mSourceCubes[sourceCubeIndex];
                    boolean matchedBaseLevelCube = false;
                    for (int i = 0; i < this.mSourceCubes.length && !matchedBaseLevelCube; ++i) {
                        if (baseLevelCube != this.mSourceCubes[i]) continue;
                        if (this.mSecurityManagers[i] != null) {
                            if (this.isAllowed((SecurityManagerInterface)this.mSecurityManagers[i], baseLevel)) {
                                return true;
                            }
                        } else {
                            return true;
                        }
                        matchedBaseLevelCube = true;
                    }
                }
                ++sourceCubeIndex;
            }
        }
        return false;
    }

    @Override
    public Dimension[] applySecurity(Dimension[] dims) {
        ArrayList<Dimension> result = new ArrayList<Dimension>();
        for (int i = 0; i < dims.length; ++i) {
            Dimension dimension = dims[i];
            if (!this.isAllowed(dimension)) continue;
            result.add(dimension);
        }
        if (dims.length == result.size()) {
            return dims;
        }
        return result.toArray(new Dimension[result.size()]);
    }

    @Override
    public Hierarchy[] applySecurity(Hierarchy[] hiers) {
        ArrayList<Hierarchy> result = new ArrayList<Hierarchy>();
        for (Hierarchy hier : hiers) {
            if (!this.isAllowed(hier)) continue;
            result.add(hier);
        }
        if (hiers.length == result.size()) {
            return hiers;
        }
        return result.toArray(new Hierarchy[result.size()]);
    }

    @Override
    public Level[] applySecurity(Level[] levels) {
        ArrayList<Level> result = new ArrayList<Level>();
        for (Level level : levels) {
            if (!this.isAllowed(level)) continue;
            result.add(level);
        }
        if (levels.length == result.size()) {
            return levels;
        }
        return result.toArray(new Level[result.size()]);
    }

    @Override
    public IMember getDefaultMember(IDimension dim) throws MetadataException {
        return this.getDefaultMember(dim.getDefaultHierarchy());
    }

    @Override
    public IMember getDefaultMember(IHierarchy hier) throws MetadataException {
        IMember originalDefaultMember = hier.getDefaultMember();
        if (this.isAllAccess() || !this.hasRestrictions(hier)) {
            return originalDefaultMember;
        }
        ROLAPVirtualSecurityCombinationInfo secInfo = this.getOrCreateSecInfo();
        IMember defaultMember = secInfo.getDefaultMember(hier);
        if (defaultMember == null && this.isAllDenied()) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_AllHierarchiesDenied, this.getAllDeniedHierarchy());
        }
        if (defaultMember == null) {
            throw new XQERuntimeException(XQEMessageKeys.ROL_InvalidDefaultMember, hier.getName());
        }
        return defaultMember;
    }

    @Override
    public boolean hasRestrictions(IHierarchy hierarchy) {
        block7: {
            block6: {
                if (this.isAllAccess()) {
                    return false;
                }
                if (!hierarchy.getDimension().isShareable()) break block6;
                int[] sourceCubeIndices = ((ShareableROLAPDimension)hierarchy.getDimension()).getVirtualCubeSourceCubeIndexes(this.virtualCube.getName());
                for (int i = 0; i < sourceCubeIndices.length; ++i) {
                    if (this.mSecurityManagers[sourceCubeIndices[i]] == null || !this.mSecurityManagers[sourceCubeIndices[i]].hasRestrictions(hierarchy)) continue;
                    return true;
                }
                break block7;
            }
            if (!(hierarchy instanceof ROLAPVirtualHierarchy)) break block7;
            IHierarchy[] sourceHierarchies = ((ROLAPVirtualHierarchy)hierarchy).getSourceHierarchies();
            int sourceCubeIndex = 0;
            for (IHierarchy sourceHierarchy : sourceHierarchies) {
                if (sourceHierarchy != null) {
                    ROLAPCube hierarchyCube = this.mSourceCubes[sourceCubeIndex];
                    boolean matchedHierarchyCube = false;
                    for (int i = 0; i < this.mSourceCubes.length && !matchedHierarchyCube; ++i) {
                        if (hierarchyCube != this.mSourceCubes[i]) continue;
                        if (this.mSecurityManagers[i] != null && this.mSecurityManagers[i].hasRestrictions(sourceHierarchy)) {
                            return true;
                        }
                        matchedHierarchyCube = true;
                    }
                }
                ++sourceCubeIndex;
            }
        }
        return false;
    }

    @Override
    public String getAuthorizationKeyForCurrentUser() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.mSecurityManagers.length; ++i) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append("Cube").append((char)(65 + i)).append(":(");
            sb.append(this.mSecurityManagers[i].getAuthorizationKeyForCurrentUser());
            sb.append(')');
        }
        return sb.toString();
    }

    @Override
    public boolean isValueSecured(IMember member) {
        if (this.isAllAccess()) {
            return false;
        }
        return member instanceof IROLAPMember && ((IROLAPMember)member).isSecurityPaddingMember();
    }

    @Override
    public boolean isTupleValueVisible(ROLAPUserSecurityContext secContext, ITuple tuple) {
        if (this.isAllAccess()) {
            return true;
        }
        HashSet<IHierarchy> securityPaddingMemberHierarchies = this.getOrCreateSecInfo().getSecurityPaddingMemberHierarchies();
        if (securityPaddingMemberHierarchies.size() == 0) {
            return true;
        }
        for (IHierarchy hierarchy : securityPaddingMemberHierarchies) {
            IMember member = tuple.getMember(hierarchy);
            if (!(member instanceof IROLAPMember) || !((IROLAPMember)member).isSecurityPaddingMember()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean getMembersRollup(IHierarchy hierarchy) {
        block8: {
            block7: {
                if (this.isAllAccess() || !this.hasRestrictions(hierarchy)) {
                    return true;
                }
                if (!hierarchy.getDimension().isShareable()) break block7;
                boolean matchedHierarchyCube = false;
                for (int i = 0; i < this.mSourceCubes.length && !matchedHierarchyCube; ++i) {
                    if (this.mSecurityManagers[i] != null && !this.mSecurityManagers[i].getMembersRollup(hierarchy)) {
                        return false;
                    }
                    matchedHierarchyCube = true;
                }
                break block8;
            }
            if (!(hierarchy instanceof ROLAPVirtualHierarchy)) break block8;
            IHierarchy[] baseHierarchies = ((ROLAPVirtualHierarchy)hierarchy).getSourceHierarchies();
            int sourceCubeIndex = 0;
            for (IHierarchy baseHierarchy : baseHierarchies) {
                if (baseHierarchy != null) {
                    ROLAPCube baseHerarchyCube = this.mSourceCubes[sourceCubeIndex];
                    boolean matchedBaseHierarchyCube = false;
                    for (int i = 0; i < this.mSourceCubes.length && !matchedBaseHierarchyCube; ++i) {
                        if (baseHerarchyCube != this.mSourceCubes[i]) continue;
                        if (this.mSecurityManagers[i] != null && !this.mSecurityManagers[i].getMembersRollup(baseHierarchy)) {
                            return false;
                        }
                        matchedBaseHierarchyCube = true;
                    }
                }
                ++sourceCubeIndex;
            }
        }
        return true;
    }

    @Override
    public boolean getCheckTupleValueVisbility() {
        if (this.isAllAccess()) {
            return false;
        }
        return this.getOrCreateSecInfo().getSecurityPaddingMemberHierarchies().size() > 0;
    }

    @Override
    public IMember[] getSecurityPaddingMembers(IHierarchy hierarchy, IMember member) {
        if (this.isAllAccess()) {
            return null;
        }
        return this.getOrCreateSecInfo().getSecurityPaddingMembers(hierarchy, member);
    }

    @Override
    public boolean hasSecurityPaddingMembers(ILevel level) {
        if (this.isAllAccess()) {
            return false;
        }
        return this.getOrCreateSecInfo().hasSecurityPaddingMembers(level);
    }

    @Override
    public boolean hasTupleSecurity() {
        if (this.isAllAccess()) {
            return false;
        }
        if (this.getOrCreateSecInfo().getSecurityPaddingMemberHierarchies().size() > 0) {
            return true;
        }
        for (IROLAPSecurityManager security : this.mSecurityManagers) {
            if (!security.getCheckTupleValueVisbility()) continue;
            return true;
        }
        return false;
    }

    private IMember getRolapCalculatedMember(IMember member) {
        if (!member.isCalculatedMember()) {
            return null;
        }
        if (member instanceof ROLAPVirtualCalculatedMember) {
            return member;
        }
        if (!(member instanceof CalculatedMember)) {
            return null;
        }
        IMember originalCalcMember = ((CalculatedMember)member).getOriginalCalculatedMember();
        if (originalCalcMember == null) {
            return null;
        }
        return originalCalcMember;
    }

    @Override
    public ROLAPUserSecurityContext createUserSecurityContext() {
        ROLAPContext rolapContext = ROLAPContext.get();
        if (rolapContext.isInternalUse()) {
            return ROLAPUserSecurityContext.USER_SECURITY_CONTEXT_SYSADMIN;
        }
        if (this.isUserSysAdmin()) {
            return ROLAPUserSecurityContext.USER_SECURITY_CONTEXT_SYSADMIN;
        }
        if (this.hasNoRestrictions()) {
            return ROLAPUserSecurityContext.USER_SECURITY_CONTEXT_ALLACCESS;
        }
        ROLAPUserSecurityContext userSecurityContext = new ROLAPUserSecurityContext(this, this.getAuthorizationKeyForCurrentUser());
        this.getOrCreateSecInfo();
        return userSecurityContext;
    }

    @Override
    public boolean hasSecurityPaddingMembers(IHierarchy hierarchy) {
        if (this.isAllAccess()) {
            return false;
        }
        return this.getOrCreateSecInfo().hasSecurityPaddingMembers(hierarchy);
    }

    public IHierarchy getAllDeniedHierarchy() {
        IHierarchy allDeniedHierarchy = null;
        for (int i = 0; i < this.mSecurityManagers.length; ++i) {
            if (this.mSecurityManagers[i] == null || !this.mSecurityManagers[i].isAllDenied()) continue;
            allDeniedHierarchy = this.mSourceCubes[i].getMeasuresHierarchy();
            break;
        }
        return allDeniedHierarchy;
    }

    public boolean isAllowed(IProperty virtualProperty) {
        if (virtualProperty instanceof NullMember) {
            return true;
        }
        if (virtualProperty == null) {
            return false;
        }
        List<IProperty> baseProperties = null;
        if (virtualProperty instanceof ROLAPVirtualProperty) {
            baseProperties = ((ROLAPVirtualProperty)virtualProperty).getAllSourceProperties();
        } else if (virtualProperty.getDimension().isShareable()) {
            baseProperties = new ArrayList<IProperty>();
            int[] sourceCubeIndices = ((ShareableROLAPDimension)virtualProperty.getDimension()).getVirtualCubeSourceCubeIndexes(this.virtualCube.getName());
            for (int index = 0; index < sourceCubeIndices.length; ++index) {
                baseProperties.add(virtualProperty);
            }
        }
        boolean result = false;
        int sourceCubeIndex = 0;
        for (IProperty baseProperty : baseProperties) {
            ROLAPCube baseMemberCube = null;
            if (virtualProperty instanceof ROLAPVirtualProperty) {
                baseMemberCube = this.getSourceCube(((ROLAPVirtualProperty)virtualProperty).getAllSourceCubes().get(sourceCubeIndex));
            } else if (virtualProperty.getDimension().isShareable()) {
                int[] sourceCubeIndices = ((ShareableROLAPDimension)baseProperty.getDimension()).getVirtualCubeSourceCubeIndexes(this.virtualCube.getName());
                baseMemberCube = this.mSourceCubes[sourceCubeIndices[sourceCubeIndex]];
            }
            if (baseProperty != null) {
                boolean matchedBasePropertyCube = false;
                for (int i = 0; i < this.mSourceCubes.length && !matchedBasePropertyCube; ++i) {
                    if (baseMemberCube != this.mSourceCubes[i]) continue;
                    if (this.mSecurityManagers[i] != null) {
                        if (this.isAllowed((SecurityManagerInterface)this.mSecurityManagers[i], baseProperty)) {
                            return true;
                        }
                    } else {
                        return true;
                    }
                    matchedBasePropertyCube = true;
                }
            }
            ++sourceCubeIndex;
        }
        return result;
    }

    private ROLAPCube getSourceCube(IROLAPCube rolapCube) {
        for (ROLAPCube cube : this.mSourceCubes) {
            if (cube != rolapCube) continue;
            return cube;
        }
        throw new XQERuntimeException(XQEMessageKeys.GEN_FoundInternalErrorParam_INTERNAL, "Cannot find source cube with name: " + rolapCube.getName());
    }

    @Override
    public List<IProperty> applySecurity(List<IProperty> properties) {
        if (properties == null || properties.size() == 0 || this.isAllAccess()) {
            return properties;
        }
        ArrayList<IProperty> output = new ArrayList<IProperty>();
        for (IProperty property : properties) {
            if (!this.isAllowed(property)) continue;
            output.add(property);
        }
        if (properties.size() == output.size()) {
            return properties;
        }
        return output;
    }

    @Override
    public boolean isDimensionSecured(IDimension dimension) {
        boolean isDimSecured;
        block7: {
            block6: {
                isDimSecured = false;
                if (!dimension.isShareable()) break block6;
                for (int i = 0; i < this.mSourceCubes.length; ++i) {
                    if (this.mSourceCubes[i] == null) continue;
                    ROLAPCube cube = this.mSourceCubes[i];
                    SecurityManagerInterface secManager = cube.getSecurityManager();
                    if (secManager == null) {
                        return false;
                    }
                    if (!secManager.isDimensionSecured(dimension)) {
                        return false;
                    }
                    isDimSecured = true;
                }
                break block7;
            }
            if (!(dimension instanceof ROLAPVirtualDimension)) break block7;
            IDimension[] baseDimensions = ((ROLAPVirtualDimension)dimension).getSourceDimensions();
            for (int i = 0; i < baseDimensions.length; ++i) {
                if (baseDimensions[i] == null) continue;
                ROLAPCube cube = this.mSourceCubes[i];
                SecurityManagerInterface secManager = cube.getSecurityManager();
                if (secManager == null) {
                    return false;
                }
                if (!secManager.isDimensionSecured(baseDimensions[i])) {
                    return false;
                }
                isDimSecured = true;
            }
        }
        return isDimSecured;
    }

    @Override
    public boolean isAttributeSecured(String property, IHierarchy hierarchy) {
        return false;
    }
}

