/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.bibushandler.IHomicide;
import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.cubingservices.CommonClassesFactory;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.AggregationNotFoundException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleStorage;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.Dimension;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.metadata.MetadataException;
import com.cognos.xqe.runtree.olap.mdx.storage.AggregationException;
import com.cognos.xqe.runtree.olap.mdx.storage.BTreeTupleIDHelper;
import com.cognos.xqe.runtree.olap.mdx.storage.TupleNotFoundException;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQEDebugLog;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xindice.core.DBException;
import org.apache.xindice.core.data.Value;
import org.apache.xindice.core.filer.BTree;
import org.apache.xindice.core.filer.BTreeException;
import org.apache.xindice.core.filer.BTreeNotFoundException;
import org.apache.xindice.util.Configuration;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class BTreeTupleStorage
implements TupleStorage {
    protected BTree data;
    private AggregationNotFoundException aggNotFoundException;
    private static final IHomicide KILLER = CommonClassesFactory.createIHomicide();
    private static final String TUPLE_NOT_FOUND = "Tuple not found.";
    private static final String FAILED_TO_GET_TUPLE = "Failed to get tuple.";
    private static final String LOG_TUPLE_NOT_CREATED = "Tuple member ID could not be created.";
    protected Cube cube;
    protected List<IDimension> dims;
    protected boolean includeLevelCombinationID = true;
    private String dataFilename;
    private boolean deleteFilesOnClose = false;
    private final String mDataFileName = this.getClass().getName() + " " + this.hashCode();
    private ReentrantReadWriteLock dataLock = new ReentrantReadWriteLock();
    private BTreeTupleIDHelper tupleIdHelper;
    private static XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

    public BTree getData() {
        return this.data;
    }

    @Override
    public boolean contains(Tuple tup) {
        return this.contains(tup, null);
    }

    public boolean contains(Tuple tup, String userName) {
        boolean result = false;
        KILLER.throwHomicideExceptionIfDead();
        try {
            byte[] b = this.tupleIdHelper.tupleToByteArray(tup, userName, false);
            try {
                try {
                    this.dataFindValue(new Value(b));
                    result = true;
                }
                catch (BTreeNotFoundException e) {
                    result = false;
                }
            }
            catch (IOException e) {
                mErrorLogger.log(e);
                result = false;
            }
            catch (BTreeException e) {
                mErrorLogger.log(e);
                result = false;
            }
        }
        catch (TupleNotFoundException e) {
            mErrorLogger.log(e);
            result = false;
        }
        return result;
    }

    public void remove(Tuple tup) {
        this.remove(tup, null);
    }

    public void remove(Tuple tup, String userName) {
        KILLER.throwHomicideExceptionIfDead();
        try {
            byte[] b = this.tupleIdHelper.tupleToByteArray(tup, userName, false);
            try {
                try {
                    this.dataRemoveValue(new Value(b));
                }
                catch (BTreeNotFoundException e) {
                    mErrorLogger.log(e);
                }
            }
            catch (IOException e) {
                mErrorLogger.log(e);
            }
            catch (BTreeException e) {
                mErrorLogger.log(e);
            }
        }
        catch (TupleNotFoundException e) {
            mErrorLogger.log(e);
        }
    }

    public BTreeTupleStorage(Cube c, String dataFileName, String indexFileName, boolean create, boolean theDeleteFilesOnClose) {
        File dataf = new File(dataFileName);
        this.dataFilename = dataFileName;
        this.deleteFilesOnClose = theDeleteFilesOnClose;
        this.cube = c;
        this.dims = this.cube.getDimensions();
        this.data = new BTree(dataf);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource src = new InputSource(new StringReader("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"));
            document = parser.parse(src);
        }
        catch (Exception e1) {
            mErrorLogger.log(e1);
        }
        Configuration config = new Configuration(document, false);
        this.tupleIdHelper = new BTreeTupleIDHelper(indexFileName, config, create, this.deleteFilesOnClose, true);
        this.data.setConfig(config);
        try {
            if (create) {
                this.data.create();
            }
            this.data.open();
        }
        catch (DBException e) {
            mErrorLogger.log(e);
        }
    }

    public BTreeTupleStorage(List<IDimension> dimensions, String dataFileName, String indexFileName, boolean create, boolean theDeleteFilesOnClose, boolean cubeScope) {
        File dataf = new File(dataFileName);
        this.dataFilename = dataFileName;
        this.deleteFilesOnClose = theDeleteFilesOnClose;
        this.dims = dimensions;
        this.data = new BTree(dataf);
        Document document = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = factory.newDocumentBuilder();
            InputSource src = new InputSource(new StringReader("<xindice>    <root-collection dbroot='./db/' name='db'>        <queryengine>            <resolver autoindex='false' class='org.apache.xindice.core.query.XPathQueryResolver'/>            <resolver class='org.apache.xindice.core.xupdate.XUpdateQueryResolver'/>        </queryengine>    </root-collection>    <xml-rpc>        <driver name='xerces'/>    </xml-rpc></xindice>"));
            document = parser.parse(src);
        }
        catch (Exception e1) {
            XQEDebugLog.err.printStackTrace(e1);
            mErrorLogger.log(e1);
        }
        Configuration config = new Configuration(document, false);
        this.tupleIdHelper = new BTreeTupleIDHelper(indexFileName, config, create, this.deleteFilesOnClose, true);
        this.tupleIdHelper.setScope(cubeScope);
        this.data.setConfig(config);
        try {
            if (create) {
                this.data.create();
            }
            this.data.open();
        }
        catch (DBException e) {
            XQEDebugLog.err.printStackTrace(e);
            mErrorLogger.log(e);
        }
    }

    public BTreeTupleStorage(String dataFileName, String indexFileName, HashMap uniqueNameToID, HashMap dimensionToMemberCount) {
        File dataf = new File(dataFileName);
        this.dataFilename = dataFileName;
        this.tupleIdHelper = new BTreeTupleIDHelper(indexFileName, null, uniqueNameToID, dimensionToMemberCount, true);
        this.data = new BTree(dataf);
        try {
            this.data.create();
            this.data.open();
        }
        catch (DBException e) {
            mErrorLogger.log(e);
        }
    }

    public void initialiseDefaultDimensionOrder() throws AggregationException {
        IMember[] tuple = new IMember[this.dims.size()];
        for (int i = 0; i < this.dims.size(); ++i) {
            Dimension dim = (Dimension)this.dims.get(i);
            try {
                tuple[i] = ((Level)dim.getLevel(0)).getMember(0);
                continue;
            }
            catch (MetadataException e) {
                throw new AggregationException("X01408", new String[]{"Dimension: " + dim.getName()}, e);
            }
        }
        this.tupleIdHelper.initialiseDimensionOrder(new Tuple(tuple));
    }

    @Override
    public void close() {
        this.dataLock.writeLock().lock();
        try {
            this.tupleIdHelper.close();
            if (this.data != null) {
                this.data.drop();
                this.data.close();
            }
            if (this.deleteFilesOnClose && this.dataFilename != null) {
                File dataf = new File(this.dataFilename);
                dataf.delete();
            }
        }
        catch (DBException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.dataLock.writeLock().unlock();
        }
    }

    @Override
    public double get(Tuple t) throws AggregationNotFoundException {
        return this.get(t, null);
    }

    public double get(Tuple t, String userName) throws AggregationNotFoundException {
        return Double.longBitsToDouble(this.getLong(t, userName));
    }

    public long getLong(Tuple t) throws AggregationNotFoundException {
        return this.getLong(t, null);
    }

    public long getLong(Tuple t, String userName) throws AggregationNotFoundException {
        long v;
        byte[] b;
        KILLER.throwHomicideExceptionIfDead();
        try {
            b = this.tupleIdHelper.tupleToByteArray(t, userName, false);
        }
        catch (TupleNotFoundException e) {
            if (this.aggNotFoundException == null) {
                this.aggNotFoundException = new AggregationNotFoundException();
            }
            this.aggNotFoundException.setMessage(TUPLE_NOT_FOUND);
            throw this.aggNotFoundException;
        }
        try {
            try {
                v = this.dataFindValue(new Value(b));
            }
            catch (BTreeNotFoundException e) {
                if (this.aggNotFoundException == null) {
                    this.aggNotFoundException = new AggregationNotFoundException();
                }
                this.aggNotFoundException.setMessage(TUPLE_NOT_FOUND);
                throw this.aggNotFoundException;
            }
        }
        catch (IOException e) {
            mErrorLogger.log(e);
            throw new AggregationNotFoundException(FAILED_TO_GET_TUPLE);
        }
        catch (BTreeException e) {
            mErrorLogger.log(e);
            if (this.aggNotFoundException == null) {
                this.aggNotFoundException = new AggregationNotFoundException();
            }
            this.aggNotFoundException.setMessage(FAILED_TO_GET_TUPLE);
            throw this.aggNotFoundException;
        }
        return v;
    }

    @Override
    public String getDataFileName() {
        return this.mDataFileName;
    }

    @Override
    public void put(Tuple t, double value) {
        this.put(t, null, value);
    }

    public void put(Tuple t, String userName, double value) {
        KILLER.throwHomicideExceptionIfDead();
        try {
            byte[] b = this.tupleIdHelper.tupleToByteArray(t, userName, true);
            this.put(b, userName, Double.doubleToRawLongBits(value));
        }
        catch (TupleNotFoundException e) {
            mErrorLogger.log(e);
            XQEDebugLog.out.println(LOG_TUPLE_NOT_CREATED);
        }
    }

    private void put(byte[] tupleAsBytes, String userName, long value) {
        try {
            this.dataAddValue(new Value(tupleAsBytes), value);
        }
        catch (IOException e) {
            mErrorLogger.log(e);
        }
        catch (BTreeException e) {
            mErrorLogger.log(e);
        }
    }

    private void put(byte[] tupleAsBytes, long value) {
        this.put(tupleAsBytes, null, value);
    }

    @Override
    public void put(String[] uniqueNames, double value) {
        KILLER.throwHomicideExceptionIfDead();
        try {
            byte[] b = this.tupleIdHelper.tupleToByteArray(uniqueNames, this.dims, true);
            this.put(b, Double.doubleToRawLongBits(value));
        }
        catch (TupleNotFoundException e) {
            mErrorLogger.log(e);
            XQEDebugLog.out.println(LOG_TUPLE_NOT_CREATED);
        }
    }

    public void putLong(Tuple t, long value) {
        this.putLong(t, null, value);
    }

    public void putLong(Tuple t, String userName, long value) {
        try {
            byte[] b = this.tupleIdHelper.tupleToByteArray(t, userName, true);
            this.put(b, userName, value);
        }
        catch (TupleNotFoundException e) {
            mErrorLogger.log(e);
            XQEDebugLog.out.println(LOG_TUPLE_NOT_CREATED);
        }
    }

    @Override
    public void increment(Tuple t, double value, int aggregationType) {
        this.increment(t, null, value, aggregationType);
    }

    public void increment(Tuple t, String userName, double value, int aggregationType) {
        KILLER.throwHomicideExceptionIfDead();
        try {
            byte[] b = this.tupleIdHelper.tupleToByteArray(t, userName, true);
            try {
                double previousV = 0.0;
                boolean vNull = false;
                try {
                    previousV = Double.longBitsToDouble(this.dataFindValue(new Value(b)));
                    switch (aggregationType) {
                        case 1: {
                            value = previousV + value;
                            break;
                        }
                        case 2: {
                            value = previousV + value;
                            break;
                        }
                        case 4: {
                            value = Math.max(value, previousV);
                            break;
                        }
                        case 3: {
                            value = Math.min(value, previousV);
                            break;
                        }
                    }
                }
                catch (BTreeNotFoundException e) {
                    vNull = true;
                }
                if (vNull || value != previousV) {
                    this.dataAddValue(new Value(b), Double.doubleToRawLongBits(value));
                }
            }
            catch (IOException e) {
                mErrorLogger.log(e);
            }
            catch (BTreeException e) {
                mErrorLogger.log(e);
            }
        }
        catch (TupleNotFoundException e) {
            mErrorLogger.log(e);
            XQEDebugLog.out.println(LOG_TUPLE_NOT_CREATED);
        }
    }

    @Override
    public void increment(Tuple t, double value) {
    }

    private long dataFindValue(Value key) throws IOException, BTreeException {
        return BTreeTupleIDHelper.safeFindValue(this.dataLock, this.data, key);
    }

    private void dataAddValue(Value key, long id) throws IOException, BTreeException {
        BTreeTupleIDHelper.safeAddValue(this.dataLock, this.data, key, id);
    }

    private void dataRemoveValue(Value key) throws IOException, BTreeException {
        BTreeTupleIDHelper.safeRemoveValue(this.dataLock, this.data, key);
    }
}

