/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.util.pool.XQEIntegerPool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class DimensionToIdCounter {
    private static final int INITIAL_DIM_ORDER_MAP_SIZE_50 = 50;
    private int maxDimId = -1;
    private Map<String, Integer> dimensionToOrder = new HashMap<String, Integer>(50);
    private List<IDimension> orderToDimension = new ArrayList<IDimension>(50);
    private ReadWriteLock dimOrderLock = new ReentrantReadWriteLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDimensionIndex(IDimension dim) {
        Integer dimIdx;
        int result = -1;
        String dimKey = dim.getUniqueName();
        this.dimOrderLock.readLock().lock();
        try {
            dimIdx = this.dimensionToOrder.get(dimKey);
            if (dimIdx != null) {
                result = dimIdx;
            }
        }
        finally {
            this.dimOrderLock.readLock().unlock();
        }
        if (result == -1) {
            this.dimOrderLock.writeLock().lock();
            try {
                dimIdx = this.dimensionToOrder.get(dimKey);
                if (dimIdx != null) {
                    result = dimIdx;
                } else {
                    ++this.maxDimId;
                    this.dimensionToOrder.put(dimKey, XQEIntegerPool.getInteger(this.maxDimId));
                    this.orderToDimension.add(dim);
                    result = this.maxDimId;
                }
            }
            finally {
                this.dimOrderLock.writeLock().unlock();
            }
        }
        return result;
    }

    public IDimension getByIndex(int dimensionOrder) {
        this.dimOrderLock.readLock().lock();
        try {
            IDimension iDimension = this.orderToDimension.get(dimensionOrder);
            return iDimension;
        }
        finally {
            this.dimOrderLock.readLock().unlock();
        }
    }

    public int getMaxDimensionIndex() {
        this.dimOrderLock.readLock().lock();
        try {
            int n = this.maxDimId;
            return n;
        }
        finally {
            this.dimOrderLock.readLock().unlock();
        }
    }
}

