/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.runtree.olap.mdx.interpreter.AggregationNotFoundException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleStorage;
import java.util.HashMap;

public class HashMapTupleStorage
implements TupleStorage {
    private HashMap<Tuple, Double> data;
    private final String mDataFileName = this.getClass().getName() + " " + this.hashCode();

    public HashMapTupleStorage() {
        this.data = new HashMap();
    }

    @Override
    public String getDataFileName() {
        return this.mDataFileName;
    }

    @Override
    public boolean contains(Tuple tup) {
        return this.data.containsKey(tup);
    }

    @Override
    public double get(Tuple tup) throws AggregationNotFoundException {
        Double v = this.data.get(tup);
        if (v == null) {
            throw new AggregationNotFoundException("Tuple not found in storage.");
        }
        return v;
    }

    @Override
    public void put(Tuple tup, double value) {
        this.data.put(tup, new Double(value));
    }

    @Override
    public void increment(Tuple tup, double value) {
        double v = 0.0;
        if (this.data.containsKey(tup)) {
            v = this.data.get(tup);
        }
        this.data.put(tup, new Double(v + value));
    }

    @Override
    public void increment(Tuple tup, double value, int aggregationType) {
    }

    @Override
    public void put(String[] uniqueNames, double value) {
    }

    @Override
    public void close() {
        this.data.clear();
    }
}

