/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage;

import com.cognos.xqe.resultset.interfaces.ICell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.BCell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.storage.ICellStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.util.CompareNumbers;
import com.cognos.xqe.runtree.olap.mdx.util.ICellCombiner;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class InMemoryCellStorage
implements ICellStorage {
    private TreeMap<Number, ICell> cellMap = null;

    public InMemoryCellStorage(ResultSet parentResultSet) {
        long maximumSize = parentResultSet.getQuerySet().size();
        this.cellMap = maximumSize > 0L ? new TreeMap() : new TreeMap(new CompareNumbers());
    }

    @Override
    public ICell put(Number ordinal, ICell cell) {
        return this.cellMap.put(ordinal, cell);
    }

    @Override
    public int size() {
        return this.cellMap.size();
    }

    @Override
    public ICell remove(Number ordinal) {
        return this.cellMap.remove(ordinal);
    }

    @Override
    public ICell get(Number ordinal) {
        return this.cellMap.get(ordinal);
    }

    @Override
    public void clear() {
        this.cellMap.clear();
    }

    @Override
    public IBlockTupleStorage getStreamStorage() {
        return null;
    }

    @Override
    public boolean isCalculationCell(Number ordinal) {
        Cell cell = (Cell)this.get(ordinal);
        return cell != null && cell.isCalculation();
    }

    @Override
    public void add(List<ICellStorage> others, ICellCombiner cellCombiner, ResultSet originalResultSet) {
        for (ICellStorage other : others) {
            for (Map.Entry<Number, ICell> otherEntry : ((InMemoryCellStorage)other).cellMap.entrySet()) {
                ICell myCell = this.cellMap.get(otherEntry.getKey());
                if (myCell == null) {
                    if (!originalResultSet.isTupleValueVisible(otherEntry.getKey())) continue;
                    Cell myNewCell = null;
                    Cell otherCell = (Cell)otherEntry.getValue();
                    myNewCell = otherCell.getOrdinal() == -123L ? new BCell((BCell)otherCell) : new Cell(otherCell);
                    Object copyOfValue = otherCell.getValue().copy();
                    myNewCell.setValue(copyOfValue);
                    this.cellMap.put(otherEntry.getKey(), myNewCell);
                    continue;
                }
                cellCombiner.combine(myCell, otherEntry.getValue());
            }
        }
    }

    @Override
    public Iterator<ICell> getCellIterator() {
        return this.cellMap.values().iterator();
    }

    @Override
    public Iterator<Number> getOrdinalIterator() {
        return this.cellMap.keySet().iterator();
    }

    public String toString() {
        return this.cellMap.toString();
    }
}

