/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletSizeException;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorage;
import java.text.NumberFormat;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class AggregateCubeletMonitor
implements CubeletMonitor {
    private static final long NOTIFY_INTERVAL = 500000L;
    private static final long LOG_MSG_INTERVAL = 5000000L;
    private AtomicLong totalBuiltCubeletSize = new AtomicLong(0L);
    private ConcurrentMap<Long, Long> buildingCubeletsSize = new ConcurrentHashMap<Long, Long>();
    private long maxSize = -1L;

    @Override
    public void creationProgress(Cubelet cubelet, long tupleCount, IOrdinalValueStorage valuesStorage) {
        long cubeletMemoryUsage = cubelet.getMemoryUsage();
        this.buildingCubeletsSize.put(Thread.currentThread().getId(), cubeletMemoryUsage);
        long totalMemory = this.getTotalMemory();
        if (tupleCount % 5000000L == 0L) {
            ROLAPLog.log("ROLAPCubes.AggregateCache", "AggregateCubelet has loaded " + NumberFormat.getInstance().format(tupleCount) + " tuples consuming " + NumberFormat.getInstance().format(cubeletMemoryUsage) + " bytes.  Total aggregate storeage size is " + NumberFormat.getInstance().format(totalMemory) + " bytes.");
        }
        if (this.maxSize >= 0L && totalMemory > this.maxSize) {
            this.validateIfAggregateCacheSizeExceeded();
        }
    }

    @Override
    public long getCreationNotificationInterval() {
        return 500000L;
    }

    @Override
    public void creationFailed(ISet set, Cubelet cubelet) {
        this.buildingCubeletsSize.remove(Thread.currentThread().getId());
    }

    @Override
    public void creationSuccessful(ISet set, Cubelet cubelet) {
        long cubeletMemoryUsage = cubelet.getMemoryUsage();
        this.buildingCubeletsSize.put(Thread.currentThread().getId(), cubeletMemoryUsage);
        this.validateIfAggregateCacheSizeExceeded();
        this.buildingCubeletsSize.remove(Thread.currentThread().getId());
        this.totalBuiltCubeletSize.addAndGet(cubelet.getMemoryUsage());
    }

    public long getTotalMemory() {
        long bytesUsed = this.totalBuiltCubeletSize.get();
        for (Long cubeletBytes : this.buildingCubeletsSize.values()) {
            bytesUsed += cubeletBytes.longValue();
        }
        return bytesUsed;
    }

    public final long getMaxSize() {
        return this.maxSize;
    }

    public final void setMaxSize(long theMaxSize) {
        this.maxSize = theMaxSize;
    }

    public void decrementTotalBuiltCubeletSize(long delta) {
        this.totalBuiltCubeletSize.addAndGet(-1L * delta);
    }

    private synchronized void validateIfAggregateCacheSizeExceeded() throws AggregateCubeletSizeException {
        long totalMemory = this.getTotalMemory();
        if (this.maxSize >= 0L && totalMemory > this.maxSize) {
            this.buildingCubeletsSize.remove(Thread.currentThread().getId());
            AggregateCubeletSizeException e = new AggregateCubeletSizeException(XQEMessageKeys.EXE_AggregateCacheSizeExceeded, String.valueOf(this.maxSize));
            throw e;
        }
    }
}

