/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.DataCacheAggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCubeletStorage;
import com.cognos.xqe.trace.LogLevel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;

public class AggregateCubeletStorage
extends UpdateableCubeletStorage {
    private static final long BYTES_PER_MEG = 0x100000L;
    private List<AggregateDefinition> possibleAggregateDefinitions = null;
    private AtomicReference<List<AggregateDefinition>> loadedAggregateDefinitions = null;

    public static AggregateCubeletStorage createInstance(ROLAPCube cube, List<AggregateDefinition> aggregateDefinitions) {
        AggregateCubeletStorage aggregateCubeletStorage = new AggregateCubeletStorage(cube, aggregateDefinitions);
        int maxAggregateCacheSize = cube.getConfigMaxAggregateCacheSize();
        aggregateCubeletStorage.setMaxSize(maxAggregateCacheSize);
        return aggregateCubeletStorage;
    }

    public AggregateCubeletStorage(Cube inputCube, List<AggregateDefinition> theAggregateDefinitions) {
        super(inputCube);
        this.setMaintainceOnAdd(false);
        this.possibleAggregateDefinitions = theAggregateDefinitions;
        this.loadedAggregateDefinitions = new AtomicReference(new ArrayList());
        AggregateCubeletMonitor monitor = new AggregateCubeletMonitor();
        monitor.setMaxSize((long)this.getMaxSize() * 0x100000L);
        this.setCubeletMonitor(monitor);
    }

    public final List<AggregateDefinition> getAllAggregateDefinitions(boolean includeDataCacheAggregates) {
        List<AggregateDefinition> aggregates = this.possibleAggregateDefinitions;
        List<AggregateDefinition> allLoadedAggregates = this.getAvailableAggregateDefinitions(true);
        if (includeDataCacheAggregates && allLoadedAggregates.size() > 0) {
            if (aggregates == null) {
                aggregates = new ArrayList<AggregateDefinition>();
            }
            ArrayList<AggregateDefinition> aggregatesWithDCEntries = new ArrayList<AggregateDefinition>(aggregates);
            for (AggregateDefinition def : allLoadedAggregates) {
                if (!(def instanceof DataCacheAggregateDefinition)) continue;
                aggregatesWithDCEntries.add(def);
            }
            aggregates = aggregatesWithDCEntries;
        }
        return aggregates;
    }

    public final List<AggregateDefinition> getAvailableAggregateDefinitions(boolean includeDataCacheAggregates) {
        List<AggregateDefinition> aggregates = this.loadedAggregateDefinitions.get();
        if (aggregates != null && !includeDataCacheAggregates && aggregates.size() > 0) {
            ArrayList<AggregateDefinition> aggregatesWithoutDCEntries = new ArrayList<AggregateDefinition>();
            for (AggregateDefinition def : aggregates) {
                if (def instanceof DataCacheAggregateDefinition) continue;
                aggregatesWithoutDCEntries.add(def);
            }
            aggregates = aggregatesWithoutDCEntries;
        }
        return aggregates;
    }

    public final void notifyAggregateDefinitionLoaded(AggregateDefinition aggregateDefinition) {
        ArrayList<AggregateDefinition> newDefinitions = new ArrayList<AggregateDefinition>();
        List<AggregateDefinition> oldDefinitions = null;
        do {
            newDefinitions.clear();
            oldDefinitions = this.loadedAggregateDefinitions.get();
            newDefinitions.addAll(oldDefinitions);
            newDefinitions.add(aggregateDefinition);
        } while (!this.loadedAggregateDefinitions.compareAndSet(oldDefinitions, newDefinitions));
    }

    @Override
    protected Cubelet createNewCubelet(ISet querySet, Iterator<TupleValue> tupleValues, String hint) {
        return new UpdateableCubelet(querySet, tupleValues, this.cubeletMonitor, hint);
    }

    @Override
    public void setMaxSize(int storageSize) {
        super.setMaxSize(storageSize);
        if (this.cubeletMonitor != null) {
            ((AggregateCubeletMonitor)this.cubeletMonitor).setMaxSize((long)storageSize * 0x100000L);
        }
    }

    public void removeCubelet(String cubeletHint) {
        ArrayList<String> cubeletHints = new ArrayList<String>();
        cubeletHints.add(cubeletHint);
        this.removeCubelets(cubeletHints);
    }

    public List<String> removeCubelets(Collection<String> cubeletHints) {
        Iterator<Cubelet> cubeletIterator = this.tupleStorage.getCache().iterator();
        ArrayList<String> cubeletsNotFound = new ArrayList<String>(cubeletHints);
        while (cubeletIterator.hasNext() && cubeletsNotFound.size() > 0) {
            Cubelet c = cubeletIterator.next();
            boolean shouldRemove = cubeletsNotFound.remove(c.getHint());
            if (!shouldRemove) continue;
            cubeletIterator.remove();
            ((AggregateCubeletMonitor)this.cubeletMonitor).decrementTotalBuiltCubeletSize(c.getMemoryUsage());
        }
        return cubeletsNotFound;
    }

    public void removeDefinedAggregateDefinition(AggregateDefinition aggregateDefinition) {
        this.possibleAggregateDefinitions.remove(aggregateDefinition);
    }

    public void addDefinedAggregateDefinitions(List<AggregateDefinition> aggregateDefinitions) {
        this.possibleAggregateDefinitions.addAll(aggregateDefinitions);
    }

    public void removeLoadedAggregateDefinition(AggregateDefinition aggregateDefinition) {
        List<AggregateDefinition> oldLoadedAggregateDefinitions = this.loadedAggregateDefinitions.get();
        ArrayList<AggregateDefinition> newLoadedAggregateDefinitions = new ArrayList<AggregateDefinition>(oldLoadedAggregateDefinitions);
        newLoadedAggregateDefinitions.remove(aggregateDefinition);
        this.loadedAggregateDefinitions.set(newLoadedAggregateDefinitions);
    }

    public boolean isAggregateLoaded(AggregateDefinition aggregateDefinition) {
        List<AggregateDefinition> aggregateDefinitions = this.loadedAggregateDefinitions.get();
        return aggregateDefinitions.contains(aggregateDefinition);
    }

    @Override
    public void maintain(double pctOfCubeletsToForceEvict) {
        this.maintainAggregateDefinitions();
    }

    public Collection<AggregateDefinition> maintainAggregateDefinitions() {
        HashSet<AggregateDefinition> invalidDefinitions = null;
        boolean newDefsSet = false;
        do {
            invalidDefinitions = new HashSet<AggregateDefinition>();
            List<AggregateDefinition> oldLoadedAggregateDefinitions = this.loadedAggregateDefinitions.get();
            ArrayList<AggregateDefinition> newLoadedAggregateDefinitions = new ArrayList<AggregateDefinition>();
            for (AggregateDefinition aggDef : oldLoadedAggregateDefinitions) {
                if (aggDef.canBeEvicted() && aggDef.getStorageLocation().getCubeletSize(aggDef.getName()) < 0L) {
                    invalidDefinitions.add(aggDef);
                    continue;
                }
                newLoadedAggregateDefinitions.add(aggDef);
            }
            newDefsSet = false;
            if (invalidDefinitions.size() <= 0) continue;
            newDefsSet = this.loadedAggregateDefinitions.compareAndSet(oldLoadedAggregateDefinitions, newLoadedAggregateDefinitions);
        } while (invalidDefinitions.size() > 0 && !newDefsSet);
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO) && invalidDefinitions.size() > 0) {
            ROLAPLog.log("ROLAPCubes.AggregateCache", String.format("Removed %d obsolete data cache aggregate definitions.  Current aggregate def total is %d.  Removed defs : %s", invalidDefinitions.size(), this.loadedAggregateDefinitions.get().size(), invalidDefinitions));
        }
        return invalidDefinitions;
    }
}

