/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.util.primitive.IteratorInt;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class AggregateMemberCalculator {
    private Map<IHierarchy, ILevel> hierToAggrLevelMap = null;

    public AggregateMemberCalculator(Map<IHierarchy, ILevel> aHierToAggrLevelMap) {
        this.hierToAggrLevelMap = aHierToAggrLevelMap;
    }

    public IMember[][] getMembers(IHierarchy[] hiers, IMember[][] members, AggregateDefinition aggregate, Set<IHierarchy> aggregateDirectMatchHierarchies, MemberLevelInfo levelInfo) {
        IMember[][] aggregateMembers = new IMember[hiers.length][];
        for (int i = 0; i < hiers.length; ++i) {
            if (aggregateDirectMatchHierarchies.contains(hiers[i]) || hiers[i].getDimension().isMeasuresDimension()) {
                aggregateMembers[i] = members[i];
                continue;
            }
            ILevel aggregateLevel = this.hierToAggrLevelMap.get(hiers[i]);
            boolean anyCompleteLevel = this.isAnyLevelComplete(hiers[i], levelInfo);
            if (anyCompleteLevel) {
                List<IMember> memberList = null;
                memberList = aggregateLevel instanceof Level ? ((Level)aggregateLevel).getMembers(true, false) : aggregateLevel.getMembers();
                IMember[] memberArray = new IMember[memberList.size()];
                memberList.toArray(memberArray);
                aggregateMembers[i] = memberArray;
                continue;
            }
            aggregateMembers[i] = AggregateMemberCalculator.calcMembersForHierarchy(hiers[i], members[i], aggregateLevel);
        }
        return aggregateMembers;
    }

    private boolean isAnyLevelComplete(IHierarchy hier, MemberLevelInfo queryLevelInfo) {
        boolean anyCompleteLevel = false;
        IteratorInt iter = queryLevelInfo.getLevelIndexes(hier).iterator();
        while (iter.hasNext()) {
            int levelNumber = iter.next();
            if (!queryLevelInfo.isLevelComplete(hier, levelNumber)) continue;
            anyCompleteLevel = true;
            break;
        }
        return anyCompleteLevel;
    }

    private static IMember[] calcMembersForHierarchy(IHierarchy iHierarchy, IMember[] queryMembers, ILevel aggregationLevel) {
        HashSet<IMember> levelMembers = new HashSet<IMember>();
        int aggregateLevelNumber = aggregationLevel.getIndex();
        for (IMember queryMember : queryMembers) {
            AggregateMemberCalculator.populateSetWithChildrenAtLevel(queryMember, aggregateLevelNumber, levelMembers);
        }
        IMember[] aggregateMembers = new IMember[levelMembers.size()];
        levelMembers.toArray(aggregateMembers);
        return aggregateMembers;
    }

    private static void populateSetWithChildrenAtLevel(IMember queryMember, int levelNumber, Set<IMember> levelMembers) {
        int memberLevelIndex = queryMember.getLevel().getIndex();
        if (memberLevelIndex == levelNumber) {
            levelMembers.add(queryMember);
        } else if (memberLevelIndex < levelNumber) {
            for (IMember child : queryMember.getChildMembers()) {
                AggregateMemberCalculator.populateSetWithChildrenAtLevel(child, levelNumber, levelMembers);
            }
        } else {
            ROLAPLog.logError("ROLAPCubes.AggregateCache", "Should never happen: Found member " + queryMember + " below aggregate level index " + levelNumber, new Exception());
        }
    }
}

