/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.format.FormatId;
import com.cognos.xqe.metadata.IDimension;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CompactTupleValueList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ITupleValueIterator;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.model.ROLAPMetaMeasure;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationMetrics;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCellsNotFoundException;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.combination.BlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public final class AggregateUtilities {
    private static final double INCREASE_10_PCT = 1.1;

    public static long estimateAggregateSize(String aggregateName, int[] levelSizes, int[] hierarchyCardinalities, long numberOfCells, boolean cellsHaveSameFormatIds) {
        return Cubelet.estimateMemoryUsage(aggregateName, levelSizes, hierarchyCardinalities, numberOfCells, cellsHaveSameFormatIds, false);
    }

    public static boolean measuresHaveSameFormatIds(List<ROLAPMetaMeasure> measures) {
        FormatId formatId = null;
        if (!measures.isEmpty()) {
            formatId = measures.get(0).getFormatId();
            for (int i = 1; i < measures.size(); ++i) {
                ROLAPMetaMeasure measure = measures.get(i);
                FormatId currentFormatId = measure.getFormatId();
                if (!(formatId == null ? currentFormatId != null : !formatId.equals(currentFormatId))) continue;
                return false;
            }
        }
        return true;
    }

    public static boolean validateDimensionalSize(IMember[][] members) {
        int[] levelSizes = new int[members.length];
        for (int i = 0; i < members.length; ++i) {
            levelSizes[i] = members[i].length;
        }
        return AggregateUtilities.validateDimensionalSize(levelSizes);
    }

    public static boolean validateDimensionalSize(int[] levelSizes) {
        return true;
    }

    public static boolean isLargeSet(int[] hierSizes) {
        return BlockTupleStorageUtil.isLargeSet(BlockTupleStorageUtil.getSetSize(hierSizes));
    }

    public static List<int[]> arrayCrossProduct(int[][] intArray) {
        ArrayList<int[]> crossProduct = new ArrayList<int[]>();
        int[] currentArray = new int[intArray.length];
        AggregateUtilities.arrayCrossProduct(intArray, 0, currentArray, crossProduct);
        return crossProduct;
    }

    private static void arrayCrossProduct(int[][] intArray, int currentIndex, int[] workingArray, List<int[]> crossProduct) {
        if (currentIndex == intArray.length) {
            int[] newArray = new int[workingArray.length];
            System.arraycopy(workingArray, 0, newArray, 0, workingArray.length);
            crossProduct.add(newArray);
        } else {
            for (int j = 0; j < intArray[currentIndex].length; ++j) {
                workingArray[currentIndex] = intArray[currentIndex][j];
                AggregateUtilities.arrayCrossProduct(intArray, currentIndex + 1, workingArray, crossProduct);
            }
        }
    }

    public static void logResultSet(String logText, ResultSet resultSet) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        ps.println();
        ITupleValueIterator aggregateIterator = resultSet.tupleValueIterator();
        while (aggregateIterator.hasNext()) {
            TupleValue tv = (TupleValue)aggregateIterator.next();
            ps.println(tv);
        }
        ps.close();
        String resultSetText = new String(os.toByteArray());
        ROLAPLog.logTrace("ROLAPCubes.AggregateCache", logText + resultSetText);
    }

    public static String formatAsString(IMember[][] members, int maxMembersPerHierToPrint) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        for (IMember[] membersPerHier : members) {
            int count = 0;
            for (IMember m : membersPerHier) {
                if (count > maxMembersPerHierToPrint) {
                    ps.print("...(" + membersPerHier.length + " total members)");
                    break;
                }
                ps.print(m);
                ps.print(',');
                ++count;
            }
            ps.println();
        }
        ps.close();
        String text = new String(os.toByteArray());
        return text;
    }

    public static IMember[][] createMemberArraySubset(IMember[][] members, int hierIndex, int startMemberIndex, int endMemberIndex) {
        IMember[][] newMembers = new IMember[members.length][];
        for (int i = 0; i < members.length; ++i) {
            if (i == hierIndex) {
                int length = endMemberIndex - startMemberIndex;
                newMembers[i] = new IMember[length];
                System.arraycopy(members[i], startMemberIndex, newMembers[i], 0, length);
                continue;
            }
            newMembers[i] = members[i];
        }
        return newMembers;
    }

    public static IMember[] getMeasures(ISet set) {
        IMember[] measures = null;
        for (IDimension d : set.getDimensions()) {
            if (!d.isMeasuresDimension()) continue;
            measures = set.getMembers(d);
            break;
        }
        return measures;
    }

    public static Iterator<TupleValue>[] createIterators(List<TupleValue> sourceTupleValues, int numIterators) {
        numIterators = Math.min(numIterators, sourceTupleValues.size());
        numIterators = Math.max(1, numIterators);
        Iterator[] sourceIterators = new Iterator[numIterators];
        int tuplesPerIterator = sourceTupleValues.size() / sourceIterators.length;
        int startTupleIndex = 0;
        for (int i = 0; i < sourceIterators.length; ++i) {
            int endTupleIndex = startTupleIndex + tuplesPerIterator;
            if (i + 1 == sourceIterators.length) {
                endTupleIndex = sourceTupleValues.size();
            }
            if (sourceTupleValues instanceof CompactTupleValueList) {
                sourceIterators[i] = ((CompactTupleValueList)sourceTupleValues).iterator(null, startTupleIndex, endTupleIndex);
            } else {
                List<TupleValue> taskAggregateTuples = sourceTupleValues.subList(startTupleIndex, endTupleIndex);
                sourceIterators[i] = taskAggregateTuples.iterator();
            }
            startTupleIndex += tuplesPerIterator;
        }
        return sourceIterators;
    }

    public static List<Iterator<TupleValue>> fetchAggregateValueIterators(IBlockTupleStorage aggregateCache, AggregateDefinition aggregate, IMember[][] aggregateMembers, AggregateCalculationMetrics metrics) throws InterpreterException {
        ArrayList<Iterator<TupleValue>> aggregateTupleIterators;
        String aggregateName = aggregate.getName();
        long aggregateQueryStartTime = System.currentTimeMillis();
        CrossJoinedSet setToFetch = BlockTupleStorageUtil.createCjsFromMemberSelections(aggregateMembers, null, true);
        BlockTupleStorageFetchResult fetchResult = aggregateCache.getTupleValues((ISet)setToFetch, aggregateName, aggregateTupleIterators = new ArrayList<Iterator<TupleValue>>());
        ISet outputSet = fetchResult.createSet();
        if (outputSet.size() != 0L) {
            AggregateCellsNotFoundException e = new AggregateCellsNotFoundException(XQEMessageKeys.EXE_AggregateDidNotSolveEntireQuery, UniqueNameGenerator.createUniqueName(aggregateName), outputSet.getHierarchies()[0].getDimension().getCube().getUniqueName());
            throw e;
        }
        long endQueryFetchTime = System.currentTimeMillis();
        metrics.setAggregateFetchTime(endQueryFetchTime - aggregateQueryStartTime);
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
            NumberFormat nf = NumberFormat.getInstance();
            ROLAPLog.log("ROLAPCubes.AggregateCache", "Created " + nf.format(aggregateTupleIterators.size()) + " aggregate tuple iterators in " + nf.format(metrics.getAggregateFetchTime()) + "ms.");
        }
        return aggregateTupleIterators;
    }

    public static List<TupleValue> fetchAggregateValues(IBlockTupleStorage aggregateCache, AggregateDefinition aggregate, IMember[][] aggregateMembers, AggregateCalculationMetrics metrics) throws InterpreterException {
        ArrayList<TupleValue> aggregateTuples;
        String aggregateName = aggregate.getName();
        long aggregateQueryStartTime = System.currentTimeMillis();
        int estimatedCells = AggregateUtilities.estimateNumberOfCellsFetchedFromAggregate(aggregate, aggregateMembers);
        CrossJoinedSet setToFetch = BlockTupleStorageUtil.createCjsFromMemberSelections(aggregateMembers, null, true);
        BlockTupleStorageFetchResult fetchResult = aggregateCache.getTupleValues((ISet)setToFetch, aggregateTuples = new ArrayList<TupleValue>(AggregateUtilities.calcListSize(estimatedCells)), aggregateName);
        ISet outputSet = fetchResult.createSet();
        if (outputSet.size() != 0L) {
            AggregateCellsNotFoundException e = new AggregateCellsNotFoundException(XQEMessageKeys.EXE_AggregateDidNotSolveEntireQuery, UniqueNameGenerator.createUniqueName(aggregateName), outputSet.getHierarchies()[0].getDimension().getCube().getUniqueName());
            throw e;
        }
        long endQueryFetchTime = System.currentTimeMillis();
        metrics.setAggregateFetchTime(endQueryFetchTime - aggregateQueryStartTime);
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
            NumberFormat nf = NumberFormat.getInstance();
            ROLAPLog.log("ROLAPCubes.AggregateCache", "Fetched " + nf.format(aggregateTuples.size()) + " tuples in " + nf.format(metrics.getAggregateFetchTime()) + "ms. ");
        }
        return aggregateTuples;
    }

    public static int estimateNumberOfCellsFetchedFromAggregate(AggregateDefinition aggregate, IMember[][] aggregateMembers) {
        double estimatedCellsFromAggregate = aggregate.getCellCount();
        for (IMember[] hierMembers : aggregateMembers) {
            double possibleMembers = hierMembers[0].getLevel().getCardinality();
            if (hierMembers[0].getDimension().isMeasuresDimension()) {
                possibleMembers = aggregate.getMeasures().length;
            }
            double pctOfMembersAccessedInHier = (double)hierMembers.length / possibleMembers;
            estimatedCellsFromAggregate *= pctOfMembersAccessedInHier;
        }
        return (int)estimatedCellsFromAggregate;
    }

    private static int calcListSize(int estimatedNumberOfAggregateCells) {
        if (estimatedNumberOfAggregateCells > 0x3FFFFFFF) {
            return estimatedNumberOfAggregateCells;
        }
        return (int)((double)estimatedNumberOfAggregateCells * 1.1);
    }

    public static Iterator<TupleValue>[] wrapIteratorsForAggregateCache(List<Iterator<TupleValue>> tvIterList) {
        if (tvIterList.size() == 0) {
            tvIterList = new ArrayList<Iterator<TupleValue>>();
            List emptyList = Collections.emptyList();
            tvIterList.add(emptyList.iterator());
        }
        Iterator[] tvIters = new Iterator[tvIterList.size()];
        return tvIterList.toArray(tvIters);
    }
}

