/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.ILevel;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.MemberLevelInfo;
import com.cognos.xqe.runtree.olap.mdx.metadata.Level;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateDefinition;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.UniqueNameGenerator;
import com.cognos.xqe.util.primitive.HashSetInt;
import com.cognos.xqe.util.primitive.IteratorInt;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class CalculationDescription {
    private static final int MAX_PARENT_MEMBERS_TO_PRINT = 15;
    private static final String LOG_DELIMITER = ", ";
    private final int[] hierarchyRollupDistances;
    private final Set<IMember>[] parentMembers;
    private final IMember[] knownParents;

    private CalculationDescription(int[] aHierarchyRollupDistances, Set<IMember>[] aCalculationMembers, IMember[] aHierarchyKnownParents) {
        this.hierarchyRollupDistances = aHierarchyRollupDistances;
        this.parentMembers = aCalculationMembers;
        this.knownParents = aHierarchyKnownParents;
    }

    public int[] getHierarchyRollupDistances() {
        return this.hierarchyRollupDistances;
    }

    public Set<IMember>[] getParentMembers() {
        return this.parentMembers;
    }

    public IMember[] getKnownParents() {
        return this.knownParents;
    }

    public static List<CalculationDescription> createFor(IHierarchy[] hiers, IMember[][] queryMembers, AggregateDefinition aggregate, Map<IHierarchy, ILevel> hierToAggrLevelMap, Set<IHierarchy> directMatchHierarchies, MemberLevelInfo levelInfo) {
        Map[] membersByLevel = new Map[hiers.length];
        int[][] queryLevels = new int[hiers.length][];
        IMember[] knownParents = new IMember[hiers.length];
        for (int i = 0; i < hiers.length; ++i) {
            if (directMatchHierarchies.contains(hiers[i]) || hiers[i].getDimension().isMeasuresDimension()) {
                queryLevels[i] = new int[1];
                queryLevels[i][0] = queryMembers[i][0].getLevel().getIndex();
                membersByLevel[i] = null;
                if (queryMembers[i].length == 1 && directMatchHierarchies.contains(hiers[i])) {
                    knownParents[i] = queryMembers[i][0];
                    continue;
                }
                knownParents[i] = null;
                continue;
            }
            if (queryMembers[i].length == 1) {
                queryLevels[i] = new int[1];
                queryLevels[i][0] = queryMembers[i][0].getLevel().getIndex();
                membersByLevel[i] = null;
                knownParents[i] = queryMembers[i][0];
                continue;
            }
            HashSetInt inputQueryLevels = levelInfo.getLevelIndexes(hiers[i]);
            queryLevels[i] = new int[inputQueryLevels.size()];
            int j = 0;
            IteratorInt iter = inputQueryLevels.iterator();
            while (iter.hasNext()) {
                int levelNumber;
                queryLevels[i][j] = levelNumber = iter.next();
                ++j;
            }
            membersByLevel[i] = null;
            if (inputQueryLevels.size() > 1) {
                HashSetInt incompleteLevels = new HashSetInt();
                IteratorInt itrInputQueryLevels = inputQueryLevels.iterator();
                while (itrInputQueryLevels.hasNext()) {
                    int levelNumber = itrInputQueryLevels.next();
                    if (levelInfo.isLevelComplete(hiers[i], levelNumber)) continue;
                    incompleteLevels.add(levelNumber);
                }
                if (incompleteLevels.size() > 0) {
                    membersByLevel[i] = CalculationDescription.groupMembersByLevel(queryMembers[i], incompleteLevels);
                }
            }
            knownParents[i] = null;
        }
        List<int[]> uniqueLevelCombinations = AggregateUtilities.arrayCrossProduct(queryLevels);
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.INFO)) {
            CalculationDescription.traceQueryLevels(hiers, queryLevels);
        }
        List<CalculationDescription> calcDescriptions = CalculationDescription.buildDescriptions(hiers, uniqueLevelCombinations, membersByLevel, knownParents, hierToAggrLevelMap);
        return calcDescriptions;
    }

    public static CalculationDescription createFor(List<ILevel> sourceLevels, List<ILevel> targetLevels) {
        if (sourceLevels.size() != targetLevels.size()) {
            throw new IllegalArgumentException("Unequals number of levels specified.  " + sourceLevels.size() + " source levels and " + targetLevels.size() + " target levels.");
        }
        for (int i = 0; i < sourceLevels.size(); ++i) {
            if (sourceLevels.get(i).getHierarchy() == targetLevels.get(i).getHierarchy()) continue;
            throw new IllegalArgumentException("Hierarchies are in a different order.  Index " + i + " has source level of " + sourceLevels.get(i) + " and a target level of " + targetLevels.get(i));
        }
        int[] rollupDistances = new int[sourceLevels.size()];
        IMember[] knownParents = new IMember[sourceLevels.size()];
        Set[] possibleParents = new Set[sourceLevels.size()];
        for (int i = 0; i < sourceLevels.size(); ++i) {
            ILevel sourceLevel = sourceLevels.get(i);
            ILevel targetLevel = targetLevels.get(i);
            rollupDistances[i] = sourceLevel.getIndex() - targetLevel.getIndex();
            if (rollupDistances[i] < 0) {
                throw new IllegalArgumentException("Error, source level " + sourceLevel + " is above target level " + targetLevel);
            }
            knownParents[i] = targetLevel.getCardinality() == 1 ? targetLevel.getMembers().get(0) : null;
            possibleParents[i] = null;
        }
        return new CalculationDescription(rollupDistances, possibleParents, knownParents);
    }

    public String toString() {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        ps.print("Distances:[");
        for (int distance : this.hierarchyRollupDistances) {
            ps.print(distance);
            ps.print(",");
        }
        ps.println("]");
        for (int i = 0; i < this.knownParents.length; ++i) {
            ps.print("hier " + i + "   known parent: " + this.knownParents[i]);
            if (this.parentMembers[i] == null) {
                ps.println("     has no parent members");
                continue;
            }
            if (this.parentMembers[i].size() < 15) {
                ps.println("     parent members: " + this.parentMembers[i]);
                continue;
            }
            ps.println("     has " + this.parentMembers[i].size() + " parent members.");
        }
        ps.close();
        String text = new String(os.toByteArray());
        return text;
    }

    private static List<CalculationDescription> buildDescriptions(IHierarchy[] hiers, List<int[]> queryLevelCombinations, Map<Integer, Set<IMember>>[] membersByLevel, IMember[] initialKnownParents, Map<IHierarchy, ILevel> hierToAggrLevelMap) {
        ArrayList<CalculationDescription> calcDescription = new ArrayList<CalculationDescription>();
        for (int[] queryLevels : queryLevelCombinations) {
            IMember[] hierarchyKnownParents = new IMember[initialKnownParents.length];
            System.arraycopy(initialKnownParents, 0, hierarchyKnownParents, 0, initialKnownParents.length);
            Set[] membersForRollupCalc = new Set[hiers.length];
            int[] rollupDistances = new int[hiers.length];
            for (int i = 0; i < hiers.length; ++i) {
                int aggregateLevel = 0;
                if (!hiers[i].getDimension().isMeasuresDimension()) {
                    aggregateLevel = hierToAggrLevelMap.get(hiers[i]).getIndex();
                }
                rollupDistances[i] = aggregateLevel - queryLevels[i];
                membersForRollupCalc[i] = null;
                ILevel level = hiers[i].getLevel(queryLevels[i]);
                if (level instanceof Level && ((Level)level).isAllLevel()) {
                    hierarchyKnownParents[i] = level.getMembers().get(0);
                    continue;
                }
                if (membersByLevel[i] == null) continue;
                membersForRollupCalc[i] = membersByLevel[i].get(queryLevels[i]);
            }
            calcDescription.add(new CalculationDescription(rollupDistances, membersForRollupCalc, hierarchyKnownParents));
        }
        return calcDescription;
    }

    private static Map<Integer, Set<IMember>> groupMembersByLevel(IMember[] members, HashSetInt levels) {
        HashMap<Integer, Set<IMember>> membersByLevel = new HashMap<Integer, Set<IMember>>();
        boolean[] populateLevel = new boolean[members[0].getHierarchy().getLevelCount()];
        Arrays.fill(populateLevel, false);
        IteratorInt iter = levels.iterator();
        while (iter.hasNext()) {
            int requestedLevel = iter.next();
            populateLevel[requestedLevel] = true;
        }
        for (int i = 0; i < members.length; ++i) {
            int levelIndex = members[i].getLevel().getIndex();
            if (!populateLevel[levelIndex]) continue;
            HashSet<IMember> membersAtLevel = (HashSet<IMember>)membersByLevel.get(levelIndex);
            if (membersAtLevel == null) {
                membersAtLevel = new HashSet<IMember>();
                membersByLevel.put(levelIndex, membersAtLevel);
            }
            membersAtLevel.add(members[i]);
        }
        return membersByLevel;
    }

    private static void traceQueryLevels(IHierarchy[] hiers, int[][] queryLevels) {
        StringBuilder sb = new StringBuilder("Input query levels: ");
        boolean needComma = false;
        for (int i = 0; i < hiers.length; ++i) {
            int[] levelNumbers = queryLevels[i];
            if (levelNumbers.length == 1) {
                if (levelNumbers[0] == 0) continue;
                if (needComma) {
                    sb.append(LOG_DELIMITER);
                }
                sb.append(hiers[i].getLevel(levelNumbers[0]).getUniqueName());
                needComma = true;
                continue;
            }
            if (needComma) {
                sb.append(LOG_DELIMITER);
            }
            sb.append(hiers[i].getUniqueName());
            sb.append(":(");
            for (int j = 0; j < levelNumbers.length; ++j) {
                sb.append(UniqueNameGenerator.createUniqueName(hiers[i].getLevel(levelNumbers[j]).getName()));
                if (j >= levelNumbers.length - 1) continue;
                sb.append(LOG_DELIMITER);
            }
            sb.append(')');
            needComma = true;
        }
        ROLAPLog.log("ROLAPCubes.AggregateCache", sb.toString());
    }
}

