/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import java.util.ArrayList;
import java.util.List;

public final class CellCache {
    private static final int DEFAULT_CACHE_SIZE = 30;
    private final CacheEntry[] cachedCells;
    private int cacheHits = 0;
    private int cacheMisses = 0;
    private int nextCacheLocation = 0;

    public CellCache(IHierarchy[] tupleHiers) {
        this(tupleHiers, 30);
    }

    public CellCache(IHierarchy[] tupleHiers, int numCacheValues) {
        this.cachedCells = new CacheEntry[numCacheValues];
        for (int i = 0; i < numCacheValues; ++i) {
            this.cachedCells[i] = new CacheEntry(tupleHiers);
        }
    }

    public ArrayList<Cell> getCachedCells(IMember[] tupleMembers) {
        int foundCacheIndex = -1;
        for (int i = 0; i < this.cachedCells.length; ++i) {
            if (!this.cachedCells[i].matches(tupleMembers)) continue;
            foundCacheIndex = i;
            break;
        }
        if (foundCacheIndex >= 0) {
            ++this.cacheHits;
            return this.cachedCells[foundCacheIndex].getCells();
        }
        ++this.cacheMisses;
        return null;
    }

    public void putCachedCells(IMember[] tupleMembers, ArrayList<Cell> cells) {
        this.cachedCells[this.nextCacheLocation].updateCacheEntry(tupleMembers, cells);
        this.incrementNextCacheLocation();
    }

    private void incrementNextCacheLocation() {
        ++this.nextCacheLocation;
        if (this.nextCacheLocation >= this.cachedCells.length) {
            this.nextCacheLocation = 0;
        }
    }

    public int getCacheHits() {
        return this.cacheHits;
    }

    public int getCacheMisses() {
        return this.cacheMisses;
    }

    private static final class CacheEntry {
        private final IMember[] members;
        private final ArrayList<Cell> cells;

        CacheEntry(IHierarchy[] tupleHiers) {
            this.members = new IMember[tupleHiers.length];
            this.members[0] = null;
            this.cells = new ArrayList();
        }

        public boolean matches(IMember[] tupleMembers) {
            boolean sameMembers = true;
            for (int i = 0; i < this.members.length; ++i) {
                if (this.members[i] == tupleMembers[i]) continue;
                sameMembers = false;
                break;
            }
            return sameMembers;
        }

        public ArrayList<Cell> getCells() {
            return this.cells;
        }

        public void updateCacheEntry(IMember[] tupleMembers, List<Cell> newCells) {
            System.arraycopy(tupleMembers, 0, this.members, 0, tupleMembers.length);
            this.cells.clear();
            if (newCells.size() == 1) {
                this.cells.add(newCells.get(0));
            } else {
                this.cells.addAll(newCells);
            }
        }
    }
}

