/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.ResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleOrdinalCalculationCache;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AbstractAggregateCalculationTask;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.CalculationDescription;
import com.cognos.xqe.trace.LogLevel;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class ResultSetAggregateCalculationTask
extends AbstractAggregateCalculationTask {
    private final CrossJoinedSet requestSetQuerySet;
    private final CrossJoinedSet resultSetQuerySet;
    private final TupleOrdinalCalculationCache ordinalCalcCacheForCallersResultSet;
    private final TupleOrdinalCalculationCache ordinalCalcCacheForOverfetchResultSet;
    private final List<long[]> cachedTupleOrdinalsList;
    private ResultSet resultSet;
    private ResultSet overfetchResultSet;

    public ResultSetAggregateCalculationTask(ROLAPCube cube, BlockingQueue<AggregateCalculationResult> aResultQueue, IHierarchy[] hierarchies, CrossJoinedSet theRequestedSet, CrossJoinedSet theResultSetQuerySet, List<CalculationDescription> calculcationDescriptions) {
        super(cube, aResultQueue, hierarchies, calculcationDescriptions, null);
        this.resultSetQuerySet = theResultSetQuerySet;
        this.requestSetQuerySet = theRequestedSet;
        this.ordinalCalcCacheForCallersResultSet = new TupleOrdinalCalculationCache(this.resultSetQuerySet);
        this.ordinalCalcCacheForOverfetchResultSet = new TupleOrdinalCalculationCache(this.requestSetQuerySet);
        this.cachedTupleOrdinalsList = new ArrayList<long[]>();
        this.resultSet = new ResultSet(this.resultSetQuerySet);
        this.overfetchResultSet = new ResultSet(this.requestSetQuerySet);
    }

    @Override
    protected boolean calcRollupCellsToUpdate(int calculationIndex, IMember[] rollupMembers, Cell aggregateCell, ArrayList<Cell> cellList) {
        boolean addedCell = false;
        Tuple tuple = new Tuple(rollupMembers, false);
        ResultSet resultSetForCells = this.resultSet;
        List<long[]> resultSetTupleOrdinals = this.resultSet.getTupleOrdinals(tuple, this.ordinalCalcCacheForCallersResultSet, this.cachedTupleOrdinalsList);
        if (resultSetTupleOrdinals.size() == 0) {
            resultSetForCells = this.overfetchResultSet;
            resultSetTupleOrdinals = this.overfetchResultSet.getTupleOrdinals(tuple, this.ordinalCalcCacheForOverfetchResultSet, this.cachedTupleOrdinalsList);
        }
        boolean cellsExist = false;
        for (long[] resultSetTupleOrdinal : resultSetTupleOrdinals) {
            Cell originalQueryCell = resultSetForCells.getCellAtTupleOrdinal(resultSetTupleOrdinal);
            if (originalQueryCell != null) {
                cellList.add(originalQueryCell);
                cellsExist = true;
                continue;
            }
            if (!cellsExist) continue;
            Exception e = new Exception("Cells existed in some ordinal locations, and not in others");
            throw new XQERuntimeException(e);
        }
        if (!cellsExist) {
            ArrayList<long[]> tempResultSetOrdinals = new ArrayList<long[]>();
            for (long[] resultSetTupleOrdinal : resultSetTupleOrdinals) {
                tempResultSetOrdinals.clear();
                tempResultSetOrdinals.add(resultSetTupleOrdinal);
                Cell newCell = new Cell(0L, aggregateCell.getValue().copy());
                resultSetForCells.addCell(tempResultSetOrdinals, newCell, false, false);
                addedCell = true;
            }
        }
        return addedCell;
    }

    @Override
    protected AggregateCalculationResult createResult() {
        return new AggregateCalculationResult(this.resultSet, this.overfetchResultSet);
    }

    @Override
    protected void combineResults(AggregateCalculationResult otherResult) {
        this.resultSet.add(otherResult.getResultSet(), true);
        this.overfetchResultSet.add(otherResult.getOverfetchResultSet(), true);
    }

    @Override
    protected int getResultSize() {
        return this.resultSet.cellCount();
    }

    @Override
    protected String extendLogMsg(String logMsg) {
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
            AggregateUtilities.logResultSet("Aggregate task result: ", this.resultSet);
            AggregateUtilities.logResultSet("Overfetch task result: ", this.overfetchResultSet);
        }
        NumberFormat nf = NumberFormat.getInstance();
        return logMsg.replace("%additional_text%", "with " + nf.format(this.overfetchResultSet.cellCount()) + " cells in the overfetchResultSet.");
    }
}

