/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.NullValue;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AbstractAggregateCalculationTask;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.CalculationDescription;
import com.cognos.xqe.trace.LogLevel;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;

public class TupleValueAggregateCalculationTask
extends AbstractAggregateCalculationTask {
    private static final int ONE_HUNDRED = 100;
    private static final int TEN = 10;
    private static final int FOUR = 4;
    private static final int TEN_MILLION = 10000000;
    private static final int ONE_MILLION = 1000000;
    private static final int ONE_HUNDRED_THOUSAND = 100000;
    private HashMap<Tuple, Cell>[] tupleToCellMaps;
    private final Tuple[] commonTuples;

    public TupleValueAggregateCalculationTask(ROLAPCube cube, BlockingQueue<AggregateCalculationResult> aResultQueue, IHierarchy[] hierarchies, List<CalculationDescription> calculcationDescriptions, int numSourceTuples, List<Set<IMember>> filterMeasures) {
        super(cube, aResultQueue, hierarchies, calculcationDescriptions, filterMeasures);
        this.commonTuples = new Tuple[calculcationDescriptions.size()];
        int hashMapSize = this.guessMapSize(numSourceTuples);
        this.tupleToCellMaps = new HashMap[calculcationDescriptions.size()];
        for (int i = 0; i < this.tupleToCellMaps.length; ++i) {
            this.tupleToCellMaps[i] = new HashMap(hashMapSize);
        }
    }

    private int guessMapSize(int numSourceTuples) {
        if (numSourceTuples == 0) {
            return 1;
        }
        if (numSourceTuples < 100000) {
            return numSourceTuples / 2;
        }
        if (numSourceTuples < 1000000) {
            return numSourceTuples / 4;
        }
        if (numSourceTuples < 10000000) {
            return numSourceTuples / 10;
        }
        return 1000000 + (numSourceTuples - 10000000) / 100;
    }

    @Override
    protected void combineResults(AggregateCalculationResult otherResult) {
        HashMap<Tuple, Cell>[] otherTupleToCellMaps = otherResult.getTupleToCellMaps();
        for (int i = 0; i < this.tupleToCellMaps.length; ++i) {
            this.tupleToCellMaps[i] = TupleValueAggregateCalculationTask.combineResults(this.tupleToCellMaps[i], otherTupleToCellMaps[i]);
        }
    }

    public static HashMap<Tuple, Cell>[] combineResults(HashMap<Tuple, Cell>[] maps1, HashMap<Tuple, Cell>[] maps2) {
        HashMap[] combinedMaps = new HashMap[maps1.length];
        for (int i = 0; i < combinedMaps.length; ++i) {
            combinedMaps[i] = TupleValueAggregateCalculationTask.combineResults(maps1[i], maps2[i]);
        }
        return combinedMaps;
    }

    private static HashMap<Tuple, Cell> combineResults(HashMap<Tuple, Cell> map1, HashMap<Tuple, Cell> map2) {
        HashMap<Tuple, Cell> largerMap;
        HashMap<Tuple, Cell> smallerMap;
        if (map1.size() > map2.size()) {
            smallerMap = map2;
            largerMap = map1;
        } else {
            smallerMap = map1;
            largerMap = map2;
        }
        ArrayList<Cell> cellList = new ArrayList<Cell>();
        int measuresIndex = -1;
        for (Map.Entry<Tuple, Cell> entry : smallerMap.entrySet()) {
            Tuple t = entry.getKey();
            Cell origCell = largerMap.put(t, entry.getValue());
            if (origCell == null) continue;
            if (measuresIndex == -1) {
                measuresIndex = Tuple.getMeasureIndex(entry.getKey(), true);
            }
            cellList.clear();
            cellList.add(entry.getValue());
            TupleValueAggregateCalculationTask.updateExistingCells(cellList, origCell, t.getMembers()[measuresIndex].getRegularAggregate());
        }
        return largerMap;
    }

    @Override
    protected AggregateCalculationResult createResult() {
        return new AggregateCalculationResult(this.tupleToCellMaps);
    }

    @Override
    protected boolean calcRollupCellsToUpdate(int calculationIndex, IMember[] rollupMembers, Cell aggregateCell, ArrayList<Cell> cellList) {
        boolean addedCell = false;
        Tuple commonTuple = this.commonTuples[calculationIndex];
        if (commonTuple == null) {
            this.commonTuples[calculationIndex] = commonTuple = new Tuple(rollupMembers, false);
        } else {
            commonTuple.recalcHashcode();
        }
        Cell c = this.tupleToCellMaps[calculationIndex].get(commonTuple);
        if (c != null) {
            cellList.add(c);
        } else {
            IMember[] mbrs = new IMember[rollupMembers.length];
            System.arraycopy(rollupMembers, 0, mbrs, 0, rollupMembers.length);
            Tuple t = new Tuple(mbrs, false);
            Cell newCell = new Cell(0L, aggregateCell.getValue().copy());
            IValue newCellValue = newCell.getValue();
            if (newCellValue == null || newCellValue instanceof NullValue || newCellValue.isNull()) {
                String errorMsg = "Error, added a cell with a null value for tuple " + t;
                errorMsg = errorMsg + "  Value is " + newCellValue + "  copied from " + aggregateCell.getValue();
                errorMsg = errorMsg + " on aggregateCell " + aggregateCell;
                ROLAPLog.logError("ROLAPCubes.IncrementalUpdates", errorMsg);
            }
            this.tupleToCellMaps[calculationIndex].put(t, newCell);
            addedCell = true;
        }
        return addedCell;
    }

    @Override
    protected int getResultSize() {
        int size = 0;
        for (int i = 0; i < this.tupleToCellMaps.length; ++i) {
            size += this.tupleToCellMaps[i].size();
        }
        return size;
    }

    @Override
    protected String extendLogMsg(String logMsg) {
        if (ROLAPLog.isOn("ROLAPCubes.AggregateCache", LogLevel.TRACE)) {
            for (int i = 0; i < this.tupleToCellMaps.length; ++i) {
                TupleValueAggregateCalculationTask.logTupleValueSet("Thread final values for calculation " + i + " : ", this.tupleToCellMaps[i]);
            }
        }
        return logMsg.replace("%additional_text%", ".");
    }

    public static void logTupleValueSet(String additionalLogMsgTxt, Map<Tuple, Cell> cellMap) {
        NumberFormat nf = NumberFormat.getNumberInstance();
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(os);
        ps.println("Num values = " + cellMap.size());
        int count = 1;
        for (Map.Entry<Tuple, Cell> entry : cellMap.entrySet()) {
            ps.print(nf.format(count));
            ps.print(": ");
            ps.print(entry.getKey());
            ps.print(" --> ");
            ps.println(entry.getValue());
            ++count;
        }
        ps.close();
        String cellMapText = new String(os.toByteArray());
        ROLAPLog.logTrace("ROLAPCubes.AggregateCache", additionalLogMsgTxt + cellMapText);
    }
}

