/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.values.DataValueFactory;
import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.ValueState;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.BaseOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.DoubleNativeValueStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.ByteArrayList;
import com.cognos.xqe.util.primitive.DoubleArrayList;
import com.cognos.xqe.util.primitive.ShortArrayList;

public abstract class AbstractDoubleValueStorage
extends BaseOrdinalValueStorage {
    protected static final XQELogger TRACE_LOGGER = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "TupleStorage", LogLevel.TRACE);
    private static final int VALUE_SIZE = 8;
    private static final int VALUE_FORMAT_ID_SIZE = 2;
    private static final int VALUE_STATE_SIZE = 1;
    private DoubleArrayList valueList = new DoubleArrayList(512);
    private ShortArrayList formatIdList;
    private ByteArrayList valueStateList;
    private double[] doubleValues = null;
    private short[] formatIds = null;
    private short globalFormatId = 0;
    private byte[] valueStates = null;
    private byte globalValueState = 0;

    @Override
    public void putImpl(OrdinalValue ordinalValue) {
        if (this.valueList == null) {
            throw new IllegalStateException("Cannot add a value after fix() has been called.");
        }
        int size = this.valueList.size();
        boolean isFirstValue = size == 0;
        DoubleValue doubleValue = (DoubleValue)ordinalValue.getValue();
        double value = doubleValue.getDouble();
        this.valueList.add(value);
        short currentFormatId = doubleValue.getInternalFormatId();
        if (this.formatIdList != null) {
            this.formatIdList.add(currentFormatId);
        } else if (isFirstValue) {
            this.globalFormatId = currentFormatId;
        } else if (currentFormatId != this.globalFormatId) {
            this.formatIdList = new ShortArrayList(size + 1);
            this.formatIdList.pad(this.globalFormatId, size);
            this.formatIdList.add(currentFormatId);
        }
        byte currentValueState = doubleValue.getState().getState();
        if (this.valueStateList != null) {
            this.valueStateList.add(currentValueState);
        } else if (isFirstValue) {
            this.globalValueState = currentValueState;
        } else if (currentValueState != this.globalValueState) {
            this.valueStateList = new ByteArrayList(size + 1);
            this.valueStateList.pad(this.globalValueState, size);
            this.valueStateList.add(currentValueState);
        }
    }

    @Override
    public void fixImpl() {
        if (this.doubleValues == null) {
            this.doubleValues = this.valueList.toArray();
            this.valueList = null;
            if (this.formatIdList != null) {
                this.formatIds = this.formatIdList.toArray();
                this.formatIdList = null;
            }
            if (this.valueStateList != null) {
                this.valueStates = this.valueStateList.toArray();
                this.valueStateList = null;
            }
        }
    }

    @Override
    protected long estimateSizeToHoldValues() {
        if (this.doubleValues != null) {
            return AbstractDoubleValueStorage.estimateSizeToHoldValues(this.doubleValues.length, this.formatIds == null, this.valueStates != null);
        }
        return AbstractDoubleValueStorage.estimateSizeToHoldValues(this.valueList.size(), this.formatIdList == null, this.valueStateList != null);
    }

    protected static long estimateSizeToHoldValues(long cellCount, boolean cellsHaveSameFormatIds, boolean includeSizeOfValueStates) {
        long estimatedShallowSizeOfValuesStorage = JavaObjectMemorySize.getEstimatedJavaObjectShallowSize(DoubleNativeValueStorage.class);
        long estimatedRetainedSizeOfDoubleValues = JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(8, cellCount);
        long estimatedRetainedSizeOfFormatIds = 0L;
        if (!cellsHaveSameFormatIds) {
            estimatedRetainedSizeOfFormatIds = JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(2, cellCount);
        }
        long estimatedRetainedSizeOfValueStates = 0L;
        if (includeSizeOfValueStates) {
            estimatedRetainedSizeOfValueStates = JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(1, cellCount);
        }
        long estimatedRetainedSizeOfValuesStorage = estimatedShallowSizeOfValuesStorage + estimatedRetainedSizeOfDoubleValues + estimatedRetainedSizeOfFormatIds + estimatedRetainedSizeOfValueStates;
        AbstractDoubleValueStorage.traceEstimatedSize(estimatedShallowSizeOfValuesStorage, estimatedRetainedSizeOfDoubleValues, estimatedRetainedSizeOfFormatIds, estimatedRetainedSizeOfValueStates, estimatedRetainedSizeOfValuesStorage);
        return estimatedRetainedSizeOfValuesStorage;
    }

    private static void traceEstimatedSize(long estimatedShallowSizeOfValuesStorage, long estimatedRetainedSizeOfValuesObject, long estimatedRetainedSizeOfFormatIdsObject, long estimatedRetainedSizeOfValueStatesObject, long estimatedRetainedSizeOfValuesStorage) {
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            String traceStringFormat = "%s = %,d bytes\n";
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("\nEstimated memory usage of valuesStorage:\n", new Object[0]));
            sb.append(String.format(traceStringFormat, "valuesStorage shallow size", estimatedShallowSizeOfValuesStorage));
            sb.append(String.format(traceStringFormat, "values retained size", estimatedRetainedSizeOfValuesObject));
            sb.append(String.format(traceStringFormat, "formatIds retained size", estimatedRetainedSizeOfFormatIdsObject));
            sb.append(String.format(traceStringFormat, "valueStates retained size", estimatedRetainedSizeOfValueStatesObject));
            sb.append(String.format(traceStringFormat, "valuesStorage retained size", estimatedRetainedSizeOfValuesStorage));
            TRACE_LOGGER.log(sb.toString());
        }
    }

    @Override
    protected boolean usesOrdinalValueObjects() {
        return false;
    }

    protected double[] getDoubleValues() {
        return this.doubleValues;
    }

    protected short[] getFormatIds() {
        return this.formatIds;
    }

    protected byte[] getValueStates() {
        return this.valueStates;
    }

    protected DoubleValue buildValue(int position) {
        DoubleValue dv = DataValueFactory.createDoubleValue();
        dv.set(this.doubleValues[position]);
        dv.setInternalFormatId(this.getFormatId(position));
        dv.setState(this.getState(position));
        return dv;
    }

    private short getFormatId(int position) {
        if (this.formatIds != null) {
            return this.formatIds[position];
        }
        return this.globalFormatId;
    }

    private ValueState getState(int position) {
        if (this.valueStates != null) {
            return ValueState.getValueState(this.valueStates[position]);
        }
        return ValueState.getValueState(this.globalValueState);
    }

    protected boolean updateValue(int position, OrdinalValue ov) {
        DoubleValue newValue = (DoubleValue)ov.getValue();
        short existingFormatId = this.getFormatId(position);
        if (existingFormatId != newValue.getFormatId().getInternalValue()) {
            throw new IllegalStateException("Format ids are different for value " + newValue + " at ordinal  " + ov.getOrdinal() + "  Existing formatId " + existingFormatId + " new formatId " + newValue.getInternalFormatId());
        }
        ValueState existingState = this.getState(position);
        if (!existingState.equals((Object)newValue.getState())) {
            throw new IllegalStateException("State is different for value " + newValue + " at ordinal " + ov.getOrdinal() + "  Existing state " + (Object)((Object)existingState) + " new state " + (Object)((Object)newValue.getState()));
        }
        this.doubleValues[position] = ((DoubleValue)ov.getValue()).getDouble();
        return true;
    }
}

