/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletIntersectionAction;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletLookupThreadReturnType;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;

public abstract class AbstractQueuedIntersectionAction
implements CubeletIntersectionAction {
    protected BlockingQueue<CubeletLookupThreadReturnType> resultQueue = null;
    private int numIntersectionTasks;
    protected int numValuesToPost = 0;

    protected void initialize(int numTasks, Cubelet cubelet, boolean supportsParallelAddCell) {
        this.numIntersectionTasks = numTasks;
        if (numTasks > 1 && !supportsParallelAddCell) {
            this.numValuesToPost = Cubelet.getNumTuplesInBlockToReturn();
            int maxNumMsgs = (int)(cubelet.getNumValues() / (long)this.numValuesToPost + (long)numTasks);
            this.resultQueue = new ArrayBlockingQueue<CubeletLookupThreadReturnType>(maxNumMsgs);
        }
    }

    @Override
    public void intersectionTasksRunning() {
        if (this.resultQueue != null) {
            int completedTasks = 0;
            while (completedTasks < this.numIntersectionTasks) {
                CubeletLookupThreadReturnType calcThreadData = null;
                try {
                    calcThreadData = this.resultQueue.take();
                }
                catch (InterruptedException e) {
                    throw new XQERuntimeException(e);
                }
                if (calcThreadData.isFinished()) {
                    ++completedTasks;
                }
                this.messageReceived(calcThreadData);
            }
        }
    }

    @Override
    public void intersectionFinished(XQERuntimeException error) {
    }

    public abstract void messageReceived(CubeletLookupThreadReturnType var1);
}

