/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.dmrprovider.IDMRMember;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AdaptiveCubeletStorageManager;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorage;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.primitive.HashSetInt;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class AdaptiveCubeletStorage
extends CubeletStorage {
    private AdaptiveCubeletStorageManager storageManager;

    public AdaptiveCubeletStorage(AdaptiveCubeletStorageManager ownerStorage) {
        super(null);
        this.storageManager = ownerStorage;
    }

    @Override
    protected boolean multipleHierarchySupport() {
        return false;
    }

    @Override
    protected List<IHierarchy> getHierarchies() {
        return this.storageManager.getHierarchies();
    }

    @Override
    protected Cubelet createNewCubelet(ISet querySet, Iterator<TupleValue> tupleValues, String hint) {
        return new CubeletImp(querySet, tupleValues, this, hint);
    }

    public void addCubelet(int[][] intQuerySet, IOrdinalValueStorage valuesStorage, long[] pageSizes, HashMapIntObject<IMember>[] membersMapArray, HashSetInt[] levelsArray) {
        this.addCubelet(new CubeletImp(intQuerySet, valuesStorage, pageSizes, membersMapArray, levelsArray, this));
    }

    public void appendNewHierarchiesToCubelets(ArrayList<IMember> newRootMembers) {
        for (CubeletImp cubeletImp : this.tupleStorage.getCache()) {
            cubeletImp.appendNewHierarchiesToCubelets(newRootMembers);
        }
    }

    @Override
    public void maintain(double pctOfCubeletsToForceEvict) {
        this.storageManager.getReadLock().lock();
        try {
            super.maintain(pctOfCubeletsToForceEvict);
        }
        finally {
            this.storageManager.getReadLock().unlock();
        }
    }

    private final class CubeletImp
    extends Cubelet {
        private AdaptiveCubeletStorage ownerStorage;

        protected CubeletImp(ISet set, Iterator<TupleValue> tupleValues, AdaptiveCubeletStorage owner, String cubeletID) {
            super(set, tupleValues, cubeletID);
            this.ownerStorage = owner;
        }

        protected CubeletImp(int[][] querySet, IOrdinalValueStorage vStorage, long[] pSizes, HashMapIntObject<IMember>[] membersMapArray, HashSetInt[] levelsArray, AdaptiveCubeletStorage owner) {
            this.intQuerySet = querySet;
            this.valuesStorage = vStorage;
            this.numValues = vStorage.getNumValues();
            this.valuesStorage.fix(this.numValues);
            this.pageSizes = pSizes;
            this.membersMap = membersMapArray;
            this.selectionLevels = levelsArray;
            this.ownerStorage = owner;
            this.estimatedMemoryUsage = Long.MIN_VALUE;
            this.getMemoryUsage();
        }

        @Override
        protected List<IHierarchy> getHierachies() {
            return this.ownerStorage.getHierarchies();
        }

        @Override
        protected int getMemberIndex(IMember mun) {
            return ((IDMRMember)mun).getIndex();
        }

        protected void appendNewHierarchiesToCubelets(ArrayList<IMember> newRootMembers) {
            int length = this.intQuerySet.length;
            int newLength = length + newRootMembers.size();
            int[][] oldQuerySet = this.intQuerySet;
            this.intQuerySet = new int[newLength][];
            HashMapIntObject[] oldMembersMap = this.membersMap;
            this.membersMap = (HashMapIntObject[])ArrayCast.uncheckedCast(new HashMapIntObject[newLength]);
            int j = 0;
            for (int i = 0; i < newLength; ++i) {
                if (i < length) {
                    this.intQuerySet[i] = oldQuerySet[i];
                    this.membersMap[i] = oldMembersMap[i];
                    continue;
                }
                IMember mun = newRootMembers.get(j);
                int index = ((IDMRMember)mun).getIndex();
                this.intQuerySet[i] = new int[1];
                this.intQuerySet[i][0] = index;
                this.membersMap[i] = new HashMapIntObject(1);
                this.membersMap[i].put(index, mun);
                ++j;
            }
            this.computePageSizes();
        }
    }
}

