/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.data.types.IDataType;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IIncrementalOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.primitive.HashMapObjectLong;

public abstract class BaseOrdinalValueStorage
implements IOrdinalValueStorage {
    protected static final int INITIAL_SIZE = 512;
    private HashMapObjectLong<IDataType> typeCount = new HashMapObjectLong();
    private long estimatedSize = 0L;
    protected int valuesCount;
    protected int incrementId = 0;
    private IIncrementalOrdinalValueStorage next = null;

    @Override
    public final boolean get(OrdinalValue ordinalValue) {
        return this.getImpl(ordinalValue);
    }

    protected abstract boolean getImpl(OrdinalValue var1);

    @Override
    public final void put(OrdinalValue ordinalValue) {
        IDataType dataType = ordinalValue.getValue().getDataType();
        long aCount = this.typeCount.get(dataType);
        this.typeCount.put(dataType, aCount + 1L);
        ++this.valuesCount;
        this.putImpl(ordinalValue);
    }

    protected abstract void putImpl(OrdinalValue var1);

    @Override
    public final void fix(int numValues) {
        this.valuesCount = numValues;
        this.fixImpl();
        this.estimatedSize = this.valuesCount == 0 ? 0L : this.calcEstimatedSize(this.typeCount);
        this.typeCount = null;
    }

    protected abstract void fixImpl();

    protected abstract long estimateSizeToHoldValues();

    @Override
    public final long estimateMemoryUsage() {
        if (this.estimatedSize == 0L && this.typeCount != null) {
            return this.calcEstimatedSize(this.typeCount);
        }
        return this.estimatedSize;
    }

    protected boolean usesOrdinalValueObjects() {
        return true;
    }

    private long calcEstimatedSize(HashMapObjectLong<IDataType> dataTypeCount) {
        long size = 0L;
        if (this.usesOrdinalValueObjects()) {
            if (dataTypeCount.size() == 0) {
                size = 0L;
            } else {
                size = 1L;
                for (IDataType type : dataTypeCount.keySet()) {
                    long count = dataTypeCount.get(type);
                    long totalSizeForObjectsOfThatType = 0L;
                    int dataTypeSize = type.sizeOf();
                    if (dataTypeSize >= 0) {
                        long valueSize = Value.getMemorySize(dataTypeSize, 0);
                        totalSizeForObjectsOfThatType = (valueSize + OrdinalValue.getMemorySize()) * count;
                    } else {
                        long sizeOfObjects = 0L;
                        OrdinalValue ov = this.createOrdinalValue();
                        for (int i = 0; i < this.valuesCount; ++i) {
                            this.get(i, ov);
                            IValue value = ov.getValue();
                            if (value == null || value.getDataType() != type || !(value instanceof ObjectValue)) continue;
                            Object objValue = ((ObjectValue)value).getObject();
                            if (objValue instanceof Set) {
                                sizeOfObjects += ((Set)objValue).sizeOf();
                                continue;
                            }
                            XQELogger mErrorLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);
                            mErrorLogger.log(LogLevel.ERROR, "Need to expand BaseOrdinalValueStorage for unexpected class stored in a cubelet ObjectValue: " + objValue.getClass());
                        }
                        totalSizeForObjectsOfThatType = sizeOfObjects + OrdinalValue.getMemorySize() * count;
                    }
                    size += totalSizeForObjectsOfThatType;
                }
            }
        }
        size += this.estimateSizeToHoldValues();
        if (this.next != null) {
            size += this.next.estimateMemoryUsage();
        }
        return size;
    }

    @Override
    public int getNumValues() {
        return this.valuesCount;
    }

    @Override
    public int getIncrementId() {
        return this.incrementId;
    }

    public void setIncrementId(int theIncrementId) {
        this.incrementId = theIncrementId;
    }

    @Override
    public IIncrementalOrdinalValueStorage getNext() {
        return this.next;
    }

    @Override
    public void setNext(IIncrementalOrdinalValueStorage nextStorage) {
        this.next = nextStorage;
    }

    @Override
    public OrdinalValue createOrdinalValue() {
        return new OrdinalValue(0L, null);
    }
}

