/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.ObjectValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.ICube;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.metadata.NullMember;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockletFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.VectorValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ArrayOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ArrayVectorValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ArrayCast;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.cognos.xqe.util.primitive.IntArrayList;
import com.cognos.xqe.util.primitive.IntList;
import com.cognos.xqe.util.primitive.LongArrayList;
import com.cognos.xqe.util.primitive.LongList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class Blocklet
extends Cubelet {
    String key;
    boolean[] isNonDegenerated;
    private final int incrementId;

    protected Blocklet() {
        this.incrementId = MultiRequestContext.getCurrentIncrementId(this.cube);
    }

    public Blocklet(String cacheKey, ISet set, Iterator<TupleValue> tupleValues) {
        super(set, tupleValues, null);
        this.key = cacheKey;
        this.isNonDegenerated = new boolean[((Cube)this.cube).getHierarchies().size()];
        this.setDegenerated(set);
        this.incrementId = MultiRequestContext.getCurrentIncrementId(this.cube);
        this.validateSet();
    }

    public Blocklet(String cacheKey, ICube parentCube, IValue defValue) {
        this.cube = parentCube;
        this.key = cacheKey;
        this.isNonDegenerated = new boolean[((Cube)this.cube).getHierarchies().size()];
        this.defaultValue = defValue;
        this.incrementId = MultiRequestContext.getCurrentIncrementId(this.cube);
    }

    private void validateSet() {
        if (this.isLargeSet()) {
            throw new UnsupportedOperationException("Blocklets do not yet support sets > 2**63");
        }
    }

    @Override
    protected void buildAxes(ISet set) {
        IHierarchy[] setHierarchies = set.getHierarchies();
        int hierCount = setHierarchies.length;
        this.cube = setHierarchies[0].getDimension().getCube();
        this.membersMap = (HashMapIntObject[])ArrayCast.uncheckedCast(new HashMapIntObject[hierCount]);
        this.intQuerySet = new int[hierCount][];
        TreeMap<Integer, IHierarchy> mapHierInCubeOrder = new TreeMap<Integer, IHierarchy>();
        List<IHierarchy> cubeHierarchies = ((Cube)this.cube).getHierarchies();
        for (IHierarchy setHier : setHierarchies) {
            int setHierIdx = cubeHierarchies.indexOf(setHier);
            mapHierInCubeOrder.put(setHierIdx, setHier);
        }
        int i = 0;
        for (Map.Entry setHierichyEntry : mapHierInCubeOrder.entrySet()) {
            IMember[] selectionsMemArray = (IMember[])ArrayCast.uncheckedCast(((Set)set).getMembers((IHierarchy)setHierichyEntry.getValue()));
            this.membersMap[i] = new HashMapIntObject(selectionsMemArray.length);
            this.intQuerySet[i] = new int[selectionsMemArray.length];
            for (int j = 0; j < selectionsMemArray.length; ++j) {
                int memberId;
                this.intQuerySet[i][j] = memberId = this.getMemberIndex(selectionsMemArray[j]);
                this.membersMap[i].put(memberId, selectionsMemArray[j]);
            }
            Arrays.sort(this.intQuerySet[i]);
            ++i;
        }
    }

    public BlockletFetchResult fetch(BlockletFetchResult request) {
        ArrayList<long[][]> exceptOrdList = new ArrayList<long[][]>();
        if (this.defaultValue != null) {
            request.setDefaultValue(this.defaultValue);
            request.setSelectionsToFetch(exceptOrdList);
            return request;
        }
        List<long[][]> requestOrdList = request.getSelectionsToFetch();
        for (long[][] requestOrd : requestOrdList) {
            ISet[] requestSets = null;
            requestSets = requestOrd.length > 1 ? request.getRequestSets() : new ISet[]{request.getRequestSet()};
            IntersectionResult intResult = this.setIntersect(requestOrd, requestSets);
            if (intResult == null) {
                return request;
            }
            List<long[][]> newOrdList = intResult.getNextOrdinalRequest(requestOrd);
            LongList looseTupleOffsets = this.dataIntersect(intResult, request);
            if (looseTupleOffsets.size() > 0) {
                newOrdList.add(new long[][]{looseTupleOffsets.toArray()});
            }
            if (newOrdList.size() <= 0) continue;
            exceptOrdList.addAll(newOrdList);
        }
        request.setSelectionsToFetch(exceptOrdList);
        return request;
    }

    private IntersectionResult setIntersect(long[][] requestOrdinals, ISet[] requestSets) {
        int[][] hierarchyMap = this.mapSetHierarchiesToBlockletHierarchies(requestSets);
        if (hierarchyMap == null) {
            return null;
        }
        int[][] intersectSet = new int[this.intQuerySet.length][];
        long[][] intersectSetOrds = new long[requestOrdinals.length][];
        long[][] exceptSet = new long[requestOrdinals.length][];
        for (int setIdx = 0; setIdx < requestOrdinals.length; ++setIdx) {
            int setHierCount = hierarchyMap[setIdx].length;
            IntList[] intersectDataOffsets = new IntList[setHierCount];
            for (int hierIdx = 0; hierIdx < setHierCount; ++hierIdx) {
                if (hierarchyMap[setIdx][hierIdx] == -1) continue;
                intersectDataOffsets[hierIdx] = new IntArrayList(requestOrdinals[setIdx].length);
            }
            LongArrayList intersectReqOffset = new LongArrayList(requestOrdinals[setIdx].length);
            LongArrayList exceptOffsets = new LongArrayList(requestOrdinals[setIdx].length);
            for (int tupleIdx = 0; tupleIdx < requestOrdinals[setIdx].length; ++tupleIdx) {
                int hierIdx;
                int[] tupleOffsets = new int[setHierCount];
                boolean subTupleFound = true;
                ITuple reqSubTuple = requestSets[setIdx].getTuple(requestOrdinals[setIdx][tupleIdx]);
                for (hierIdx = 0; hierIdx < setHierCount; ++hierIdx) {
                    if (hierarchyMap[setIdx][hierIdx] == -1) continue;
                    IMember member = reqSubTuple.getMember(hierIdx);
                    int memberId = this.getMemberIndex(member);
                    int position = Arrays.binarySearch(this.intQuerySet[hierarchyMap[setIdx][hierIdx]], memberId);
                    if (position >= 0) {
                        tupleOffsets[hierIdx] = position;
                        continue;
                    }
                    subTupleFound = false;
                    break;
                }
                if (subTupleFound) {
                    for (hierIdx = 0; hierIdx < setHierCount; ++hierIdx) {
                        if (hierarchyMap[setIdx][hierIdx] == -1) continue;
                        intersectDataOffsets[hierIdx].add(tupleOffsets[hierIdx]);
                    }
                    intersectReqOffset.add(requestOrdinals[setIdx][tupleIdx]);
                    continue;
                }
                exceptOffsets.add(requestOrdinals[setIdx][tupleIdx]);
            }
            if (intersectReqOffset.size() == 0) {
                return new IntersectionResult(requestOrdinals, new int[0][], new long[0][]);
            }
            for (int hierIdx = 0; hierIdx < setHierCount; ++hierIdx) {
                if (hierarchyMap[setIdx][hierIdx] == -1) continue;
                intersectSet[hierarchyMap[setIdx][hierIdx]] = intersectDataOffsets[hierIdx].toArray();
            }
            intersectSetOrds[setIdx] = intersectReqOffset.toArray();
            exceptSet[setIdx] = exceptOffsets.toArray();
        }
        return new IntersectionResult(exceptSet, intersectSet, intersectSetOrds);
    }

    private LongList dataIntersect(IntersectionResult intResult, BlockletFetchResult result) {
        int[][] intersectSet = intResult.getIntersect();
        long[][] intersectTupleOrd = intResult.getIntersectOrdinals();
        LongArrayList exceptSetLooseTuples = new LongArrayList();
        if (intersectSet == null || intersectSet.length == 0) {
            return exceptSetLooseTuples;
        }
        ISet requestSet = result.getRequestSet();
        ISet[] requestSetList = result.getRequestSets();
        Object hierarchyMap = null;
        if (intersectTupleOrd.length > 1) {
            hierarchyMap = this.mapSetHierarchiesToBlockletHierarchies(requestSetList);
        } else {
            hierarchyMap = new int[][]{this.mapSetHierarchiesToBlockletHierarchies(requestSet)};
            requestSetList = new ISet[]{requestSet};
        }
        int[] currentSetOffsets = new int[this.intQuerySet.length];
        int[] memberIDs = new int[this.intQuerySet.length];
        int[] currentIndices = new int[intersectTupleOrd.length];
        long[] intersectSetSizes = new long[intersectTupleOrd.length];
        long[] requestSetSizes = new long[intersectTupleOrd.length];
        for (int i = 0; i < intersectTupleOrd.length; ++i) {
            intersectSetSizes[i] = intersectTupleOrd[i].length;
            requestSetSizes[i] = requestSetList[i].size();
        }
        long[] setOrd = new long[intersectTupleOrd.length];
        OrdinalValue searchKey = this.valuesStorage.createOrdinalValue();
        boolean isVectorAddressing = searchKey instanceof VectorValue;
        List<TupleValue> tupleValues = result.getTuplesValues();
        boolean more = true;
        while (more) {
            for (int setIdx = 0; setIdx < intersectTupleOrd.length; ++setIdx) {
                int setHierCount = hierarchyMap[setIdx].length;
                for (int hierIdx = 0; hierIdx < setHierCount; ++hierIdx) {
                    if (hierarchyMap[setIdx][hierIdx] == -1) continue;
                    int memberInTupleIndex = hierarchyMap[setIdx][hierIdx];
                    currentSetOffsets[memberInTupleIndex] = intersectSet[memberInTupleIndex][currentIndices[setIdx]];
                    memberIDs[memberInTupleIndex] = this.intQuerySet[memberInTupleIndex][currentSetOffsets[memberInTupleIndex]];
                }
                setOrd[setIdx] = intersectTupleOrd[setIdx][currentIndices[setIdx]];
            }
            long reqSetOrd = this.getCrossjoinOrdinal(setOrd, requestSetSizes);
            if (isVectorAddressing) {
                ((VectorValue)searchKey).setMemberIds(memberIDs);
            } else {
                long ordinal = this.computeOrdinalFromSetOffsets(currentSetOffsets);
                searchKey.setOrdinal(ordinal);
            }
            if (this.valuesStorage.get(searchKey)) {
                ITuple dataTuple = requestSet.getTuple(reqSetOrd);
                IMember[] reOrderedMembers = new IMember[dataTuple.size()];
                int memberIdx = 0;
                for (int setIdx = 0; setIdx < intersectTupleOrd.length; ++setIdx) {
                    int setHierCount = requestSetList[setIdx].getHierarchies().length;
                    for (int hierIdx = 0; hierIdx < setHierCount; ++hierIdx) {
                        if (hierarchyMap[setIdx][hierIdx] == -1) continue;
                        reOrderedMembers[hierarchyMap[setIdx][hierIdx]] = dataTuple.getMember(memberIdx++);
                    }
                }
                dataTuple = new Tuple(reOrderedMembers);
                tupleValues.add(new TupleValue(dataTuple, new Cell(reqSetOrd, searchKey.getValue())));
            } else {
                exceptSetLooseTuples.add(reqSetOrd);
            }
            more = this.nextOrdinal(currentIndices, intersectTupleOrd.length - 1, intersectSetSizes);
        }
        return exceptSetLooseTuples;
    }

    private int[][] mapSetHierarchiesToBlockletHierarchies(ISet[] sets) {
        int[][] hierarchyMap = new int[sets.length][];
        List<IHierarchy> cubeHierarchies = this.getHierachiesInSets(sets);
        for (int i = 0; i < sets.length; ++i) {
            hierarchyMap[i] = this.mapSetHierarchiesToBlockletHierarchiesInSets(sets[i], cubeHierarchies);
            if (hierarchyMap[i] != null) continue;
            return null;
        }
        return hierarchyMap;
    }

    private int[] mapSetHierarchiesToBlockletHierarchies(ISet set) {
        List<IHierarchy> cubeHierarchies = this.getHierachiesInSets(new ISet[]{set});
        return this.mapSetHierarchiesToBlockletHierarchiesInSets(set, cubeHierarchies);
    }

    private int[] mapSetHierarchiesToBlockletHierarchiesInSets(ISet set, List<IHierarchy> blockletHierarchiesInSets) {
        IHierarchy[] setHierarchies = set.getHierarchies();
        int[] hierarchyMap = new int[setHierarchies.length];
        for (int i = 0; i < hierarchyMap.length; ++i) {
            hierarchyMap[i] = blockletHierarchiesInSets.indexOf(setHierarchies[i]);
        }
        return hierarchyMap;
    }

    private long getCrossjoinOrdinal(long[] setOrdinal, long[] setSizes) {
        int cjOrd = 0;
        int setWeight = 1;
        for (int i = setSizes.length - 1; i >= 0; --i) {
            cjOrd = (int)((long)cjOrd + setOrdinal[i] * (long)setWeight);
            setWeight = (int)((long)setWeight * setSizes[i]);
        }
        return cjOrd;
    }

    private boolean nextOrdinal(int[] currentIndices, int currentSet, long[] setSize) {
        if (currentSet < 0) {
            return false;
        }
        int n = currentSet;
        currentIndices[n] = currentIndices[n] + 1;
        if ((long)currentIndices[n] >= setSize[currentSet]) {
            currentIndices[currentSet] = 0;
            return this.nextOrdinal(currentIndices, currentSet - 1, setSize);
        }
        return true;
    }

    @Override
    protected int getMemberIndex(IMember member) {
        if (member.isCalculatedMember() || member instanceof NullMember) {
            return -1;
        }
        return ((Cube)this.cube).getMemberIndex(member);
    }

    @Override
    protected void setStoredDataType(IValue value) {
        Object objValue;
        this.storedDataType = value.getDataType().toString();
        if (value instanceof ObjectValue && (objValue = ((ObjectValue)value).getObject()) instanceof Set) {
            this.storedDataType = "Set";
        }
    }

    public String getKey() {
        return this.key;
    }

    public Blocklet merge(Blocklet fromBlocklet) {
        int i;
        boolean isVectorAddressing;
        long ticks = System.currentTimeMillis();
        Blocklet retBlocklet = new Blocklet();
        retBlocklet.key = this.key;
        retBlocklet.isNonDegenerated = (boolean[])this.isNonDegenerated.clone();
        if (!this.key.equalsIgnoreCase(fromBlocklet.key) || !this.contains(fromBlocklet)) {
            return null;
        }
        retBlocklet.cube = this.cube;
        retBlocklet.membersMap = (HashMapIntObject[])this.membersMap.clone();
        retBlocklet.intQuerySet = (int[][])this.intQuerySet.clone();
        if (this.pageSizes != null) {
            retBlocklet.pageSizes = (long[])this.pageSizes.clone();
        }
        retBlocklet.numQuerySetTuples = this.numQuerySetTuples;
        boolean bl = isVectorAddressing = !this.isStoringByOrdinals();
        if (isVectorAddressing) {
            retBlocklet.valuesStorage = new ArrayVectorValueStorage();
            isVectorAddressing = true;
        } else {
            retBlocklet.valuesStorage = new ArrayOrdinalValueStorage();
        }
        int myNumValues = this.valuesStorage.getNumValues();
        for (int i2 = 0; i2 < myNumValues; ++i2) {
            OrdinalValue ordVal = this.valuesStorage.get(i2, null);
            retBlocklet.valuesStorage.put(ordVal);
        }
        int fromBlockletNumValues = fromBlocklet.valuesStorage.getNumValues();
        if (this.membersMap.length == fromBlocklet.membersMap.length || isVectorAddressing) {
            for (i = 0; i < fromBlockletNumValues; ++i) {
                OrdinalValue ordVal = fromBlocklet.valuesStorage.get(i, null);
                retBlocklet.valuesStorage.put(ordVal);
            }
        } else {
            for (i = 0; i < fromBlockletNumValues; ++i) {
                OrdinalValue ordVal = fromBlocklet.valuesStorage.get(i, null);
                int[] memberIds = fromBlocklet.getMemberIDs(ordVal.getOrdinal());
                int[] memberOffsets = new int[this.intQuerySet.length];
                if ((memberOffsets = Blocklet.findOffset(this.intQuerySet, memberIds, memberOffsets)) == null) {
                    throw new XQERuntimeException();
                }
                long ordinal = this.computeOrdinalFromSetOffsets(memberOffsets);
                ordVal.setOrdinal(ordinal);
                retBlocklet.valuesStorage.put(ordVal);
            }
        }
        retBlocklet.numValues = this.numValues + fromBlocklet.numValues;
        retBlocklet.valuesStorage.fix(retBlocklet.numValues);
        long valuesMemory = fromBlocklet.valuesStorage.estimateMemoryUsage();
        retBlocklet.estimatedMemoryUsage = valuesMemory == -1L ? this.estimatedMemoryUsage : this.estimatedMemoryUsage + valuesMemory;
        if (traceLogger.isOn(LogLevel.TRACE)) {
            long ticks2 = System.currentTimeMillis() - ticks;
            traceLogger.log("Blocklet merge Time: " + ticks2);
        }
        return retBlocklet;
    }

    private int[] getMemberIDs(long ordinal) {
        int[] offsets = new int[this.intQuerySet.length];
        int[] memberIDs = new int[this.intQuerySet.length];
        long weight = 1L;
        for (int i = this.intQuerySet.length - 1; i >= 0; --i) {
            offsets[i] = (int)(ordinal / weight) % this.intQuerySet[i].length;
            memberIDs[i] = this.intQuerySet[i][offsets[i]];
            weight *= (long)this.intQuerySet[i].length;
        }
        return memberIDs;
    }

    public boolean isNonDegenerated(int hierCubeIndex) {
        return this.isNonDegenerated[hierCubeIndex];
    }

    private void setDegenerated(ISet set) {
        List<IHierarchy> setHierarchies = Arrays.asList(set.getHierarchies());
        List<IHierarchy> cubeHierarchies = ((Cube)this.cube).getHierarchies();
        for (int i = 0; i < cubeHierarchies.size(); ++i) {
            int setHierIdx = setHierarchies.indexOf(cubeHierarchies.get(i));
            this.isNonDegenerated[i] = setHierIdx != -1;
        }
    }

    @Override
    protected List<IHierarchy> getHierachies() {
        List<IHierarchy> cubeHierarchies = ((Cube)this.cube).getHierarchies();
        ArrayList<IHierarchy> blockHierarchies = new ArrayList<IHierarchy>();
        for (int i = 0; i < cubeHierarchies.size(); ++i) {
            if (!this.isNonDegenerated(i)) continue;
            blockHierarchies.add(cubeHierarchies.get(i));
        }
        return blockHierarchies;
    }

    private List<IHierarchy> getHierachiesInSets(ISet[] sets) {
        List<IHierarchy> cubeHierarchies = ((Cube)this.cube).getHierarchies();
        ArrayList<IHierarchy> setsHierarchies = new ArrayList<IHierarchy>();
        for (int i = 0; i < sets.length; ++i) {
            IHierarchy[] setHierarchies = sets[i].getHierarchies();
            for (int j = 0; j < setHierarchies.length; ++j) {
                setsHierarchies.add(setHierarchies[j]);
            }
        }
        ArrayList<IHierarchy> blockletHierarchies = new ArrayList<IHierarchy>();
        for (int i = 0; i < cubeHierarchies.size(); ++i) {
            if (!this.isNonDegenerated(i) || setsHierarchies.indexOf(cubeHierarchies.get(i)) == -1) continue;
            blockletHierarchies.add(cubeHierarchies.get(i));
        }
        return blockletHierarchies;
    }

    @Override
    public int getBaseIncrementId() {
        return this.incrementId;
    }

    private final class IntersectionResult {
        private final int[][] intersectOffsets;
        private final long[][] intersectOrdinals;
        private final long[][] exceptOrdinals;

        IntersectionResult(long[][] exceptOrd, int[][] intOffsets, long[][] intOrd) {
            this.exceptOrdinals = exceptOrd;
            this.intersectOffsets = intOffsets;
            this.intersectOrdinals = intOrd;
        }

        public int[][] getIntersect() {
            return this.intersectOffsets;
        }

        public long[][] getIntersectOrdinals() {
            return this.intersectOrdinals;
        }

        public List<long[][]> getNextOrdinalRequest(long[][] requestOrdinals) {
            ArrayList<long[][]> ordList = new ArrayList<long[][]>();
            if (this.exceptOrdinals == null || this.exceptOrdinals.length == 0) {
                return ordList;
            }
            boolean allMissing = false;
            boolean allFound = true;
            for (int i = 0; i < this.exceptOrdinals.length; ++i) {
                if (this.intersectOrdinals.length == 0 || this.intersectOrdinals[i].length == 0) {
                    allMissing = true;
                    break;
                }
                if (!allFound || this.exceptOrdinals[i].length <= 0) continue;
                allFound = false;
            }
            if (allMissing) {
                ordList.add(requestOrdinals);
                return ordList;
            }
            if (allFound) {
                return ordList;
            }
            long[][] nextSetOrdinals = new long[this.intersectOrdinals.length][];
            for (int setIdx = 0; setIdx < this.intersectOrdinals.length; ++setIdx) {
                int i;
                if (this.intersectOrdinals[setIdx].length > 0) {
                    nextSetOrdinals[setIdx] = this.intersectOrdinals[setIdx];
                    if (this.exceptOrdinals[setIdx].length == 0) {
                        continue;
                    }
                } else {
                    nextSetOrdinals[setIdx] = this.exceptOrdinals[setIdx];
                }
                long[][] nextOrdinals = new long[this.intersectOrdinals.length][];
                for (i = 0; i < setIdx; ++i) {
                    nextOrdinals[i] = nextSetOrdinals[i];
                }
                nextOrdinals[setIdx] = this.exceptOrdinals[setIdx];
                for (i = setIdx + 1; i < requestOrdinals.length; ++i) {
                    nextOrdinals[i] = requestOrdinals[i];
                }
                ordList.add(nextOrdinals);
                if (this.exceptOrdinals[setIdx].length == requestOrdinals[setIdx].length) break;
            }
            return ordList;
        }
    }
}

