/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.runtree.olap.mdx.metadata.CubeManager;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeManager;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.SingletonHelper;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

public class CubeletMaintenanceService {
    private static final int DEFAULT_MAINTENANCE_INTERVAL_SECONDS = 60;
    private static SingletonHelper<CubeletMaintenanceService> singletonHelper = new SingletonHelper<CubeletMaintenanceService>(){

        @Override
        protected CubeletMaintenanceService newInstance() {
            return new CubeletMaintenanceService();
        }

        @Override
        protected void initializeImpl(CubeletMaintenanceService theInstance) {
        }

        @Override
        protected void releaseImpl(CubeletMaintenanceService theInstance) {
            theInstance.release();
        }
    };
    private static long maintenanceInterval;
    private CubeletMaintenanceThread serviceThread = new CubeletMaintenanceThread();

    public static CubeletMaintenanceService getInstance() {
        return singletonHelper.getInstance();
    }

    public static void releaseInstance() {
        singletonHelper.releaseInstance();
    }

    protected int getMaintenanceQueueSize() {
        return this.serviceThread.getQueueSize();
    }

    public CubeletMaintenanceService() {
        this.initialize();
    }

    public void initialize() {
        this.serviceThread.setDaemon(true);
        this.serviceThread.start();
    }

    public void release() {
    }

    public void maintain(CubeletStorage cs, double forceCubeletEvictPct) {
        this.serviceThread.addToQueue(cs, forceCubeletEvictPct);
    }

    static {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        maintenanceInterval = configuration.getIntegerProperty("queryExecution.MDXEngineCellCache.MaintenanceTimeInterval[@value]", 60) * 1000;
    }

    private static class CubeletMaintenanceThread
    extends Thread {
        private CubeManager cubeManager;
        private LinkedBlockingQueue<CubeletMaintenanceRequest> cubeletStorageQueue = new LinkedBlockingQueue();
        private static XQELogger log = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "Exception", LogLevel.ERROR);

        CubeletMaintenanceThread() {
            super("CubeletMaintenanceService-Thread");
            this.cubeManager = CubeManager.getCubeManager();
        }

        public void addToQueue(CubeletStorage cs, double forceCubeletEvictPct) {
            CubeletMaintenanceRequest request = new CubeletMaintenanceRequest(cs, forceCubeletEvictPct);
            if (!this.cubeletStorageQueue.contains(request)) {
                this.cubeletStorageQueue.offer(request);
            }
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        CubeletMaintenanceRequest mr;
                        if ((mr = this.cubeletStorageQueue.poll(maintenanceInterval, TimeUnit.MILLISECONDS)) == null) {
                            this.maintain();
                            continue;
                        }
                        mr.getCubeletStorage().maintain(mr.getForceCubeletEvictPct());
                    }
                }
                catch (InterruptedException e) {
                    log.log("Thread " + Thread.currentThread().getName() + " has encountered the following (uncaught) interrupted exception: ", (Throwable)e);
                    continue;
                }
                catch (Throwable e) {
                    log.log("Thread  " + Thread.currentThread().getName() + " has encountered the following (uncaught) exception: ", e);
                    continue;
                }
                break;
            }
        }

        void maintain() {
            this.cubeManager.maintain();
            ROLAPCubeManager rolapCubeManager = ROLAPCubeManager.getInstance();
            if (rolapCubeManager != null) {
                rolapCubeManager.maintain();
            }
        }

        protected int getQueueSize() {
            return this.cubeletStorageQueue.size();
        }

        private static class CubeletMaintenanceRequest {
            private final CubeletStorage cubeletStorage;
            private final double forceCubeletEvictPct;

            CubeletMaintenanceRequest(CubeletStorage cs, double forceEvictPct) {
                this.cubeletStorage = cs;
                this.forceCubeletEvictPct = forceEvictPct;
            }

            public CubeletStorage getCubeletStorage() {
                return this.cubeletStorage;
            }

            public double getForceCubeletEvictPct() {
                return this.forceCubeletEvictPct;
            }

            public boolean equals(Object o) {
                if (!(o instanceof CubeletMaintenanceRequest)) {
                    return false;
                }
                CubeletMaintenanceRequest other = (CubeletMaintenanceRequest)o;
                return this.cubeletStorage == other.cubeletStorage && this.forceCubeletEvictPct == other.forceCubeletEvictPct;
            }

            public int hashCode() {
                return this.cubeletStorage.hashCode();
            }
        }
    }
}

