/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.config.XQEConfiguration;
import com.cognos.xqe.config.XQEConfigurationManager;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.data.values.Value;
import com.cognos.xqe.metadata.IHierarchy;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CrossJoinedSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Set;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.metadata.Cube;
import com.cognos.xqe.runtree.olap.mdx.security.SecurityManagerInterface;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageRequest;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockTupleStorageUtil;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.BlockletFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorageRequest;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.ICubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.combination.BlockTupleStorageFetchResult;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Blocklet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletAgeComparator;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMaintenanceService;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ExpiringCubeletHitCountComparator;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.primitive.ArrayListInt;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class CubeletStorage
implements IBlockTupleStorage {
    private static final long KILO = 1024L;
    private static final float ONE_HUNDRED = 100.0f;
    protected static final int MILLISECONDS_IN_SECOND = 1000;
    private static final int DEFAULT_CUBELET_LIMIT_THRESHOLD_PERCENTAGE = 90;
    private static final String LIMIT_THRESHOLD_PARAM = "queryExecution.MDXEngineCellCache.LimitThreshold[@value]";
    private static final int DEFAULT_CUBELET_STORAGE_SIZE_MB = 50;
    public static final String HIT_EXPIRATION_INTERVAL_PARAM = "queryExecution.MDXEngineCellCache.HitExpirationIntervalInMillis";
    private static final int DEFAULT_HIT_EXPIRATION_INTERVAL_IN_SEC = 3600;
    public static final String HIT_SURVIVAL_RATE_PARAM = "queryExecution.MDXEngineCellCache.HitSurvivalRate";
    private static final int DEFAULT_HIT_SURVIVAL_RATE_PERCENTAGE = 85;
    public static final String INCUBATOR_SIZE_PARAM = "queryExecution.MDXEngineCellCache.IncubatorSize";
    private static final int DEFAULT_INCUBATOR_SIZE_PERCENTAGE = 25;
    private static final String RIGHT_BRACE = ")";
    private static final String LEFT_BRACE = "(";
    private static XQELogger statsLogger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "CubeletStatistics", LogLevel.INFO);
    private volatile int lastNumThreadsUsed = 0;
    private int maxSize;
    protected boolean maintenanceOnAdd = true;
    private static int limitThresholdPercent;
    private long limitThreshold;
    private final Cube cube;
    protected static final int[][] EMPTY_INTEGER_SET;
    protected CubeletMonitor cubeletMonitor = null;
    private static final Comparator<Cubelet> TUPLE_COUNT_COMPARATOR;
    protected CubeletCache tupleStorage;
    boolean expressionStorageEnabled = true;
    private ConcurrentMap<String, CubeletCache> expressionStorage;

    public CubeletStorage(Cube inputCube) {
        this.cube = inputCube;
        AtomicReference cache = new AtomicReference(new ConcurrentLinkedQueue());
        AtomicReference old = new AtomicReference(new ConcurrentLinkedQueue());
        ConcurrentLinkedQueue temp = new ConcurrentLinkedQueue();
        this.tupleStorage = new CubeletCache(cache, temp, old);
        if (this.expressionStorageEnabled) {
            this.expressionStorage = new ConcurrentHashMap<String, CubeletCache>();
        }
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int newMaxSize = configuration.getIntegerProperty("queryExecution.MDXEngineCellCache.StorageSizePerCube[@value]", 50);
        this.setMaxSize(newMaxSize);
        if (statsLogger.isOn(LogLevel.TRACE)) {
            StringBuilder strBldr = new StringBuilder("Constructed new Cubelet ");
            strBldr.append(this.toString()).append(" for Cube ");
            if (this.cube != null) {
                strBldr.append(this.cube.getName()).append(LEFT_BRACE).append(this.cube.hashCode()).append(RIGHT_BRACE);
            }
            statsLogger.log(LogLevel.TRACE, strBldr.toString());
        }
    }

    @Override
    public void initialize() {
    }

    @Override
    public IBlockTupleStorageFetchResult getTupleValues(ISet requiredSet) throws InterpreterException {
        BlockTupleStorageRequest request = new BlockTupleStorageRequest();
        request.setSelectionsInCubeOrder(this.getSetSelectionsInCubeDimensionOrder(requiredSet));
        request.setCubeHierarchies(this.getHierarchies().toArray(new IHierarchy[this.getHierarchies().size()]));
        request.setRequestedSet(requiredSet);
        BlockTupleStorageFetchResult result = this.scanStorage(request);
        return result;
    }

    @Override
    public ISet getTupleValues(ISet requiredSet, List<TupleValue> tupleValues) throws InterpreterException {
        BlockTupleStorageFetchResult result = this.getTupleValues(requiredSet, tupleValues, null);
        return result.createSet();
    }

    @Override
    public BlockTupleStorageFetchResult getTupleValues(ISet requiredSet, List<TupleValue> tupleValues, String cubeletHint) throws InterpreterException {
        BlockTupleStorageRequest request = new BlockTupleStorageRequest();
        request.setSelectionsInCubeOrder(this.getSetSelectionsInCubeDimensionOrder(requiredSet));
        request.setCubeHierarchies(this.getHierarchies().toArray(new IHierarchy[this.getHierarchies().size()]));
        request.setRequestedSet(requiredSet);
        request.setTupleValues(tupleValues);
        request.setHint(cubeletHint);
        return this.getTupleValues(request);
    }

    @Override
    public BlockTupleStorageFetchResult getTupleValues(ISet requiredSet, String cubeletHint, List<Iterator<TupleValue>> tupleValueIterators) throws InterpreterException {
        BlockTupleStorageRequest request = new BlockTupleStorageRequest();
        request.setSelectionsInCubeOrder(this.getSetSelectionsInCubeDimensionOrder(requiredSet));
        request.setCubeHierarchies(this.getHierarchies().toArray(new IHierarchy[this.getHierarchies().size()]));
        request.setRequestedSet(requiredSet);
        request.setTupleValueIterators(tupleValueIterators);
        request.setHint(cubeletHint);
        return this.getTupleValues(request);
    }

    public BlockTupleStorageFetchResult getTupleValues(IBlockTupleStorageRequest request) throws InterpreterException {
        return this.scanStorage(request);
    }

    protected BlockTupleStorageFetchResult scanStorage(IBlockTupleStorageRequest request) throws InterpreterException {
        BlockTupleStorageFetchResult result = new BlockTupleStorageFetchResult(request);
        Iterator<Cubelet> cubeletIterator = null;
        ScanMetrics scanMetrics = new ScanMetrics();
        long startTime = System.currentTimeMillis();
        boolean unknownMembersExist = true;
        String cubeletHint = request.getHint();
        if (cubeletHint != null) {
            List<Cubelet> cubelets = this.findCubelets(cubeletHint);
            for (Cubelet cubelet : cubelets) {
                result = cubelet.fetch(result);
                scanMetrics.incrementScanCount();
                unknownMembersExist = BlockTupleStorageUtil.hasUnknownMbrs(result.getSelectionsToFetch());
                if (unknownMembersExist) continue;
                break;
            }
        }
        if (unknownMembersExist) {
            cubeletIterator = this.tupleStorage.getCache().iterator();
            result = this.scanCubelets(result, cubeletIterator, scanMetrics);
            cubeletIterator = this.tupleStorage.getOldCache().iterator();
            result = this.scanCubelets(result, cubeletIterator, scanMetrics);
        }
        long cubeletScanTime = System.currentTimeMillis() - startTime;
        if (statsLogger.isOn(LogLevel.TRACE)) {
            long reqSetSize = request.getRequestSet().size();
            long setToFetchSize = BlockTupleStorageUtil.getCombinationsSize(result.getSelectionsToFetch());
            StringBuilder strBldr = new StringBuilder(Cubelet.NEWLINE);
            if (this.cube != null) {
                strBldr.append("Cubelet storage get tuple values request: ").append(this.cube.getName());
            }
            strBldr.append(Cubelet.NEWLINE).append("Num tuples in request set: ").append(reqSetSize);
            strBldr.append(Cubelet.NEWLINE).append("Num cubelets scanned: ").append(scanMetrics.getScanCount());
            strBldr.append(Cubelet.NEWLINE).append("Num tuples found in storage: ").append(reqSetSize - setToFetchSize);
            strBldr.append(Cubelet.NEWLINE).append("Scan time: ").append(cubeletScanTime).append(Cubelet.NEWLINE);
            if (result.getTupleValueIterators() != null) {
                strBldr.append("Number of returned iterators: ").append(result.getTupleValueIterators().size()).append(Cubelet.NEWLINE);
            }
            statsLogger.log(LogLevel.INFO, strBldr.toString());
        }
        this.lastNumThreadsUsed = result.getNumThreadsUsed();
        return result;
    }

    private BlockTupleStorageFetchResult scanCubelets(BlockTupleStorageFetchResult result, Iterator<Cubelet> cubeletIterator, ScanMetrics scanMetrics) throws InterpreterException {
        while (cubeletIterator.hasNext()) {
            Cubelet cubelet = cubeletIterator.next();
            result = cubelet.fetch(result);
            scanMetrics.incrementScanCount();
            if (BlockTupleStorageUtil.hasUnknownMbrs(result.getSelectionsToFetch())) continue;
            break;
        }
        return result;
    }

    public CubeletMonitor getCubeletMonitor() {
        return this.cubeletMonitor;
    }

    public void setCubeletMonitor(CubeletMonitor monitor) {
        this.cubeletMonitor = monitor;
    }

    @Override
    public void maintain(double pctOfCubeletsToForceEvict) {
        ConcurrentLinkedQueue tempExprCache;
        long maintenanceStartTime = System.currentTimeMillis();
        ArrayList<Cubelet> cubeletsArray = new ArrayList<Cubelet>();
        CubeletStats stats = new CubeletStats(this);
        ConcurrentLinkedQueue<Cubelet> temp = this.swapInTempAndMerge(this.tupleStorage, stats, cubeletsArray);
        HashMap<Iterator<Cubelet>, ConcurrentLinkedQueue> tempExprCacheMap = null;
        if (this.expressionStorage != null) {
            tempExprCacheMap = new HashMap<Iterator<Cubelet>, ConcurrentLinkedQueue>();
            for (Iterator<Cubelet> expr : this.expressionStorage.keySet()) {
                tempExprCache = this.swapInTempAndMerge((CubeletCache)this.expressionStorage.get(expr), stats, cubeletsArray);
                tempExprCacheMap.put(expr, tempExprCache);
            }
        }
        if (cubeletsArray.isEmpty()) {
            return;
        }
        List<Cubelet> survivingCubelets = this.reorgCubelets(cubeletsArray, pctOfCubeletsToForceEvict);
        for (Cubelet c : survivingCubelets) {
            if (c instanceof Blocklet) {
                tempExprCache = (ConcurrentLinkedQueue)tempExprCacheMap.get(((Blocklet)c).getKey());
                tempExprCache.add(c);
            } else {
                temp.add(c);
            }
            stats.currentMemoryUsage += c.getMemoryUsage();
            ++stats.currentCubelets;
            stats.logActiveCubelet(c);
        }
        cubeletsArray.removeAll(survivingCubelets);
        for (Cubelet c : cubeletsArray) {
            if (c == null) continue;
            stats.estimatedMemoryFreed = (int)((long)stats.estimatedMemoryFreed + c.getMemoryUsage());
            ++stats.cubeletsRemoved;
            stats.logRemovedCubelet(c, "Storage memory exceeded limitThreashold value");
        }
        this.swapOutTemp(temp, this.tupleStorage);
        if (this.expressionStorage != null) {
            for (String expr : tempExprCacheMap.keySet()) {
                this.swapOutTemp((ConcurrentLinkedQueue)tempExprCacheMap.get(expr), (CubeletCache)this.expressionStorage.get(expr));
            }
        }
        stats.maintenanceTime = System.currentTimeMillis() - maintenanceStartTime;
        stats.log();
    }

    protected void removeExpiredCubelets(ConcurrentLinkedQueue<Cubelet> cubelets) {
    }

    public List<Cubelet> reorgCubelets(List<Cubelet> availableCubelets, double pctToForceEvict) {
        ArrayList<Cubelet> survivingCubelets = new ArrayList<Cubelet>();
        long usedMemory = this.selectCubeletsViaAge(availableCubelets, survivingCubelets);
        ArrayList<Cubelet> newAvailableCubelets = new ArrayList<Cubelet>(availableCubelets);
        newAvailableCubelets.removeAll(survivingCubelets);
        long expirationInterval = this.getHitExpirationInterval();
        double hitSurvivalRate = this.getHitSurvivalRate();
        ExpiringCubeletHitCountComparator hitRateComparator = new ExpiringCubeletHitCountComparator(expirationInterval, hitSurvivalRate, TUPLE_COUNT_COMPARATOR);
        this.selectCubeletsViaHits(newAvailableCubelets, survivingCubelets, usedMemory, hitRateComparator);
        Collections.sort(survivingCubelets, hitRateComparator);
        if (pctToForceEvict > 0.0) {
            this.evictByPercentage(survivingCubelets, pctToForceEvict);
        }
        return survivingCubelets;
    }

    private void evictByPercentage(List<Cubelet> cubelets, double pctToForceEvict) {
        int numActualCubelets = 0;
        for (Cubelet c : cubelets) {
            if (c == null) continue;
            ++numActualCubelets;
        }
        long bytesFreed = 0L;
        int numCubeletsToEvict = (int)(pctToForceEvict * (double)numActualCubelets);
        int evicted = 0;
        for (int i = cubelets.size() - 1; i >= 0 && evicted < numCubeletsToEvict; --i) {
            Cubelet c = cubelets.get(i);
            if (c == null) continue;
            cubelets.remove(i);
            bytesFreed += c.getMemoryUsage();
            ++evicted;
        }
        NumberFormat nf = NumberFormat.getInstance();
        String msg = "Cube '" + this.cube.getName() + "' forcefully evicted " + nf.format(evicted) + " cubelets freeing " + nf.format(bytesFreed) + " bytes in cubeletStorage.";
        statsLogger.log(LogLevel.WARN, msg);
    }

    private long selectCubeletsViaHits(List<Cubelet> availableCubelets, List<Cubelet> survivingCubelets, long usedMemory, Comparator<Cubelet> hitRateComparator) {
        Collections.sort(availableCubelets, hitRateComparator);
        for (Cubelet c : availableCubelets) {
            long cubeletSize;
            if (c == null || usedMemory + (cubeletSize = c.getMemoryUsage()) >= this.limitThreshold) continue;
            survivingCubelets.add(c);
            usedMemory += cubeletSize;
        }
        return usedMemory;
    }

    private long selectCubeletsViaAge(List<Cubelet> availableCubelets, List<Cubelet> survivingCubelets) {
        long incubatorSize = this.getIncubatorSize();
        if (incubatorSize == 0L) {
            return 0L;
        }
        Collections.sort(availableCubelets, new CubeletAgeComparator());
        long usedMemory = 0L;
        int numCubelets = availableCubelets.size();
        for (int i = 0; i < numCubelets / 2; ++i) {
            Cubelet c = availableCubelets.get(i);
            if (c == null) continue;
            long cubeletSize = c.getMemoryUsage();
            boolean addCubelet = false;
            if (usedMemory == 0L) {
                if (cubeletSize < this.limitThreshold) {
                    addCubelet = true;
                }
            } else if (usedMemory + cubeletSize < incubatorSize) {
                addCubelet = true;
            }
            if (!addCubelet) continue;
            survivingCubelets.add(c);
            usedMemory += cubeletSize;
        }
        return usedMemory;
    }

    private double getHitSurvivalRate() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int hitSurvialPct = configuration.getIntegerProperty(HIT_SURVIVAL_RATE_PARAM, 85);
        return (double)hitSurvialPct / 100.0;
    }

    private long getHitExpirationInterval() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int hitExpirationIntervalInSec = configuration.getIntegerProperty(HIT_EXPIRATION_INTERVAL_PARAM, 3600);
        return TimeUnit.SECONDS.toMillis(hitExpirationIntervalInSec);
    }

    private long getIncubatorSize() {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        int incubatorSizePct = configuration.getIntegerProperty(INCUBATOR_SIZE_PARAM, 25);
        long size = CubeletStorage.calcPercentage((long)this.maxSize * 1024L * 1024L, incubatorSizePct);
        return size;
    }

    private static long calcPercentage(long size, int pct) {
        return (long)((float)(size * (long)pct) / 100.0f);
    }

    private ConcurrentLinkedQueue<Cubelet> swapInTempAndMerge(CubeletCache caches, CubeletStats stats, ArrayList<Cubelet> cubeletsArray) {
        ConcurrentLinkedQueue temp = (ConcurrentLinkedQueue)caches.curCache.get();
        if (!temp.isEmpty()) {
            caches.oldCache.set(temp);
            caches.curCache.set(caches.tmpCache);
            this.removeExpiredCubelets(temp);
            Cubelet[] cubelets = temp.toArray(new Cubelet[temp.size()]);
            Arrays.sort(cubelets, TUPLE_COUNT_COMPARATOR);
            for (int i = 0; i < cubelets.length; ++i) {
                int j;
                if (cubelets[i] == null) continue;
                if (cubelets[i] instanceof Blocklet) {
                    for (j = i + 1; j < cubelets.length; ++j) {
                        Blocklet mergedBlocklet;
                        if (cubelets[j] == null || !(cubelets[j] instanceof Blocklet) || (mergedBlocklet = ((Blocklet)cubelets[i]).merge((Blocklet)cubelets[j])) == null) continue;
                        cubelets[i] = mergedBlocklet;
                        stats.estimatedMemoryFreed = (int)((long)stats.estimatedMemoryFreed + cubelets[i].getMemoryUsage());
                        stats.estimatedMemoryFreed = (int)((long)stats.estimatedMemoryFreed + cubelets[j].getMemoryUsage());
                        stats.estimatedMemoryFreed = (int)((long)stats.estimatedMemoryFreed - mergedBlocklet.getMemoryUsage());
                        ++stats.cubeletsRemoved;
                        stats.logRemovedCubelet(cubelets[j], "Contained within another blocklet");
                        cubelets[j] = null;
                    }
                } else {
                    for (j = i + 1; j < cubelets.length; ++j) {
                        if (cubelets[j] == null || cubelets[j] instanceof Blocklet || !cubelets[i].contains(cubelets[j])) continue;
                        stats.estimatedMemoryFreed = (int)((long)stats.estimatedMemoryFreed + cubelets[j].getMemoryUsage());
                        ++stats.cubeletsRemoved;
                        stats.logRemovedCubelet(cubelets[j], "Contained within another cubelet");
                        cubelets[j] = null;
                    }
                }
                cubeletsArray.add(cubelets[i]);
            }
        }
        return new ConcurrentLinkedQueue<Cubelet>();
    }

    private void swapOutTemp(ConcurrentLinkedQueue<Cubelet> temp, CubeletCache caches) {
        caches.curCache.set(temp);
        Iterator tempQueueIterator = caches.tmpCache.iterator();
        while (tempQueueIterator.hasNext()) {
            temp.add((Cubelet)tempQueueIterator.next());
        }
        caches.tmpCache.clear();
        caches.oldCache.set(caches.tmpCache);
    }

    protected Cubelet createNewCubelet(ISet querySet, Iterator<TupleValue> tupleValues, String hint) {
        return new Cubelet(querySet, tupleValues, this.cubeletMonitor, hint);
    }

    @Override
    public void putTupleValues(ISet querySet, Iterator<TupleValue> tupleValues) throws InterpreterException {
        this.putTupleValues(querySet, tupleValues, null);
    }

    @Override
    public void putTupleValues(ISet querySet, Iterator<TupleValue> tupleValues, String hint) throws InterpreterException {
        Cubelet cubelet = this.createNewCubelet(querySet, tupleValues, hint);
        this.addCubelet(cubelet);
        if (this.maintenanceOnAdd) {
            CubeletMaintenanceService.getInstance().maintain(this, 0.0);
        }
    }

    public void putTupleValues(IBlockTupleStorageRequest request) throws InterpreterException {
        this.putTupleValues(request.getRequestSet(), request.getTupleValues().iterator(), request.getHint());
    }

    @Override
    public void putOrdinalValues(ISet querySet, List<OrdinalValue> ordinalValues) throws InterpreterException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putCubelet(ICubelet cubelet) throws InterpreterException {
        this.addCubelet((Cubelet)((Object)cubelet));
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(int storageSize) {
        this.maxSize = storageSize;
        this.limitThreshold = CubeletStorage.calcPercentage((long)this.maxSize * 1024L * 1024L, limitThresholdPercent);
    }

    public long getCubeletSize(String cubeletHint) {
        List<Cubelet> cubelets = this.findCubelets(cubeletHint);
        if (cubelets.isEmpty()) {
            return -1L;
        }
        long size = 0L;
        for (Cubelet cubelet : cubelets) {
            size += cubelet.getMemoryUsage();
        }
        return size;
    }

    public long getSize() {
        long size = 0L;
        Iterator<Cubelet> cubeletIterator = this.tupleStorage.getCache().iterator();
        while (cubeletIterator.hasNext()) {
            size += cubeletIterator.next().getMemoryUsage();
        }
        cubeletIterator = this.tupleStorage.getOldCache().iterator();
        while (cubeletIterator.hasNext()) {
            size += cubeletIterator.next().getMemoryUsage();
        }
        if (this.expressionStorage != null) {
            for (CubeletCache cache : this.expressionStorage.values()) {
                Iterator blockletIterator = ((ConcurrentLinkedQueue)cache.curCache.get()).iterator();
                while (blockletIterator.hasNext()) {
                    size += ((Cubelet)blockletIterator.next()).getMemoryUsage();
                }
            }
        }
        return size;
    }

    private List<Cubelet> findCubelets(String cubeletHint) {
        HashSet<Cubelet> uniqueCubelets = new HashSet<Cubelet>();
        Iterator<Cubelet> cubeletIterator = this.tupleStorage.getCache().iterator();
        uniqueCubelets.addAll(this.findCubelets(cubeletIterator, cubeletHint));
        cubeletIterator = this.tupleStorage.getOldCache().iterator();
        uniqueCubelets.addAll(this.findCubelets(cubeletIterator, cubeletHint));
        return new ArrayList<Cubelet>(uniqueCubelets);
    }

    private List<Cubelet> findCubelets(Iterator<Cubelet> cubeletIterator, String cubeletHint) {
        ArrayList<Cubelet> cubelets = new ArrayList<Cubelet>();
        while (cubeletIterator.hasNext()) {
            Cubelet cubelet = cubeletIterator.next();
            if (!cubeletHint.equals(cubelet.getHint())) continue;
            cubelets.add(cubelet);
        }
        return cubelets;
    }

    protected void addCubelet(Cubelet cubelet) {
        this.tupleStorage.getCache().add(cubelet);
    }

    protected List<IHierarchy> getHierarchies() {
        return this.cube.getHierarchies();
    }

    protected boolean multipleHierarchySupport() {
        return this.cube.multipleHierarchySupport();
    }

    protected IMember[][] getSetSelectionsInCubeDimensionOrder(ISet set) {
        List<IHierarchy> setHierarchies;
        List<IHierarchy> cubeHierList = this.getHierarchies();
        if (!this.multipleHierarchySupport()) {
            setHierarchies = Arrays.asList(set.getHierarchies());
            IHierarchy[] cubeHierachies = cubeHierList.toArray(new IHierarchy[0]);
            cubeHierList.clear();
            int hierIdx = 0;
            for (IHierarchy cubeHierarchy : cubeHierachies) {
                for (IHierarchy queryHierarchy : setHierarchies) {
                    if (cubeHierarchy.getDimension() != queryHierarchy.getDimension()) continue;
                    cubeHierachies[hierIdx] = queryHierarchy;
                    break;
                }
                cubeHierList.add(cubeHierachies[hierIdx]);
                ++hierIdx;
            }
        } else {
            setHierarchies = Arrays.asList(set.getHierarchies());
            List<IHierarchy> cubeHierachies = this.getHierarchies();
            cubeHierList.clear();
            for (IHierarchy cubeHierarchy : cubeHierachies) {
                if (!setHierarchies.contains(cubeHierarchy)) continue;
                cubeHierList.add(cubeHierarchy);
            }
        }
        IHierarchy[] cubeHierarchies = cubeHierList.toArray(new IHierarchy[cubeHierList.size()]);
        return ((Set)set).getMembers(cubeHierarchies);
    }

    public final boolean isMaintainceOnAdd() {
        return this.maintenanceOnAdd;
    }

    public final void setMaintainceOnAdd(boolean doMaintenanceOnAdd) {
        this.maintenanceOnAdd = doMaintenanceOnAdd;
    }

    @Override
    public ISet getTupleValues(String expr, ISet requiredSet, List<TupleValue> tupleValues, Value defaultValue, ArrayListInt intNonDegenSets) throws InterpreterException {
        if (!this.expressionStorageEnabled) {
            return requiredSet;
        }
        String key = this.makeBlockletKey(expr);
        CubeletCache caches = (CubeletCache)this.expressionStorage.get(key);
        if (caches == null) {
            return requiredSet;
        }
        caches.findNonDegenSets((CrossJoinedSet)requiredSet, intNonDegenSets);
        Set[] sets = ((CrossJoinedSet)requiredSet).getSets();
        ArrayList<Set> nonDegenSets = new ArrayList<Set>();
        for (int i = 0; i < intNonDegenSets.size(); ++i) {
            nonDegenSets.add(sets[intNonDegenSets.get(i)]);
        }
        CrossJoinedSet nonDegenRequiredSet = new CrossJoinedSet(nonDegenSets.toArray(new ISet[0]));
        BlockletFetchResult result = new BlockletFetchResult(nonDegenRequiredSet, tupleValues);
        this.scanStorage(caches, nonDegenRequiredSet, result);
        defaultValue.setNull();
        if (result.getDefaultValue() != null) {
            defaultValue.set(((Value)result.getDefaultValue()).getObject());
        }
        ISet setToFetch = result.createSetFromOrdinalList(result.getSelectionsToFetch());
        return setToFetch;
    }

    @Override
    public void putTupleValues(String expr, ISet querySet, Iterator<TupleValue> tupleValues) throws InterpreterException {
        if (!this.expressionStorageEnabled) {
            return;
        }
        String key = this.makeBlockletKey(expr);
        Blocklet blocklet = new Blocklet(key, querySet, tupleValues);
        this.addCubelet(blocklet);
        if (this.maintenanceOnAdd) {
            CubeletMaintenanceService.getInstance().maintain(this, 0.0);
        }
    }

    @Override
    public void putDefaultValue(String expr, IValue defaultValue) {
        if (!this.expressionStorageEnabled) {
            return;
        }
        String key = this.makeBlockletKey(expr);
        Blocklet blocklet = new Blocklet(key, this.cube, defaultValue);
        this.addCubelet(blocklet);
        if (this.maintenanceOnAdd) {
            CubeletMaintenanceService.getInstance().maintain(this, 0.0);
        }
    }

    public int getLastNumThreadsUsed() {
        return this.lastNumThreadsUsed;
    }

    private void addCubelet(Blocklet blocklet) {
        AtomicReference old;
        ConcurrentLinkedQueue temp;
        AtomicReference cache;
        CubeletCache cubeletCacheFromMap;
        String key = blocklet.getKey();
        CubeletCache cubeletCache = (CubeletCache)this.expressionStorage.get(key);
        if (cubeletCache == null && (cubeletCacheFromMap = this.expressionStorage.putIfAbsent(key, cubeletCache = new CubeletCache(cache = new AtomicReference(new ConcurrentLinkedQueue()), temp = new ConcurrentLinkedQueue(), old = new AtomicReference(new ConcurrentLinkedQueue())))) != null) {
            cubeletCache = cubeletCacheFromMap;
        }
        cache = cubeletCache.curCache;
        ((ConcurrentLinkedQueue)cache.get()).add(blocklet);
    }

    private void scanStorage(CubeletCache blockletCache, ISet requiredSet, BlockletFetchResult result) throws InterpreterException {
        if (blockletCache == null) {
            return;
        }
        long scanCount = 0L;
        long startTime = System.currentTimeMillis();
        for (Cubelet cubelet : blockletCache.getCache()) {
            result = ((Blocklet)cubelet).fetch(result);
            ++scanCount;
            if (!BlockletFetchResult.isEmpty(result.getSelectionsToFetch())) continue;
            break;
        }
        for (Cubelet cubelet : blockletCache.getOldCache()) {
            result = ((Blocklet)cubelet).fetch(result);
            ++scanCount;
            if (!BlockletFetchResult.isEmpty(result.getSelectionsToFetch())) continue;
            break;
        }
        long cubeletScanTime = System.currentTimeMillis() - startTime;
        if (statsLogger.isOn(LogLevel.TRACE)) {
            long reqSetSize = requiredSet.size();
            long setToFetchSize = result.createSetFromOrdinalList(result.getSelectionsToFetch()).size();
            StringBuilder strBldr = new StringBuilder(Cubelet.NEWLINE);
            if (this.cube != null) {
                strBldr.append("Blocklet storage get tuple values request: ").append(this.cube.getName());
            }
            strBldr.append(Cubelet.NEWLINE).append("Number of tuples in request set: ").append(reqSetSize);
            strBldr.append(Cubelet.NEWLINE).append("Number of blocklets scanned: ").append(scanCount);
            strBldr.append(Cubelet.NEWLINE).append("Number of tuples found in storage: ").append(reqSetSize - setToFetchSize);
            strBldr.append(Cubelet.NEWLINE).append("Blocklets Scan time: ").append(cubeletScanTime).append(Cubelet.NEWLINE);
            statsLogger.log(LogLevel.INFO, strBldr.toString());
        }
    }

    private String makeBlockletKey(String expr) {
        String securityKey;
        StringBuilder key = new StringBuilder(expr);
        SecurityManagerInterface secMan = this.cube.getSecurityManager();
        if (secMan != null && (securityKey = secMan.getAuthorizationKeyForCurrentUser()) != null) {
            key.append(securityKey);
        }
        key.append("_incrementId:");
        key.append(MultiRequestContext.getCurrentIncrementId(this.cube));
        return key.toString();
    }

    static {
        XQEConfiguration configuration = XQEConfigurationManager.getInstance().getConfiguration(ServiceEnumeration.XQE);
        limitThresholdPercent = configuration.getIntegerProperty(LIMIT_THRESHOLD_PARAM, 90);
        EMPTY_INTEGER_SET = new int[0][0];
        TUPLE_COUNT_COMPARATOR = new TupleCountComparator();
    }

    private static final class ScanMetrics {
        private long scanCount = 0L;

        private ScanMetrics() {
        }

        public void incrementScanCount() {
            ++this.scanCount;
        }

        public long getScanCount() {
            return this.scanCount;
        }
    }

    private final class CubeletStats {
        private static final String SPACE_BYTES = " bytes";
        int cubeletsRemoved = 0;
        int estimatedMemoryFreed = 0;
        int currentCubelets = 0;
        long currentMemoryUsage = 0L;
        long maintenanceTime = 0L;
        private final CubeletStorage parent;
        StringBuilder activeCubeletsStringBuilder;
        StringBuilder removedCubeletsStringBuilder;

        private CubeletStats(CubeletStorage owner) {
            this.parent = owner;
            if (statsLogger.isOn(LogLevel.TRACE)) {
                this.activeCubeletsStringBuilder = new StringBuilder();
                this.removedCubeletsStringBuilder = new StringBuilder();
            }
        }

        private void log() {
            if (statsLogger.isOn(LogLevel.INFO)) {
                StringBuilder strBldr = new StringBuilder(Cubelet.NEWLINE);
                if (CubeletStorage.this.cube != null) {
                    strBldr.append("Cubelet maintenance statistics for cube: ").append(CubeletStorage.this.cube.getName());
                    strBldr.append(CubeletStorage.LEFT_BRACE).append(CubeletStorage.this.cube.hashCode()).append(CubeletStorage.RIGHT_BRACE).append(Cubelet.NEWLINE);
                }
                strBldr.append("Storage ").append(this.parent.toString()).append(Cubelet.NEWLINE);
                strBldr.append("Max. size: \t\t\t\t\t").append(CubeletStorage.this.maxSize).append(" mb").append(Cubelet.NEWLINE);
                strBldr.append("Cubelets removed: \t\t\t").append(this.cubeletsRemoved).append(Cubelet.NEWLINE);
                strBldr.append("Est. memory freed: \t\t\t").append(this.estimatedMemoryFreed).append(SPACE_BYTES).append(Cubelet.NEWLINE);
                strBldr.append("Cubelets in storage: \t\t\t").append(this.currentCubelets).append(Cubelet.NEWLINE);
                strBldr.append("Est. memory used: \t\t\t").append(this.currentMemoryUsage).append(SPACE_BYTES).append(Cubelet.NEWLINE);
                strBldr.append("Maintenance time: \t\t\t").append(this.maintenanceTime).append(" ms").append(Cubelet.NEWLINE);
                if (statsLogger.isOn(LogLevel.TRACE)) {
                    strBldr.append(Cubelet.NEWLINE).append("Currently active cubelets:");
                    strBldr.append(Cubelet.NEWLINE).append((CharSequence)this.activeCubeletsStringBuilder);
                    strBldr.append(Cubelet.NEWLINE).append("Removed cubelets:");
                    strBldr.append(Cubelet.NEWLINE).append((CharSequence)this.removedCubeletsStringBuilder);
                }
                statsLogger.log(LogLevel.INFO, strBldr.toString());
            }
        }

        private void logActiveCubelet(Cubelet c) {
            if (statsLogger.isOn(LogLevel.TRACE)) {
                this.activeCubeletsStringBuilder.append(Cubelet.NEWLINE);
                this.activeCubeletsStringBuilder.append(c.toString());
            }
        }

        private void logRemovedCubelet(Cubelet c, String removalReason) {
            if (statsLogger.isOn(LogLevel.TRACE)) {
                this.removedCubeletsStringBuilder.append(Cubelet.NEWLINE);
                this.removedCubeletsStringBuilder.append(c.toString());
                this.removedCubeletsStringBuilder.append("Reason for removal: ").append(removalReason);
            }
        }
    }

    private static final class TupleCountComparator
    implements Comparator<Cubelet> {
        private TupleCountComparator() {
        }

        @Override
        public int compare(Cubelet o1, Cubelet o2) {
            if (o1.getNumQuerySetTuples() > o2.getNumQuerySetTuples()) {
                return -1;
            }
            if (o1.getNumQuerySetTuples() < o2.getNumQuerySetTuples()) {
                return 1;
            }
            return 0;
        }
    }

    protected final class CubeletCache {
        private AtomicReference<ConcurrentLinkedQueue<Cubelet>> curCache;
        private final ConcurrentLinkedQueue<Cubelet> tmpCache;
        private AtomicReference<ConcurrentLinkedQueue<Cubelet>> oldCache;

        private CubeletCache(AtomicReference<ConcurrentLinkedQueue<Cubelet>> cache, ConcurrentLinkedQueue<Cubelet> temp, AtomicReference<ConcurrentLinkedQueue<Cubelet>> old) {
            this.curCache = cache;
            this.tmpCache = temp;
            this.oldCache = old;
        }

        public ConcurrentLinkedQueue<Cubelet> getCache() {
            return this.curCache.get();
        }

        public ConcurrentLinkedQueue<Cubelet> getOldCache() {
            return this.oldCache.get();
        }

        private void findNonDegenSets(CrossJoinedSet requiredSet, ArrayListInt intNonDegenSets) {
            List<IHierarchy> setHierarchies = Arrays.asList(requiredSet.getHierarchies());
            List<IHierarchy> cubeHierarchies = CubeletStorage.this.cube.getHierarchies();
            int[] hierarchyMap = new int[setHierarchies.size()];
            int mapIdx = 0;
            for (int i = 0; i < cubeHierarchies.size(); ++i) {
                int setHierIdx = setHierarchies.indexOf(cubeHierarchies.get(i));
                if (setHierIdx == -1) continue;
                hierarchyMap[setHierIdx] = mapIdx++;
            }
            boolean[] isNonDegenHier = new boolean[cubeHierarchies.size()];
            for (int i = 0; i < cubeHierarchies.size(); ++i) {
                isNonDegenHier[i] = true;
            }
            for (Blocklet blocklet : this.curCache.get()) {
                for (int i = 0; i < cubeHierarchies.size(); ++i) {
                    int n = i;
                    isNonDegenHier[n] = isNonDegenHier[n] & blocklet.isNonDegenerated(i);
                }
            }
            Set[] setArray = requiredSet.getSets();
            int iHier = 0;
            block4: for (int i = 0; i < setArray.length; ++i) {
                for (int j = 0; j < setArray[i].getTuple(0L).size(); ++j) {
                    if (isNonDegenHier[hierarchyMap[iHier]]) {
                        intNonDegenSets.add(i);
                        iHier += setArray[i].getTuple(0L).size() - j;
                        continue block4;
                    }
                    ++iHier;
                }
            }
        }
    }
}

