/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AbstractDoubleValueStorage;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.JavaObjectMemorySize;
import com.cognos.xqe.util.primitive.Arrays;
import com.cognos.xqe.util.primitive.LongArrayList;

public class DoubleNativeValueStorage
extends AbstractDoubleValueStorage {
    private static final int ORDINAL_SIZE = 8;
    private LongArrayList ordinalList = new LongArrayList(512);
    private long[] ordinals = null;

    @Override
    public boolean getImpl(OrdinalValue ordinalValue) {
        int position = java.util.Arrays.binarySearch(this.ordinals, ordinalValue.getOrdinal());
        if (position < 0) {
            return false;
        }
        DoubleValue dv = this.buildValue(position);
        ordinalValue.setValue(dv);
        return true;
    }

    @Override
    public void putImpl(OrdinalValue ordinalValue) {
        if (this.ordinalList == null) {
            throw new IllegalStateException("Cannot add a value after fix() has been called.");
        }
        long ordinal = ordinalValue.getOrdinal();
        this.ordinalList.add(ordinal);
        super.putImpl(ordinalValue);
    }

    @Override
    public void fixImpl() {
        if (this.ordinalList != null) {
            this.ordinals = this.ordinalList.toArray();
            this.ordinalList = null;
            super.fixImpl();
            Arrays.sort(this.ordinals, this.getDoubleValues(), this.getFormatIds(), this.getValueStates());
        }
    }

    @Override
    protected long estimateSizeToHoldValues() {
        long baseSize = super.estimateSizeToHoldValues();
        long ordinalSize = 0L;
        ordinalSize = this.ordinals != null ? JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(8, this.ordinals.length) : JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(8, this.ordinalList.size());
        DoubleNativeValueStorage.traceEstimatedSize(ordinalSize);
        return ordinalSize + baseSize;
    }

    public static long estimateSizeToHoldValues(long cellCount, boolean cellsHaveSameFormatIds, boolean includeSizeOfValueStates) {
        long baseSize = AbstractDoubleValueStorage.estimateSizeToHoldValues(cellCount, cellsHaveSameFormatIds, includeSizeOfValueStates);
        long estimatedRetainedSizeOfOrdinals = JavaObjectMemorySize.getEstimatedJavaPrimitiveArraySize(8, cellCount);
        DoubleNativeValueStorage.traceEstimatedSize(estimatedRetainedSizeOfOrdinals);
        return baseSize + estimatedRetainedSizeOfOrdinals;
    }

    private static void traceEstimatedSize(long estimatedRetainedSizeOfOrdinalsObject) {
        if (TRACE_LOGGER.isOn(LogLevel.TRACE)) {
            String traceStringFormat = "%s = %,d bytes\n";
            StringBuilder sb = new StringBuilder();
            sb.append(String.format(traceStringFormat, "ordinals retained size", estimatedRetainedSizeOfOrdinalsObject));
            TRACE_LOGGER.log(sb.toString());
        }
    }

    @Override
    public OrdinalValue get(int index, OrdinalValue returnOrdinalValue) {
        if (returnOrdinalValue == null) {
            returnOrdinalValue = new OrdinalValue(0L, null);
        }
        returnOrdinalValue.setOrdinal(this.ordinals[index]);
        returnOrdinalValue.setValue(this.buildValue(index));
        return returnOrdinalValue;
    }

    public boolean updateValue(OrdinalValue ov) {
        int position = java.util.Arrays.binarySearch(this.ordinals, ov.getOrdinal());
        if (position < 0) {
            return false;
        }
        super.updateValue(position, ov);
        return true;
    }

    @Override
    public int getIndex(OrdinalValue ordinalValue) {
        return java.util.Arrays.binarySearch(this.ordinals, ordinalValue.getOrdinal());
    }
}

