/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import java.util.Comparator;

public class ExpiringCubeletHitCountComparator
implements Comparator<Cubelet> {
    private long expirationInterval = 0L;
    private double survivalFactor = 0.0;
    private Comparator<Cubelet> tieBreakingComparator = null;

    public ExpiringCubeletHitCountComparator(long aExpirationInterval, double aSurvivalFactor, Comparator<Cubelet> aTieBreakingComparator) {
        this.expirationInterval = aExpirationInterval;
        this.survivalFactor = aSurvivalFactor;
        this.tieBreakingComparator = aTieBreakingComparator;
    }

    @Override
    public int compare(Cubelet o1, Cubelet o2) {
        double o2HitCount;
        if (o2 == null && o1 == null) {
            return 0;
        }
        if (o1 == null) {
            return 1;
        }
        if (o2 == null) {
            return -1;
        }
        double o1HitCount = this.modifyHitCount(o1.getCombinedCacheHitCount(), o1.getLastDataReuseTime());
        if (o1HitCount > (o2HitCount = this.modifyHitCount(o2.getCombinedCacheHitCount(), o2.getLastDataReuseTime()))) {
            return -1;
        }
        if (o1HitCount < o2HitCount) {
            return 1;
        }
        if (this.tieBreakingComparator == null) {
            return 0;
        }
        return this.tieBreakingComparator.compare(o1, o2);
    }

    private double modifyHitCount(long hitCount, long lastDataReuseTime) {
        if (this.expirationInterval == 0L || hitCount == 0L) {
            return hitCount;
        }
        long cubleletIdleTime = System.currentTimeMillis() - lastDataReuseTime;
        long numberOfIntervals = cubleletIdleTime / this.expirationInterval;
        double totalSurvivalFactor = 1.0;
        int i = 0;
        while ((long)i < numberOfIntervals) {
            totalSurvivalFactor *= this.survivalFactor;
            ++i;
        }
        return (double)hitCount * totalSurvivalFactor;
    }
}

