/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.data.values.DoubleValue;
import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.VectorValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AbstractDoubleValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.DoubleNativeValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IIncrementalOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IncrementalDoubleNativeValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IncrementalVectorDoubleNativeValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.VectorDoubleNativeValueStorage;
import com.cognos.xqe.runtree.olap.mdx.util.ICellCombiner;
import com.cognos.xqe.util.primitive.LongArrayList;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.List;

public class IncrementFactory {
    public static IIncrementalOrdinalValueStorage buildIncrement(IOrdinalValueStorage baseValues, IIncrementalOrdinalValueStorage previousIncrement, LongArrayList ordinals, List<int[]> memberIds, List<TupleValue> tupleValues, ICellCombiner cellCombiner) {
        OrdinalValue ordValueInPrevious;
        boolean isMemberIds = memberIds != null;
        IIncrementalOrdinalValueStorage newStorage = IncrementFactory.createNewStorage(baseValues, previousIncrement, isMemberIds);
        int newNumUniqueValues = 0;
        if (previousIncrement != null) {
            newNumUniqueValues = previousIncrement.getNumUniqueValues();
        }
        ArrayList<TupleValue> tupleValuesNeedingUpdate = new ArrayList<TupleValue>();
        LongArrayList ordinalsNeedingUpdate = null;
        ArrayList<int[]> memberIdsNeedingUpdate = null;
        VectorValue ordValueLargeOrdinal = null;
        if (isMemberIds) {
            memberIdsNeedingUpdate = new ArrayList<int[]>();
            ordValueLargeOrdinal = new VectorValue(null, null);
            ordValueInPrevious = ordValueLargeOrdinal;
        } else {
            ordinalsNeedingUpdate = new LongArrayList();
            ordValueInPrevious = new OrdinalValue(0L, null);
        }
        for (int i = 0; i < tupleValues.size(); ++i) {
            TupleValue tv = tupleValues.get(i);
            long ordinal = 0L;
            int[] tupleMemberIds = null;
            if (isMemberIds) {
                tupleMemberIds = memberIds.get(i);
                ordValueLargeOrdinal.setMemberIds(tupleMemberIds);
            } else {
                ordinal = ordinals.get(i);
                ordValueInPrevious.setOrdinal(ordinal);
            }
            if (previousIncrement == null || !previousIncrement.get(ordValueInPrevious)) {
                DoubleValue newIncrementValue = (DoubleValue)tv.getCell().getValue().copy();
                if (baseValues.get(ordValueInPrevious)) {
                    IValue combinedValue = cellCombiner.combine(tv.getTuple(), ordValueInPrevious.getValue(), newIncrementValue);
                    newIncrementValue.set(combinedValue);
                } else {
                    ++newNumUniqueValues;
                }
                ordValueInPrevious.setValue(newIncrementValue);
                newStorage.put(ordValueInPrevious);
                continue;
            }
            tupleValuesNeedingUpdate.add(tv);
            if (isMemberIds) {
                memberIdsNeedingUpdate.add(tupleMemberIds);
                continue;
            }
            ordinalsNeedingUpdate.add(ordinal);
        }
        int numValuesInNewStorage = tupleValues.size() - tupleValuesNeedingUpdate.size();
        if (previousIncrement != null) {
            numValuesInNewStorage += previousIncrement.getNumValues();
        }
        newStorage.setNumUniqueValues(newNumUniqueValues);
        newStorage.fix(numValuesInNewStorage);
        OrdinalValue ordValueToUpdate = ordValueInPrevious;
        for (int i = 0; i < tupleValuesNeedingUpdate.size(); ++i) {
            TupleValue tv = (TupleValue)tupleValuesNeedingUpdate.get(i);
            if (isMemberIds) {
                int[] tupleNeedingUpdate = (int[])memberIdsNeedingUpdate.get(i);
                ordValueLargeOrdinal.setMemberIds(tupleNeedingUpdate);
            } else {
                long ordinal = ordinalsNeedingUpdate.get(i);
                ordValueToUpdate.setOrdinal(ordinal);
            }
            if (!newStorage.get(ordValueToUpdate)) {
                throw new IllegalStateException("We could not find tuple " + tv.getTuple() + " in the storage, where we found it earlier.");
            }
            IValue combinedValue = cellCombiner.combine(tv.getTuple(), ordValueToUpdate.getValue(), tv.getCell().getValue());
            ordValueToUpdate.setValue(combinedValue);
            newStorage.updateValue(ordValueToUpdate);
        }
        return newStorage;
    }

    private static IIncrementalOrdinalValueStorage createNewStorage(IOrdinalValueStorage baseValues, IIncrementalOrdinalValueStorage previousIncrement, boolean isStoringByMemberIds) {
        AbstractDoubleValueStorage newStorage = previousIncrement == null ? (isStoringByMemberIds ? new IncrementalVectorDoubleNativeValueStorage(((VectorDoubleNativeValueStorage)baseValues).getMemberIdArrayWidth()) : new IncrementalDoubleNativeValueStorage()) : (isStoringByMemberIds ? new IncrementalVectorDoubleNativeValueStorage((VectorDoubleNativeValueStorage)((Object)previousIncrement)) : new IncrementalDoubleNativeValueStorage((DoubleNativeValueStorage)((Object)previousIncrement)));
        return newStorage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IIncrementalOrdinalValueStorage> trimIncrementsBefore(IOrdinalValueStorage baseIncrement, int incrementID) {
        ArrayList<IIncrementalOrdinalValueStorage> trimmedIncrements = new ArrayList<IIncrementalOrdinalValueStorage>();
        IOrdinalValueStorage iOrdinalValueStorage = baseIncrement;
        synchronized (iOrdinalValueStorage) {
            IIncrementalOrdinalValueStorage incrementalStorage;
            for (incrementalStorage = baseIncrement.getNext(); incrementalStorage != null && incrementalStorage.getIncrementId() < incrementID; incrementalStorage = incrementalStorage.getNext()) {
                trimmedIncrements.add(incrementalStorage);
            }
            baseIncrement.setNext(incrementalStorage);
        }
        return trimmedIncrements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IIncrementalOrdinalValueStorage removeIncrement(IOrdinalValueStorage baseIncrement, int incrementID) {
        IIncrementalOrdinalValueStorage trimmedIncrement = null;
        IOrdinalValueStorage iOrdinalValueStorage = baseIncrement;
        synchronized (iOrdinalValueStorage) {
            IOrdinalValueStorage previousIncrementalStorage = baseIncrement;
            for (IIncrementalOrdinalValueStorage incrementalStorage = baseIncrement.getNext(); incrementalStorage != null; incrementalStorage = incrementalStorage.getNext()) {
                if (incrementID == incrementalStorage.getIncrementId()) {
                    previousIncrementalStorage.setNext(incrementalStorage.getNext());
                    trimmedIncrement = incrementalStorage;
                    break;
                }
                previousIncrementalStorage = incrementalStorage;
            }
        }
        return trimmedIncrement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void linkIncrement(IOrdinalValueStorage baseIncrement, IIncrementalOrdinalValueStorage newIncrement) {
        IOrdinalValueStorage iOrdinalValueStorage = baseIncrement;
        synchronized (iOrdinalValueStorage) {
            IncrementFactory.linkIncrementImpl(baseIncrement.getNext(), baseIncrement, newIncrement);
        }
    }

    private static void linkIncrementImpl(IIncrementalOrdinalValueStorage currentIncrement, IOrdinalValueStorage prevIncrement, IIncrementalOrdinalValueStorage newIncrement) {
        int compareResult = -1;
        if (currentIncrement != null) {
            compareResult = Ints.compare((int)newIncrement.getIncrementId(), (int)currentIncrement.getIncrementId());
        }
        if (compareResult == 0) {
            return;
        }
        if (compareResult > 0) {
            IncrementFactory.linkIncrementImpl(currentIncrement.getNext(), currentIncrement, newIncrement);
        } else {
            newIncrement.setNext(currentIncrement);
            prevIncrement.setNext(newIncrement);
        }
    }
}

