/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.OrdinalValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IIncrementalOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorageFetcher;

public class IncrementStorageFetcher
implements IOrdinalValueStorageFetcher {
    private final IOrdinalValueStorageFetcher baseStorage;
    private final IIncrementalOrdinalValueStorage incrementalStorage;
    private int lastFoundUniqueValueIndex = -1;
    private int lastFoundLocation = -1;

    public IncrementStorageFetcher(IOrdinalValueStorageFetcher theBaseStorage, IIncrementalOrdinalValueStorage theIncrementalStorage) {
        this.baseStorage = theBaseStorage;
        this.incrementalStorage = theIncrementalStorage;
    }

    @Override
    public boolean get(OrdinalValue ordinalValue) {
        boolean found = this.incrementalStorage.get(ordinalValue);
        if (!found) {
            found = this.baseStorage.get(ordinalValue);
        }
        return found;
    }

    @Override
    public int getNumValues() {
        return this.baseStorage.getNumValues() + this.incrementalStorage.getNumUniqueValues();
    }

    @Override
    public OrdinalValue get(int index, OrdinalValue returnOrdinalValue) {
        OrdinalValue ov;
        if (index < 0 || index >= this.getNumValues()) {
            throw new IllegalArgumentException("Index " + index + " is out of range.  Stored values are " + this.getNumValues());
        }
        if (returnOrdinalValue == null) {
            returnOrdinalValue = this.createOrdinalValue();
        }
        if (index < this.baseStorage.getNumValues()) {
            ov = this.baseStorage.get(index, returnOrdinalValue);
            this.incrementalStorage.get(ov);
        } else {
            int foundAtLocation;
            int uniqueValueIndex = index - this.baseStorage.getNumValues() + 1;
            if (uniqueValueIndex > this.lastFoundUniqueValueIndex && this.lastFoundUniqueValueIndex > 0) {
                int delta = uniqueValueIndex - this.lastFoundUniqueValueIndex;
                foundAtLocation = this.getUniqueValue(delta, this.lastFoundLocation + 1, returnOrdinalValue);
            } else if (uniqueValueIndex == this.lastFoundUniqueValueIndex) {
                ov = this.incrementalStorage.get(this.lastFoundLocation, returnOrdinalValue);
                foundAtLocation = this.lastFoundLocation;
            } else {
                foundAtLocation = this.getUniqueValue(uniqueValueIndex, 0, returnOrdinalValue);
            }
            this.lastFoundLocation = foundAtLocation;
            this.lastFoundUniqueValueIndex = uniqueValueIndex;
            ov = returnOrdinalValue;
        }
        return ov;
    }

    private int getUniqueValue(int numValue, int fromIndex, OrdinalValue ov) {
        while (numValue > 0) {
            if (!this.baseStorage.get(ov = this.incrementalStorage.get(fromIndex, ov))) {
                --numValue;
            }
            ++fromIndex;
        }
        return fromIndex - 1;
    }

    @Override
    public OrdinalValue createOrdinalValue() {
        return this.baseStorage.createOrdinalValue();
    }
}

