/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.IResultSet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.aggregate.AggregateCacheLoader;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AbstractQueuedIntersectionAction;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletIntersectionTaskAction;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletLookupThreadReturnType;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.ResultSetIntersectionTaskInterface;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.context.ExecutionEnvironmentContext;
import java.util.List;
import org.apache.commons.configuration.ConversionException;

public class ResultSetIntersectionInterface
extends AbstractQueuedIntersectionAction {
    private static final String MAX_NUM_THREADS = "MaxNumberOfCubeletThreadsForPipelining";
    private static final int DEFAULT_MAX_NUM_THREADS = 5;
    private final IResultSet resultSet;

    public static int getMaxNumThreads() {
        int max;
        try {
            max = ExecutionEnvironmentContext.getExecutionEnvironment().getMultiRequestContext().fetchgetIntConfiguration(MAX_NUM_THREADS, 5);
        }
        catch (ConversionException e) {
            max = 5;
        }
        return max;
    }

    public ResultSetIntersectionInterface(IResultSet aResultSet) {
        this.resultSet = aResultSet;
    }

    @Override
    public CubeletIntersectionTaskAction[] createTaskAction(int numTasks, Cubelet cubelet) {
        this.initialize(numTasks, cubelet, this.resultSet.supportsParallelAccess());
        if (!(this.resultSet instanceof AggregateCacheLoader.MetricsOnlyResultSet)) {
            long startTime = System.currentTimeMillis();
            TupleValue tupVal = cubelet.getFirstTupleValue();
            this.resultSet.getQuerySet().initializeForOrdinalScan(tupVal.getTuple(), true);
            long endTime = System.currentTimeMillis();
            XQELogger traceLgr = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "TupleStorage", LogLevel.TRACE);
            if (traceLgr.isOn(LogLevel.TRACE)) {
                traceLgr.log("Initializing the querySet for ordinal scanning took " + (endTime - startTime) + "ms");
            }
        }
        CubeletIntersectionTaskAction[] taskInterfaces = new CubeletIntersectionTaskAction[numTasks];
        if (numTasks == 1 || this.resultSet.supportsParallelAccess()) {
            for (int i = 0; i < numTasks; ++i) {
                taskInterfaces[i] = new ResultSetIntersectionTaskInterface(this.resultSet);
            }
        } else {
            for (int i = 0; i < numTasks; ++i) {
                taskInterfaces[i] = new ResultSetIntersectionTaskInterface(this.resultQueue, this.numValuesToPost, this.resultSet);
            }
        }
        return taskInterfaces;
    }

    @Override
    public void messageReceived(CubeletLookupThreadReturnType msg) {
        List<List<long[]>> resultSetTupleOrdinals = msg.getResultSetTupleOrdinals();
        List<Cell> cells = msg.getCells();
        for (int i = 0; i < resultSetTupleOrdinals.size(); ++i) {
            Cell c = cells.get(i);
            this.resultSet.addCell(resultSetTupleOrdinals.get(i), c, c.isCalculation(), false);
        }
    }

    @Override
    public int getMaxThreads() {
        if (this.resultSet.isPipelining()) {
            if (this.resultSet.supportsParallelAccess()) {
                return ResultSetIntersectionInterface.getMaxNumThreads();
            }
            return -1;
        }
        return -1;
    }
}

