/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.resultset.interfaces.ITuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletIntersectionTaskAction;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletLookupThreadReturnType;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.OperationEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;

public class TupleValueListIntersectionTaskInterface
implements CubeletIntersectionTaskAction {
    private final BlockingQueue<CubeletLookupThreadReturnType> resultQueue;
    private List<TupleValue> tupleValues = null;
    private final int numValuesToPost;

    public TupleValueListIntersectionTaskInterface(List<TupleValue> aTupleValues) {
        this.tupleValues = aTupleValues;
        this.resultQueue = null;
        this.numValuesToPost = 1;
    }

    public TupleValueListIntersectionTaskInterface(BlockingQueue<CubeletLookupThreadReturnType> aResultQueue, int numberOfValuesToPost) {
        this.resultQueue = aResultQueue;
        this.tupleValues = new ArrayList<TupleValue>();
        this.numValuesToPost = numberOfValuesToPost;
    }

    @Override
    public void taskFinished(Throwable error) {
        if (this.resultQueue != null && error == null) {
            CubeletLookupThreadReturnType msg = new CubeletLookupThreadReturnType(this.tupleValues, null, null, true);
            try {
                this.resultQueue.put(msg);
            }
            catch (InterruptedException e) {
                Cubelet.traceLogger.log(LogLevel.ERROR, OperationEnum.DEFAULT, "Could not enqueue msg", e);
            }
        }
    }

    @Override
    public void valueFound(IValue value, ITuple tuple) {
        TupleValue tv = TupleValueListIntersectionTaskInterface.createTupleValue(value, tuple.getMembers());
        this.tupleValues.add(tv);
        if (this.resultQueue != null && this.tupleValues.size() >= this.numValuesToPost) {
            CubeletLookupThreadReturnType msg = new CubeletLookupThreadReturnType(this.tupleValues, null, null, false);
            try {
                this.resultQueue.put(msg);
            }
            catch (InterruptedException e) {
                throw new XQERuntimeException(e);
            }
            this.tupleValues = new ArrayList<TupleValue>(this.numValuesToPost);
        }
    }

    private static TupleValue createTupleValue(IValue value, IMember[] members) {
        IMember[] tupleMembers = new IMember[members.length];
        System.arraycopy(members, 0, tupleMembers, 0, members.length);
        return new TupleValue(new Tuple(tupleMembers, false), new Cell(value));
    }
}

