/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet;

import com.cognos.xqe.config.ServiceEnumeration;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.metadata.AggregateTypeEnum;
import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.query.engine.MultiRequestContext;
import com.cognos.xqe.resultset.interfaces.ISet;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.Tuple;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateUtilities;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.AbstractDoubleValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.BaseOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.Cubelet;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.CubeletMonitor;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.DoubleNativeValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IIncrementalOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IOrdinalValueStorageFetcher;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IncrementFactory;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.IncrementStorageFetcher;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCacheEntry;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.VectorDoubleNativeValueStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementManager;
import com.cognos.xqe.runtree.olap.mdx.util.AdditiveCellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.CellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.ICellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.MaxCellCombiner;
import com.cognos.xqe.runtree.olap.mdx.util.MinCellCombiner;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.trace.XQELog;
import com.cognos.xqe.trace.XQELogger;
import com.cognos.xqe.util.primitive.ArrayListInt;
import com.cognos.xqe.util.primitive.LongArrayList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class UpdateableCubelet
extends Cubelet
implements UpdateableCacheEntry {
    private final ICellCombiner cellCombiner;
    private int oldestValidIncrementId = 0;
    private final IMember[] measures;
    private final boolean nonAdditiveMeasures;

    public UpdateableCubelet(ISet set, Iterator<TupleValue> tupleValues, CubeletMonitor aMonitor, String cubeletID) {
        super(set, tupleValues, aMonitor, cubeletID);
        if (this.numValues == 0) {
            int incrementId = ((BaseOrdinalValueStorage)this.valuesStorage).getIncrementId();
            this.valuesStorage = !this.isStoringByOrdinals() ? new VectorDoubleNativeValueStorage(this.intQuerySet.length) : new DoubleNativeValueStorage();
            ((AbstractDoubleValueStorage)this.valuesStorage).setIncrementId(incrementId);
            this.valuesStorage.fix(0);
        }
        this.measures = AggregateUtilities.getMeasures(set);
        this.cellCombiner = this.selectCombiner(this.measures);
        this.nonAdditiveMeasures = this.containsNonAdditiveMeasures(this.measures);
    }

    protected UpdateableCubelet(ISet set, Iterator<TupleValue> tupleValues, String cubeletID) {
        this(set, tupleValues, null, cubeletID);
    }

    @Override
    public int[][] getLevels() {
        int[][] levelsByHier = new int[this.selectionLevels.length][];
        for (int i = 0; i < this.selectionLevels.length; ++i) {
            levelsByHier[i] = this.selectionLevels[i].toArray(new int[this.selectionLevels[i].size()]);
        }
        return levelsByHier;
    }

    @Override
    public void createNewIncrement(int incrementId, Iterable<TupleValue> tupleValues) {
        long startTime = System.currentTimeMillis();
        IIncrementalOrdinalValueStorage latestIncrement = this.getLatestIncrement();
        int latestIncrementId = this.getLatestIncrementId();
        if (latestIncrementId + 1 != incrementId) {
            throw new IllegalStateException("Cubelet at incrementID " + latestIncrementId + " is asked to upgrade to " + incrementId);
        }
        ArrayList<TupleValue> incrementTupleValues = new ArrayList<TupleValue>();
        LongArrayList incrementOrdinals = null;
        ArrayList<int[]> incrementMemberIds = null;
        if (this.isStoringByOrdinals()) {
            incrementOrdinals = new LongArrayList();
        } else {
            incrementMemberIds = new ArrayList<int[]>();
        }
        this.filterTupleValues(tupleValues, incrementTupleValues, incrementOrdinals, incrementMemberIds);
        IIncrementalOrdinalValueStorage newIncrement = IncrementFactory.buildIncrement(this.valuesStorage, latestIncrement, incrementOrdinals, incrementMemberIds, incrementTupleValues, this.cellCombiner);
        newIncrement.setIncrementId(incrementId);
        IncrementFactory.linkIncrement(this.valuesStorage, newIncrement);
        this.estimatedMemoryUsage += newIncrement.estimateMemoryUsage();
        long endTime = System.currentTimeMillis();
        traceLogger.log("Increment " + newIncrement.getIncrementId() + " created with " + newIncrement.getNumValues() + " values in " + (endTime - startTime) + "ms.");
    }

    private IIncrementalOrdinalValueStorage getLatestIncrement() {
        return this.getIncrement(this.getLatestIncrementId());
    }

    private IIncrementalOrdinalValueStorage getIncrement(int incrementId) {
        IIncrementalOrdinalValueStorage increment;
        for (increment = this.valuesStorage.getNext(); increment != null && incrementId != increment.getIncrementId(); increment = increment.getNext()) {
        }
        return increment;
    }

    public boolean hasNonAdditiveMeasures() {
        return this.nonAdditiveMeasures;
    }

    @Override
    public boolean isUpdateable() {
        return this.cellCombiner != null && this.valuesStorage instanceof AbstractDoubleValueStorage;
    }

    public void filterTupleValues(Iterable<TupleValue> sourceTupleValues, List<TupleValue> tvForThisCubelet, LongArrayList ordinalsForThisCubelet, List<int[]> memberIdsForThisCubelet) {
        int[] memberIds = new int[this.intQuerySet.length];
        int[] memberOffsets = new int[this.intQuerySet.length];
        boolean storeByOrdinals = this.isStoringByOrdinals();
        for (TupleValue tv : sourceTupleValues) {
            Tuple aTuple = tv.getTuple();
            IMember[] members = aTuple.getMembers();
            for (int i = 0; i < members.length; ++i) {
                memberIds[i] = this.getMemberIndex(members[i]);
            }
            int[] calcedOffsets = UpdateableCubelet.findOffset(this.intQuerySet, memberIds, memberOffsets);
            if (calcedOffsets == null) continue;
            if (storeByOrdinals) {
                long ordinal = this.computeOrdinalFromSetOffsets(memberOffsets);
                ordinalsForThisCubelet.add(ordinal);
            } else {
                int[] newMemberIds = new int[memberIds.length];
                System.arraycopy(memberIds, 0, newMemberIds, 0, memberIds.length);
                memberIdsForThisCubelet.add(newMemberIds);
            }
            tvForThisCubelet.add(tv);
        }
    }

    @Override
    public ArrayListInt getIncrementIds() {
        ArrayListInt ids = new ArrayListInt();
        for (IOrdinalValueStorage increment = this.valuesStorage; increment != null; increment = increment.getNext()) {
            ids.add(increment.getIncrementId());
        }
        return ids;
    }

    @Override
    protected IOrdinalValueStorageFetcher getOrdinalStorageFetcher() {
        IOrdinalValueStorageFetcher fetcher;
        int incrementId = MultiRequestContext.getCurrentIncrementId(this.cube);
        this.validateIncrementId(incrementId);
        if (incrementId != 0 && this.isUpdateable() && incrementId != this.valuesStorage.getIncrementId()) {
            IIncrementalOrdinalValueStorage incremantalStorage = this.getIncrement(incrementId);
            if (incremantalStorage == null) {
                XQELogger logger = XQELog.getLogger(ServiceEnumeration.XQE, "XQE", "TupleStorage", LogLevel.INFO);
                logger.log(LogLevel.INFO, "Dynamically updating cubelet to incrementId " + incrementId);
                IncrementManager im = this.getIncrementManager();
                try {
                    im.updateCacheEntry(this, incrementId);
                }
                catch (InterpreterException e) {
                    throw new XQERuntimeException(e);
                }
                incremantalStorage = this.getIncrement(incrementId);
                if (incremantalStorage == null) {
                    throw new IllegalStateException("Upgrade to increment " + incrementId + " failed.");
                }
            }
            fetcher = new IncrementStorageFetcher(this.valuesStorage, incremantalStorage);
        } else {
            fetcher = super.getOrdinalStorageFetcher();
        }
        return fetcher;
    }

    protected IncrementManager getIncrementManager() {
        return ((ROLAPCube)this.cube).getIncrementManagerInContext();
    }

    private boolean containsNonAdditiveMeasures(IMember[] theMeasures) {
        for (IMember measure : theMeasures) {
            if (AggregateCalculationEngine.canRollupMeasure(measure)) continue;
            return true;
        }
        return false;
    }

    private void validateIncrementId(int incrementId) {
        if (this.isUpdateable()) {
            if (incrementId < this.valuesStorage.getIncrementId()) {
                throw new IllegalStateException("Cubelets with a base incrementId after the requestId should not have passed intersection.  IncrementId " + incrementId + "  baseId " + this.valuesStorage.getIncrementId());
            }
        } else if (this.valuesStorage.getNext() != null) {
            throw new IllegalStateException("non updateable cubelets should not have increments");
        }
        if (incrementId < this.oldestValidIncrementId) {
            throw new IllegalStateException("Request came in for an incrementId that was already expired.  IncrementId " + incrementId + "  oldestValidIncrementId " + this.oldestValidIncrementId);
        }
    }

    private ICellCombiner selectCombiner(IMember[] theMeasures) {
        HashSet<ICellCombiner> combiners = new HashSet<ICellCombiner>();
        for (IMember measure : theMeasures) {
            if (!AggregateCalculationEngine.canRollupMeasure(measure)) continue;
            AggregateTypeEnum measureType = measure.getRegularAggregate();
            if (AggregateTypeEnum.MAX.equals(measureType)) {
                combiners.add(MaxCellCombiner.getInstance());
                continue;
            }
            if (AggregateTypeEnum.MIN.equals(measureType)) {
                combiners.add(MinCellCombiner.getInstance());
                continue;
            }
            combiners.add(AdditiveCellCombiner.getInstance());
        }
        ICellCombiner combiner = null;
        if (combiners.size() == 1) {
            combiner = (ICellCombiner)combiners.iterator().next();
        } else if (combiners.size() > 1) {
            combiner = new CellCombiner();
        }
        traceLogger.log("CellCombiner selected = " + combiner);
        return combiner;
    }

    @Override
    public int getLatestIncrementId() {
        ArrayListInt ids = this.getIncrementIds();
        return ids.get(ids.size() - 1);
    }

    @Override
    public boolean contains(Cubelet other) {
        int otherBaseIncrementID;
        boolean canContain;
        if (!(other instanceof UpdateableCubelet)) {
            return false;
        }
        UpdateableCubelet otherUC = (UpdateableCubelet)other;
        int myBaseIncrementID = this.getBaseIncrementId();
        boolean bl = canContain = myBaseIncrementID <= (otherBaseIncrementID = otherUC.getBaseIncrementId()) || myBaseIncrementID <= this.oldestValidIncrementId;
        if (canContain && otherUC.hasNonAdditiveMeasures()) {
            canContain = myBaseIncrementID == otherBaseIncrementID || otherBaseIncrementID < this.oldestValidIncrementId;
        }
        return canContain && super.contains(other);
    }

    @Override
    public void expireIncrementsBefore(int incrementId) {
        this.oldestValidIncrementId = incrementId;
        List<IIncrementalOrdinalValueStorage> trimmedStorages = IncrementFactory.trimIncrementsBefore(this.valuesStorage, incrementId);
        if (trimmedStorages.size() > 0) {
            long trimmedBytes = 0L;
            for (IIncrementalOrdinalValueStorage trimmedStorage : trimmedStorages) {
                trimmedBytes += trimmedStorage.estimateMemoryUsage();
            }
            this.estimatedMemoryUsage -= trimmedBytes;
        }
    }

    @Override
    public IMember[] getMeasures() {
        return this.measures;
    }

    @Override
    public boolean removeIncrement(int incrementId) {
        IIncrementalOrdinalValueStorage increment = IncrementFactory.removeIncrement(this.valuesStorage, incrementId);
        return increment != null;
    }
}

