/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental;

import com.cognos.xqe.data.values.IValue;
import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.InterpreterException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPContext;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPBaseCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCubeReservation;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.cache.ROLAPDataCache;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.IBlockTupleStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCacheEntry;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.cubelet.UpdateableCubeletStorage;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.AggregateCalculationStrategy;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IIncrementStagingAdapter;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IStreamedValues;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.IncrementMetrics;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.TupleValueFetchTask;
import com.cognos.xqe.trace.LogLevel;
import com.cognos.xqe.util.ClosableIterator;
import com.cognos.xqe.util.Pipe;
import com.cognos.xqe.util.concurrent.UnboundedThreadPool;
import com.cognos.xqe.util.primitive.HashMapIntObject;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class IncrementManager {
    private static final int DEFAULT_INCREMENT_SIZE = 100000;
    private static final double INCREASE_10_PERCENT = 1.1;
    public static final int DEFAULT_INCREMENT_ID = 0;
    private final ROLAPBaseCube cube;
    private volatile int currentIncrementId = 0;
    private volatile int oldestActiveIncrementId = 0;
    private int numMaintenancePassesAtOldestIncrementId = 0;
    private volatile boolean incrementLoadInProgress = false;
    private final IIncrementStagingAdapter stagingAdapter;
    protected final HashMapIntObject<Collection<TupleValue>> incrementValues = new HashMapIntObject();
    private IncrementMetrics lastMetrics = null;

    public IncrementManager(ROLAPBaseCube theCube, IIncrementStagingAdapter theStagingAdapter) {
        this.cube = theCube;
        this.stagingAdapter = theStagingAdapter;
        IValue currentTid = null;
        if (this.stagingAdapter != null) {
            currentTid = this.stagingAdapter.getCurrentTID();
        }
        this.lastMetrics = new IncrementMetrics(currentTid, System.currentTimeMillis());
    }

    public boolean isIncrementalUpdatesEnabled() {
        return this.stagingAdapter.isIncrementalUpdatesEnabled();
    }

    public synchronized void updateCacheEntry(UpdateableCacheEntry entry, int incrementID) throws InterpreterException {
        List<UpdateableCacheEntry> entryAsList = Arrays.asList(entry);
        if (!this.incrementValues.containsKey(incrementID)) {
            throw new IllegalArgumentException("Invalid or expired increment ID: " + incrementID);
        }
        int currentId = entry.getLatestIncrementId();
        while (currentId < incrementID) {
            int nextId = currentId + 1;
            this.updateCacheEntries(entryAsList, nextId, null);
            currentId = nextId;
        }
    }

    public synchronized void loadNextIncrement(ROLAPDataCache dataCache, String strTID) throws InterpreterException {
        this.incrementLoadInProgress = true;
        try {
            IncrementMetrics metrics;
            if (!this.stagingAdapter.isIncrementalUpdatesEnabled()) {
                throw new XQERuntimeException(XQEMessageKeys.ROL_NearRealTimeNotDefinedForCube, this.cube.getName());
            }
            long startTime = System.currentTimeMillis();
            IValue previousTID = this.stagingAdapter.getCurrentTID();
            boolean callerSpecifiedTID = strTID != null;
            int newId = this.stagingAdapter.getNextIncrementId(strTID);
            long incrementIDFetchTimeEnd = System.currentTimeMillis();
            this.maintainIncrementHistory(dataCache);
            if (newId == 0 || this.currentIncrementId >= newId) {
                IncrementMetrics metrics2;
                this.lastMetrics = metrics2 = new IncrementMetrics(strTID, previousTID, incrementIDFetchTimeEnd - startTime, incrementIDFetchTimeEnd);
                ROLAPLog.log("ROLAPCubes.IncrementalUpdates", "No new increment TID: " + metrics2.toString());
                return;
            }
            ClosableIterator<TupleValue> valuesIter = this.stagingAdapter.getTupleValuesForCurrentIncrement(!callerSpecifiedTID);
            long incrementQueryExecuteTimeEnd = System.currentTimeMillis();
            if (!valuesIter.hasNext() && !this.incrementValues.containsKey(newId)) {
                IncrementMetrics metrics3;
                this.lastMetrics = metrics3 = new IncrementMetrics(strTID, previousTID, incrementIDFetchTimeEnd - startTime, incrementIDFetchTimeEnd);
                ROLAPLog.log("ROLAPCubes.IncrementalUpdates", "No new increment rows.  " + metrics3.toString());
                valuesIter.close();
                return;
            }
            Pipe<TupleValue> newIncrementValues = new Pipe<TupleValue>();
            TupleValueFetchTask fetchTask = new TupleValueFetchTask(this.cube, newIncrementValues, valuesIter, this.getEstimatedNumTuples());
            Callable<List<TupleValue>> wrappedTask = ROLAPCallable.decorateCallable(fetchTask);
            Future<List<TupleValue>> fetchTaskResults = UnboundedThreadPool.getThreadPool().submit(wrappedTask);
            List<UpdateableCacheEntry> allEntries = this.getUpdateableCacheEntries(dataCache);
            if (!allEntries.isEmpty()) {
                int oldestID;
                HashMultimap<Integer, UpdateableCacheEntry> entriesById = this.getEntriesByIncrementID(allEntries);
                for (int currentId = oldestID = ((Integer)Collections.min(entriesById.keySet())).intValue(); currentId < newId; ++currentId) {
                    Set entriesForId = entriesById.get((Object)currentId);
                    int nextId = currentId + 1;
                    if (nextId == newId) {
                        this.updateCacheEntries(entriesForId, nextId, new StreamedValues(newIncrementValues, fetchTaskResults));
                    } else {
                        this.updateCacheEntries(entriesForId, nextId, null);
                    }
                    entriesById.putAll((Object)nextId, (Iterable)entriesForId);
                    entriesById.removeAll((Object)currentId);
                }
            } else {
                Iterator<TupleValue> tvIter = newIncrementValues.iterator();
                while (tvIter.hasNext()) {
                    tvIter.next();
                }
            }
            List<TupleValue> compactList = fetchTaskResults.get();
            this.incrementValues.put(newId, compactList);
            this.currentIncrementId = newId;
            this.stagingAdapter.commitIncrement();
            long endTime = System.currentTimeMillis();
            IValue currentTID = this.stagingAdapter.getCurrentTID();
            String strCurrentTID = null;
            if (currentTID != null) {
                strCurrentTID = currentTID.toString();
            }
            this.lastMetrics = metrics = new IncrementMetrics(strCurrentTID, previousTID, newId, endTime - startTime, endTime, compactList.size(), incrementQueryExecuteTimeEnd - incrementIDFetchTimeEnd, incrementIDFetchTimeEnd - startTime, allEntries.size());
            ROLAPLog.log("ROLAPCubes.IncrementalUpdates", metrics.toString());
        }
        catch (InterruptedException e) {
            throw new XQERuntimeException(e);
        }
        catch (ExecutionException e) {
            throw new XQERuntimeException(e);
        }
        finally {
            this.incrementLoadInProgress = false;
        }
    }

    public IIncrementStagingAdapter getStagingAdapter() {
        return this.stagingAdapter;
    }

    public String getFactQueryFilterExpression(boolean deltaQuery) {
        if (this.isIncrementalUpdatesEnabled()) {
            int incId = IncrementManager.getIncrementID(this.cube);
            if (!deltaQuery) {
                return this.stagingAdapter.generateFactQueryTidExpression(incId);
            }
            return this.stagingAdapter.generateFactQueryNonDefaultTidExpression(incId);
        }
        return null;
    }

    protected List<UpdateableCacheEntry> getUpdateableCacheEntries(ROLAPDataCache dataCacheContainer) {
        ArrayList allEntries = Lists.newArrayList();
        AggregateCubeletStorage aggCache = dataCacheContainer.getAggregateStorage();
        UpdateableCubeletStorage dataCache = (UpdateableCubeletStorage)dataCacheContainer.getBlockTupleStorage();
        if (aggCache != null) {
            allEntries.addAll(aggCache.getUpdateableCubelets());
        }
        if (dataCache != null) {
            allEntries.addAll(dataCache.getUpdateableCubelets());
        }
        return allEntries;
    }

    private HashMultimap<Integer, UpdateableCacheEntry> getEntriesByIncrementID(Collection<UpdateableCacheEntry> entries) {
        HashMultimap entriesByID = HashMultimap.create();
        for (UpdateableCacheEntry entry : entries) {
            int currentIncrement = entry.getLatestIncrementId();
            entriesByID.put((Object)currentIncrement, (Object)entry);
        }
        return entriesByID;
    }

    private void updateCacheEntries(Collection<UpdateableCacheEntry> entries, int incrementID, IStreamedValues<TupleValue> streamedIncrementValues) throws InterpreterException {
        int estimatedNumLeafTuples;
        Collection<TupleValue> existingLeafValues = null;
        if (streamedIncrementValues == null) {
            existingLeafValues = this.incrementValues.get(incrementID);
            if (existingLeafValues == null) {
                throw new IllegalStateException("Cannot find values for increment " + incrementID);
            }
            estimatedNumLeafTuples = existingLeafValues.size();
        } else {
            estimatedNumLeafTuples = this.getEstimatedNumTuples();
        }
        AggregateCalculationStrategy agp = new AggregateCalculationStrategy(entries, this.cube);
        agp.execute(existingLeafValues, streamedIncrementValues, incrementID, estimatedNumLeafTuples);
    }

    private int getEstimatedNumTuples() {
        int estimatedNumLeafTuples = this.lastMetrics != null && this.lastMetrics.getNumLeafTuples() > 0L ? (int)((double)this.lastMetrics.getNumLeafTuples() * 1.1) : 100000;
        return estimatedNumLeafTuples;
    }

    public int getCurrentIncrementID() {
        return this.currentIncrementId;
    }

    public synchronized void maintainIncrementHistory(ROLAPDataCache dataCache) {
        long numCubeletsUpdated = 0L;
        long numTupleValuesFreed = 0L;
        long startTime = System.currentTimeMillis();
        LogLevel logLevel = LogLevel.TRACE;
        int previousOldestActiveIncrementId = this.oldestActiveIncrementId;
        if (dataCache != null) {
            Object aggregateStorage;
            this.oldestActiveIncrementId = dataCache.getCube().getOldestPossibleIncrementId();
            IBlockTupleStorage cubeletStorage = dataCache.getBlockTupleStorage();
            if (cubeletStorage != null) {
                this.oldestActiveIncrementId = Math.min(this.oldestActiveIncrementId, ((UpdateableCubeletStorage)cubeletStorage).getUpdateableCubeletsOldestIncrementId());
            }
            if ((aggregateStorage = dataCache.getAggregateStorage()) != null) {
                this.oldestActiveIncrementId = Math.min(this.oldestActiveIncrementId, ((UpdateableCubeletStorage)aggregateStorage).getUpdateableCubeletsOldestIncrementId());
            }
        }
        if (this.oldestActiveIncrementId > previousOldestActiveIncrementId) {
            this.numMaintenancePassesAtOldestIncrementId = 0;
            List<UpdateableCacheEntry> allEntries = this.getUpdateableCacheEntries(dataCache);
            for (UpdateableCacheEntry cacheEntry : allEntries) {
                cacheEntry.expireIncrementsBefore(this.oldestActiveIncrementId);
                ++numCubeletsUpdated;
            }
            for (int unusedIncrementId = previousOldestActiveIncrementId; unusedIncrementId < this.oldestActiveIncrementId; ++unusedIncrementId) {
                numTupleValuesFreed = (long)this.expireIncrementId(unusedIncrementId, true) + numTupleValuesFreed;
            }
        } else {
            ++this.numMaintenancePassesAtOldestIncrementId;
            if (this.numMaintenancePassesAtOldestIncrementId > 1 && this.oldestActiveIncrementId == this.currentIncrementId) {
                numTupleValuesFreed = (long)this.expireIncrementId(this.currentIncrementId, false) + numTupleValuesFreed;
            }
        }
        if (numTupleValuesFreed > 0L) {
            logLevel = LogLevel.INFO;
        }
        long endTime = System.currentTimeMillis();
        if (ROLAPLog.isOn("ROLAPCubes.IncrementalUpdates", logLevel)) {
            ROLAPLog.getLogger("ROLAPCubes.IncrementalUpdates").log(logLevel, String.format("Increment maintenance took %,dms to move oldest active increment id to %,d from %,d.  %,d cubelets processed, %,d tupleValues freed.", endTime - startTime, this.oldestActiveIncrementId, previousOldestActiveIncrementId, numCubeletsUpdated, numTupleValuesFreed));
        }
    }

    private int expireIncrementId(int incrementId, boolean expireInStagingAdapter) {
        if (expireInStagingAdapter) {
            this.stagingAdapter.expireIncrementId(incrementId);
        }
        int numTupleValuesFreed = 0;
        Collection<TupleValue> tupleValues = this.incrementValues.get(incrementId);
        if (tupleValues != null) {
            numTupleValuesFreed = tupleValues.size();
            this.incrementValues.remove(incrementId);
        }
        return numTupleValuesFreed;
    }

    public IncrementMetrics getLastMetrics() {
        return this.lastMetrics;
    }

    public long getNumSavedTupleValues() {
        long totalTVs = 0L;
        for (Collection<TupleValue> tvs : this.incrementValues.values()) {
            totalTVs += (long)tvs.size();
        }
        return totalTVs;
    }

    public int getOldestActiveIncrementID() {
        return this.oldestActiveIncrementId;
    }

    public boolean isIncrementLoadInProgress() {
        return this.incrementLoadInProgress;
    }

    public static int getIncrementID(ROLAPCube cube) {
        ROLAPContext rolapContext = ROLAPContext.get();
        if (rolapContext == null) {
            throw new IllegalStateException("Cannot get an incrementId from cube  " + cube.getUniqueName() + " without a rolapContext to hold a reservation.");
        }
        ROLAPCubeReservation reservation = rolapContext.getReservation(cube);
        if (reservation != null) {
            return reservation.getIncrementID();
        }
        throw new IllegalStateException("Cannot get an incrementId from cube " + cube.getUniqueName() + " without a reservation.");
    }

    public static boolean queryWillIncludeTidRange(ROLAPCube cube) {
        IncrementManager im = cube.getIncrementManagerInContext();
        return im != null && im.getFactQueryFilterExpression(true) != null && im.isIncrementalUpdatesEnabled();
    }

    private static class StreamedValues
    implements IStreamedValues<TupleValue> {
        private final Pipe<TupleValue> pipe;
        private final Future<List<TupleValue>> streamingTaskResults;

        StreamedValues(Pipe<TupleValue> aPipe, Future<List<TupleValue>> theStreamingTaskResults) {
            this.pipe = aPipe;
            this.streamingTaskResults = theStreamingTaskResults;
        }

        @Override
        public Pipe<TupleValue> getStream() {
            return this.pipe;
        }

        @Override
        public List<TupleValue> getValues() {
            if (this.streamingTaskResults.isDone()) {
                try {
                    return this.streamingTaskResults.get();
                }
                catch (InterruptedException e) {
                    throw new XQERuntimeException(e);
                }
                catch (ExecutionException e) {
                    throw new XQERuntimeException(e);
                }
            }
            return null;
        }
    }
}

