/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental;

import com.cognos.xqe.data.values.IValue;

public class IncrementMetrics {
    private String tid = null;
    private String previousTid = null;
    private long numFactRows = -1L;
    private int incrementID = 0;
    private long durationToBuildIncrement = 0L;
    private long timeIncrementProcessed = 0L;
    private long numLeafTuples = 0L;
    private long durationToFetchLeafTuples = 0L;
    private long durationToExecuteIncrementQuery = 0L;
    private long numCubelets = 0L;
    private boolean cubeStartTID = false;

    public IncrementMetrics(String theTID, IValue thePreviousTID, int theIncrementID, long theDurationToBuildLatestIncrement, long theTimeIncrementBecameAvailable, long theNumLeafTuples, long theDurationToFetchLeafTuples, long theDurationToExecuteIncrementQuery, long theNumCubelets) {
        this.tid = theTID;
        if (thePreviousTID != null) {
            this.previousTid = thePreviousTID.toString();
        }
        this.incrementID = theIncrementID;
        this.durationToBuildIncrement = theDurationToBuildLatestIncrement;
        this.timeIncrementProcessed = theTimeIncrementBecameAvailable;
        this.numLeafTuples = theNumLeafTuples;
        this.durationToFetchLeafTuples = theDurationToFetchLeafTuples;
        this.durationToExecuteIncrementQuery = theDurationToExecuteIncrementQuery;
        this.numCubelets = theNumCubelets;
    }

    public IncrementMetrics(String theTID, IValue thePreviousTID, long theDurationToBuildLatestIncrement, long theTimeIncrementBecameAvailable) {
        this.tid = theTID;
        if (thePreviousTID != null) {
            this.previousTid = thePreviousTID.toString();
        }
        this.durationToBuildIncrement = theDurationToBuildLatestIncrement;
        this.timeIncrementProcessed = theTimeIncrementBecameAvailable;
    }

    public IncrementMetrics(IValue theTID, long theTimeIncrementBecameAvailable) {
        this.tid = theTID != null ? theTID.toString() : null;
        this.previousTid = null;
        this.durationToBuildIncrement = 0L;
        this.timeIncrementProcessed = theTimeIncrementBecameAvailable;
        this.cubeStartTID = true;
    }

    public String getTID() {
        return this.tid;
    }

    public long getFactRowsFetchedInLatestIncrement() {
        return this.numFactRows;
    }

    public int getIncrementID() {
        return this.incrementID;
    }

    public long getDurationToBuildLatestIncrement() {
        return this.durationToBuildIncrement;
    }

    public long getTimeLatestIncrementBecameAvailable() {
        return this.timeIncrementProcessed;
    }

    public long getNumLeafTuples() {
        return this.numLeafTuples;
    }

    public String getPreviousTid() {
        return this.previousTid;
    }

    public boolean didIncrementHaveNewData() {
        return this.numLeafTuples != 0L;
    }

    public String toString() {
        String txt = this.didIncrementHaveNewData() ? String.format("Increment %d advanced to tid %s from tid %s at %tD %tT.\n%,d leaf tuples applied to %,d cubelets.\nDuration to build increment: %,dms.  Execute increment query: %,dms.  Fetch incrementID: %,dms", this.incrementID, this.tid, this.previousTid, this.timeIncrementProcessed, this.timeIncrementProcessed, this.numLeafTuples, this.numCubelets, this.durationToBuildIncrement, this.durationToFetchLeafTuples, this.durationToExecuteIncrementQuery) : (this.cubeStartTID ? String.format("Initial cube start TID %s at %tD %tT.\n", this.tid, this.timeIncrementProcessed, this.timeIncrementProcessed) : String.format("No new rows found for TID %s at %tD %tT.\nDuration to build increment: %,dms.  Current TID still %s", this.tid, this.timeIncrementProcessed, this.timeIncrementProcessed, this.durationToBuildIncrement, this.previousTid));
        return txt;
    }
}

