/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental;

import java.util.Arrays;

public class LevelSet
implements Comparable<LevelSet> {
    private final int[] levelIdxInCubeHierOrder;

    public LevelSet(int[] levelIndexesInCubeHierOrder) {
        this.levelIdxInCubeHierOrder = levelIndexesInCubeHierOrder;
    }

    public int[] getIndexes() {
        return this.levelIdxInCubeHierOrder;
    }

    @Override
    public int compareTo(LevelSet o) {
        if (Arrays.equals(this.levelIdxInCubeHierOrder, o.levelIdxInCubeHierOrder)) {
            return 0;
        }
        boolean allLowerEqual = true;
        boolean allGreaterEqual = true;
        for (int j = 0; j < this.levelIdxInCubeHierOrder.length; ++j) {
            if (this.levelIdxInCubeHierOrder[j] < o.levelIdxInCubeHierOrder[j]) {
                allLowerEqual = false;
                continue;
            }
            if (this.levelIdxInCubeHierOrder[j] <= o.levelIdxInCubeHierOrder[j]) continue;
            allGreaterEqual = false;
        }
        if (allGreaterEqual) {
            return 1;
        }
        if (allLowerEqual) {
            return -1;
        }
        return 0;
    }

    public int hashCode() {
        return Arrays.hashCode(this.levelIdxInCubeHierOrder);
    }

    public boolean equals(Object o) {
        if (!(o instanceof LevelSet)) {
            return false;
        }
        return Arrays.equals(this.levelIdxInCubeHierOrder, ((LevelSet)o).levelIdxInCubeHierOrder);
    }

    public String toString() {
        return Arrays.toString(this.levelIdxInCubeHierOrder);
    }

    public int size() {
        return this.levelIdxInCubeHierOrder.length;
    }

    public LevelSet copy() {
        return new LevelSet(Arrays.copyOf(this.levelIdxInCubeHierOrder, this.size()));
    }

    public void superset(LevelSet other) {
        if (this.levelIdxInCubeHierOrder.length != other.levelIdxInCubeHierOrder.length) {
            throw new IllegalArgumentException("LevelSets are for different hierarchy counts");
        }
        for (int i = 0; i < this.levelIdxInCubeHierOrder.length; ++i) {
            if (this.levelIdxInCubeHierOrder[i] >= other.levelIdxInCubeHierOrder[i]) continue;
            this.levelIdxInCubeHierOrder[i] = other.levelIdxInCubeHierOrder[i];
        }
    }
}

