/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental;

import com.cognos.xqe.metadata.IMember;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.aggregate.AggregateCalculationEngine;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.LeafLevelSetWithMeasures;
import com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental.LevelSet;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class LevelSetWithMeasures
extends LevelSet {
    private final Set<IMember> measures;

    public LevelSetWithMeasures(int[] levelIndexesInCubeHierOrder, IMember[] theMeasures) {
        super(levelIndexesInCubeHierOrder);
        this.measures = new HashSet<IMember>(theMeasures.length);
        for (IMember m : theMeasures) {
            this.measures.add(m);
        }
    }

    public LevelSetWithMeasures(int[] levelIndexesInCubeHierOrder, Set<IMember> theMeasures) {
        super(levelIndexesInCubeHierOrder);
        this.measures = theMeasures;
    }

    @Override
    public int compareTo(LevelSet o) {
        LevelSetWithMeasures other = (LevelSetWithMeasures)o;
        if (other instanceof LeafLevelSetWithMeasures) {
            return 1;
        }
        int levelCompare = super.compareTo(o);
        if (levelCompare == 0 && !Arrays.equals(this.getIndexes(), other.getIndexes())) {
            return 0;
        }
        if (levelCompare != 0) {
            Set<IMember> targetMesures;
            Set<IMember> sourceMeasures;
            if (levelCompare == 1) {
                sourceMeasures = other.measures;
                targetMesures = this.measures;
            } else {
                sourceMeasures = this.measures;
                targetMesures = other.measures;
            }
            for (IMember m : targetMesures) {
                boolean targetMeasureOk = sourceMeasures.contains(m) && AggregateCalculationEngine.canRollupMeasure(m);
                if (targetMeasureOk) continue;
                return 0;
            }
        } else {
            if (this.measures.size() == other.measures.size()) {
                return 0;
            }
            if (this.measures.containsAll(other.measures)) {
                return -1;
            }
            if (other.measures.containsAll(this.measures)) {
                return 1;
            }
            return 0;
        }
        return levelCompare;
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof LevelSetWithMeasures) || o instanceof LeafLevelSetWithMeasures) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LevelSetWithMeasures other = (LevelSetWithMeasures)o;
        if (this.measures.size() != other.measures.size()) {
            return false;
        }
        return this.measures.containsAll(other.measures);
    }

    @Override
    public String toString() {
        return super.toString() + this.measures.toString();
    }

    @Override
    public LevelSetWithMeasures copy() {
        return new LevelSetWithMeasures(Arrays.copyOf(this.getIndexes(), this.size()), (HashSet)((HashSet)this.measures).clone());
    }

    public void superset(LevelSetWithMeasures other) {
        super.superset(other);
        this.measures.addAll(other.measures);
    }

    public Set<IMember> getMeasures() {
        return this.measures;
    }
}

