/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.storage.blocktuple.incremental;

import com.cognos.xqe.exception.XQEMessageKeys;
import com.cognos.xqe.exception.XQERuntimeException;
import com.cognos.xqe.runtree.olap.mdx.interpreter.CompactTupleValueList;
import com.cognos.xqe.runtree.olap.mdx.interpreter.TupleValue;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPCallable;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.ROLAPLog;
import com.cognos.xqe.runtree.olap.mdx.rolapprovider.admin.ROLAPCube;
import com.cognos.xqe.util.ClosableIterator;
import com.cognos.xqe.util.Pipe;
import java.util.List;

public class TupleValueFetchTask
extends ROLAPCallable<List<TupleValue>> {
    private final Pipe<TupleValue> pipe;
    private final ClosableIterator<TupleValue> tvIter;
    private final CompactTupleValueList compactList;

    public TupleValueFetchTask(ROLAPCube cube, Pipe<TupleValue> thePipe, ClosableIterator<TupleValue> theIterator, int estimatedNumTuples) {
        super(cube);
        this.pipe = thePipe;
        this.tvIter = theIterator;
        this.compactList = new CompactTupleValueList(cube.getHierarchies().size(), estimatedNumTuples);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<TupleValue> callImpl() throws Exception {
        try {
            while (this.tvIter.hasNext()) {
                TupleValue tv = (TupleValue)this.tvIter.next();
                this.compactList.add(tv);
                this.pipe.add(tv);
            }
            this.compactList.trim();
            ROLAPLog.log("ROLAPCubes.IncrementalUpdates", String.format("%,d enqueues when pipe full out of %,d total enqueues.", this.pipe.getNumEnquesWhenFull(), this.pipe.getNumEnques()));
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Throwable ex) {
            throw XQERuntimeException.wrap(XQEMessageKeys.GEN_UnexpectedException, ex);
        }
        finally {
            try {
                this.tvIter.close();
            }
            finally {
                this.pipe.producerFinished();
            }
        }
        return this.compactList;
    }
}

