/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.runtree.olap.mdx.interpreter.Cell;
import java.util.Iterator;
import java.util.TreeSet;

public class CellTreeSet
extends TreeSet<Cell> {
    private static final long serialVersionUID = 1L;
    private long maxOrdinal;
    private Object defaultValue;

    public CellTreeSet(Object defValue, long maxOrd) {
        this.defaultValue = defValue;
        this.maxOrdinal = maxOrd;
    }

    @Override
    public Iterator<Cell> iterator() {
        Iterator<Cell> valueIter = super.iterator();
        if (this.defaultValue == null) {
            return valueIter;
        }
        return new CellTreeSetIterator(valueIter);
    }

    @Override
    public int size() {
        if (this.defaultValue == null) {
            return super.size();
        }
        return (int)(this.maxOrdinal + 1L);
    }

    class CellTreeSetIterator
    implements Iterator<Cell> {
        private Iterator<Cell> valueIterator;
        private long nextOrdinal = 0L;
        Cell nextValueCell = null;

        CellTreeSetIterator(Iterator<Cell> treeSetIter) {
            this.valueIterator = treeSetIter;
            if (this.valueIterator.hasNext()) {
                this.nextValueCell = this.valueIterator.next();
            }
        }

        @Override
        public boolean hasNext() {
            if (CellTreeSet.this.defaultValue == null) {
                return this.valueIterator.hasNext();
            }
            boolean hasValueOrd = this.valueIterator.hasNext();
            if (hasValueOrd) {
                return true;
            }
            return this.nextOrdinal <= CellTreeSet.this.maxOrdinal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Cell next() {
            if (CellTreeSet.this.defaultValue == null) {
                return this.valueIterator.next();
            }
            Cell retCell = null;
            if (this.nextValueCell == null) {
                if (this.nextOrdinal <= CellTreeSet.this.maxOrdinal) {
                    retCell = new Cell(CellTreeSet.this.defaultValue, this.nextOrdinal, false);
                    ++this.nextOrdinal;
                }
                return retCell;
            }
            if (this.nextOrdinal < this.nextValueCell.getOrdinal()) {
                retCell = new Cell(CellTreeSet.this.defaultValue, this.nextOrdinal, false);
            } else if (this.nextOrdinal == this.nextValueCell.getOrdinal()) {
                retCell = this.nextValueCell;
                this.nextValueCell = this.valueIterator.hasNext() ? this.valueIterator.next() : null;
            }
            ++this.nextOrdinal;
            return retCell;
        }
    }
}

