/*
 * Decompiled with CFR 0.152.
 */
package com.cognos.xqe.runtree.olap.mdx.util;

import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContext;
import com.cognos.xqe.runtree.olap.mdx.interpreter.QueryContextFactory;
import com.cognos.xqe.runtree.olap.mdx.util.ChainedException;
import com.cognos.xqe.trace.XQEDebugLog;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public class ChainedRuntimeException
extends RuntimeException {
    private static final long serialVersionUID = -2033938036422412529L;
    private Throwable cause = null;
    private String[] args;
    private static final int NUMBER_4 = 4;
    private static final String NUMERIC_PLACEHOLDER1 = "%d";
    private static final String NUMERIC_PLACEHOLDER2 = "$d";
    private static final String STRING_PLACEHOLDER1 = "%s";
    private static final String STRING_PLACEHOLDER2 = "$s";
    private static final String COMMA_SPACE = ", ";
    private static final String BUNDLE = "com.cognos.xqe.runtree.olap.mdx.util.CubeMessageBundle";

    public ChainedRuntimeException() {
    }

    public ChainedRuntimeException(String message) {
        this(message, (String[])null);
    }

    public ChainedRuntimeException(String message, String[] theArgs) {
        this(message, theArgs, null);
    }

    public ChainedRuntimeException(String message, Throwable theCause) {
        this(message, null, theCause);
    }

    public ChainedRuntimeException(String message, String[] theArgs, Throwable theCause) {
        super(message);
        this.args = theArgs;
        this.cause = theCause;
    }

    public ChainedRuntimeException(Throwable theCause) {
        this.cause = theCause;
    }

    private Locale getLocale() {
        QueryContext infoData = QueryContextFactory.getThreadLocalQueryContext();
        Locale locale = infoData == null ? Locale.getDefault() : infoData.getLocale();
        return locale;
    }

    @Override
    public String getLocalizedMessage() {
        Locale locale = this.getLocale();
        return this.getLocalizedMessage(locale);
    }

    public String getLocalizedMessage(Locale locale) {
        String localizedMessage;
        String message = this.getMessage();
        if (message == null) {
            return null;
        }
        try {
            localizedMessage = this.getResourceBundle(locale).getString(message);
        }
        catch (MissingResourceException e) {
            try {
                localizedMessage = this.getResourceBundle(Locale.ENGLISH).getString(message);
                locale = Locale.ENGLISH;
            }
            catch (MissingResourceException e1) {
                String result = message + ".";
                return result;
            }
        }
        localizedMessage = localizedMessage.replace(NUMERIC_PLACEHOLDER1, STRING_PLACEHOLDER1);
        localizedMessage = localizedMessage.replace(NUMERIC_PLACEHOLDER2, STRING_PLACEHOLDER2);
        String[] localizedArgs = null;
        if (this.args != null) {
            localizedArgs = new String[this.args.length];
            for (int i = 0; i < this.args.length; ++i) {
                String[] argArray = this.args[i].split(COMMA_SPACE);
                for (int j = 0; j < argArray.length; ++j) {
                    try {
                        if (!message.equals("X01405")) {
                            argArray[j] = this.getLocalizedClassName(argArray[j].trim());
                        }
                        argArray[j] = this.getResourceBundle(locale).getString(argArray[j].trim());
                        continue;
                    }
                    catch (Exception e) {
                        argArray[j] = argArray[j].trim();
                    }
                }
                localizedArgs[i] = argArray[0];
                HashSet<String> typesSet = new HashSet<String>();
                for (int j = 1; j < argArray.length; ++j) {
                    if (argArray[j].equals("") || typesSet.contains(argArray[j])) continue;
                    localizedArgs[i] = localizedArgs[i] + COMMA_SPACE + argArray[j];
                    typesSet.add(argArray[j]);
                }
            }
        }
        String result = String.format(locale, localizedMessage, (Object[])localizedArgs);
        result = result.substring(4);
        return result;
    }

    public String getLocalizedClassName(String className) {
        if (className.contains(" ") && !className.startsWith("class ")) {
            return className;
        }
        if (className.equalsIgnoreCase("DrillDownLevel") || className.equalsIgnoreCase("DrillDownMember") || className.equalsIgnoreCase("DrillUpLevel") || className.equalsIgnoreCase("DrillUpMember") || className.equalsIgnoreCase("NameToSet") || className.equalsIgnoreCase("NextMember") || className.equalsIgnoreCase("PrevMember") || className.equals("HIERARCHY") || className.equals("DIMENSION") || className.equals("LEVEL") || className.equals("MEMBER")) {
            return className;
        }
        if (className.endsWith("TupleValue") || className.endsWith("TupleValue[]")) {
            return "";
        }
        if (className.endsWith("ResultSet") || className.endsWith("ResultSet[]")) {
            return "";
        }
        if (className.endsWith("Set") || className.endsWith("Set[]")) {
            return "CMP_TYPESET";
        }
        if (className.endsWith("Tuple") || className.endsWith("Tuple[]")) {
            return "CMP_TYPETUPLE";
        }
        if (className.endsWith("Member") || className.endsWith("Member[]")) {
            return "CMP_TYPEMEMBER";
        }
        if (className.endsWith("Cube") || className.endsWith("Cube[]")) {
            return "CMP_TYPECUBE";
        }
        if (className.endsWith("Dimension") || className.endsWith("Dimension[]")) {
            return "CMP_TYPEDIMENSION";
        }
        if (className.endsWith("Hierarchy") || className.endsWith("Hierarchy[]")) {
            return "CMP_TYPEHIERARCHY";
        }
        if (className.endsWith("Level") || className.endsWith("Level[]")) {
            return "CMP_TYPELEVEL";
        }
        if (className.endsWith("String") || className.endsWith("String[]") || className.endsWith("StringValue")) {
            return "CMP_TYPESTRING";
        }
        if (className.endsWith("Double") || className.endsWith("Double[]") || className.endsWith("Integer") || className.endsWith("Integer[]") || className.endsWith("DoubleValue")) {
            return "CMP_TYPENUMERIC";
        }
        if (className.endsWith("CalculatedMember") || className.endsWith("CalculatedMember[]")) {
            return "CMP_TYPECALCMEMBER";
        }
        if (className.endsWith("NamedSet") || className.endsWith("NamedSet[]")) {
            return "CMP_TYPENAMEDSET";
        }
        if (className.endsWith("MetaData") || className.endsWith("MetaData[]")) {
            return "";
        }
        if (className.endsWith("SearchConditionEvaluator")) {
            return "";
        }
        if (className.endsWith("NullObject")) {
            return "";
        }
        return className;
    }

    @Override
    public Throwable getCause() {
        return this.cause;
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace(XQEDebugLog.err);
        if (this.cause != null) {
            XQEDebugLog.err.println(this.getCausedByString());
            XQEDebugLog.err.printStackTrace(this.cause);
        }
    }

    @Override
    public void printStackTrace(PrintStream ps) {
        super.printStackTrace(ps);
        if (this.cause != null) {
            ps.println(this.getCausedByString());
            this.cause.printStackTrace(ps);
        }
    }

    @Override
    public void printStackTrace(PrintWriter pw) {
        super.printStackTrace(pw);
        if (this.cause != null) {
            pw.println(this.getCausedByString());
            this.cause.printStackTrace(pw);
        }
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle message = ResourceBundle.getBundle(BUNDLE, locale);
        return message;
    }

    public String getCausedByString() {
        Locale locale = this.getLocale();
        return this.getCausedByString(locale);
    }

    public String getCausedByString(Locale locale) {
        if (this.cause == null) {
            return null;
        }
        if (this.cause instanceof ChainedException) {
            return ((ChainedException)this.cause).getLocalizedMessage(locale);
        }
        if (this.cause instanceof ChainedRuntimeException) {
            return ((ChainedRuntimeException)this.cause).getLocalizedMessage(locale);
        }
        return this.cause.getLocalizedMessage();
    }
}

